/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.SharedLibraryInfo;
import android.content.pm.VersionedPackage;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public final class SharedLibraryInfoBuilder {
    private String path;
    private String packageName;
    private List<String> codePaths;
    private String name;
    private long version;
    private int type;
    private VersionedPackage declaringPackage;
    private List<VersionedPackage> dependentPackages;
    private List<SharedLibraryInfo> dependencies;
    private boolean isNative;

    private SharedLibraryInfoBuilder() {
    }

    public static SharedLibraryInfoBuilder newBuilder() {
        return new SharedLibraryInfoBuilder();
    }

    public SharedLibraryInfoBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    public SharedLibraryInfoBuilder setPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public SharedLibraryInfoBuilder setCodePaths(List<String> codePaths) {
        this.codePaths = codePaths;
        return this;
    }

    public SharedLibraryInfoBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public SharedLibraryInfoBuilder setVersion(long version) {
        this.version = version;
        return this;
    }

    public SharedLibraryInfoBuilder setType(int type) {
        this.type = type;
        return this;
    }

    public SharedLibraryInfoBuilder setDeclaringPackage(VersionedPackage declaringPackage) {
        this.declaringPackage = declaringPackage;
        return this;
    }

    public SharedLibraryInfoBuilder setDependentPackages(List<VersionedPackage> dependentPackages) {
        this.dependentPackages = dependentPackages;
        return this;
    }

    public SharedLibraryInfoBuilder setDependencies(List<SharedLibraryInfo> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public SharedLibraryInfoBuilder setIsNative(boolean isNative) {
        this.isNative = isNative;
        return this;
    }

    public SharedLibraryInfo build() {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel <= 27) {
            return (SharedLibraryInfo)ReflectionHelpers.callConstructor(SharedLibraryInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.name), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)((int)this.version)), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.type), ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.declaringPackage), ReflectionHelpers.ClassParameter.from(List.class, this.dependentPackages)});
        }
        if (apiLevel <= 28) {
            return (SharedLibraryInfo)ReflectionHelpers.callConstructor(SharedLibraryInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.name), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.version), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.type), ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.declaringPackage), ReflectionHelpers.ClassParameter.from(List.class, this.dependentPackages)});
        }
        if (apiLevel <= 30) {
            return (SharedLibraryInfo)ReflectionHelpers.callConstructor(SharedLibraryInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.path), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(List.class, this.codePaths), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.name), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.version), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.type), ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.declaringPackage), ReflectionHelpers.ClassParameter.from(List.class, this.dependentPackages), ReflectionHelpers.ClassParameter.from(List.class, this.dependencies)});
        }
        return (SharedLibraryInfo)ReflectionHelpers.callConstructor(SharedLibraryInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.path), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.packageName), ReflectionHelpers.ClassParameter.from(List.class, this.codePaths), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.name), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.version), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.type), ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.declaringPackage), ReflectionHelpers.ClassParameter.from(List.class, this.dependentPackages), ReflectionHelpers.ClassParameter.from(List.class, this.dependencies), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isNative)});
    }
}

