/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.VersionedPackage;
import android.content.rollback.PackageRollbackInfo;
import android.content.rollback.RollbackInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;

public final class RollbackInfoBuilder {
    private int rollbackId;
    private List<PackageRollbackInfo> packages = ImmutableList.of();
    private boolean isStaged;
    private List<VersionedPackage> causePackages = ImmutableList.of();
    private int committedSessionId;

    private RollbackInfoBuilder() {
    }

    public static RollbackInfoBuilder newBuilder() {
        return new RollbackInfoBuilder();
    }

    public RollbackInfoBuilder setRollbackId(int rollbackId) {
        this.rollbackId = rollbackId;
        return this;
    }

    public RollbackInfoBuilder setPackages(List<PackageRollbackInfo> packages) {
        Preconditions.checkNotNull(packages, (Object)"Field 'packages' not allowed to be null.");
        this.packages = packages;
        return this;
    }

    public RollbackInfoBuilder setIsStaged(boolean isStaged) {
        this.isStaged = isStaged;
        return this;
    }

    public RollbackInfoBuilder setCausePackages(List<VersionedPackage> causePackages) {
        Preconditions.checkNotNull(causePackages, (Object)"Field 'causePackages' not allowed to be null.");
        this.causePackages = causePackages;
        return this;
    }

    public RollbackInfoBuilder setCommittedSessionId(int committedSessionId) {
        this.committedSessionId = committedSessionId;
        return this;
    }

    public RollbackInfo build() {
        Preconditions.checkState((RuntimeEnvironment.getApiLevel() >= 29 ? 1 : 0) != 0);
        return new RollbackInfo(this.rollbackId, this.packages, this.isStaged, this.causePackages, this.committedSessionId);
    }
}

