/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.nfc.INfcCardEmulation;
import android.nfc.cardemulation.CardEmulation;
import android.provider.Settings;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=CardEmulation.class)
public class ShadowCardEmulation {
    private static Map<String, ComponentName> defaultServiceForCategoryMap = new HashMap<String, ComponentName>();
    private static ComponentName preferredService = null;
    @RealObject
    CardEmulation cardEmulation;

    @Implementation(minSdk=19)
    public boolean isDefaultServiceForCategory(ComponentName service, String category) {
        return service.equals((Object)defaultServiceForCategoryMap.get(category));
    }

    @Implementation(minSdk=21)
    public boolean setPreferredService(Activity activity, ComponentName service) {
        preferredService = service;
        return true;
    }

    @Implementation(minSdk=21)
    public boolean unsetPreferredService(Activity activity) {
        preferredService = null;
        return true;
    }

    public static void setDefaultServiceForCategory(ComponentName service, String category) {
        defaultServiceForCategoryMap.put(category, service);
    }

    public static ComponentName getPreferredService() {
        return preferredService;
    }

    public static void setCategoryPaymentAllowsForegroundPreference(boolean value) {
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"nfc_payment_foreground", (int)(value ? 1 : 0));
    }

    @Resetter
    public static void reset() {
        defaultServiceForCategoryMap = new HashMap<String, ComponentName>();
        preferredService = null;
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            CardEmulationReflector reflector = (CardEmulationReflector)Reflector.reflector(CardEmulationReflector.class);
            reflector.setIsInitialized(false);
            reflector.setService(null);
            Map<Context, CardEmulation> cardEmus = reflector.getCardEmus();
            if (cardEmus != null) {
                cardEmus.clear();
            }
        }
    }

    @ForType(value=CardEmulation.class)
    static interface CardEmulationReflector {
        @Static
        @Accessor(value="sIsInitialized")
        public void setIsInitialized(boolean var1);

        @Static
        @Accessor(value="sService")
        public void setService(INfcCardEmulation var1);

        @Static
        @Accessor(value="sCardEmus")
        public Map<Context, CardEmulation> getCardEmus();
    }
}

