/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.location.BatchedLocationCallback;
import android.location.Criteria;
import android.location.GnssAntennaInfo;
import android.location.GnssMeasurementsEvent;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.location.LocationRequest;
import android.location.OnNmeaMessageListener;
import android.location.provider.ProviderProperties;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSettings;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=LocationManager.class, looseSignatures=true)
public class ShadowLocationManager {
    private static final String TAG = "ShadowLocationManager";
    private static final long GET_CURRENT_LOCATION_TIMEOUT_MS = 30000L;
    private static final long MAX_CURRENT_LOCATION_AGE_MS = 10000L;
    @GuardedBy(value="ShadowLocationManager.class")
    @Nullable
    private static Constructor<LocationProvider> locationProviderConstructor;
    @RealObject
    private LocationManager realLocationManager;
    @GuardedBy(value="providers")
    private final HashSet<ProviderEntry> providers = new HashSet();
    @GuardedBy(value="gpsStatusListeners")
    private final HashSet<GpsStatus.Listener> gpsStatusListeners = new HashSet();
    @GuardedBy(value="gnssStatusTransports")
    private final CopyOnWriteArrayList<GnssStatusCallbackTransport> gnssStatusTransports = new CopyOnWriteArrayList();
    @GuardedBy(value="nmeaMessageTransports")
    private final CopyOnWriteArrayList<OnNmeaMessageListenerTransport> nmeaMessageTransports = new CopyOnWriteArrayList();
    @GuardedBy(value="gnssMeasurementTransports")
    private final CopyOnWriteArrayList<GnssMeasurementsEventCallbackTransport> gnssMeasurementTransports = new CopyOnWriteArrayList();
    @GuardedBy(value="gnssAntennaInfoTransports")
    private final CopyOnWriteArrayList<GnssAntennaInfoListenerTransport> gnssAntennaInfoTransports = new CopyOnWriteArrayList();
    @Nullable
    private String gnssHardwareModelName;
    private int gnssYearOfHardware;
    private int gnssBatchSize;

    public ShadowLocationManager() {
        this.providers.add(new ProviderEntry("gps", new ProviderProperties(true, true, false, false, true, true, true, 3, 1)));
        this.providers.add(new ProviderEntry("network", new ProviderProperties(false, false, false, false, true, true, true, 1, 2)));
        this.providers.add(new ProviderEntry("passive", new ProviderProperties(false, false, false, false, false, false, false, 1, 2)));
    }

    @Implementation
    protected List<String> getAllProviders() {
        ArrayList<String> allProviders = new ArrayList<String>();
        for (ProviderEntry providerEntry : this.getProviderEntries()) {
            allProviders.add(providerEntry.getName());
        }
        return allProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    @Nullable
    protected LocationProvider getProvider(String name) {
        if (RuntimeEnvironment.getApiLevel() < 19) {
            return null;
        }
        ProviderEntry providerEntry = this.getProviderEntry(name);
        if (providerEntry == null) {
            return null;
        }
        ProviderProperties properties = providerEntry.getProperties();
        if (properties == null) {
            return null;
        }
        try {
            Class<ShadowLocationManager> clazz = ShadowLocationManager.class;
            synchronized (ShadowLocationManager.class) {
                if (locationProviderConstructor == null) {
                    locationProviderConstructor = RuntimeEnvironment.getApiLevel() >= 31 ? LocationProvider.class.getDeclaredConstructor(String.class, android.location.provider.ProviderProperties.class) : LocationProvider.class.getDeclaredConstructor(String.class, Class.forName("com.android.internal.location.ProviderProperties"));
                }
                locationProviderConstructor.setAccessible(true);
                if (RuntimeEnvironment.getApiLevel() >= 31) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return locationProviderConstructor.newInstance(name, properties.getProviderProperties());
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return locationProviderConstructor.newInstance(name, properties.getLegacyProviderProperties());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    @Implementation
    protected List<String> getProviders(boolean enabledOnly) {
        return this.getProviders(null, enabledOnly);
    }

    @Implementation
    protected List<String> getProviders(@Nullable Criteria criteria, boolean enabled) {
        ArrayList<String> matchingProviders = new ArrayList<String>();
        for (ProviderEntry providerEntry : this.getProviderEntries()) {
            if (enabled && !this.isProviderEnabled(providerEntry.getName()) || criteria != null && !providerEntry.meetsCriteria(criteria)) continue;
            matchingProviders.add(providerEntry.getName());
        }
        return matchingProviders;
    }

    @Implementation
    @Nullable
    protected String getBestProvider(Criteria criteria, boolean enabled) {
        List<String> providers = this.getProviders(criteria, enabled);
        if (providers.isEmpty()) {
            providers = this.getProviders(null, enabled);
        }
        if (!providers.isEmpty()) {
            if (providers.contains("gps")) {
                return "gps";
            }
            if (providers.contains("network")) {
                return "network";
            }
            return providers.get(0);
        }
        return null;
    }

    @Implementation(minSdk=31)
    @Nullable
    protected Object getProviderProperties(Object providerStr) {
        String provider = (String)providerStr;
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return null;
        }
        ProviderProperties properties = providerEntry.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.getProviderProperties();
    }

    @Implementation(minSdk=31)
    protected boolean hasProvider(String provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        return this.getProviderEntry(provider) != null;
    }

    @Implementation
    protected boolean isProviderEnabled(String provider) {
        if (RuntimeEnvironment.getApiLevel() >= 28 && !this.isLocationEnabled()) {
            return false;
        }
        ProviderEntry entry = this.getProviderEntry(provider);
        return entry != null && entry.isEnabled();
    }

    public void removeProvider(String name) {
        this.removeProviderEntry(name);
    }

    public void setProviderProperties(String name, @Nullable ProviderProperties properties) {
        this.getOrCreateProviderEntry(Objects.requireNonNull(name)).setProperties(properties);
    }

    public void setProviderEnabled(String name, boolean enabled) {
        this.getOrCreateProviderEntry(name).setEnabled(enabled);
    }

    @Implementation(minSdk=28)
    protected boolean isLocationEnabledForUser(UserHandle userHandle) {
        return this.isLocationEnabled();
    }

    @Implementation(minSdk=28)
    protected boolean isLocationEnabled() {
        return this.getLocationMode() != 0;
    }

    @Implementation(minSdk=28)
    protected void setLocationEnabledForUser(boolean enabled, UserHandle userHandle) {
        this.setLocationModeInternal(enabled ? 3 : 0);
    }

    public void setLocationEnabled(boolean enabled) {
        this.setLocationEnabledForUser(enabled, Process.myUserHandle());
    }

    private int getLocationMode() {
        return Settings.Secure.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"location_mode", (int)0);
    }

    public void setLocationMode(int locationMode) {
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            throw new AssertionError((Object)"Tests may not set location mode directly on P and above. Instead, use setLocationEnabled() and setProviderEnabled() in combination to achieve the desired result.");
        }
        this.setLocationModeInternal(locationMode);
    }

    private void setLocationModeInternal(int locationMode) {
        Settings.Secure.putInt((ContentResolver)this.getContext().getContentResolver(), (String)"location_mode", (int)locationMode);
    }

    @Implementation
    @Nullable
    protected Location getLastKnownLocation(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return null;
        }
        return providerEntry.getLastLocation();
    }

    @Deprecated
    public void setLastKnownLocation(String provider, @Nullable Location location) {
        this.getOrCreateProviderEntry(provider).setLastLocation(location);
    }

    @Implementation(minSdk=30)
    @RequiresApi(api=30)
    protected void getCurrentLocation(String provider, @Nullable CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        this.getCurrentLocationInternal(provider, LocationRequest.create(), cancellationSignal, executor, consumer);
    }

    @Implementation(minSdk=31)
    @RequiresApi(api=31)
    protected void getCurrentLocation(String provider, LocationRequest request, @Nullable CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        this.getCurrentLocationInternal(provider, request, cancellationSignal, executor, consumer);
    }

    @RequiresApi(api=30)
    private void getCurrentLocationInternal(String provider, LocationRequest request, @Nullable CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        long locationAgeMs;
        Location location;
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if ((location = this.getLastKnownLocation(provider)) != null && (locationAgeMs = SystemClock.elapsedRealtime() - TimeUnit.NANOSECONDS.toMillis(location.getElapsedRealtimeNanos())) < 10000L) {
            executor.execute(() -> consumer.accept(location));
            return;
        }
        CurrentLocationTransport listener = new CurrentLocationTransport(executor, consumer);
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(request), Runnable::run, listener);
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(listener::cancel);
        }
        listener.startTimeout(30000L);
    }

    @Implementation
    protected void requestSingleUpdate(String provider, LocationListener listener, @Nullable Looper looper) {
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(provider, 0L, 0.0f, true), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation
    protected void requestSingleUpdate(Criteria criteria, LocationListener listener, @Nullable Looper looper) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(bestProvider, new RoboLocationRequest(bestProvider, 0L, 0.0f, true), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation
    protected void requestSingleUpdate(String provider, PendingIntent pendingIntent) {
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(provider, 0L, 0.0f, true), pendingIntent);
    }

    @Implementation
    protected void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUpdatesInternal(bestProvider, new RoboLocationRequest(bestProvider, 0L, 0.0f, true), pendingIntent);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(provider, minTime, minDistance, false), new HandlerExecutor(new Handler()), listener);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, @Nullable Looper looper) {
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(provider, minTime, minDistance, false), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation(minSdk=30)
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, Executor executor, LocationListener listener) {
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(provider, minTime, minDistance, false), executor, listener);
    }

    @Implementation
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, LocationListener listener, @Nullable Looper looper) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(bestProvider, new RoboLocationRequest(bestProvider, minTime, minDistance, false), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation(minSdk=30)
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, Executor executor, LocationListener listener) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUpdatesInternal(bestProvider, new RoboLocationRequest(bestProvider, minTime, minDistance, false), executor, listener);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent pendingIntent) {
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(provider, minTime, minDistance, false), pendingIntent);
    }

    @Implementation
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent pendingIntent) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUpdatesInternal(bestProvider, new RoboLocationRequest(bestProvider, minTime, minDistance, false), pendingIntent);
    }

    @Implementation(minSdk=30)
    protected void requestLocationUpdates(@Nullable LocationRequest request, Executor executor, LocationListener listener) {
        if (request == null) {
            request = LocationRequest.create();
        }
        this.requestLocationUpdatesInternal(request.getProvider(), new RoboLocationRequest(request), executor, listener);
    }

    @Implementation(minSdk=19)
    protected void requestLocationUpdates(@Nullable LocationRequest request, LocationListener listener, Looper looper) {
        if (request == null) {
            request = LocationRequest.create();
        }
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(request.getProvider(), new RoboLocationRequest(request), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation(minSdk=19)
    protected void requestLocationUpdates(@Nullable LocationRequest request, PendingIntent pendingIntent) {
        if (request == null) {
            request = LocationRequest.create();
        }
        this.requestLocationUpdatesInternal(request.getProvider(), new RoboLocationRequest(request), pendingIntent);
    }

    @Implementation(minSdk=31)
    protected void requestLocationUpdates(String provider, LocationRequest request, Executor executor, LocationListener listener) {
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(request), executor, listener);
    }

    @Implementation(minSdk=31)
    protected void requestLocationUpdates(String provider, LocationRequest request, PendingIntent pendingIntent) {
        this.requestLocationUpdatesInternal(provider, new RoboLocationRequest(request), pendingIntent);
    }

    private void requestLocationUpdatesInternal(String provider, RoboLocationRequest request, Executor executor, LocationListener listener) {
        if (provider == null || request == null || executor == null || listener == null) {
            throw new IllegalArgumentException();
        }
        this.getOrCreateProviderEntry(provider).addListener(listener, request, executor);
    }

    private void requestLocationUpdatesInternal(String provider, RoboLocationRequest request, PendingIntent pendingIntent) {
        if (provider == null || request == null || pendingIntent == null) {
            throw new IllegalArgumentException();
        }
        this.getOrCreateProviderEntry(provider).addListener(pendingIntent, request);
    }

    @Implementation
    protected void removeUpdates(LocationListener listener) {
        this.removeUpdatesInternal(listener);
    }

    @Implementation
    protected void removeUpdates(PendingIntent pendingIntent) {
        this.removeUpdatesInternal(pendingIntent);
    }

    private void removeUpdatesInternal(Object key) {
        for (ProviderEntry providerEntry : this.getProviderEntries()) {
            providerEntry.removeListener(key);
        }
    }

    @Implementation(minSdk=31)
    protected void requestFlush(String provider, LocationListener listener, int requestCode) {
        ProviderEntry entry = this.getProviderEntry(provider);
        if (entry == null) {
            throw new IllegalArgumentException("unknown provider \"" + provider + "\"");
        }
        entry.requestFlush(listener, requestCode);
    }

    @Implementation(minSdk=31)
    protected void requestFlush(String provider, PendingIntent pendingIntent, int requestCode) {
        ProviderEntry entry = this.getProviderEntry(provider);
        if (entry == null) {
            throw new IllegalArgumentException("unknown provider \"" + provider + "\"");
        }
        entry.requestFlush(pendingIntent, requestCode);
    }

    @RequiresApi(value=19)
    public List<LocationRequest> getLocationRequests(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(providerEntry.getTransports(), transport -> transport.getRequest().getLocationRequest()));
    }

    public List<RoboLocationRequest> getLegacyLocationRequests(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(providerEntry.getTransports(), LocationTransport::getRequest));
    }

    @Implementation(minSdk=28)
    protected boolean injectLocation(Location location) {
        return false;
    }

    @Implementation(minSdk=26)
    protected int getGnssBatchSize() {
        return this.gnssBatchSize;
    }

    public void setGnssBatchSize(int gnssBatchSize) {
        this.gnssBatchSize = gnssBatchSize;
    }

    @Implementation(minSdk=26)
    protected boolean registerGnssBatchedLocationCallback(Object periodNanos, Object wakeOnFifoFull, Object callback, Object handler) {
        this.getOrCreateProviderEntry("gps").setLegacyBatchedListener(callback, new HandlerExecutor((Handler)handler), this.gnssBatchSize, (Boolean)wakeOnFifoFull);
        return true;
    }

    @Implementation(minSdk=26)
    protected void flushGnssBatch() {
        ProviderEntry e = this.getProviderEntry("gps");
        if (e != null) {
            e.flushLegacyBatch();
        }
    }

    @Implementation(minSdk=26)
    protected boolean unregisterGnssBatchedLocationCallback(Object callback) {
        ProviderEntry e = this.getProviderEntry("gps");
        if (e != null) {
            e.clearLegacyBatchedListener();
        }
        return true;
    }

    @Implementation(minSdk=28)
    @Nullable
    protected String getGnssHardwareModelName() {
        return this.gnssHardwareModelName;
    }

    public void setGnssHardwareModelName(@Nullable String gnssHardwareModelName) {
        this.gnssHardwareModelName = gnssHardwareModelName;
    }

    @Implementation(minSdk=28)
    protected int getGnssYearOfHardware() {
        return this.gnssYearOfHardware;
    }

    public void setGnssYearOfHardware(int gnssYearOfHardware) {
        this.gnssYearOfHardware = gnssYearOfHardware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean addGpsStatusListener(GpsStatus.Listener listener) {
        if (RuntimeEnvironment.getApiLevel() > 30) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            this.gpsStatusListeners.add(listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void removeGpsStatusListener(GpsStatus.Listener listener) {
        if (RuntimeEnvironment.getApiLevel() > 30) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            this.gpsStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GpsStatus.Listener> getGpsStatusListeners() {
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            return new ArrayList<GpsStatus.Listener>(this.gpsStatusListeners);
        }
    }

    @Implementation(minSdk=24)
    protected boolean registerGnssStatusCallback(GnssStatus.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        return this.registerGnssStatusCallback(new HandlerExecutor(handler), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected boolean registerGnssStatusCallback(Executor executor, GnssStatus.Callback listener) {
        CopyOnWriteArrayList<GnssStatusCallbackTransport> copyOnWriteArrayList = this.gnssStatusTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.gnssStatusTransports, transport -> transport.getListener() == listener);
            this.gnssStatusTransports.add(new GnssStatusCallbackTransport(executor, listener));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void unregisterGnssStatusCallback(GnssStatus.Callback listener) {
        CopyOnWriteArrayList<GnssStatusCallbackTransport> copyOnWriteArrayList = this.gnssStatusTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.gnssStatusTransports, transport -> transport.getListener() == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=24)
    public void simulateGnssStatusStarted() {
        CopyOnWriteArrayList<GnssStatusCallbackTransport> transports;
        CopyOnWriteArrayList<GnssStatusCallbackTransport> copyOnWriteArrayList = this.gnssStatusTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.gnssStatusTransports;
        }
        for (GnssStatusCallbackTransport transport : transports) {
            transport.onStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=24)
    public void simulateGnssStatusFirstFix(int ttff) {
        CopyOnWriteArrayList<GnssStatusCallbackTransport> transports;
        CopyOnWriteArrayList<GnssStatusCallbackTransport> copyOnWriteArrayList = this.gnssStatusTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.gnssStatusTransports;
        }
        for (GnssStatusCallbackTransport transport : transports) {
            transport.onFirstFix(ttff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=24)
    public void simulateGnssStatus(GnssStatus status) {
        CopyOnWriteArrayList<GnssStatusCallbackTransport> transports;
        CopyOnWriteArrayList<GnssStatusCallbackTransport> copyOnWriteArrayList = this.gnssStatusTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.gnssStatusTransports;
        }
        for (GnssStatusCallbackTransport transport : transports) {
            transport.onSatelliteStatusChanged(status);
        }
    }

    @Deprecated
    @RequiresApi(value=24)
    public void sendGnssStatus(GnssStatus status) {
        this.simulateGnssStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=24)
    public void simulateGnssStatusStopped() {
        CopyOnWriteArrayList<GnssStatusCallbackTransport> transports;
        CopyOnWriteArrayList<GnssStatusCallbackTransport> copyOnWriteArrayList = this.gnssStatusTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.gnssStatusTransports;
        }
        for (GnssStatusCallbackTransport transport : transports) {
            transport.onStopped();
        }
    }

    @Implementation(minSdk=24)
    protected boolean addNmeaListener(OnNmeaMessageListener listener, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        return this.addNmeaListener(new HandlerExecutor(handler), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected boolean addNmeaListener(Executor executor, OnNmeaMessageListener listener) {
        CopyOnWriteArrayList<OnNmeaMessageListenerTransport> copyOnWriteArrayList = this.nmeaMessageTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.nmeaMessageTransports, transport -> transport.getListener() == listener);
            this.nmeaMessageTransports.add(new OnNmeaMessageListenerTransport(executor, listener));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void removeNmeaListener(OnNmeaMessageListener listener) {
        CopyOnWriteArrayList<OnNmeaMessageListenerTransport> copyOnWriteArrayList = this.nmeaMessageTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.nmeaMessageTransports, transport -> transport.getListener() == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=24)
    public void simulateNmeaMessage(String message, long timestamp) {
        CopyOnWriteArrayList<OnNmeaMessageListenerTransport> transports;
        CopyOnWriteArrayList<OnNmeaMessageListenerTransport> copyOnWriteArrayList = this.nmeaMessageTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.nmeaMessageTransports;
        }
        for (OnNmeaMessageListenerTransport transport : transports) {
            transport.onNmeaMessage(message, timestamp);
        }
    }

    @Deprecated
    @RequiresApi(api=24)
    public void sendNmeaMessage(String message, long timestamp) {
        this.simulateNmeaMessage(message, timestamp);
    }

    @Implementation(minSdk=24)
    protected boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback listener, Handler handler) {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            if (handler == null) {
                handler = new Handler();
            }
            return this.registerGnssMeasurementsCallback(new HandlerExecutor(handler), listener);
        }
        return this.registerGnssMeasurementsCallback(Runnable::run, listener);
    }

    @Implementation(minSdk=30)
    @RequiresApi(api=30)
    protected boolean registerGnssMeasurementsCallback(Object request, Object executor, Object callback) {
        return this.registerGnssMeasurementsCallback((Executor)executor, (GnssMeasurementsEvent.Callback)callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected boolean registerGnssMeasurementsCallback(Executor executor, GnssMeasurementsEvent.Callback listener) {
        CopyOnWriteArrayList<GnssMeasurementsEventCallbackTransport> copyOnWriteArrayList = this.gnssMeasurementTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.gnssMeasurementTransports, transport -> transport.getListener() == listener);
            this.gnssMeasurementTransports.add(new GnssMeasurementsEventCallbackTransport(executor, listener));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void unregisterGnssMeasurementsCallback(GnssMeasurementsEvent.Callback listener) {
        CopyOnWriteArrayList<GnssMeasurementsEventCallbackTransport> copyOnWriteArrayList = this.gnssMeasurementTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.gnssMeasurementTransports, transport -> transport.getListener() == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=24)
    public void simulateGnssMeasurementsEvent(GnssMeasurementsEvent event) {
        CopyOnWriteArrayList<GnssMeasurementsEventCallbackTransport> transports;
        CopyOnWriteArrayList<GnssMeasurementsEventCallbackTransport> copyOnWriteArrayList = this.gnssMeasurementTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.gnssMeasurementTransports;
        }
        for (GnssMeasurementsEventCallbackTransport transport : transports) {
            transport.onGnssMeasurementsReceived(event);
        }
    }

    @Deprecated
    @RequiresApi(api=24)
    public void sendGnssMeasurementsEvent(GnssMeasurementsEvent event) {
        this.simulateGnssMeasurementsEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=24)
    public void simulateGnssMeasurementsStatus(int status) {
        CopyOnWriteArrayList<GnssMeasurementsEventCallbackTransport> transports;
        CopyOnWriteArrayList<GnssMeasurementsEventCallbackTransport> copyOnWriteArrayList = this.gnssMeasurementTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.gnssMeasurementTransports;
        }
        for (GnssMeasurementsEventCallbackTransport transport : transports) {
            transport.onStatusChanged(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected Object registerAntennaInfoListener(Object executor, Object listener) {
        CopyOnWriteArrayList<GnssAntennaInfoListenerTransport> copyOnWriteArrayList = this.gnssAntennaInfoTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.gnssAntennaInfoTransports, transport -> transport.getListener() == listener);
            this.gnssAntennaInfoTransports.add(new GnssAntennaInfoListenerTransport((Executor)executor, (GnssAntennaInfo.Listener)listener));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected void unregisterAntennaInfoListener(Object listener) {
        CopyOnWriteArrayList<GnssAntennaInfoListenerTransport> copyOnWriteArrayList = this.gnssAntennaInfoTransports;
        synchronized (copyOnWriteArrayList) {
            Iterables.removeIf(this.gnssAntennaInfoTransports, transport -> transport.getListener() == listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=30)
    public void simulateGnssAntennaInfo(List<GnssAntennaInfo> antennaInfos) {
        CopyOnWriteArrayList<GnssAntennaInfoListenerTransport> transports;
        CopyOnWriteArrayList<GnssAntennaInfoListenerTransport> copyOnWriteArrayList = this.gnssAntennaInfoTransports;
        synchronized (copyOnWriteArrayList) {
            transports = this.gnssAntennaInfoTransports;
        }
        for (GnssAntennaInfoListenerTransport transport : transports) {
            transport.onGnssAntennaInfoReceived(new ArrayList<GnssAntennaInfo>(antennaInfos));
        }
    }

    @Deprecated
    @RequiresApi(api=30)
    public void sendGnssAntennaInfo(List<GnssAntennaInfo> antennaInfos) {
        this.simulateGnssAntennaInfo(antennaInfos);
    }

    public void simulateLocation(Location location) {
        this.simulateLocation(location.getProvider(), location);
    }

    public void simulateLocation(String provider, Location ... locations) {
        ProviderEntry passiveProviderEntry;
        ProviderEntry providerEntry = this.getOrCreateProviderEntry(provider);
        if (!"passive".equals(providerEntry.getName())) {
            providerEntry.simulateLocation(locations);
        }
        if ((passiveProviderEntry = this.getProviderEntry("passive")) != null) {
            passiveProviderEntry.simulateLocation(locations);
        }
    }

    @Deprecated
    public List<LocationListener> getRequestLocationUpdateListeners() {
        return this.getLocationUpdateListeners();
    }

    @Deprecated
    public List<LocationListener> getLocationUpdateListeners() {
        HashSet listeners = new HashSet();
        for (ProviderEntry providerEntry : this.getProviderEntries()) {
            Iterables.addAll(listeners, (Iterable)Iterables.transform((Iterable)Iterables.filter(providerEntry.getTransports(), LocationListenerTransport.class), LocationTransport::getKey));
        }
        return new ArrayList<LocationListener>(listeners);
    }

    @Deprecated
    public List<LocationListener> getLocationUpdateListeners(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return Collections.emptyList();
        }
        HashSet listeners = new HashSet();
        Iterables.addAll(listeners, (Iterable)Iterables.transform((Iterable)Iterables.filter(providerEntry.getTransports(), LocationListenerTransport.class), LocationTransport::getKey));
        return new ArrayList<LocationListener>(listeners);
    }

    @Deprecated
    public List<PendingIntent> getLocationUpdatePendingIntents() {
        HashSet listeners = new HashSet();
        for (ProviderEntry providerEntry : this.getProviderEntries()) {
            Iterables.addAll(listeners, (Iterable)Iterables.transform((Iterable)Iterables.filter(providerEntry.getTransports(), LocationPendingIntentTransport.class), LocationTransport::getKey));
        }
        return new ArrayList<PendingIntent>(listeners);
    }

    @Deprecated
    public List<PendingIntent> getLocationUpdatePendingIntents(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return Collections.emptyList();
        }
        HashSet listeners = new HashSet();
        Iterables.addAll(listeners, (Iterable)Iterables.transform((Iterable)Iterables.filter(providerEntry.getTransports(), LocationPendingIntentTransport.class), LocationTransport::getKey));
        return new ArrayList<PendingIntent>(listeners);
    }

    private Context getContext() {
        return (Context)ReflectionHelpers.getField((Object)this.realLocationManager, (String)"mContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderEntry getOrCreateProviderEntry(String name) {
        if (name == null) {
            throw new IllegalArgumentException("cannot use a null provider");
        }
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ProviderEntry providerEntry = this.getProviderEntry(name);
            if (providerEntry == null) {
                providerEntry = new ProviderEntry(name, null);
                this.providers.add(providerEntry);
            }
            return providerEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ProviderEntry getProviderEntry(String name) {
        if (name == null) {
            return null;
        }
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            for (ProviderEntry providerEntry : this.providers) {
                if (!name.equals(providerEntry.getName())) continue;
                return providerEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ProviderEntry> getProviderEntries() {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            return this.providers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProviderEntry(String name) {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            this.providers.remove(this.getProviderEntry(name));
        }
    }

    static float distanceBetween(Location location1, Location location2) {
        double earthRadius = 3958.75;
        double latDifference = Math.toRadians(location2.getLatitude() - location1.getLatitude());
        double lonDifference = Math.toRadians(location2.getLongitude() - location1.getLongitude());
        double a = Math.sin(latDifference / 2.0) * Math.sin(latDifference / 2.0) + Math.cos(Math.toRadians(location1.getLatitude())) * Math.cos(Math.toRadians(location2.getLatitude())) * Math.sin(lonDifference / 2.0) * Math.sin(lonDifference / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = Math.abs(earthRadius * c);
        int meterConversion = 1609;
        return (float)(dist * (double)meterConversion);
    }

    @Resetter
    public static synchronized void reset() {
        locationProviderConstructor = null;
    }

    private static final class HandlerExecutor
    implements Executor {
        private final Handler handler;

        HandlerExecutor(Handler handler) {
            this.handler = Objects.requireNonNull(handler);
        }

        @Override
        public void execute(Runnable command) {
            if (!this.handler.post(command)) {
                throw new RejectedExecutionException(this.handler + " is shutting down");
            }
        }
    }

    private static final class GnssAntennaInfoListenerTransport {
        private final Executor executor;
        private final GnssAntennaInfo.Listener listener;

        GnssAntennaInfoListenerTransport(Executor executor, GnssAntennaInfo.Listener listener) {
            this.executor = Objects.requireNonNull(executor);
            this.listener = Objects.requireNonNull(listener);
        }

        GnssAntennaInfo.Listener getListener() {
            return this.listener;
        }

        @RequiresApi(api=30)
        public void onGnssAntennaInfoReceived(List<GnssAntennaInfo> antennaInfos) {
            this.executor.execute(() -> this.listener.onGnssAntennaInfoReceived(antennaInfos));
        }
    }

    private static final class GnssMeasurementsEventCallbackTransport {
        private final Executor executor;
        private final GnssMeasurementsEvent.Callback listener;

        GnssMeasurementsEventCallbackTransport(Executor executor, GnssMeasurementsEvent.Callback listener) {
            this.executor = Objects.requireNonNull(executor);
            this.listener = Objects.requireNonNull(listener);
        }

        GnssMeasurementsEvent.Callback getListener() {
            return this.listener;
        }

        @RequiresApi(api=24)
        public void onStatusChanged(int status) {
            this.executor.execute(() -> this.listener.onStatusChanged(status));
        }

        @RequiresApi(api=24)
        public void onGnssMeasurementsReceived(GnssMeasurementsEvent event) {
            this.executor.execute(() -> this.listener.onGnssMeasurementsReceived(event));
        }
    }

    private static final class OnNmeaMessageListenerTransport {
        private final Executor executor;
        private final OnNmeaMessageListener listener;

        OnNmeaMessageListenerTransport(Executor executor, OnNmeaMessageListener listener) {
            this.executor = Objects.requireNonNull(executor);
            this.listener = Objects.requireNonNull(listener);
        }

        OnNmeaMessageListener getListener() {
            return this.listener;
        }

        @RequiresApi(api=24)
        public void onNmeaMessage(String message, long timestamp) {
            this.executor.execute(() -> this.listener.onNmeaMessage(message, timestamp));
        }
    }

    private static final class GnssStatusCallbackTransport {
        private final Executor executor;
        private final GnssStatus.Callback listener;

        GnssStatusCallbackTransport(Executor executor, GnssStatus.Callback listener) {
            this.executor = Objects.requireNonNull(executor);
            this.listener = Objects.requireNonNull(listener);
        }

        GnssStatus.Callback getListener() {
            return this.listener;
        }

        @RequiresApi(api=24)
        public void onStarted() {
            this.executor.execute(() -> ((GnssStatus.Callback)this.listener).onStarted());
        }

        @RequiresApi(api=24)
        public void onFirstFix(int ttff) {
            this.executor.execute(() -> this.listener.onFirstFix(ttff));
        }

        @RequiresApi(api=24)
        public void onSatelliteStatusChanged(GnssStatus status) {
            this.executor.execute(() -> this.listener.onSatelliteStatusChanged(status));
        }

        @RequiresApi(api=24)
        public void onStopped() {
            this.executor.execute(() -> ((GnssStatus.Callback)this.listener).onStopped());
        }
    }

    @RequiresApi(api=24)
    private final class CurrentLocationTransport
    implements LocationListener {
        private final Executor executor;
        private final Consumer<Location> consumer;
        private final Handler timeoutHandler;
        @GuardedBy(value="this")
        private boolean triggered;
        @Nullable
        Runnable timeoutRunnable;

        CurrentLocationTransport(Executor executor, Consumer<Location> consumer) {
            this.executor = executor;
            this.consumer = consumer;
            this.timeoutHandler = new Handler(Looper.getMainLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            CurrentLocationTransport currentLocationTransport = this;
            synchronized (currentLocationTransport) {
                if (this.triggered) {
                    return;
                }
                this.triggered = true;
            }
            this.cleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTimeout(long timeoutMs) {
            CurrentLocationTransport currentLocationTransport = this;
            synchronized (currentLocationTransport) {
                if (this.triggered) {
                    return;
                }
                this.timeoutRunnable = () -> {
                    this.timeoutRunnable = null;
                    this.onLocationChanged(null);
                };
                this.timeoutHandler.postDelayed(this.timeoutRunnable, timeoutMs);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
            this.onLocationChanged(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLocationChanged(@Nullable Location location) {
            CurrentLocationTransport currentLocationTransport = this;
            synchronized (currentLocationTransport) {
                if (this.triggered) {
                    return;
                }
                this.triggered = true;
            }
            this.executor.execute(() -> this.consumer.accept(location));
            this.cleanup();
        }

        private void cleanup() {
            ShadowLocationManager.this.removeUpdates(this);
            if (this.timeoutRunnable != null) {
                this.timeoutHandler.removeCallbacks(this.timeoutRunnable);
                this.timeoutRunnable = null;
            }
        }
    }

    private static final class LegacyBatchedTransport {
        private final BatchedLocationCallback callback;
        private final Executor executor;
        private final int batchSize;
        private final boolean flushOnFifoFull;
        private ArrayList<Location> batch = new ArrayList();

        LegacyBatchedTransport(Object callback, Executor executor, int batchSize, boolean flushOnFifoFull) {
            this.callback = (BatchedLocationCallback)callback;
            this.executor = executor;
            this.batchSize = batchSize;
            this.flushOnFifoFull = flushOnFifoFull;
        }

        public void invokeFlush() {
            ArrayList<Location> delivery = this.batch;
            this.batch = new ArrayList();
            this.executor.execute(() -> {
                this.callback.onLocationBatch((List)delivery);
                if (!delivery.isEmpty()) {
                    this.callback.onLocationBatch(new ArrayList());
                }
            });
        }

        public void invokeOnLocations(Location ... locations) {
            for (Location location : locations) {
                this.batch.add(new Location(location));
                if (this.batch.size() < this.batchSize) continue;
                if (!this.flushOnFifoFull) {
                    this.batch.remove(0);
                    continue;
                }
                ArrayList<Location> delivery = this.batch;
                this.batch = new ArrayList();
                this.executor.execute(() -> this.callback.onLocationBatch((List)delivery));
            }
        }
    }

    private static final class LocationPendingIntentTransport
    extends LocationTransport<PendingIntent> {
        private final Context context;

        LocationPendingIntentTransport(Context context, PendingIntent key, RoboLocationRequest request) {
            super(key, request);
            this.context = context;
        }

        @Override
        void onLocation(Location location) throws PendingIntent.CanceledException {
            Intent intent = new Intent();
            intent.putExtra("location", (Parcelable)new Location(location));
            ((PendingIntent)this.getKey()).send(this.context, 0, intent);
        }

        @Override
        void onLocations(List<Location> locations) throws PendingIntent.CanceledException {
            if (RuntimeEnvironment.getApiLevel() >= 31) {
                Intent intent = new Intent();
                intent.putExtra("location", (Parcelable)locations.get(locations.size() - 1));
                intent.putExtra("locations", (Parcelable[])locations.toArray(new Location[0]));
                ((PendingIntent)this.getKey()).send(this.context, 0, intent);
            } else {
                for (Location location : locations) {
                    this.onLocation(location);
                }
            }
        }

        @Override
        void onProviderEnabled(String provider, boolean enabled) throws PendingIntent.CanceledException {
            Intent intent = new Intent();
            intent.putExtra("providerEnabled", enabled);
            ((PendingIntent)this.getKey()).send(this.context, 0, intent);
        }

        @Override
        void onFlushComplete(int requestCode) throws PendingIntent.CanceledException {
            Intent intent = new Intent();
            intent.putExtra("flushComplete", requestCode);
            ((PendingIntent)this.getKey()).send(this.context, 0, intent);
        }
    }

    private static final class LocationListenerTransport
    extends LocationTransport<LocationListener> {
        private final Executor executor;

        LocationListenerTransport(LocationListener key, RoboLocationRequest request, Executor executor) {
            super(key, request);
            this.executor = executor;
        }

        @Override
        void onLocation(Location location) {
            this.executor.execute(() -> ((LocationListener)this.getKey()).onLocationChanged(location));
        }

        @Override
        void onLocations(List<Location> locations) {
            this.executor.execute(() -> {
                if (RuntimeEnvironment.getApiLevel() >= 31) {
                    ((LocationListener)this.getKey()).onLocationChanged(locations);
                } else {
                    for (Location location : locations) {
                        ((LocationListener)this.getKey()).onLocationChanged(location);
                    }
                }
            });
        }

        @Override
        void onProviderEnabled(String provider, boolean enabled) {
            this.executor.execute(() -> {
                if (enabled) {
                    ((LocationListener)this.getKey()).onProviderEnabled(provider);
                } else {
                    ((LocationListener)this.getKey()).onProviderDisabled(provider);
                }
            });
        }

        @Override
        void onFlushComplete(int requestCode) {
            this.executor.execute(() -> ((LocationListener)this.getKey()).onFlushComplete(requestCode));
        }
    }

    private static abstract class LocationTransport<KeyT> {
        private final KeyT key;
        private final RoboLocationRequest request;
        private Location lastDeliveredLocation;
        private int numDeliveries;

        LocationTransport(KeyT key, RoboLocationRequest request) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            this.key = key;
            this.request = request;
        }

        public KeyT getKey() {
            return this.key;
        }

        public RoboLocationRequest getRequest() {
            return this.request;
        }

        public boolean invokeOnLocations(Location ... locations) {
            ArrayList<Location> deliverableLocations = new ArrayList<Location>(locations.length);
            for (Location location : locations) {
                if (this.lastDeliveredLocation != null) {
                    if (location.getTime() - this.lastDeliveredLocation.getTime() < this.request.getMinUpdateIntervalMillis()) {
                        Log.w((String)ShadowLocationManager.TAG, (String)"location rejected for simulated delivery - too fast");
                        continue;
                    }
                    if (ShadowLocationManager.distanceBetween(location, this.lastDeliveredLocation) < this.request.getMinUpdateDistanceMeters()) {
                        Log.w((String)ShadowLocationManager.TAG, (String)"location rejected for simulated delivery - too close");
                        continue;
                    }
                }
                deliverableLocations.add(new Location(location));
                this.lastDeliveredLocation = new Location(location);
            }
            if (deliverableLocations.isEmpty()) {
                return true;
            }
            boolean needsRemoval = false;
            this.numDeliveries += deliverableLocations.size();
            if (this.numDeliveries >= this.request.getMaxUpdates()) {
                needsRemoval = true;
            }
            try {
                if (deliverableLocations.size() == 1) {
                    this.onLocation(deliverableLocations.get(0));
                } else {
                    this.onLocations(deliverableLocations);
                }
            }
            catch (PendingIntent.CanceledException e) {
                needsRemoval = true;
            }
            return !needsRemoval;
        }

        public boolean invokeOnProviderEnabled(String provider, boolean enabled) {
            try {
                this.onProviderEnabled(provider, enabled);
                return true;
            }
            catch (PendingIntent.CanceledException e) {
                return false;
            }
        }

        public boolean invokeOnFlush(int requestCode) {
            try {
                this.onFlushComplete(requestCode);
                return true;
            }
            catch (PendingIntent.CanceledException e) {
                return false;
            }
        }

        abstract void onLocation(Location var1) throws PendingIntent.CanceledException;

        abstract void onLocations(List<Location> var1) throws PendingIntent.CanceledException;

        abstract void onProviderEnabled(String var1, boolean var2) throws PendingIntent.CanceledException;

        abstract void onFlushComplete(int var1) throws PendingIntent.CanceledException;
    }

    public static final class RoboLocationRequest {
        @Nullable
        private final Object locationRequest;
        private final long intervalMillis;
        private final float minUpdateDistanceMeters;
        private final boolean singleShot;

        @RequiresApi(value=19)
        public RoboLocationRequest(LocationRequest locationRequest) {
            this.locationRequest = Objects.requireNonNull(locationRequest);
            this.intervalMillis = 0L;
            this.minUpdateDistanceMeters = 0.0f;
            this.singleShot = false;
        }

        public RoboLocationRequest(String provider, long intervalMillis, float minUpdateDistanceMeters, boolean singleShot) {
            this.locationRequest = RuntimeEnvironment.getApiLevel() >= 19 ? LocationRequest.createFromDeprecatedProvider((String)provider, (long)intervalMillis, (float)minUpdateDistanceMeters, (boolean)singleShot) : null;
            this.intervalMillis = intervalMillis;
            this.minUpdateDistanceMeters = minUpdateDistanceMeters;
            this.singleShot = singleShot;
        }

        @RequiresApi(value=19)
        public LocationRequest getLocationRequest() {
            return (LocationRequest)Objects.requireNonNull(this.locationRequest);
        }

        public long getIntervalMillis() {
            if (this.locationRequest != null) {
                return ((LocationRequest)this.locationRequest).getInterval();
            }
            return this.intervalMillis;
        }

        public float getMinUpdateDistanceMeters() {
            if (this.locationRequest != null) {
                return ((LocationRequest)this.locationRequest).getSmallestDisplacement();
            }
            return this.minUpdateDistanceMeters;
        }

        public boolean isSingleShot() {
            if (this.locationRequest != null) {
                return ((LocationRequest)this.locationRequest).getNumUpdates() == 1;
            }
            return this.singleShot;
        }

        long getMinUpdateIntervalMillis() {
            if (this.locationRequest != null) {
                return ((LocationRequest)this.locationRequest).getFastestInterval();
            }
            return this.intervalMillis;
        }

        int getMaxUpdates() {
            if (this.locationRequest != null) {
                return ((LocationRequest)this.locationRequest).getNumUpdates();
            }
            return this.singleShot ? 1 : Integer.MAX_VALUE;
        }

        public boolean equals(Object o) {
            if (o instanceof RoboLocationRequest) {
                RoboLocationRequest that = (RoboLocationRequest)o;
                if (RuntimeEnvironment.getApiLevel() >= 31) {
                    return Objects.equals(this.locationRequest, that.locationRequest);
                }
                if (this.intervalMillis != that.intervalMillis || this.singleShot != that.singleShot || Float.compare(that.minUpdateDistanceMeters, this.minUpdateDistanceMeters) != 0 || this.locationRequest == null != (that.locationRequest == null)) {
                    return false;
                }
                if (this.locationRequest != null) {
                    WorkSource thatWorkSource;
                    LocationRequest lr = (LocationRequest)this.locationRequest;
                    LocationRequest thatLr = (LocationRequest)that.locationRequest;
                    if (lr.getQuality() != thatLr.getQuality() || lr.getInterval() != thatLr.getInterval() || lr.getFastestInterval() != thatLr.getFastestInterval() || lr.getExpireAt() != thatLr.getExpireAt() || lr.getNumUpdates() != thatLr.getNumUpdates() || lr.getSmallestDisplacement() != thatLr.getSmallestDisplacement() || lr.getHideFromAppOps() != thatLr.getHideFromAppOps() || !Objects.equals(lr.getProvider(), thatLr.getProvider())) {
                        return false;
                    }
                    WorkSource workSource = lr.getWorkSource() == null ? new WorkSource() : lr.getWorkSource();
                    WorkSource workSource2 = thatWorkSource = thatLr.getWorkSource() == null ? new WorkSource() : thatLr.getWorkSource();
                    if (!workSource.equals((Object)thatWorkSource)) {
                        return false;
                    }
                    if (RuntimeEnvironment.getApiLevel() >= 29 && (lr.isLowPowerMode() != thatLr.isLowPowerMode() || lr.isLocationSettingsIgnored() != thatLr.isLocationSettingsIgnored())) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.locationRequest != null) {
                return this.locationRequest.hashCode();
            }
            return Objects.hash(this.intervalMillis, this.singleShot, Float.valueOf(this.minUpdateDistanceMeters));
        }

        public String toString() {
            if (this.locationRequest != null) {
                return this.locationRequest.toString();
            }
            return "Request[interval=" + this.intervalMillis + ", minUpdateDistance=" + this.minUpdateDistanceMeters + ", singleShot=" + this.singleShot + "]";
        }
    }

    private final class ProviderEntry {
        private final String name;
        @GuardedBy(value="this")
        private final CopyOnWriteArrayList<LocationTransport<?>> locationTransports = new CopyOnWriteArrayList();
        @GuardedBy(value="this")
        @Nullable
        private LegacyBatchedTransport legacyBatchedTransport;
        @GuardedBy(value="this")
        @Nullable
        private ProviderProperties properties;
        @GuardedBy(value="this")
        private boolean enabled;
        @GuardedBy(value="this")
        @Nullable
        private Location lastLocation;

        ProviderEntry(@Nullable String name, ProviderProperties properties) {
            this.name = name;
            this.properties = properties;
            switch (name) {
                case "passive": {
                    this.enabled = true;
                    break;
                }
                case "gps": {
                    this.enabled = true;
                    break;
                }
                case "network": {
                    this.enabled = false;
                    break;
                }
                default: {
                    this.enabled = false;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public synchronized List<LocationTransport<?>> getTransports() {
            return this.locationTransports;
        }

        @Nullable
        public synchronized ProviderProperties getProperties() {
            return this.properties;
        }

        public synchronized void setProperties(@Nullable ProviderProperties properties) {
            this.properties = properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled() {
            if ("passive".equals(this.name) || RuntimeEnvironment.getApiLevel() >= 29) {
                ProviderEntry providerEntry = this;
                synchronized (providerEntry) {
                    return this.enabled;
                }
            }
            String allowedProviders = Settings.Secure.getString((ContentResolver)ShadowLocationManager.this.getContext().getContentResolver(), (String)"location_providers_allowed");
            if (TextUtils.isEmpty((CharSequence)allowedProviders)) {
                return false;
            }
            return Arrays.asList(allowedProviders.split(",")).contains(this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            CopyOnWriteArrayList<LocationTransport<?>> transports;
            ProviderEntry providerEntry = this;
            synchronized (providerEntry) {
                int n;
                if ("passive".equals(this.name)) {
                    this.enabled = enabled;
                    return;
                }
                int newLocationMode = n = ShadowLocationManager.this.getLocationMode();
                if (RuntimeEnvironment.getApiLevel() < 28) {
                    if ("gps".equals(this.name)) {
                        if (enabled) {
                            switch (n) {
                                case 0: {
                                    newLocationMode = 1;
                                    break;
                                }
                                case 2: {
                                    newLocationMode = 3;
                                    break;
                                }
                            }
                        } else {
                            switch (n) {
                                case 1: {
                                    newLocationMode = 0;
                                    break;
                                }
                                case 3: {
                                    newLocationMode = 2;
                                    break;
                                }
                            }
                        }
                    } else if ("network".equals(this.name)) {
                        if (enabled) {
                            switch (n) {
                                case 0: {
                                    newLocationMode = 2;
                                    break;
                                }
                                case 1: {
                                    newLocationMode = 3;
                                    break;
                                }
                            }
                        } else {
                            switch (n) {
                                case 2: {
                                    newLocationMode = 0;
                                    break;
                                }
                                case 3: {
                                    newLocationMode = 1;
                                    break;
                                }
                            }
                        }
                    }
                }
                if (newLocationMode != n) {
                    ShadowLocationManager.this.setLocationModeInternal(newLocationMode);
                } else if (RuntimeEnvironment.getApiLevel() >= 29) {
                    if (enabled == this.enabled) {
                        return;
                    }
                    this.enabled = enabled;
                    ShadowSettings.ShadowSecure.updateEnabledProviders(ShadowLocationManager.this.getContext().getContentResolver(), this.name, enabled);
                } else {
                    if (enabled == this.enabled) {
                        return;
                    }
                    this.enabled = enabled;
                    ShadowSettings.ShadowSecure.updateEnabledProviders(ShadowLocationManager.this.getContext().getContentResolver(), this.name, enabled);
                }
                transports = this.locationTransports;
            }
            for (LocationTransport locationTransport : transports) {
                if (locationTransport.invokeOnProviderEnabled(this.name, enabled)) continue;
                ProviderEntry providerEntry2 = this;
                synchronized (providerEntry2) {
                    Iterables.removeIf(this.locationTransports, current -> current == transport);
                }
            }
        }

        @Nullable
        public synchronized Location getLastLocation() {
            return this.lastLocation;
        }

        public synchronized void setLastLocation(@Nullable Location location) {
            this.lastLocation = location;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void simulateLocation(Location ... locations) {
            LegacyBatchedTransport batchedTransport;
            CopyOnWriteArrayList<LocationTransport<?>> transports;
            ProviderEntry providerEntry = this;
            synchronized (providerEntry) {
                this.lastLocation = new Location(locations[locations.length - 1]);
                transports = this.locationTransports;
                batchedTransport = this.legacyBatchedTransport;
            }
            if (batchedTransport != null) {
                batchedTransport.invokeOnLocations(locations);
            }
            for (LocationTransport locationTransport : transports) {
                if (locationTransport.invokeOnLocations(locations)) continue;
                ProviderEntry providerEntry2 = this;
                synchronized (providerEntry2) {
                    Iterables.removeIf(this.locationTransports, current -> current == transport);
                }
            }
        }

        public synchronized boolean meetsCriteria(Criteria criteria) {
            if ("passive".equals(this.name)) {
                return false;
            }
            if (this.properties == null) {
                return false;
            }
            return this.properties.meetsCriteria(criteria);
        }

        public void addListener(LocationListener listener, RoboLocationRequest request, Executor executor) {
            this.addListenerInternal(new LocationListenerTransport(listener, request, executor));
        }

        public void addListener(PendingIntent pendingIntent, RoboLocationRequest request) {
            this.addListenerInternal(new LocationPendingIntentTransport(ShadowLocationManager.this.getContext(), pendingIntent, request));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLegacyBatchedListener(Object callback, Executor executor, int batchSize, boolean flushOnFifoFull) {
            ProviderEntry providerEntry = this;
            synchronized (providerEntry) {
                this.legacyBatchedTransport = new LegacyBatchedTransport(callback, executor, batchSize, flushOnFifoFull);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushLegacyBatch() {
            LegacyBatchedTransport batchedTransport;
            ProviderEntry providerEntry = this;
            synchronized (providerEntry) {
                batchedTransport = this.legacyBatchedTransport;
            }
            if (batchedTransport != null) {
                batchedTransport.invokeFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearLegacyBatchedListener() {
            ProviderEntry providerEntry = this;
            synchronized (providerEntry) {
                this.legacyBatchedTransport = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListenerInternal(LocationTransport<?> transport) {
            boolean invokeOnProviderEnabled;
            ProviderEntry providerEntry = this;
            synchronized (providerEntry) {
                Iterables.removeIf(this.locationTransports, current -> current.getKey() == transport.getKey());
                this.locationTransports.add(transport);
                invokeOnProviderEnabled = !this.enabled;
            }
            if (invokeOnProviderEnabled && !transport.invokeOnProviderEnabled(this.name, false)) {
                providerEntry = this;
                synchronized (providerEntry) {
                    Iterables.removeIf(this.locationTransports, current -> current == transport);
                }
            }
        }

        public synchronized void removeListener(Object key) {
            Iterables.removeIf(this.locationTransports, transport -> transport.getKey() == key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestFlush(Object key, int requestCode) {
            LocationTransport transport;
            ProviderEntry providerEntry = this;
            synchronized (providerEntry) {
                transport = (LocationTransport)Iterables.tryFind(this.locationTransports, t -> t.getKey() == key).orNull();
            }
            if (transport == null) {
                throw new IllegalArgumentException("unregistered listener cannot be flushed");
            }
            if (!transport.invokeOnFlush(requestCode)) {
                providerEntry = this;
                synchronized (providerEntry) {
                    Iterables.removeIf(this.locationTransports, current -> current == transport);
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof ProviderEntry) {
                ProviderEntry that = (ProviderEntry)o;
                return Objects.equals(this.name, that.name);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }

    public static class ProviderProperties {
        @Nullable
        private final Object properties;
        private final boolean requiresNetwork;
        private final boolean requiresSatellite;
        private final boolean requiresCell;
        private final boolean hasMonetaryCost;
        private final boolean supportsAltitude;
        private final boolean supportsSpeed;
        private final boolean supportsBearing;
        private final int powerRequirement;
        private final int accuracy;

        @RequiresApi(value=31)
        ProviderProperties(android.location.provider.ProviderProperties properties) {
            this.properties = Objects.requireNonNull(properties);
            this.requiresNetwork = false;
            this.requiresSatellite = false;
            this.requiresCell = false;
            this.hasMonetaryCost = false;
            this.supportsAltitude = false;
            this.supportsSpeed = false;
            this.supportsBearing = false;
            this.powerRequirement = 0;
            this.accuracy = 0;
        }

        public ProviderProperties(boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
            this.properties = RuntimeEnvironment.getApiLevel() >= 31 ? new ProviderProperties.Builder().setHasNetworkRequirement(requiresNetwork).setHasSatelliteRequirement(requiresSatellite).setHasCellRequirement(requiresCell).setHasMonetaryCost(hasMonetaryCost).setHasAltitudeSupport(supportsAltitude).setHasSpeedSupport(supportsSpeed).setHasBearingSupport(supportsBearing).setPowerUsage(powerRequirement).setAccuracy(accuracy).build() : null;
            this.requiresNetwork = requiresNetwork;
            this.requiresSatellite = requiresSatellite;
            this.requiresCell = requiresCell;
            this.hasMonetaryCost = hasMonetaryCost;
            this.supportsAltitude = supportsAltitude;
            this.supportsSpeed = supportsSpeed;
            this.supportsBearing = supportsBearing;
            this.powerRequirement = powerRequirement;
            this.accuracy = accuracy;
        }

        public ProviderProperties(Criteria criteria) {
            this(false, false, false, criteria.isCostAllowed(), criteria.isAltitudeRequired(), criteria.isSpeedRequired(), criteria.isBearingRequired(), criteria.getPowerRequirement(), criteria.getAccuracy());
        }

        @RequiresApi(value=31)
        android.location.provider.ProviderProperties getProviderProperties() {
            return (android.location.provider.ProviderProperties)Objects.requireNonNull(this.properties);
        }

        Object getLegacyProviderProperties() {
            try {
                return ReflectionHelpers.callConstructor(Class.forName("com.android.internal.location.ProviderProperties"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.requiresNetwork), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.requiresSatellite), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.requiresCell), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.hasMonetaryCost), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.supportsAltitude), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.supportsSpeed), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.supportsBearing), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.powerRequirement), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.accuracy)});
            }
            catch (ClassNotFoundException c) {
                throw new RuntimeException("Unable to load old ProviderProperties class", c);
            }
        }

        public boolean hasNetworkRequirement() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).hasNetworkRequirement();
            }
            return this.requiresNetwork;
        }

        public boolean hasSatelliteRequirement() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).hasSatelliteRequirement();
            }
            return this.requiresSatellite;
        }

        public boolean isRequiresCell() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).hasCellRequirement();
            }
            return this.requiresCell;
        }

        public boolean isHasMonetaryCost() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).hasMonetaryCost();
            }
            return this.hasMonetaryCost;
        }

        public boolean hasAltitudeSupport() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).hasAltitudeSupport();
            }
            return this.supportsAltitude;
        }

        public boolean hasSpeedSupport() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).hasSpeedSupport();
            }
            return this.supportsSpeed;
        }

        public boolean hasBearingSupport() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).hasBearingSupport();
            }
            return this.supportsBearing;
        }

        public int getPowerUsage() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).getPowerUsage();
            }
            return this.powerRequirement;
        }

        public int getAccuracy() {
            if (this.properties != null) {
                return ((android.location.provider.ProviderProperties)this.properties).getAccuracy();
            }
            return this.accuracy;
        }

        boolean meetsCriteria(Criteria criteria) {
            if (criteria.getAccuracy() != 0 && criteria.getAccuracy() < this.getAccuracy()) {
                return false;
            }
            if (criteria.getPowerRequirement() != 0 && criteria.getPowerRequirement() < this.getPowerUsage()) {
                return false;
            }
            if (criteria.isAltitudeRequired() && !this.hasAltitudeSupport()) {
                return false;
            }
            if (criteria.isSpeedRequired() && !this.hasSpeedSupport()) {
                return false;
            }
            if (criteria.isBearingRequired() && !this.hasBearingSupport()) {
                return false;
            }
            return criteria.isCostAllowed() || !this.hasMonetaryCost;
        }
    }
}

