/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Build;
import android.telephony.NetworkRegistrationInfo;
import android.telephony.ServiceState;
import androidx.annotation.RequiresApi;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class ServiceStateBuilder {
    private ServiceState serviceState = new ServiceState();

    public static ServiceStateBuilder newBuilder() {
        return new ServiceStateBuilder();
    }

    public static ServiceStateBuilder newBuilder(ServiceState serviceState) {
        ServiceStateBuilder builder = new ServiceStateBuilder();
        builder.serviceState = serviceState;
        return builder;
    }

    public ServiceState build() {
        return this.serviceState;
    }

    public ServiceStateBuilder setVoiceRegState(int value) {
        this.serviceState.setVoiceRegState(value);
        return this;
    }

    public ServiceStateBuilder setDataRegState(int value) {
        this.serviceState.setDataRegState(value);
        return this;
    }

    public ServiceStateBuilder setNrFrequencyRange(int value) {
        this.assertIsAtLeast(29);
        this.serviceState.setNrFrequencyRange(value);
        return this;
    }

    public ServiceStateBuilder setIsManualSelection(boolean value) {
        this.serviceState.setIsManualSelection(value);
        return this;
    }

    public ServiceStateBuilder setOperatorName(String longName, String shortName, String numeric) {
        this.assertIsAtLeast(30);
        this.serviceState.setOperatorName(longName, shortName, numeric);
        return this;
    }

    public ServiceStateBuilder setIwlanPreferred(boolean value) {
        this.assertIsAtLeast(30);
        this.serviceState.setIwlanPreferred(value);
        return this;
    }

    public ServiceStateBuilder setEmergencyOnly(boolean value) {
        this.serviceState.setEmergencyOnly(value);
        return this;
    }

    public ServiceStateBuilder setDataRoamingFromRegistration(boolean value) {
        this.assertIsAtLeast(30);
        this.serviceState.setDataRoamingFromRegistration(value);
        return this;
    }

    public ServiceStateBuilder setIsUsingCarrierAggregation(boolean value) {
        this.assertIsAtLeast(28);
        if (Build.VERSION.SDK_INT >= 29) {
            throw new UnsupportedOperationException("Newer SDKs must specify carrier aggregation by constructing an appropriate NetworkRegistrationInfo and calling #setNetworkRegistrationInfoList instead");
        }
        ((ServiceStateReflector)Reflector.reflector(ServiceStateReflector.class, (Object)this.serviceState)).setIsUsingCarrierAggregation(value);
        return this;
    }

    @RequiresApi(value=29)
    public ServiceStateBuilder setNetworkRegistrationInfoList(List<NetworkRegistrationInfo> value) {
        this.assertIsAtLeast(29);
        ((ServiceStateReflector)Reflector.reflector(ServiceStateReflector.class, (Object)this.serviceState)).setNetworkRegistrationInfos(value);
        return this;
    }

    public ServiceStateBuilder setRoaming(boolean value) {
        this.serviceState.setRoaming(value);
        return this;
    }

    public ServiceStateBuilder setChannelNumber(int value) {
        this.serviceState.setChannelNumber(value);
        return this;
    }

    public ServiceStateBuilder setCellBandwidths(int[] value) {
        this.serviceState.setCellBandwidths(value);
        return this;
    }

    private void assertIsAtLeast(int sdk) {
        if (Build.VERSION.SDK_INT < sdk) {
            throw new IllegalStateException("This method is not available on SDK : " + RuntimeEnvironment.getApiLevel());
        }
    }

    @ForType(value=ServiceState.class)
    private static interface ServiceStateReflector {
        @Accessor(value="mIsUsingCarrierAggregation")
        public void setIsUsingCarrierAggregation(boolean var1);

        @Accessor(value="mNetworkRegistrationInfos")
        public void setNetworkRegistrationInfos(List<NetworkRegistrationInfo> var1);
    }
}

