/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowMatrix;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Bitmap.class, isInAndroidSdk=false)
public class ShadowLegacyBitmap
extends ShadowBitmap {
    private static final int INTERNAL_BYTES_PER_PIXEL = 4;
    int createdFromResId = -1;
    String createdFromPath;
    InputStream createdFromStream;
    FileDescriptor createdFromFileDescriptor;
    byte[] createdFromBytes;
    @RealObject
    private Bitmap realBitmap;
    private Bitmap createdFromBitmap;
    private Bitmap scaledFromBitmap;
    private int createdFromX = -1;
    private int createdFromY = -1;
    private int createdFromWidth = -1;
    private int createdFromHeight = -1;
    private int[] createdFromColors;
    private Matrix createdFromMatrix;
    private boolean createdFromFilter;
    private int width;
    private int height;
    private BufferedImage bufferedImage;
    private Bitmap.Config config;
    private boolean mutable = true;
    private String description = "";
    private boolean recycled = false;
    private boolean hasMipMap;
    private boolean requestPremultiplied = true;
    private boolean hasAlpha;
    private ColorSpace colorSpace;

    @Implementation
    protected static Bitmap createBitmap(int width, int height, Bitmap.Config config) {
        return ShadowLegacyBitmap.createBitmap((DisplayMetrics)null, width, height, config);
    }

    @Implementation(minSdk=17)
    protected static Bitmap createBitmap(DisplayMetrics displayMetrics, int width, int height, Bitmap.Config config) {
        return ShadowLegacyBitmap.createBitmap(displayMetrics, width, height, config, true);
    }

    @Implementation(minSdk=17)
    protected static Bitmap createBitmap(DisplayMetrics displayMetrics, int width, int height, Bitmap.Config config, boolean hasAlpha) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Preconditions.checkNotNull((Object)config);
        Bitmap scaledBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)scaledBitmap);
        shadowBitmap.setDescription("Bitmap (" + width + " x " + height + ")");
        shadowBitmap.width = width;
        shadowBitmap.height = height;
        shadowBitmap.config = config;
        shadowBitmap.hasAlpha = hasAlpha;
        shadowBitmap.setMutable(true);
        if (displayMetrics != null) {
            scaledBitmap.setDensity(displayMetrics.densityDpi);
        }
        shadowBitmap.bufferedImage = new BufferedImage(width, height, 2);
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            shadowBitmap.colorSpace = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
        }
        return scaledBitmap;
    }

    @Implementation(minSdk=26)
    protected static Bitmap createBitmap(int width, int height, Bitmap.Config config, boolean hasAlpha, ColorSpace colorSpace) {
        Preconditions.checkArgument((colorSpace != null || config == Bitmap.Config.ALPHA_8 ? 1 : 0) != 0);
        Bitmap bitmap = ShadowLegacyBitmap.createBitmap(null, width, height, config, hasAlpha);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.colorSpace = colorSpace;
        return bitmap;
    }

    @Implementation
    protected static Bitmap createBitmap(Bitmap src, int x, int y, int width, int height, Matrix matrix, boolean filter) {
        if (x == 0 && y == 0 && width == src.getWidth() && height == src.getHeight() && (matrix == null || matrix.isIdentity())) {
            return src;
        }
        if (x + width > src.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (y + height > src.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        Bitmap newBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowLegacyBitmap shadowNewBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)newBitmap);
        ShadowLegacyBitmap shadowSrcBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)src);
        shadowNewBitmap.appendDescription(shadowSrcBitmap.getDescription());
        shadowNewBitmap.appendDescription(" at (" + x + "," + y + ")");
        shadowNewBitmap.appendDescription(" with width " + width + " and height " + height);
        shadowNewBitmap.createdFromBitmap = src;
        shadowNewBitmap.createdFromX = x;
        shadowNewBitmap.createdFromY = y;
        shadowNewBitmap.createdFromWidth = width;
        shadowNewBitmap.createdFromHeight = height;
        shadowNewBitmap.createdFromMatrix = matrix;
        shadowNewBitmap.createdFromFilter = filter;
        shadowNewBitmap.config = src.getConfig();
        if (matrix != null) {
            ShadowMatrix shadowMatrix = (ShadowMatrix)Shadow.extract((Object)matrix);
            shadowNewBitmap.appendDescription(" using matrix " + shadowMatrix.getDescription());
            RectF mappedRect = new RectF();
            matrix.mapRect(mappedRect, new RectF(0.0f, 0.0f, (float)width, (float)height));
            width = Math.round(mappedRect.width());
            height = Math.round(mappedRect.height());
        }
        if (filter) {
            shadowNewBitmap.appendDescription(" with filter");
        }
        shadowNewBitmap.width = width;
        shadowNewBitmap.height = height;
        shadowNewBitmap.setMutable(true);
        newBitmap.setDensity(src.getDensity());
        if ((matrix == null || matrix.isIdentity()) && shadowSrcBitmap.bufferedImage != null) {
            shadowNewBitmap.bufferedImage = shadowSrcBitmap.bufferedImage.getSubimage(x, y, width, height);
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            shadowNewBitmap.colorSpace = shadowSrcBitmap.colorSpace;
        }
        return newBitmap;
    }

    @Implementation
    protected static Bitmap createBitmap(int[] colors, int offset, int stride, int width, int height, Bitmap.Config config) {
        return ShadowLegacyBitmap.createBitmap(null, colors, offset, stride, width, height, config);
    }

    @Implementation(minSdk=17)
    protected static Bitmap createBitmap(DisplayMetrics displayMetrics, int[] colors, int offset, int stride, int width, int height, Bitmap.Config config) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        Preconditions.checkNotNull((Object)config);
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        bufferedImage.setRGB(0, 0, width, height, colors, offset, stride);
        Bitmap bitmap = ShadowLegacyBitmap.createBitmap(bufferedImage, width, height, config);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.setMutable(false);
        shadowBitmap.createdFromColors = colors;
        if (displayMetrics != null) {
            bitmap.setDensity(displayMetrics.densityDpi);
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            shadowBitmap.colorSpace = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB);
        }
        return bitmap;
    }

    private static Bitmap createBitmap(BufferedImage bufferedImage, int width, int height, Bitmap.Config config) {
        Bitmap newBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)newBitmap);
        shadowBitmap.bufferedImage = bufferedImage;
        return newBitmap;
    }

    @Implementation
    protected static Bitmap createScaledBitmap(Bitmap src, int dstWidth, int dstHeight, boolean filter) {
        if (dstWidth == src.getWidth() && dstHeight == src.getHeight() && !filter) {
            return src;
        }
        if (dstWidth <= 0 || dstHeight <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap scaledBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)scaledBitmap);
        ShadowLegacyBitmap shadowSrcBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)src);
        shadowBitmap.appendDescription(shadowSrcBitmap.getDescription());
        shadowBitmap.appendDescription(" scaled to " + dstWidth + " x " + dstHeight);
        if (filter) {
            shadowBitmap.appendDescription(" with filter " + filter);
        }
        shadowBitmap.createdFromBitmap = src;
        shadowBitmap.scaledFromBitmap = src;
        shadowBitmap.createdFromFilter = filter;
        shadowBitmap.width = dstWidth;
        shadowBitmap.height = dstHeight;
        shadowBitmap.config = src.getConfig();
        shadowBitmap.mutable = true;
        if (!ImageUtil.scaledBitmap(src, scaledBitmap, filter)) {
            shadowBitmap.bufferedImage = new BufferedImage(dstWidth, dstHeight, 2);
            shadowBitmap.setPixelsInternal(new int[shadowBitmap.getHeight() * shadowBitmap.getWidth()], 0, 0, 0, 0, shadowBitmap.getWidth(), shadowBitmap.getHeight());
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            shadowBitmap.colorSpace = shadowSrcBitmap.colorSpace;
        }
        return scaledBitmap;
    }

    @Implementation
    protected static Bitmap nativeCreateFromParcel(Parcel p) {
        int parceledWidth = p.readInt();
        int parceledHeight = p.readInt();
        Bitmap.Config parceledConfig = (Bitmap.Config)p.readSerializable();
        int[] parceledColors = new int[parceledHeight * parceledWidth];
        p.readIntArray(parceledColors);
        return ShadowLegacyBitmap.createBitmap(parceledColors, 0, parceledWidth, parceledWidth, parceledHeight, parceledConfig);
    }

    static int getBytesPerPixel(Bitmap.Config config) {
        if (config == null) {
            throw new NullPointerException("Bitmap config was null.");
        }
        switch (config) {
            case RGBA_F16: {
                return 8;
            }
            case ARGB_8888: 
            case HARDWARE: {
                return 4;
            }
            case RGB_565: 
            case ARGB_4444: {
                return 2;
            }
            case ALPHA_8: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown bitmap config: " + config);
    }

    @Override
    public Bitmap getCreatedFromBitmap() {
        return this.createdFromBitmap;
    }

    @Override
    public int getCreatedFromResId() {
        return this.createdFromResId;
    }

    @Override
    public String getCreatedFromPath() {
        return this.createdFromPath;
    }

    @Override
    public InputStream getCreatedFromStream() {
        return this.createdFromStream;
    }

    @Override
    public byte[] getCreatedFromBytes() {
        return this.createdFromBytes;
    }

    @Override
    public int getCreatedFromX() {
        return this.createdFromX;
    }

    @Override
    public int getCreatedFromY() {
        return this.createdFromY;
    }

    @Override
    public int getCreatedFromWidth() {
        return this.createdFromWidth;
    }

    @Override
    public int getCreatedFromHeight() {
        return this.createdFromHeight;
    }

    @Override
    public int[] getCreatedFromColors() {
        return this.createdFromColors;
    }

    @Override
    public Matrix getCreatedFromMatrix() {
        return this.createdFromMatrix;
    }

    @Override
    public boolean getCreatedFromFilter() {
        return this.createdFromFilter;
    }

    @Implementation(minSdk=31)
    protected Bitmap asShared() {
        this.setMutable(false);
        return this.realBitmap;
    }

    @Implementation
    protected boolean compress(Bitmap.CompressFormat format, int quality, OutputStream stream) {
        this.appendDescription(" compressed as " + format + " with quality " + quality);
        return ImageUtil.writeToStream(this.realBitmap, format, quality, stream);
    }

    @Implementation
    protected void setPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.checkBitmapMutable();
        this.setPixelsInternal(pixels, offset, stride, x, y, width, height);
    }

    void setPixelsInternal(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        if (this.bufferedImage == null) {
            this.bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        this.bufferedImage.setRGB(x, y, width, height, pixels, offset, stride);
    }

    @Implementation
    protected int getPixel(int x, int y) {
        this.internalCheckPixelAccess(x, y);
        if (this.bufferedImage != null) {
            return this.bufferedImage.getRGB(x, y);
        }
        return 0;
    }

    @Implementation
    protected void setPixel(int x, int y, int color) {
        this.checkBitmapMutable();
        this.internalCheckPixelAccess(x, y);
        if (this.bufferedImage == null) {
            this.bufferedImage = new BufferedImage(this.width, this.height, 2);
        }
        this.bufferedImage.setRGB(x, y, color);
    }

    @Implementation
    protected void getPixels(int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        this.bufferedImage.getRGB(x, y, width, height, pixels, offset, stride);
    }

    @Implementation
    protected int getRowBytes() {
        return ShadowLegacyBitmap.getBytesPerPixel(this.config) * this.getWidth();
    }

    @Implementation
    protected int getByteCount() {
        return this.getRowBytes() * this.getHeight();
    }

    @Implementation
    protected void recycle() {
        this.recycled = true;
    }

    @Implementation
    protected final boolean isRecycled() {
        return this.recycled;
    }

    @Implementation
    protected Bitmap copy(Bitmap.Config config, boolean isMutable) {
        Bitmap newBitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowLegacyBitmap shadowBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)newBitmap);
        shadowBitmap.createdFromBitmap = this.realBitmap;
        shadowBitmap.config = config;
        shadowBitmap.mutable = isMutable;
        shadowBitmap.height = this.getHeight();
        shadowBitmap.width = this.getWidth();
        if (this.bufferedImage != null) {
            ColorModel cm = this.bufferedImage.getColorModel();
            WritableRaster raster = this.bufferedImage.copyData(this.bufferedImage.getRaster().createCompatibleWritableRaster());
            shadowBitmap.bufferedImage = new BufferedImage(cm, raster, false, null);
        }
        return newBitmap;
    }

    @Implementation(minSdk=19)
    protected final int getAllocationByteCount() {
        return this.getRowBytes() * this.getHeight();
    }

    @Implementation
    protected final Bitmap.Config getConfig() {
        return this.config;
    }

    @Implementation(minSdk=19)
    protected void setConfig(Bitmap.Config config) {
        this.config = config;
    }

    @Implementation
    protected final boolean isMutable() {
        return this.mutable;
    }

    @Override
    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public void appendDescription(String s) {
        this.description = this.description + s;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String s) {
        this.description = s;
    }

    @Implementation
    protected final boolean hasAlpha() {
        return this.hasAlpha && this.config != Bitmap.Config.RGB_565;
    }

    @Implementation
    protected void setHasAlpha(boolean hasAlpha) {
        this.hasAlpha = hasAlpha;
    }

    @Implementation
    protected Bitmap extractAlpha() {
        WritableRaster raster = this.bufferedImage.getAlphaRaster();
        BufferedImage alphaImage = new BufferedImage(this.width, this.height, 2);
        alphaImage.getAlphaRaster().setRect(raster);
        return ShadowLegacyBitmap.createBitmap(alphaImage, this.getWidth(), this.getHeight(), Bitmap.Config.ALPHA_8);
    }

    @Implementation
    protected Bitmap extractAlpha(Paint paint, int[] offsetXY) {
        return this.extractAlpha();
    }

    @Implementation(minSdk=17)
    protected final boolean hasMipMap() {
        return this.hasMipMap;
    }

    @Implementation(minSdk=17)
    protected final void setHasMipMap(boolean hasMipMap) {
        this.hasMipMap = hasMipMap;
    }

    @Implementation
    protected int getWidth() {
        return this.width;
    }

    @Implementation(minSdk=19)
    protected void setWidth(int width) {
        this.width = width;
    }

    @Implementation
    protected int getHeight() {
        return this.height;
    }

    @Implementation(minSdk=19)
    protected void setHeight(int height) {
        this.height = height;
    }

    @Implementation
    protected int getGenerationId() {
        return 0;
    }

    @Implementation(minSdk=23)
    protected Bitmap createAshmemBitmap() {
        return this.realBitmap;
    }

    @Implementation
    protected void eraseColor(int color) {
        if (this.bufferedImage != null) {
            int[] pixels = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
            Arrays.fill(pixels, color);
        }
        this.setDescription(String.format("Bitmap (%d, %d)", this.width, this.height));
        if (color != 0) {
            this.appendDescription(String.format(" erased with 0x%08x", color));
        }
    }

    @Implementation
    protected void writeToParcel(Parcel p, int flags) {
        p.writeInt(this.width);
        p.writeInt(this.height);
        p.writeSerializable((Serializable)this.config);
        int[] pixels = new int[this.width * this.height];
        this.getPixels(pixels, 0, this.width, 0, 0, this.width, this.height);
        p.writeIntArray(pixels);
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            Object gainmap = ((ShadowBitmap.BitmapReflector)Reflector.reflector(ShadowBitmap.BitmapReflector.class, (Object)this.realBitmap)).getGainmap();
            if (gainmap != null) {
                p.writeBoolean(true);
                p.writeTypedObject((Parcelable)gainmap, flags);
            } else {
                p.writeBoolean(false);
            }
        }
    }

    @Implementation
    protected void copyPixelsFromBuffer(Buffer dst) {
        IntBuffer intBuffer;
        if (this.isRecycled()) {
            throw new IllegalStateException("Can't call copyPixelsFromBuffer() on a recycled bitmap");
        }
        if (ShadowLegacyBitmap.getBytesPerPixel(this.config) != 4) {
            throw new RuntimeException("Not implemented: only Bitmaps with 4 bytes per pixel are supported");
        }
        if (!(dst instanceof ByteBuffer) && !(dst instanceof IntBuffer)) {
            throw new RuntimeException("Not implemented: unsupported Buffer subclass");
        }
        ByteBuffer byteBuffer = null;
        if (dst instanceof IntBuffer) {
            intBuffer = (IntBuffer)dst;
        } else {
            byteBuffer = (ByteBuffer)dst;
            intBuffer = byteBuffer.asIntBuffer();
        }
        if (intBuffer.remaining() < this.width * this.height) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        int[] colors = new int[this.width * this.height];
        intBuffer.get(colors);
        if (byteBuffer != null) {
            byteBuffer.position(byteBuffer.position() + intBuffer.position() * 4);
        }
        int[] pixels = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        System.arraycopy(colors, 0, pixels, 0, pixels.length);
    }

    @Implementation
    protected void copyPixelsToBuffer(Buffer dst) {
        if (ShadowLegacyBitmap.getBytesPerPixel(this.config) != 4) {
            throw new RuntimeException("Not implemented: only Bitmaps with 4 bytes per pixel are supported");
        }
        if (!(dst instanceof ByteBuffer) && !(dst instanceof IntBuffer)) {
            throw new RuntimeException("Not implemented: unsupported Buffer subclass");
        }
        int[] pixels = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        if (dst instanceof ByteBuffer) {
            IntBuffer intBuffer = ((ByteBuffer)dst).asIntBuffer();
            intBuffer.put(pixels);
            dst.position(intBuffer.position() * 4);
        } else if (dst instanceof IntBuffer) {
            ((IntBuffer)dst).put(pixels);
        }
    }

    @Implementation(minSdk=19)
    protected void reconfigure(int width, int height, Bitmap.Config config) {
        if (Build.VERSION.SDK_INT >= 26 && this.config == Bitmap.Config.HARDWARE) {
            throw new IllegalStateException("native-backed bitmaps may not be reconfigured");
        }
        this.width = width;
        this.height = height;
        this.config = config;
        this.bufferedImage = new BufferedImage(width, height, 2);
    }

    @Implementation(minSdk=19)
    protected boolean isPremultiplied() {
        return this.requestPremultiplied && this.hasAlpha();
    }

    @Implementation(minSdk=19)
    protected void setPremultiplied(boolean isPremultiplied) {
        this.requestPremultiplied = isPremultiplied;
    }

    @Implementation(minSdk=26)
    protected ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Implementation(minSdk=29)
    protected void setColorSpace(ColorSpace colorSpace) {
        this.colorSpace = (ColorSpace)Preconditions.checkNotNull((Object)colorSpace);
    }

    @Implementation
    protected boolean sameAs(Bitmap other) {
        int[] otherPixels;
        int[] pixels;
        if (other == null) {
            return false;
        }
        ShadowLegacyBitmap shadowOtherBitmap = (ShadowLegacyBitmap)Shadow.extract((Object)other);
        if (this.width != shadowOtherBitmap.width || this.height != shadowOtherBitmap.height) {
            return false;
        }
        if (this.config != shadowOtherBitmap.config) {
            return false;
        }
        if (this.bufferedImage == null && shadowOtherBitmap.bufferedImage != null) {
            return false;
        }
        if (this.bufferedImage != null && shadowOtherBitmap.bufferedImage == null) {
            return false;
        }
        if (this.bufferedImage != null && shadowOtherBitmap.bufferedImage != null && !Arrays.equals(pixels = ((DataBufferInt)this.bufferedImage.getData().getDataBuffer()).getData(), otherPixels = ((DataBufferInt)shadowOtherBitmap.bufferedImage.getData().getDataBuffer()).getData())) {
            return false;
        }
        if (this.scaledFromBitmap != null && shadowOtherBitmap.scaledFromBitmap != null) {
            return this.scaledFromBitmap.sameAs(shadowOtherBitmap.scaledFromBitmap);
        }
        return true;
    }

    void setCreatedFromResId(int resId, String description) {
        this.createdFromResId = resId;
        this.appendDescription(" for resource:" + description);
    }

    private void checkBitmapMutable() {
        if (this.isRecycled()) {
            throw new IllegalStateException("Can't call setPixel() on a recycled bitmap");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("Bitmap is immutable");
        }
    }

    private void internalCheckPixelAccess(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
        if (x >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (y >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }

    void drawRect(Rect r, Paint paint) {
        if (this.bufferedImage == null) {
            return;
        }
        int[] pixels = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        Rect toDraw = new Rect(Integer.max(0, r.left), Integer.max(0, r.top), Integer.min(this.getWidth(), r.right), Integer.min(this.getHeight(), r.bottom));
        if (toDraw.left == 0 && toDraw.top == 0 && toDraw.right == this.getWidth()) {
            Arrays.fill(pixels, 0, this.getWidth() * toDraw.bottom, paint.getColor());
            return;
        }
        for (int y = toDraw.top; y < toDraw.bottom; ++y) {
            Arrays.fill(pixels, y * this.getWidth() + toDraw.left, y * this.getWidth() + toDraw.right, paint.getColor());
        }
    }

    void drawRect(RectF r, Paint paint) {
        if (this.bufferedImage == null) {
            return;
        }
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        Rectangle2D.Float r2d = new Rectangle2D.Float(r.left, r.top, r.right - r.left, r.bottom - r.top);
        graphics2D.setColor(new Color(paint.getColor()));
        graphics2D.draw(r2d);
        graphics2D.dispose();
    }

    void drawBitmap(Bitmap source, int left, int top) {
        ShadowLegacyBitmap shadowSource = (ShadowLegacyBitmap)Shadow.extract((Object)source);
        if (this.bufferedImage == null || shadowSource.bufferedImage == null) {
            return;
        }
        int[] pixels = ((DataBufferInt)this.bufferedImage.getRaster().getDataBuffer()).getData();
        int[] sourcePixels = ((DataBufferInt)shadowSource.bufferedImage.getRaster().getDataBuffer()).getData();
        if (left == 0 && top == 0 && this.getWidth() == source.getWidth()) {
            int size = Integer.min(this.getWidth() * this.getHeight(), source.getWidth() * source.getHeight());
            System.arraycopy(sourcePixels, 0, pixels, 0, size);
            return;
        }
        int startSourceY = Integer.max(0, -top);
        int startSourceX = Integer.max(0, -left);
        int startY = Integer.max(0, top);
        int startX = Integer.max(0, left);
        int endY = Integer.min(this.getHeight(), top + source.getHeight());
        int endX = Integer.min(this.getWidth(), left + source.getWidth());
        int lenY = endY - startY;
        int lenX = endX - startX;
        for (int y = 0; y < lenY; ++y) {
            System.arraycopy(sourcePixels, (startSourceY + y) * source.getWidth() + startSourceX, pixels, (startY + y) * this.getWidth() + startX, lenX);
        }
    }

    BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }
}

