/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.PersistableBundle;
import android.uwb.RangingSession;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.RangingSessionBuilder;

@Implements(value=RangingSession.class, minSdk=31, isInAndroidSdk=false)
public class ShadowRangingSession {
    @RealObject
    private RangingSession realRangingSession;
    private RangingSession.Callback callback;
    private Executor executor;
    private Adapter adapter;

    static RangingSession newInstance(Executor executor, RangingSession.Callback callback, Adapter adapter) {
        RangingSession rangingSession = RangingSessionBuilder.newBuilder().setExecutor(executor).setCallback(callback).build();
        ShadowRangingSession shadow = (ShadowRangingSession)Shadow.extract((Object)rangingSession);
        shadow.setCallback(callback, executor);
        shadow.setAdapter(adapter);
        return rangingSession;
    }

    @Implementation
    protected void start(PersistableBundle params) {
        this.executor.execute(() -> this.adapter.onStart(this.realRangingSession, this.callback, params));
    }

    @Implementation
    protected void reconfigure(PersistableBundle params) {
        this.executor.execute(() -> this.adapter.onReconfigure(this.realRangingSession, this.callback, params));
    }

    @Implementation
    protected void stop() {
        this.executor.execute(() -> this.adapter.onStop(this.realRangingSession, this.callback));
    }

    @Implementation
    protected void close() {
        this.executor.execute(() -> this.adapter.onClose(this.realRangingSession, this.callback));
    }

    void open(PersistableBundle params) {
        this.executor.execute(() -> this.adapter.onOpen(this.realRangingSession, this.callback, params));
    }

    private void setCallback(RangingSession.Callback callback, Executor executor) {
        this.callback = callback;
        this.executor = executor;
    }

    private void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public static interface Adapter {
        public void onOpen(RangingSession var1, RangingSession.Callback var2, PersistableBundle var3);

        public void onStart(RangingSession var1, RangingSession.Callback var2, PersistableBundle var3);

        public void onReconfigure(RangingSession var1, RangingSession.Callback var2, PersistableBundle var3);

        public void onStop(RangingSession var1, RangingSession.Callback var2);

        public void onClose(RangingSession var1, RangingSession.Callback var2);
    }
}

