/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.SystemProperties;
import android.telecom.PhoneAccountHandle;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyCallback;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.TelephonyManager;
import android.telephony.VisualVoicemailSmsFilterSettings;
import android.telephony.emergency.EmergencyNumber;
import android.text.TextUtils;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.shadows.ShadowServiceManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TelephonyManager.class, looseSignatures=true)
public class ShadowTelephonyManager {
    @RealObject
    protected TelephonyManager realTelephonyManager;
    private final Map<PhoneStateListener, Integer> phoneStateRegistrations = new HashMap<PhoneStateListener, Integer>();
    private final List<Object> telephonyCallbackRegistrations = new ArrayList<Object>();
    private final Map<Integer, String> slotIndexToDeviceId = new HashMap<Integer, String>();
    private final Map<Integer, String> slotIndexToImei = new HashMap<Integer, String>();
    private final Map<Integer, String> slotIndexToMeid = new HashMap<Integer, String>();
    private final Map<PhoneAccountHandle, Boolean> voicemailVibrationEnabledMap = new HashMap<PhoneAccountHandle, Boolean>();
    private final Map<PhoneAccountHandle, Uri> voicemailRingtoneUriMap = new HashMap<PhoneAccountHandle, Uri>();
    private final Map<PhoneAccountHandle, TelephonyManager> phoneAccountToTelephonyManagers = new HashMap<PhoneAccountHandle, TelephonyManager>();
    private final Map<PhoneAccountHandle, Integer> phoneAccountHandleSubscriptionId = new HashMap<PhoneAccountHandle, Integer>();
    private PhoneStateListener lastListener;
    private Object lastTelephonyCallback;
    private int lastEventFlags;
    private String deviceId;
    private String deviceSoftwareVersion;
    private String imei;
    private String meid;
    private String groupIdLevel1;
    private String networkOperatorName = "";
    private String networkCountryIso;
    private String networkOperator = "";
    private String networkSpecifier = "";
    private Locale simLocale;
    private String simOperator = "";
    private String simOperatorName;
    private String simSerialNumber;
    private boolean readPhoneStatePermission = true;
    private int phoneType = 1;
    private String line1Number;
    private int networkType;
    private int dataNetworkType = 0;
    private int voiceNetworkType = 0;
    private List<CellInfo> allCellInfo = Collections.emptyList();
    private List<CellInfo> callbackCellInfos = null;
    private CellLocation cellLocation = null;
    private int callState = 0;
    private int dataState = 0;
    private int dataActivity = 0;
    private String incomingPhoneNumber = null;
    private boolean isSmsCapable = true;
    private boolean voiceCapable = true;
    private String voiceMailNumber;
    private String voiceMailAlphaTag;
    private int phoneCount = 1;
    private int activeModemCount = 1;
    private Map<Integer, TelephonyManager> subscriptionIdsToTelephonyManagers = new HashMap<Integer, TelephonyManager>();
    private PersistableBundle carrierConfig;
    private ServiceState serviceState;
    private boolean isNetworkRoaming;
    private final SparseIntArray simStates = new SparseIntArray();
    private final SparseIntArray currentPhoneTypes = new SparseIntArray();
    private final SparseArray<List<String>> carrierPackageNames = new SparseArray();
    private final Map<Integer, String> simCountryIsoMap = new HashMap<Integer, String>();
    private int simCarrierId;
    private int carrierIdFromSimMccMnc;
    private String subscriberId;
    private Object uiccSlotInfos;
    private Object uiccCardsInfo = new ArrayList();
    private String visualVoicemailPackageName = null;
    private SignalStrength signalStrength;
    private boolean dataEnabled = false;
    private final Set<Integer> dataDisabledReasons = new HashSet<Integer>();
    private boolean isRttSupported;
    private boolean isTtyModeSupported;
    private final SparseBooleanArray subIdToHasCarrierPrivileges = new SparseBooleanArray();
    private final List<String> sentDialerSpecialCodes = new ArrayList<String>();
    private boolean hearingAidCompatibilitySupported = false;
    private int requestCellInfoUpdateErrorCode = 0;
    private Throwable requestCellInfoUpdateDetail = null;
    private Object telephonyDisplayInfo;
    private boolean isDataConnectionAllowed;
    private static int callComposerStatus = 0;
    private VisualVoicemailSmsParams lastVisualVoicemailSmsParams;
    private VisualVoicemailSmsFilterSettings visualVoicemailSmsFilterSettings;
    private boolean emergencyCallbackMode;
    private static Map<Integer, List<EmergencyNumber>> emergencyNumbersList;
    private Object callback;
    private Object phoneCapability;

    public ShadowTelephonyManager() {
        this.resetSimStates();
        this.resetSimCountryIsos();
    }

    @Resetter
    public static void reset() {
        callComposerStatus = 0;
        emergencyNumbersList = null;
    }

    @Implementation(minSdk=31)
    protected void setCallComposerStatus(int callComposerStatus) {
        ShadowTelephonyManager.callComposerStatus = callComposerStatus;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected int getCallComposerStatus() {
        return callComposerStatus;
    }

    public Object getBootstrapAuthenticationCallback() {
        return this.callback;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    public void bootstrapAuthenticationRequest(Object appType, Object nafId, Object securityProtocol, Object forceBootStrapping, Object e, Object callback) {
        this.callback = callback;
    }

    public void setPhoneCapability(Object phoneCapability) {
        this.phoneCapability = phoneCapability;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    public Object getPhoneCapability() {
        return this.phoneCapability;
    }

    @Implementation
    protected void listen(PhoneStateListener listener, int flags) {
        this.lastListener = listener;
        this.lastEventFlags = flags;
        if (flags == 0) {
            this.phoneStateRegistrations.remove(listener);
        } else {
            this.initListener(listener, flags);
            this.phoneStateRegistrations.put(listener, flags);
        }
    }

    @Deprecated
    public PhoneStateListener getListener() {
        return this.lastListener;
    }

    @Deprecated
    public int getEventFlags() {
        return this.lastEventFlags;
    }

    @Implementation(minSdk=31)
    public void registerTelephonyCallback(Object executor, Object callback) {
        Preconditions.checkArgument((boolean)(executor instanceof Executor));
        Preconditions.checkArgument((boolean)(callback instanceof TelephonyCallback));
        this.lastTelephonyCallback = callback;
        this.initTelephonyCallback(callback);
        this.telephonyCallbackRegistrations.add(callback);
    }

    @Implementation(minSdk=33)
    protected void registerTelephonyCallback(Object includeLocationData, Object executor, Object callback) {
        Preconditions.checkArgument((boolean)(includeLocationData instanceof Integer));
        this.registerTelephonyCallback(executor, callback);
    }

    @Implementation(minSdk=31)
    public void unregisterTelephonyCallback(Object callback) {
        this.telephonyCallbackRegistrations.remove(callback);
    }

    public Object getLastTelephonyCallback() {
        return this.lastTelephonyCallback;
    }

    @Implementation(minSdk=31)
    protected int getCallStateForSubscription() {
        this.checkReadPhoneStatePermission();
        return this.callState;
    }

    @Implementation
    protected int getCallState() {
        this.checkReadPhoneStatePermission();
        return this.callState;
    }

    public void setCallState(int callState) {
        this.setCallState(callState, null);
    }

    public void setCallState(int callState, String incomingPhoneNumber) {
        if (callState != 1) {
            incomingPhoneNumber = null;
        }
        this.callState = callState;
        this.incomingPhoneNumber = incomingPhoneNumber;
        for (PhoneStateListener phoneStateListener : this.getListenersForFlags(32)) {
            phoneStateListener.onCallStateChanged(callState, incomingPhoneNumber);
        }
        if (Build.VERSION.SDK_INT >= 31) {
            for (TelephonyCallback.CallStateListener callStateListener : this.getCallbackForListener(TelephonyCallback.CallStateListener.class)) {
                callStateListener.onCallStateChanged(callState);
            }
        }
    }

    @Implementation
    protected int getDataState() {
        return this.dataState;
    }

    public void setDataState(int dataState) {
        this.dataState = dataState;
    }

    @Implementation
    protected int getDataActivity() {
        return this.dataActivity;
    }

    public void setDataActivity(int dataActivity) {
        this.dataActivity = dataActivity;
    }

    @Implementation
    protected String getDeviceId() {
        this.checkReadPhoneStatePermission();
        return this.deviceId;
    }

    public void setDeviceId(String newDeviceId) {
        this.deviceId = newDeviceId;
    }

    @Implementation
    protected String getDeviceSoftwareVersion() {
        this.checkReadPhoneStatePermission();
        return this.deviceSoftwareVersion;
    }

    public void setDeviceSoftwareVersion(String newDeviceSoftwareVersion) {
        this.deviceSoftwareVersion = newDeviceSoftwareVersion;
    }

    @Implementation(minSdk=22, maxSdk=34)
    public void setNetworkOperatorName(String networkOperatorName) {
        this.networkOperatorName = networkOperatorName;
    }

    @Implementation(minSdk=35)
    public void setNetworkOperatorNameForPhone(int phoneId, String networkOperatorName) {
        this.setNetworkOperatorName(networkOperatorName);
    }

    @Implementation(minSdk=21)
    protected String getImei() {
        this.checkReadPhoneStatePermission();
        return this.imei;
    }

    @Implementation(minSdk=26)
    protected String getImei(int slotIndex) {
        this.checkReadPhoneStatePermission();
        return this.slotIndexToImei.get(slotIndex);
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public void setImei(int slotIndex, String imei) {
        this.slotIndexToImei.put(slotIndex, imei);
    }

    @Implementation(minSdk=26)
    protected String getMeid() {
        this.checkReadPhoneStatePermission();
        return this.meid;
    }

    @Implementation(minSdk=26)
    protected String getMeid(int slotIndex) {
        this.checkReadPhoneStatePermission();
        return this.slotIndexToMeid.get(slotIndex);
    }

    public void setMeid(String meid) {
        this.meid = meid;
    }

    public void setMeid(int slotIndex, String meid) {
        this.slotIndexToMeid.put(slotIndex, meid);
    }

    @Implementation
    protected String getNetworkOperatorName() {
        return this.networkOperatorName;
    }

    @Implementation(minSdk=22, maxSdk=28)
    public void setNetworkCountryIso(String networkCountryIso) {
        this.networkCountryIso = networkCountryIso;
    }

    @Implementation
    protected String getNetworkCountryIso() {
        return this.networkCountryIso == null ? null : Ascii.toLowerCase((String)this.networkCountryIso);
    }

    public void setSimLocale(Locale simLocale) {
        this.simLocale = simLocale;
    }

    @Implementation(minSdk=29)
    protected Locale getSimLocale() {
        return this.simLocale;
    }

    public void setNetworkOperator(String networkOperator) {
        this.networkOperator = networkOperator;
    }

    @Implementation
    protected String getNetworkOperator() {
        return this.networkOperator;
    }

    public void setNetworkSpecifier(String networkSpecifier) {
        this.networkSpecifier = networkSpecifier;
    }

    @Implementation(minSdk=26)
    protected String getNetworkSpecifier() {
        return this.networkSpecifier;
    }

    @Implementation
    protected String getSimOperator() {
        return this.simOperator;
    }

    public void setSimOperator(String simOperator) {
        this.simOperator = simOperator;
    }

    @Implementation
    protected String getSimOperatorName() {
        return this.simOperatorName;
    }

    @Implementation(minSdk=22, maxSdk=34)
    public void setSimOperatorName(String simOperatorName) {
        this.simOperatorName = simOperatorName;
    }

    @Implementation(minSdk=35)
    public void setSimOperatorNameForPhone(int phoneId, String name) {
        this.setSimOperatorName(name);
    }

    @Implementation
    protected String getSimSerialNumber() {
        this.checkReadPhoneStatePermission();
        return this.simSerialNumber;
    }

    public void setSimSerialNumber(String simSerialNumber) {
        this.simSerialNumber = simSerialNumber;
    }

    @Implementation
    protected String getSimCountryIso() {
        String simCountryIso = this.simCountryIsoMap.get(0);
        return simCountryIso == null ? simCountryIso : Ascii.toLowerCase((String)simCountryIso);
    }

    @Implementation(minSdk=24, maxSdk=29)
    @HiddenApi
    protected String getSimCountryIso(int subId) {
        return this.simCountryIsoMap.get(subId);
    }

    @Implementation(minSdk=22)
    public void setSimCountryIso(String simCountryIso) {
        this.setSimCountryIso(0, simCountryIso);
    }

    public void setSimCountryIso(int subId, String simCountryIso) {
        this.simCountryIsoMap.put(subId, simCountryIso);
    }

    public void resetSimCountryIsos() {
        this.simCountryIsoMap.clear();
        this.simCountryIsoMap.put(0, "");
    }

    @Implementation
    protected int getSimState() {
        return this.getSimState(0);
    }

    public void setSimState(int simState) {
        this.setSimState(0, simState);
    }

    public void setSimState(int slotIndex, int state) {
        this.simStates.put(slotIndex, state);
    }

    @Implementation(minSdk=26)
    protected int getSimState(int slotIndex) {
        return this.simStates.get(slotIndex, 0);
    }

    public void setUiccSlotsInfo(Object uiccSlotsInfos) {
        this.uiccSlotInfos = uiccSlotsInfos;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected Object getUiccSlotsInfo() {
        return this.uiccSlotInfos;
    }

    public void setUiccCardsInfo(Object uiccCardsInfo) {
        this.uiccCardsInfo = uiccCardsInfo;
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected Object getUiccCardsInfo() {
        return this.uiccCardsInfo;
    }

    public void resetSimStates() {
        this.simStates.clear();
        this.simStates.put(0, 5);
    }

    public void setReadPhoneStatePermission(boolean readPhoneStatePermission) {
        this.readPhoneStatePermission = readPhoneStatePermission;
    }

    private void checkReadPhoneStatePermission() {
        if (!this.readPhoneStatePermission) {
            throw new SecurityException();
        }
    }

    private void checkReadPrivilegedPhoneStatePermission() {
        if (!ShadowTelephonyManager.checkPermission("android.permission.READ_PRIVILEGED_PHONE_STATE")) {
            throw new SecurityException();
        }
    }

    static ShadowInstrumentation getShadowInstrumentation() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        return (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
    }

    static boolean checkPermission(String permission2) {
        return ShadowTelephonyManager.getShadowInstrumentation().checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @Implementation
    protected int getPhoneType() {
        return this.phoneType;
    }

    @Implementation(minSdk=22, maxSdk=34)
    public void setPhoneType(int phoneType) {
        this.phoneType = phoneType;
    }

    @Implementation(minSdk=35)
    public void setPhoneType(int phoneId, int type) {
        this.setPhoneType(type);
    }

    @Implementation
    protected String getLine1Number() {
        this.checkReadPhoneStatePermission();
        return this.line1Number;
    }

    public void setLine1Number(String line1Number) {
        this.line1Number = line1Number;
    }

    @Implementation
    protected int getNetworkType() {
        this.checkReadPhoneStatePermission();
        return this.networkType;
    }

    @Deprecated
    public void setNetworkType(int networkType) {
        this.networkType = networkType;
    }

    @Implementation(minSdk=24)
    protected int getDataNetworkType() {
        this.checkReadPhoneStatePermission();
        return this.dataNetworkType;
    }

    @Implementation(minSdk=22)
    public void setDataNetworkType(int dataNetworkType) {
        this.dataNetworkType = dataNetworkType;
    }

    @Implementation(minSdk=24)
    protected int getVoiceNetworkType() {
        this.checkReadPhoneStatePermission();
        return this.voiceNetworkType;
    }

    public void setVoiceNetworkType(int voiceNetworkType) {
        this.voiceNetworkType = voiceNetworkType;
    }

    @Implementation(minSdk=17)
    protected List<CellInfo> getAllCellInfo() {
        return this.allCellInfo;
    }

    public void setAllCellInfo(List<CellInfo> allCellInfo) {
        this.allCellInfo = allCellInfo;
        if (Build.VERSION.SDK_INT >= 17) {
            for (PhoneStateListener phoneStateListener : this.getListenersForFlags(1024)) {
                phoneStateListener.onCellInfoChanged(allCellInfo);
            }
        }
        if (Build.VERSION.SDK_INT >= 31) {
            for (TelephonyCallback.CellInfoListener cellInfoListener : this.getCallbackForListener(TelephonyCallback.CellInfoListener.class)) {
                cellInfoListener.onCellInfoChanged(allCellInfo);
            }
        }
    }

    @Implementation(minSdk=29)
    protected void requestCellInfoUpdate(Object cellInfoExecutor, Object cellInfoCallback) {
        Executor executor = (Executor)cellInfoExecutor;
        if (this.callbackCellInfos != null) {
            if (this.requestCellInfoUpdateErrorCode != 0 || this.requestCellInfoUpdateDetail != null) {
                executor.execute(() -> {
                    TelephonyManager.CellInfoCallback callback = (TelephonyManager.CellInfoCallback)cellInfoCallback;
                    callback.onError(this.requestCellInfoUpdateErrorCode, this.requestCellInfoUpdateDetail);
                });
            } else {
                executor.execute(() -> {
                    TelephonyManager.CellInfoCallback callback = (TelephonyManager.CellInfoCallback)cellInfoCallback;
                    callback.onCellInfo(this.callbackCellInfos);
                });
            }
        }
    }

    public void setCallbackCellInfos(List<CellInfo> callbackCellInfos) {
        this.callbackCellInfos = callbackCellInfos;
    }

    public void setRequestCellInfoUpdateErrorValues(int errorCode, Throwable detail) {
        this.requestCellInfoUpdateErrorCode = errorCode;
        this.requestCellInfoUpdateDetail = detail;
    }

    @Implementation
    protected CellLocation getCellLocation() {
        return this.cellLocation;
    }

    public void setCellLocation(CellLocation cellLocation) {
        this.cellLocation = cellLocation;
        for (PhoneStateListener phoneStateListener : this.getListenersForFlags(16)) {
            phoneStateListener.onCellLocationChanged(cellLocation);
        }
        if (Build.VERSION.SDK_INT >= 31) {
            for (TelephonyCallback.CellLocationListener cellLocationListener : this.getCallbackForListener(TelephonyCallback.CellLocationListener.class)) {
                cellLocationListener.onCellLocationChanged(cellLocation);
            }
        }
    }

    @Implementation(minSdk=18)
    protected String getGroupIdLevel1() {
        this.checkReadPhoneStatePermission();
        return this.groupIdLevel1;
    }

    public void setGroupIdLevel1(String groupIdLevel1) {
        this.groupIdLevel1 = groupIdLevel1;
    }

    protected void initListener(PhoneStateListener listener, int flags) {
        if ((flags & 0x20) != 0) {
            listener.onCallStateChanged(this.callState, this.incomingPhoneNumber);
        }
        if ((flags & 0x400) != 0 && Build.VERSION.SDK_INT >= 17) {
            listener.onCellInfoChanged(this.allCellInfo);
        }
        if ((flags & 0x10) != 0) {
            listener.onCellLocationChanged(this.cellLocation);
        }
        if (this.telephonyDisplayInfo != null && (flags & 0x100000) != 0) {
            listener.onDisplayInfoChanged((TelephonyDisplayInfo)this.telephonyDisplayInfo);
        }
        if (this.serviceState != null && (flags & 1) != 0) {
            listener.onServiceStateChanged(this.serviceState);
        }
    }

    protected void initTelephonyCallback(Object callback) {
        if (Build.VERSION.SDK_INT < 31) {
            return;
        }
        if (callback instanceof TelephonyCallback.CallStateListener) {
            ((TelephonyCallback.CallStateListener)callback).onCallStateChanged(this.callState);
        }
        if (callback instanceof TelephonyCallback.CellInfoListener) {
            ((TelephonyCallback.CellInfoListener)callback).onCellInfoChanged(this.allCellInfo);
        }
        if (callback instanceof TelephonyCallback.CellLocationListener) {
            ((TelephonyCallback.CellLocationListener)callback).onCellLocationChanged(this.cellLocation);
        }
        if (this.telephonyDisplayInfo != null && callback instanceof TelephonyCallback.DisplayInfoListener) {
            ((TelephonyCallback.DisplayInfoListener)callback).onDisplayInfoChanged((TelephonyDisplayInfo)this.telephonyDisplayInfo);
        }
        if (this.serviceState != null && callback instanceof TelephonyCallback.ServiceStateListener) {
            ((TelephonyCallback.ServiceStateListener)callback).onServiceStateChanged(this.serviceState);
        }
    }

    protected Iterable<PhoneStateListener> getListenersForFlags(final int flags) {
        return Iterables.filter(this.phoneStateRegistrations.keySet(), (Predicate)new Predicate<PhoneStateListener>(){

            public boolean apply(PhoneStateListener input) {
                return ((Integer)ShadowTelephonyManager.this.phoneStateRegistrations.get(input) & flags) != 0;
            }
        });
    }

    protected <T> Iterable<T> getCallbackForListener(Class<T> clazz) {
        return Iterables.filter(this.telephonyCallbackRegistrations, clazz);
    }

    @Implementation
    protected boolean isSmsCapable() {
        return this.isSmsCapable;
    }

    public void setIsSmsCapable(boolean isSmsCapable) {
        this.isSmsCapable = isSmsCapable;
    }

    @Implementation(minSdk=26)
    protected PersistableBundle getCarrierConfig() {
        this.checkReadPhoneStatePermission();
        return this.carrierConfig != null ? this.carrierConfig : new PersistableBundle();
    }

    public void setCarrierConfig(PersistableBundle carrierConfig) {
        this.carrierConfig = carrierConfig;
    }

    @Implementation
    protected String getVoiceMailNumber() {
        this.checkReadPhoneStatePermission();
        return this.voiceMailNumber;
    }

    public void setVoiceMailNumber(String voiceMailNumber) {
        this.voiceMailNumber = voiceMailNumber;
    }

    @Implementation
    protected String getVoiceMailAlphaTag() {
        this.checkReadPhoneStatePermission();
        return this.voiceMailAlphaTag;
    }

    public void setVoiceMailAlphaTag(String voiceMailAlphaTag) {
        this.voiceMailAlphaTag = voiceMailAlphaTag;
    }

    @Implementation(minSdk=23)
    protected int getPhoneCount() {
        return this.phoneCount;
    }

    public void setPhoneCount(int phoneCount) {
        this.phoneCount = phoneCount;
    }

    @Implementation(minSdk=30)
    protected int getActiveModemCount() {
        return this.activeModemCount;
    }

    public void setActiveModemCount(int activeModemCount) {
        this.activeModemCount = activeModemCount;
    }

    @Implementation(minSdk=23)
    protected String getDeviceId(int slot) {
        this.checkReadPhoneStatePermission();
        return this.slotIndexToDeviceId.get(slot);
    }

    public void setDeviceId(int slot, String deviceId) {
        this.slotIndexToDeviceId.put(slot, deviceId);
    }

    @Implementation(minSdk=22)
    protected boolean isVoiceCapable() {
        return this.voiceCapable;
    }

    public void setVoiceCapable(boolean voiceCapable) {
        this.voiceCapable = voiceCapable;
    }

    @Implementation(minSdk=24)
    protected boolean isVoicemailVibrationEnabled(PhoneAccountHandle handle) {
        Boolean result = this.voicemailVibrationEnabledMap.get(handle);
        return result != null ? result : false;
    }

    @Implementation(minSdk=26)
    protected void setVoicemailVibrationEnabled(PhoneAccountHandle handle, boolean isEnabled) {
        this.voicemailVibrationEnabledMap.put(handle, isEnabled);
    }

    @Implementation(minSdk=24)
    protected Uri getVoicemailRingtoneUri(PhoneAccountHandle handle) {
        return this.voicemailRingtoneUriMap.get(handle);
    }

    @Implementation(minSdk=26)
    protected void setVoicemailRingtoneUri(PhoneAccountHandle handle, Uri uri) {
        this.voicemailRingtoneUriMap.put(handle, uri);
    }

    @Implementation(minSdk=26)
    protected TelephonyManager createForPhoneAccountHandle(PhoneAccountHandle handle) {
        this.checkReadPhoneStatePermission();
        return this.phoneAccountToTelephonyManagers.get(handle);
    }

    public void setTelephonyManagerForHandle(PhoneAccountHandle handle, TelephonyManager telephonyManager) {
        this.phoneAccountToTelephonyManagers.put(handle, telephonyManager);
    }

    @Implementation(minSdk=24)
    protected TelephonyManager createForSubscriptionId(int subId) {
        return this.subscriptionIdsToTelephonyManagers.get(subId);
    }

    public void setTelephonyManagerForSubscriptionId(int subscriptionId, TelephonyManager telephonyManager) {
        this.subscriptionIdsToTelephonyManagers.put(subscriptionId, telephonyManager);
    }

    @Implementation(minSdk=26)
    protected ServiceState getServiceState() {
        this.checkReadPhoneStatePermission();
        return this.serviceState;
    }

    @Implementation(minSdk=33)
    protected ServiceState getServiceState(int includeLocationData) {
        return this.getServiceState();
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
        for (PhoneStateListener phoneStateListener : this.getListenersForFlags(1)) {
            phoneStateListener.onServiceStateChanged(serviceState);
        }
        if (Build.VERSION.SDK_INT >= 31) {
            for (TelephonyCallback.ServiceStateListener serviceStateListener : this.getCallbackForListener(TelephonyCallback.ServiceStateListener.class)) {
                serviceStateListener.onServiceStateChanged(serviceState);
            }
        }
    }

    @Implementation
    protected boolean isNetworkRoaming() {
        return this.isNetworkRoaming;
    }

    public void setIsNetworkRoaming(boolean isNetworkRoaming) {
        this.isNetworkRoaming = isNetworkRoaming;
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected int getCurrentPhoneType(int subId) {
        return this.currentPhoneTypes.get(subId, 0);
    }

    public void setCurrentPhoneType(int subId, int phoneType) {
        this.currentPhoneTypes.put(subId, phoneType);
    }

    public void clearPhoneTypes() {
        this.currentPhoneTypes.clear();
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected List<String> getCarrierPackageNamesForIntentAndPhone(Intent intent, int phoneId) {
        return (List)this.carrierPackageNames.get(phoneId);
    }

    @Implementation(minSdk=21)
    @HiddenApi
    protected List<String> getCarrierPackageNamesForIntent(Intent intent) {
        return (List)this.carrierPackageNames.get(Integer.MAX_VALUE);
    }

    public void setCarrierPackageNamesForPhone(int phoneId, List<String> packages) {
        this.carrierPackageNames.put(phoneId, packages);
    }

    @Implementation(minSdk=29)
    protected int getCarrierIdFromSimMccMnc() {
        return this.carrierIdFromSimMccMnc;
    }

    public void setCarrierIdFromSimMccMnc(int carrierIdFromSimMccMnc) {
        this.carrierIdFromSimMccMnc = carrierIdFromSimMccMnc;
    }

    @Implementation(minSdk=28)
    protected int getSimCarrierId() {
        return this.simCarrierId;
    }

    public void setSimCarrierId(int simCarrierId) {
        this.simCarrierId = simCarrierId;
    }

    @Implementation
    protected String getSubscriberId() {
        this.checkReadPhoneStatePermission();
        return this.subscriberId;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    @Implementation(minSdk=30)
    protected int getSubscriptionId(PhoneAccountHandle handle) {
        this.checkReadPhoneStatePermission();
        return this.phoneAccountHandleSubscriptionId.get(handle);
    }

    public void setPhoneAccountHandleSubscriptionId(PhoneAccountHandle handle, int subscriptionId) {
        this.phoneAccountHandleSubscriptionId.put(handle, subscriptionId);
    }

    @Implementation(minSdk=26)
    protected String getVisualVoicemailPackageName() {
        this.checkReadPhoneStatePermission();
        return this.visualVoicemailPackageName;
    }

    public void setVisualVoicemailPackageName(String visualVoicemailPackageName) {
        this.visualVoicemailPackageName = visualVoicemailPackageName;
    }

    @Implementation(minSdk=28)
    protected SignalStrength getSignalStrength() {
        return this.signalStrength;
    }

    public void setSignalStrength(SignalStrength signalStrength) {
        this.signalStrength = signalStrength;
        for (PhoneStateListener phoneStateListener : this.getListenersForFlags(256)) {
            phoneStateListener.onSignalStrengthsChanged(signalStrength);
        }
        if (Build.VERSION.SDK_INT >= 31) {
            for (TelephonyCallback.SignalStrengthsListener signalStrengthsListener : this.getCallbackForListener(TelephonyCallback.SignalStrengthsListener.class)) {
                signalStrengthsListener.onSignalStrengthsChanged(signalStrength);
            }
        }
    }

    @Implementation(minSdk=29)
    protected boolean isEmergencyNumber(String number) {
        if (ShadowServiceManager.getService("phone") == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        if (number == null) {
            return false;
        }
        Context context = (Context)ReflectionHelpers.getField((Object)this.realTelephonyManager, (String)"mContext");
        Locale locale = context == null ? null : context.getResources().getConfiguration().locale;
        String defaultCountryIso = locale == null ? null : locale.getCountry();
        int slotId = -1;
        boolean useExactMatch = true;
        String ecclist = slotId <= 0 ? "ril.ecclist" : "ril.ecclist" + slotId;
        String emergencyNumbers = SystemProperties.get((String)ecclist, (String)"");
        if (TextUtils.isEmpty((CharSequence)emergencyNumbers)) {
            emergencyNumbers = SystemProperties.get((String)"ro.ril.ecclist");
        }
        if (!TextUtils.isEmpty((CharSequence)emergencyNumbers)) {
            for (String emergencyNum : emergencyNumbers.split(",")) {
                if (!(useExactMatch || "BR".equalsIgnoreCase(defaultCountryIso) ? number.equals(emergencyNum) : number.startsWith(emergencyNum))) continue;
                return true;
            }
            return false;
        }
        emergencyNumbers = slotId < 0 ? "112,911,000,08,110,118,119,999" : "112,911";
        for (String emergencyNum : emergencyNumbers.split(",")) {
            if (!(useExactMatch ? number.equals(emergencyNum) : number.startsWith(emergencyNum))) continue;
            return true;
        }
        return false;
    }

    public void setEmergencyCallbackMode(boolean emergencyCallbackMode) {
        this.emergencyCallbackMode = emergencyCallbackMode;
    }

    @Implementation(minSdk=26)
    protected boolean getEmergencyCallbackMode() {
        this.checkReadPrivilegedPhoneStatePermission();
        return this.emergencyCallbackMode;
    }

    @Implementation(minSdk=29)
    protected boolean isPotentialEmergencyNumber(String number) {
        return this.isEmergencyNumber(number);
    }

    @Implementation(minSdk=26)
    protected boolean isDataEnabled() {
        this.checkReadPhoneStatePermission();
        return this.dataEnabled;
    }

    @Implementation(minSdk=31)
    protected boolean isDataEnabledForReason(int reason) {
        this.checkReadPhoneStatePermission();
        return !this.dataDisabledReasons.contains(reason);
    }

    @Implementation(minSdk=26)
    public void setDataEnabled(boolean enabled) {
        this.setDataEnabledForReason(0, enabled);
    }

    @Implementation(minSdk=31)
    public void setDataEnabledForReason(int reason, boolean enabled) {
        if (enabled) {
            this.dataDisabledReasons.remove(reason);
        } else {
            this.dataDisabledReasons.add(reason);
        }
        this.dataEnabled = this.dataDisabledReasons.isEmpty();
    }

    @Implementation(minSdk=29)
    protected boolean isRttSupported() {
        return this.isRttSupported;
    }

    public void setRttSupported(boolean isRttSupported) {
        this.isRttSupported = isRttSupported;
    }

    @Implementation(minSdk=23)
    protected boolean isTtyModeSupported() {
        this.checkReadPhoneStatePermission();
        return this.isTtyModeSupported;
    }

    public void setTtyModeSupported(boolean isTtyModeSupported) {
        this.isTtyModeSupported = isTtyModeSupported;
    }

    @Implementation(minSdk=24)
    @HiddenApi
    protected boolean hasCarrierPrivileges(int subId) {
        return this.subIdToHasCarrierPrivileges.get(subId);
    }

    public void setHasCarrierPrivileges(boolean hasCarrierPrivileges) {
        int subId = (Integer)ReflectionHelpers.callInstanceMethod((Object)this.realTelephonyManager, (String)"getSubId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this.setHasCarrierPrivileges(subId, hasCarrierPrivileges);
    }

    public void setHasCarrierPrivileges(int subId, boolean hasCarrierPrivileges) {
        this.subIdToHasCarrierPrivileges.put(subId, hasCarrierPrivileges);
    }

    @Implementation(minSdk=26)
    public void sendDialerSpecialCode(String inputCode) {
        this.sentDialerSpecialCodes.add(inputCode);
    }

    public List<String> getSentDialerSpecialCodes() {
        return ImmutableList.copyOf(this.sentDialerSpecialCodes);
    }

    public void setHearingAidCompatibilitySupported(boolean isSupported) {
        this.hearingAidCompatibilitySupported = isSupported;
    }

    @Implementation(minSdk=23)
    protected boolean isHearingAidCompatibilitySupported() {
        return this.hearingAidCompatibilitySupported;
    }

    public static Object createTelephonyDisplayInfo(int networkType, int overrideNetworkType) {
        return new TelephonyDisplayInfo(networkType, overrideNetworkType);
    }

    public void setTelephonyDisplayInfo(Object telephonyDisplayInfo) {
        Preconditions.checkNotNull((Object)telephonyDisplayInfo);
        this.telephonyDisplayInfo = telephonyDisplayInfo;
        for (PhoneStateListener phoneStateListener : this.getListenersForFlags(0x100000)) {
            phoneStateListener.onDisplayInfoChanged((TelephonyDisplayInfo)telephonyDisplayInfo);
        }
        if (Build.VERSION.SDK_INT >= 31) {
            for (TelephonyCallback.DisplayInfoListener displayInfoListener : this.getCallbackForListener(TelephonyCallback.DisplayInfoListener.class)) {
                displayInfoListener.onDisplayInfoChanged((TelephonyDisplayInfo)telephonyDisplayInfo);
            }
        }
    }

    @Implementation(minSdk=30)
    @HiddenApi
    protected boolean isDataConnectionAllowed() {
        this.checkReadPhoneStatePermission();
        return this.isDataConnectionAllowed;
    }

    public void setIsDataConnectionAllowed(boolean isDataConnectionAllowed) {
        this.isDataConnectionAllowed = isDataConnectionAllowed;
    }

    @Implementation(minSdk=26)
    public void sendVisualVoicemailSms(String number, int port, String text, PendingIntent sentIntent) {
        this.lastVisualVoicemailSmsParams = new VisualVoicemailSmsParams(number, port, text, sentIntent);
    }

    public VisualVoicemailSmsParams getLastSentVisualVoicemailSmsParams() {
        return this.lastVisualVoicemailSmsParams;
    }

    @Implementation(minSdk=26)
    public void setVisualVoicemailSmsFilterSettings(VisualVoicemailSmsFilterSettings settings) {
        this.visualVoicemailSmsFilterSettings = settings;
    }

    public VisualVoicemailSmsFilterSettings getVisualVoicemailSmsFilterSettings() {
        return this.visualVoicemailSmsFilterSettings;
    }

    public static void setEmergencyNumberList(Map<Integer, List<EmergencyNumber>> emergencyNumbersList) {
        ShadowTelephonyManager.emergencyNumbersList = emergencyNumbersList;
    }

    @Implementation(minSdk=30)
    protected Map<Integer, List<EmergencyNumber>> getEmergencyNumberList() {
        if (emergencyNumbersList != null) {
            return emergencyNumbersList;
        }
        return ImmutableMap.of();
    }

    public static class VisualVoicemailSmsParams {
        private final String destinationAddress;
        private final int port;
        private final String text;
        private final PendingIntent sentIntent;

        public VisualVoicemailSmsParams(String destinationAddress, int port, String text, PendingIntent sentIntent) {
            this.destinationAddress = destinationAddress;
            this.port = port;
            this.text = text;
            this.sentIntent = sentIntent;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public int getPort() {
            return this.port;
        }

        public String getText() {
            return this.text;
        }

        public PendingIntent getSentIntent() {
            return this.sentIntent;
        }
    }
}

