/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemProperties;
import android.text.TextUtils;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(className="android.hardware.display.AmbientDisplayConfiguration", minSdk=29, isInAndroidSdk=false)
public class ShadowAmbientDisplayConfiguration {
    private static String dozeComponent;
    private static boolean dozeAlwaysOnDisplayAvailable;

    @Implementation
    protected String ambientDisplayComponent() {
        return dozeComponent;
    }

    @Implementation
    protected boolean alwaysOnAvailable() {
        return (this.alwaysOnDisplayDebuggingEnabled() || this.alwaysOnDisplayAvailable()) && this.ambientDisplayAvailable();
    }

    @Implementation
    protected boolean ambientDisplayAvailable() {
        return !TextUtils.isEmpty((CharSequence)this.ambientDisplayComponent());
    }

    @Implementation
    protected boolean alwaysOnDisplayDebuggingEnabled() {
        return SystemProperties.getBoolean((String)"debug.doze.aod", (boolean)false) && SystemProperties.getInt((String)"ro.debuggable", (int)0) == 1;
    }

    @Implementation
    protected boolean alwaysOnDisplayAvailable() {
        return dozeAlwaysOnDisplayAvailable;
    }

    public static void setDozeComponent(String dozeComponent) {
        ShadowAmbientDisplayConfiguration.dozeComponent = dozeComponent;
    }

    public static void setDozeAlwaysOnDisplayAvailable(boolean dozeAlwaysOnDisplayAvailable) {
        ShadowAmbientDisplayConfiguration.dozeAlwaysOnDisplayAvailable = dozeAlwaysOnDisplayAvailable;
    }

    @Resetter
    public static void reset() {
        dozeComponent = null;
        dozeAlwaysOnDisplayAvailable = false;
    }
}

