/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.os.Build;
import android.os.Handler;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=CameraManager.class, minSdk=21)
public class ShadowCameraManager {
    @RealObject
    private CameraManager realObject;
    private final Map<String, CameraCharacteristics> cameraIdToCharacteristics = new LinkedHashMap<String, CameraCharacteristics>();
    private final Map<String, Boolean> cameraTorches = new HashMap<String, Boolean>();
    private final Set<CameraManager.AvailabilityCallback> registeredCallbacks = new HashSet<CameraManager.AvailabilityCallback>();
    private final Set<Object> torchCallbacks = new HashSet<Object>();
    private CameraDevice lastDevice;
    private CameraDevice.StateCallback lastCallback;
    @Nullable
    private Executor lastCallbackExecutor;
    @Nullable
    private Handler lastCallbackHandler;
    protected static final Set<CameraDeviceImpl> createdCameras = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    @Implementation
    protected String[] getCameraIdList() throws CameraAccessException {
        Set<String> cameraIds = this.cameraIdToCharacteristics.keySet();
        return cameraIds.toArray(new String[0]);
    }

    @Implementation
    protected CameraCharacteristics getCameraCharacteristics(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        CameraCharacteristics characteristics = this.cameraIdToCharacteristics.get(cameraId);
        Preconditions.checkArgument((characteristics != null ? 1 : 0) != 0);
        return characteristics;
    }

    @Implementation(minSdk=23)
    protected void setTorchMode(String cameraId, boolean enabled) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.keySet().contains(cameraId));
        this.cameraTorches.put(cameraId, enabled);
        for (Object callback : this.torchCallbacks) {
            ((CameraManager.TorchCallback)callback).onTorchModeChanged(cameraId, enabled);
        }
    }

    @Implementation(minSdk=34)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int uid, int oomScoreOffset, boolean overrideToPortrait) {
        return this.openCameraDeviceUserAsync(cameraId, callback, executor, uid, oomScoreOffset);
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int unusedClientUid, int unusedOomScoreOffset) {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Application context = RuntimeEnvironment.getApplication();
        CameraDeviceImpl deviceImpl = (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Executor.class, (Object)executor), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics), ReflectionHelpers.ClassParameter.from(Map.class, Collections.emptyMap()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)context.getApplicationInfo().targetSdkVersion), ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, null, executor);
        executor.execute(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=28, maxSdk=30)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int uid) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Context context = ((ReflectorCameraManager)Reflector.reflector(ReflectorCameraManager.class, (Object)this.realObject)).getContext();
        CameraDeviceImpl deviceImpl = (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Executor.class, (Object)executor), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)context.getApplicationInfo().targetSdkVersion)});
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, null, executor);
        executor.execute(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=25, maxSdk=27)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler, int uid) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Context context = ((ReflectorCameraManager)Reflector.reflector(ReflectorCameraManager.class, (Object)this.realObject)).getContext();
        CameraDeviceImpl deviceImpl = Build.VERSION.SDK_INT == 25 ? (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics)}) : (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)context.getApplicationInfo().targetSdkVersion)});
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, handler, null);
        handler.post(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=21, maxSdk=24)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl deviceImpl = (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics)});
        createdCameras.add(deviceImpl);
        this.updateCameraCallback((CameraDevice)deviceImpl, callback, handler, null);
        handler.post(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=21)
    protected void registerAvailabilityCallback(CameraManager.AvailabilityCallback callback, Handler handler) {
        Preconditions.checkNotNull((Object)callback);
        this.registeredCallbacks.add(callback);
    }

    @Implementation(minSdk=21)
    protected void unregisterAvailabilityCallback(CameraManager.AvailabilityCallback callback) {
        Preconditions.checkNotNull((Object)callback);
        this.registeredCallbacks.remove(callback);
    }

    @Implementation(minSdk=23)
    protected void registerTorchCallback(CameraManager.TorchCallback callback, Handler handler) {
        Preconditions.checkNotNull((Object)callback);
        this.torchCallbacks.add(callback);
    }

    @Implementation(minSdk=23)
    protected void unregisterTorchCallback(CameraManager.TorchCallback callback) {
        Preconditions.checkNotNull((Object)callback);
        this.torchCallbacks.remove(callback);
    }

    private void triggerOnCameraAvailable(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        for (CameraManager.AvailabilityCallback callback : this.registeredCallbacks) {
            callback.onCameraAvailable(cameraId);
        }
    }

    private void triggerOnCameraUnavailable(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        for (CameraManager.AvailabilityCallback callback : this.registeredCallbacks) {
            callback.onCameraUnavailable(cameraId);
        }
    }

    public void addCamera(String cameraId, CameraCharacteristics characteristics) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkNotNull((Object)characteristics);
        Preconditions.checkArgument((!this.cameraIdToCharacteristics.containsKey(cameraId) ? 1 : 0) != 0);
        this.cameraIdToCharacteristics.put(cameraId, characteristics);
        this.triggerOnCameraAvailable(cameraId);
    }

    public void removeCamera(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.containsKey(cameraId));
        this.cameraIdToCharacteristics.remove(cameraId);
        this.triggerOnCameraUnavailable(cameraId);
    }

    public boolean getTorchMode(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.keySet().contains(cameraId));
        Boolean torchState = this.cameraTorches.get(cameraId);
        return torchState;
    }

    public void triggerDisconnect() {
        if (this.lastCallbackHandler != null) {
            this.lastCallbackHandler.post(() -> this.lastCallback.onDisconnected(this.lastDevice));
        } else if (this.lastCallbackExecutor != null) {
            this.lastCallbackExecutor.execute(() -> this.lastCallback.onDisconnected(this.lastDevice));
        }
    }

    protected void updateCameraCallback(CameraDevice device, CameraDevice.StateCallback callback, @Nullable Handler handler, @Nullable Executor executor) {
        this.lastDevice = device;
        this.lastCallback = callback;
        this.lastCallbackHandler = handler;
        this.lastCallbackExecutor = executor;
    }

    @Resetter
    public static void reset() {
        for (CameraDeviceImpl cameraDevice : createdCameras) {
            cameraDevice.close();
        }
        createdCameras.clear();
    }

    @ForType(value=CameraManager.class)
    private static interface ReflectorCameraManager {
        @Accessor(value="mContext")
        public Context getContext();
    }

    @Implements(className="android.hardware.camera2.CameraManager$CameraManagerGlobal", minSdk=21)
    public static class ShadowCameraManagerGlobal {
        @Implementation(minSdk=24)
        protected void scheduleCameraServiceReconnectionLocked() {
        }
    }
}

