/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=KeyCharacterMap.class)
public class ShadowKeyCharacterMap {
    private static final Map<Character, Integer> CHAR_TO_KEY_CODE = new HashMap<Character, Integer>();
    private static final Map<Character, Integer> CHAR_TO_KEY_CODE_SHIFT_ON = new HashMap<Character, Integer>();
    private static final Map<Integer, Character> KEY_CODE_TO_CHAR = new HashMap<Integer, Character>();
    private static final Map<Integer, Character> KEY_CODE_TO_CHAR_SHIFT_ON = new HashMap<Integer, Character>();

    @Implementation
    protected static KeyCharacterMap load(int deviceId) {
        return (KeyCharacterMap)ReflectionHelpers.callConstructor(KeyCharacterMap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation(minSdk=20)
    protected static KeyEvent[] nativeGetEvents(long ptr, char[] chars) {
        int eventsPerChar = 2;
        KeyEvent[] events = new KeyEvent[chars.length * eventsPerChar];
        for (int i = 0; i < chars.length; ++i) {
            events[eventsPerChar * i] = ShadowKeyCharacterMap.getDownEvent(chars[i]);
            events[eventsPerChar * i + 1] = ShadowKeyCharacterMap.getUpEvent(chars[i]);
        }
        return events;
    }

    @Implementation(maxSdk=19)
    protected static KeyEvent[] nativeGetEvents(int ptr, char[] chars) {
        return ShadowKeyCharacterMap.nativeGetEvents((long)ptr, chars);
    }

    @Implementation(minSdk=20)
    protected static int nativeGetKeyboardType(long ptr) {
        return 4;
    }

    @Implementation(maxSdk=19)
    protected static int nativeGetKeyboardType(int ptr) {
        return 4;
    }

    @Implementation(maxSdk=19)
    protected static char nativeGetCharacter(int ptr, int keyCode, int metaState) {
        return ShadowKeyCharacterMap.nativeGetCharacter((long)ptr, keyCode, metaState);
    }

    @Implementation(minSdk=20)
    protected static char nativeGetCharacter(long ptr, int keyCode, int metaState) {
        boolean metaShiftOn = (metaState & 1) != 0;
        Character character = KEY_CODE_TO_CHAR.get(keyCode);
        if (character == null) {
            return '\u0000';
        }
        if (metaShiftOn) {
            return KEY_CODE_TO_CHAR_SHIFT_ON.getOrDefault(keyCode, character).charValue();
        }
        return Character.toLowerCase(character.charValue());
    }

    private static KeyEvent getDownEvent(char a) {
        return new KeyEvent(0L, 0L, 0, ShadowKeyCharacterMap.toCharKeyCode(a), 0, ShadowKeyCharacterMap.getMetaState(a), -1, 0);
    }

    private static KeyEvent getUpEvent(char a) {
        return new KeyEvent(0L, 0L, 1, ShadowKeyCharacterMap.toCharKeyCode(a), 0, ShadowKeyCharacterMap.getMetaState(a), -1, 0);
    }

    @Implementation(minSdk=20)
    protected static char nativeGetDisplayLabel(long ptr, int keyCode) {
        return KEY_CODE_TO_CHAR.getOrDefault(keyCode, Character.valueOf('\u0000')).charValue();
    }

    @Implementation(maxSdk=19)
    protected static char nativeGetDisplayLabel(int ptr, int keyCode) {
        return KEY_CODE_TO_CHAR.getOrDefault(keyCode, Character.valueOf('\u0000')).charValue();
    }

    @Implementation(minSdk=20)
    protected static char nativeGetNumber(long ptr, int keyCode) {
        Character character = KEY_CODE_TO_CHAR.get(keyCode);
        if (character == null) {
            return '\u0000';
        }
        return character.charValue();
    }

    @Implementation(maxSdk=19)
    protected static char nativeGetNumber(int ptr, int keyCode) {
        Character character = KEY_CODE_TO_CHAR.get(keyCode);
        if (character == null) {
            return '\u0000';
        }
        return character.charValue();
    }

    private static int toCharKeyCode(char a) {
        if (CHAR_TO_KEY_CODE.containsKey(Character.valueOf(Character.toUpperCase(a)))) {
            return CHAR_TO_KEY_CODE.get(Character.valueOf(Character.toUpperCase(a)));
        }
        if (CHAR_TO_KEY_CODE_SHIFT_ON.containsKey(Character.valueOf(a))) {
            return CHAR_TO_KEY_CODE_SHIFT_ON.get(Character.valueOf(a));
        }
        return 0;
    }

    private static int getMetaState(char a) {
        if (Character.isUpperCase(a) || CHAR_TO_KEY_CODE_SHIFT_ON.containsKey(Character.valueOf(a))) {
            return 1;
        }
        return 0;
    }

    static {
        CHAR_TO_KEY_CODE.put(Character.valueOf('0'), 7);
        CHAR_TO_KEY_CODE.put(Character.valueOf('1'), 8);
        CHAR_TO_KEY_CODE.put(Character.valueOf('2'), 9);
        CHAR_TO_KEY_CODE.put(Character.valueOf('3'), 10);
        CHAR_TO_KEY_CODE.put(Character.valueOf('4'), 11);
        CHAR_TO_KEY_CODE.put(Character.valueOf('5'), 12);
        CHAR_TO_KEY_CODE.put(Character.valueOf('6'), 13);
        CHAR_TO_KEY_CODE.put(Character.valueOf('7'), 14);
        CHAR_TO_KEY_CODE.put(Character.valueOf('8'), 15);
        CHAR_TO_KEY_CODE.put(Character.valueOf('9'), 16);
        CHAR_TO_KEY_CODE.put(Character.valueOf('A'), 29);
        CHAR_TO_KEY_CODE.put(Character.valueOf('B'), 30);
        CHAR_TO_KEY_CODE.put(Character.valueOf('C'), 31);
        CHAR_TO_KEY_CODE.put(Character.valueOf('D'), 32);
        CHAR_TO_KEY_CODE.put(Character.valueOf('E'), 33);
        CHAR_TO_KEY_CODE.put(Character.valueOf('F'), 34);
        CHAR_TO_KEY_CODE.put(Character.valueOf('G'), 35);
        CHAR_TO_KEY_CODE.put(Character.valueOf('H'), 36);
        CHAR_TO_KEY_CODE.put(Character.valueOf('I'), 37);
        CHAR_TO_KEY_CODE.put(Character.valueOf('J'), 38);
        CHAR_TO_KEY_CODE.put(Character.valueOf('K'), 39);
        CHAR_TO_KEY_CODE.put(Character.valueOf('L'), 40);
        CHAR_TO_KEY_CODE.put(Character.valueOf('M'), 41);
        CHAR_TO_KEY_CODE.put(Character.valueOf('N'), 42);
        CHAR_TO_KEY_CODE.put(Character.valueOf('O'), 43);
        CHAR_TO_KEY_CODE.put(Character.valueOf('P'), 44);
        CHAR_TO_KEY_CODE.put(Character.valueOf('Q'), 45);
        CHAR_TO_KEY_CODE.put(Character.valueOf('R'), 46);
        CHAR_TO_KEY_CODE.put(Character.valueOf('S'), 47);
        CHAR_TO_KEY_CODE.put(Character.valueOf('T'), 48);
        CHAR_TO_KEY_CODE.put(Character.valueOf('U'), 49);
        CHAR_TO_KEY_CODE.put(Character.valueOf('V'), 50);
        CHAR_TO_KEY_CODE.put(Character.valueOf('W'), 51);
        CHAR_TO_KEY_CODE.put(Character.valueOf('X'), 52);
        CHAR_TO_KEY_CODE.put(Character.valueOf('Y'), 53);
        CHAR_TO_KEY_CODE.put(Character.valueOf('Z'), 54);
        CHAR_TO_KEY_CODE.put(Character.valueOf(' '), 62);
        CHAR_TO_KEY_CODE.put(Character.valueOf('-'), 69);
        CHAR_TO_KEY_CODE.put(Character.valueOf('+'), 81);
        CHAR_TO_KEY_CODE.put(Character.valueOf('@'), 77);
        CHAR_TO_KEY_CODE.put(Character.valueOf('.'), 56);
        CHAR_TO_KEY_CODE.put(Character.valueOf(','), 55);
        CHAR_TO_KEY_CODE.put(Character.valueOf('['), 71);
        CHAR_TO_KEY_CODE.put(Character.valueOf(']'), 72);
        CHAR_TO_KEY_CODE.put(Character.valueOf(';'), 74);
        CHAR_TO_KEY_CODE.put(Character.valueOf('\''), 75);
        CHAR_TO_KEY_CODE.put(Character.valueOf(')'), 163);
        CHAR_TO_KEY_CODE.put(Character.valueOf('('), 162);
        CHAR_TO_KEY_CODE.put(Character.valueOf('#'), 18);
        CHAR_TO_KEY_CODE.put(Character.valueOf('*'), 17);
        CHAR_TO_KEY_CODE.put(Character.valueOf('/'), 76);
        CHAR_TO_KEY_CODE.put(Character.valueOf('='), 70);
        CHAR_TO_KEY_CODE.put(Character.valueOf('`'), 68);
        CHAR_TO_KEY_CODE.put(Character.valueOf('\\'), 73);
        CHAR_TO_KEY_CODE.put(Character.valueOf('\n'), 66);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('_'), 69);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('+'), 70);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('{'), 71);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('}'), 72);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf(':'), 74);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('\"'), 75);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf(')'), 7);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('!'), 8);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('@'), 9);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('#'), 10);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('$'), 11);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('%'), 12);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('^'), 13);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('&'), 14);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('*'), 15);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('('), 16);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('>'), 56);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('<'), 55);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('?'), 76);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('|'), 73);
        CHAR_TO_KEY_CODE_SHIFT_ON.put(Character.valueOf('~'), 68);
        KEY_CODE_TO_CHAR.put(7, Character.valueOf('0'));
        KEY_CODE_TO_CHAR.put(8, Character.valueOf('1'));
        KEY_CODE_TO_CHAR.put(9, Character.valueOf('2'));
        KEY_CODE_TO_CHAR.put(10, Character.valueOf('3'));
        KEY_CODE_TO_CHAR.put(11, Character.valueOf('4'));
        KEY_CODE_TO_CHAR.put(12, Character.valueOf('5'));
        KEY_CODE_TO_CHAR.put(13, Character.valueOf('6'));
        KEY_CODE_TO_CHAR.put(14, Character.valueOf('7'));
        KEY_CODE_TO_CHAR.put(15, Character.valueOf('8'));
        KEY_CODE_TO_CHAR.put(16, Character.valueOf('9'));
        KEY_CODE_TO_CHAR.put(29, Character.valueOf('A'));
        KEY_CODE_TO_CHAR.put(30, Character.valueOf('B'));
        KEY_CODE_TO_CHAR.put(31, Character.valueOf('C'));
        KEY_CODE_TO_CHAR.put(32, Character.valueOf('D'));
        KEY_CODE_TO_CHAR.put(33, Character.valueOf('E'));
        KEY_CODE_TO_CHAR.put(34, Character.valueOf('F'));
        KEY_CODE_TO_CHAR.put(35, Character.valueOf('G'));
        KEY_CODE_TO_CHAR.put(36, Character.valueOf('H'));
        KEY_CODE_TO_CHAR.put(37, Character.valueOf('I'));
        KEY_CODE_TO_CHAR.put(38, Character.valueOf('J'));
        KEY_CODE_TO_CHAR.put(39, Character.valueOf('K'));
        KEY_CODE_TO_CHAR.put(40, Character.valueOf('L'));
        KEY_CODE_TO_CHAR.put(41, Character.valueOf('M'));
        KEY_CODE_TO_CHAR.put(42, Character.valueOf('N'));
        KEY_CODE_TO_CHAR.put(43, Character.valueOf('O'));
        KEY_CODE_TO_CHAR.put(44, Character.valueOf('P'));
        KEY_CODE_TO_CHAR.put(45, Character.valueOf('Q'));
        KEY_CODE_TO_CHAR.put(46, Character.valueOf('R'));
        KEY_CODE_TO_CHAR.put(47, Character.valueOf('S'));
        KEY_CODE_TO_CHAR.put(48, Character.valueOf('T'));
        KEY_CODE_TO_CHAR.put(49, Character.valueOf('U'));
        KEY_CODE_TO_CHAR.put(50, Character.valueOf('V'));
        KEY_CODE_TO_CHAR.put(51, Character.valueOf('W'));
        KEY_CODE_TO_CHAR.put(52, Character.valueOf('X'));
        KEY_CODE_TO_CHAR.put(53, Character.valueOf('Y'));
        KEY_CODE_TO_CHAR.put(54, Character.valueOf('Z'));
        KEY_CODE_TO_CHAR.put(62, Character.valueOf(' '));
        KEY_CODE_TO_CHAR.put(69, Character.valueOf('-'));
        KEY_CODE_TO_CHAR.put(81, Character.valueOf('+'));
        KEY_CODE_TO_CHAR.put(77, Character.valueOf('@'));
        KEY_CODE_TO_CHAR.put(56, Character.valueOf('.'));
        KEY_CODE_TO_CHAR.put(55, Character.valueOf(','));
        KEY_CODE_TO_CHAR.put(71, Character.valueOf('['));
        KEY_CODE_TO_CHAR.put(72, Character.valueOf(']'));
        KEY_CODE_TO_CHAR.put(74, Character.valueOf(';'));
        KEY_CODE_TO_CHAR.put(75, Character.valueOf('\''));
        KEY_CODE_TO_CHAR.put(163, Character.valueOf(')'));
        KEY_CODE_TO_CHAR.put(162, Character.valueOf('('));
        KEY_CODE_TO_CHAR.put(18, Character.valueOf('#'));
        KEY_CODE_TO_CHAR.put(17, Character.valueOf('*'));
        KEY_CODE_TO_CHAR.put(76, Character.valueOf('/'));
        KEY_CODE_TO_CHAR.put(70, Character.valueOf('='));
        KEY_CODE_TO_CHAR.put(68, Character.valueOf('`'));
        KEY_CODE_TO_CHAR.put(73, Character.valueOf('\\'));
        KEY_CODE_TO_CHAR.put(66, Character.valueOf('\n'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(69, Character.valueOf('_'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(70, Character.valueOf('+'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(71, Character.valueOf('{'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(72, Character.valueOf('}'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(74, Character.valueOf(':'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(75, Character.valueOf('\"'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(7, Character.valueOf(')'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(8, Character.valueOf('!'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(9, Character.valueOf('@'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(10, Character.valueOf('#'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(11, Character.valueOf('$'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(12, Character.valueOf('%'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(13, Character.valueOf('^'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(14, Character.valueOf('&'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(15, Character.valueOf('*'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(16, Character.valueOf('('));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(56, Character.valueOf('>'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(55, Character.valueOf('<'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(76, Character.valueOf('?'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(73, Character.valueOf('|'));
        KEY_CODE_TO_CHAR_SHIFT_ON.put(68, Character.valueOf('~'));
    }
}

