/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Path;
import android.graphics.RectF;
import java.util.List;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowLegacyPath;
import org.robolectric.shadows.ShadowNativePath;

@Implements(value=Path.class, shadowPicker=Picker.class)
public abstract class ShadowPath {
    public abstract List<Point> getPoints();

    public abstract void fillBounds(RectF var1);

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowLegacyPath.class, ShadowNativePath.class);
        }
    }

    public static class Point {
        private final float x;
        private final float y;
        private final Type type;

        public Point(float x, float y, Type type) {
            this.x = x;
            this.y = y;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point point = (Point)o;
            if (Float.compare(point.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(point.y, this.y) != 0) {
                return false;
            }
            return this.type == point.type;
        }

        public int hashCode() {
            int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Point(" + this.x + "," + this.y + "," + (Object)((Object)this.type) + ")";
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            MOVE_TO,
            LINE_TO;

        }
    }
}

