/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaPlayer;
import android.net.Uri;
import android.widget.VideoView;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowSurfaceView;

@Implements(value=VideoView.class)
public class ShadowVideoView
extends ShadowSurfaceView {
    private MediaPlayer.OnCompletionListener completionListner;
    private MediaPlayer.OnErrorListener errorListener;
    private MediaPlayer.OnPreparedListener preparedListener;
    private Uri uri;
    private String path;
    private int duration = 0;
    public static final int STOP = 0;
    public static final int START = 1;
    public static final int SUSPEND = 2;
    public static final int PAUSE = 3;
    public static final int RESUME = 4;
    private int currentState = -1;
    private int prevState;
    private int currentPosition;

    @Implementation
    protected void setOnPreparedListener(MediaPlayer.OnPreparedListener l) {
        this.preparedListener = l;
    }

    @Implementation
    protected void setOnErrorListener(MediaPlayer.OnErrorListener l) {
        this.errorListener = l;
    }

    @Implementation
    protected void setOnCompletionListener(MediaPlayer.OnCompletionListener l) {
        this.completionListner = l;
    }

    @Implementation
    protected void setVideoPath(String path) {
        this.path = path;
    }

    @Implementation
    protected void setVideoURI(Uri uri) {
        this.uri = uri;
    }

    @Implementation
    protected void start() {
        this.savePrevState();
        this.currentState = 1;
    }

    @Implementation
    protected void stopPlayback() {
        this.savePrevState();
        this.currentState = 0;
    }

    @Implementation
    protected void suspend() {
        this.savePrevState();
        this.currentState = 2;
    }

    @Implementation
    protected void pause() {
        this.savePrevState();
        this.currentState = 3;
    }

    @Implementation
    protected void resume() {
        this.savePrevState();
        this.currentState = 4;
    }

    @Implementation
    protected boolean isPlaying() {
        return this.currentState == 1;
    }

    @Implementation
    protected boolean canPause() {
        return this.currentState != 3 && this.currentState != 0 && this.currentState != 2;
    }

    @Implementation
    protected void seekTo(int msec) {
        this.currentPosition = msec;
    }

    @Implementation
    protected int getCurrentPosition() {
        return this.currentPosition;
    }

    @Implementation
    protected int getDuration() {
        return this.duration;
    }

    public MediaPlayer.OnPreparedListener getOnPreparedListener() {
        return this.preparedListener;
    }

    public MediaPlayer.OnErrorListener getOnErrorListener() {
        return this.errorListener;
    }

    public MediaPlayer.OnCompletionListener getOnCompletionListener() {
        return this.completionListner;
    }

    public String getVideoPath() {
        return this.path;
    }

    public String getVideoURIString() {
        return this.uri == null ? null : this.uri.toString();
    }

    public int getCurrentVideoState() {
        return this.currentState;
    }

    public int getPrevVideoState() {
        return this.prevState;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    private void savePrevState() {
        this.prevState = this.currentState;
    }
}

