/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import com.android.internal.util.VirtualRefBasePtr;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.res.android.NativeObjRegistry;

@Implements(value=VirtualRefBasePtr.class, isInAndroidSdk=false)
public class ShadowVirtualRefBasePtr {
    private static final NativeObjRegistry<RefHolder> NATIVE_REGISTRY = new NativeObjRegistry(RefHolder.class);

    protected static synchronized <T> long put(T object) {
        return NATIVE_REGISTRY.register(new RefHolder(object));
    }

    protected static synchronized <T> T get(long nativePtr, Class<T> clazz) {
        return clazz.cast(((RefHolder)NATIVE_REGISTRY.getNativeObject(nativePtr)).nativeThing);
    }

    @Implementation(minSdk=21)
    protected static synchronized void nIncStrong(long ptr) {
        if (ptr == 0L) {
            return;
        }
        ((RefHolder)ShadowVirtualRefBasePtr.NATIVE_REGISTRY.getNativeObject(ptr)).incr();
    }

    @Implementation(minSdk=21)
    protected static synchronized void nDecStrong(long ptr) {
        if (ptr == 0L) {
            return;
        }
        if (((RefHolder)ShadowVirtualRefBasePtr.NATIVE_REGISTRY.getNativeObject(ptr)).decr()) {
            NATIVE_REGISTRY.unregister(ptr);
        }
    }

    private static final class RefHolder<T> {
        private T nativeThing;
        private int refCount;

        private RefHolder(T object) {
            this.nativeThing = object;
        }

        private synchronized void incr() {
            ++this.refCount;
        }

        private synchronized boolean decr() {
            --this.refCount;
            return this.refCount == 0;
        }
    }
}

