/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.backup.BackupDataOutput;
import com.google.common.collect.ImmutableList;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadows.BackupDataEntity;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;

@Implements(value=BackupDataOutput.class, minSdk=21)
public class ShadowBackupDataOutput {
    protected static final String KEY_PREFIX_JOINER = ":";
    private static final NativeObjRegistry<NativeBackupDataOutput> nativeObjectRegistry = new NativeObjRegistry(NativeBackupDataOutput.class);
    @ReflectorObject
    private BackupDataOutputReflector backupDataOutputReflector;

    public ImmutableList<BackupDataEntity> getEntities() {
        return ImmutableList.copyOf(((NativeBackupDataOutput)ShadowBackupDataOutput.nativeObjectRegistry.getNativeObject((long)this.backupDataOutputReflector.getBackupWriter())).entities);
    }

    @Implementation
    protected static int writeEntityHeader_native(long mBackupWriter, String key, int dataSize) {
        NativeBackupDataOutput nativeObject = (NativeBackupDataOutput)nativeObjectRegistry.getNativeObject(mBackupWriter);
        if (nativeObject.currentEntity != null && nativeObject.currentBytesWritten < nativeObject.currentEntity.dataSize()) {
            return -1;
        }
        String prefixedKey = nativeObject.keyPrefix != null ? nativeObject.keyPrefix + KEY_PREFIX_JOINER + key : key;
        nativeObject.currentEntity = dataSize >= 0 ? BackupDataEntity.create(prefixedKey, new byte[dataSize]) : BackupDataEntity.createDeletedEntity(prefixedKey);
        nativeObject.currentBytesWritten = 0;
        nativeObject.entities.add(nativeObject.currentEntity);
        return key.length() + 1;
    }

    @Implementation
    protected static int writeEntityData_native(long mBackupWriter, byte[] data, int size) {
        NativeBackupDataOutput nativeObject = (NativeBackupDataOutput)nativeObjectRegistry.getNativeObject(mBackupWriter);
        if (nativeObject.currentEntity == null) {
            return -1;
        }
        if (size > data.length || nativeObject.currentBytesWritten + size > nativeObject.currentEntity.dataSize()) {
            return -1;
        }
        System.arraycopy(data, 0, nativeObject.currentEntity.data(), nativeObject.currentBytesWritten, size);
        nativeObject.currentBytesWritten += size;
        return size;
    }

    @Implementation
    protected static void setKeyPrefix_native(long mBackupWriter, String keyPrefix) {
        ((NativeBackupDataOutput)ShadowBackupDataOutput.nativeObjectRegistry.getNativeObject((long)mBackupWriter)).keyPrefix = keyPrefix;
    }

    @Implementation
    protected static long ctor(FileDescriptor fd) {
        return nativeObjectRegistry.register((Object)new NativeBackupDataOutput());
    }

    @Implementation
    protected static void dtor(long mBackupWriter) {
        nativeObjectRegistry.unregister(mBackupWriter);
    }

    @ForType(value=BackupDataOutput.class)
    private static interface BackupDataOutputReflector {
        @Accessor(value="mBackupWriter")
        public long getBackupWriter();
    }

    private static final class NativeBackupDataOutput {
        final List<BackupDataEntity> entities = new ArrayList<BackupDataEntity>();
        String keyPrefix = null;
        BackupDataEntity currentEntity = null;
        int currentBytesWritten = 0;

        private NativeBackupDataOutput() {
        }
    }
}

