/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.AdvertisingSet;
import android.bluetooth.le.AdvertisingSetCallback;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.content.AttributionSource;
import android.os.Handler;
import android.os.ParcelUuid;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=BluetoothLeAdvertiser.class, minSdk=26)
public class ShadowBluetoothLeAdvertiser {
    private static final String CALLBACK_NULL_MESSAGE = "callback cannot be null.";
    private static final int MAX_LEGACY_ADVERTISING_DATA_BYTES = 31;
    private static final int OVERHEAD_BYTES_PER_FIELD = 2;
    private static final int FLAGS_FIELD_BYTES = 3;
    private static final int MANUFACTURER_SPECIFIC_DATA_LENGTH = 2;
    private static final int SERVICE_DATA_UUID_LENGTH = 2;
    private BluetoothAdapter bluetoothAdapter;
    private final Set<AdvertiseCallback> advertisements = new HashSet<AdvertiseCallback>();
    private final Map<AdvertisingSetCallback, AdvertisingSet> advertisingSetMap = new HashMap<AdvertisingSetCallback, AdvertisingSet>();
    private final AtomicInteger advertiserId = new AtomicInteger(0);
    @ReflectorObject
    protected BluetoothLeAdvertiserReflector bluetoothLeAdvertiserReflector;

    @Implementation(maxSdk=30)
    protected void __constructor__(IBluetoothManager bluetoothManager) {
        this.bluetoothLeAdvertiserReflector.__constructor__(bluetoothManager);
        PerfStatsCollector.getInstance().incrementCount("constructShadowBluetoothLeAdvertiser");
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    @Implementation(minSdk=31)
    protected void __constructor__(BluetoothAdapter bluetoothAdapter) {
        this.bluetoothLeAdvertiserReflector.__constructor__(bluetoothAdapter);
        PerfStatsCollector.getInstance().incrementCount("constructShadowBluetoothLeAdvertiser");
        this.bluetoothAdapter = bluetoothAdapter;
    }

    @Implementation
    protected void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseCallback callback) {
        this.startAdvertising(settings, advertiseData, null, callback);
    }

    @Implementation
    protected void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(CALLBACK_NULL_MESSAGE);
        }
        boolean isConnectable = settings.isConnectable();
        if (this.getTotalBytes(advertiseData, isConnectable) > 31 || this.getTotalBytes(scanResponse, false) > 31) {
            callback.onStartFailure(1);
            return;
        }
        if (this.advertisements.contains(callback)) {
            callback.onStartFailure(3);
            return;
        }
        this.advertisements.add(callback);
        callback.onStartSuccess(settings);
    }

    @Implementation
    protected void stopAdvertising(AdvertiseCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(CALLBACK_NULL_MESSAGE);
        }
        this.advertisements.remove(callback);
    }

    @Implementation(minSdk=34)
    protected void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, BluetoothGattServer gattServer, AdvertisingSetCallback callback, Handler handler) {
        boolean hasFlags;
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        boolean isConnectable = parameters.isConnectable();
        boolean isDiscoverable = parameters.isDiscoverable();
        boolean bl = hasFlags = isConnectable && isDiscoverable;
        if (parameters.isLegacy()) {
            if (this.getTotalBytes(advertiseData, hasFlags) > 31) {
                throw new IllegalArgumentException("Legacy advertising data too big");
            }
            if (this.getTotalBytes(scanResponse, false) > 31) {
                throw new IllegalArgumentException("Legacy scan response data too big");
            }
        } else {
            boolean supportCodedPhy = this.bluetoothAdapter.isLeCodedPhySupported();
            boolean support2MPhy = this.bluetoothAdapter.isLe2MPhySupported();
            int pphy = parameters.getPrimaryPhy();
            int sphy = parameters.getSecondaryPhy();
            if (pphy == 3 && !supportCodedPhy) {
                throw new IllegalArgumentException("Unsupported primary PHY selected");
            }
            if (sphy == 3 && !supportCodedPhy || sphy == 2 && !support2MPhy) {
                throw new IllegalArgumentException("Unsupported secondary PHY selected");
            }
            int maxData = this.bluetoothAdapter.getLeMaximumAdvertisingDataLength();
            if (this.getTotalBytes(advertiseData, hasFlags) > maxData) {
                throw new IllegalArgumentException("Advertising data too big");
            }
            if (this.getTotalBytes(scanResponse, false) > maxData) {
                throw new IllegalArgumentException("Scan response data too big");
            }
            if (this.getTotalBytes(periodicData, false) > maxData) {
                throw new IllegalArgumentException("Periodic advertising data too big");
            }
        }
        if (maxExtendedAdvertisingEvents < 0 || maxExtendedAdvertisingEvents > 255) {
            throw new IllegalArgumentException("maxExtendedAdvertisingEvents out of range: " + maxExtendedAdvertisingEvents);
        }
        if (maxExtendedAdvertisingEvents != 0 && !this.bluetoothAdapter.isLePeriodicAdvertisingSupported()) {
            throw new IllegalArgumentException("Can't use maxExtendedAdvertisingEvents with controller that don't support LE Extended Advertising");
        }
        if (duration < 0 || duration > 65535) {
            throw new IllegalArgumentException("duration out of range: " + duration);
        }
        if (this.advertisingSetMap.containsKey(callback)) {
            callback.onAdvertisingSetStarted(null, parameters.getTxPowerLevel(), 3);
            return;
        }
        AdvertisingSet advertisingSet = (AdvertisingSet)ReflectionHelpers.callConstructor(AdvertisingSet.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.advertiserId.getAndAdd(1)), ReflectionHelpers.ClassParameter.from(IBluetoothManager.class, (Object)((IBluetoothManager)ReflectionHelpers.createNullProxy(IBluetoothManager.class))), ReflectionHelpers.ClassParameter.from(AttributionSource.class, (Object)((AttributionSource)ReflectionHelpers.callInstanceMethod((Object)this.bluetoothAdapter, (String)"getAttributionSource", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])))});
        callback.onAdvertisingSetStarted(advertisingSet, parameters.getTxPowerLevel(), 0);
        this.advertisingSetMap.put(callback, advertisingSet);
    }

    @Implementation(minSdk=34)
    protected void stopAdvertisingSet(AdvertisingSetCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        if (!this.advertisingSetMap.containsKey(callback)) {
            throw new IllegalArgumentException("callback not found");
        }
        callback.onAdvertisingSetStopped(this.advertisingSetMap.get(callback));
        this.advertisingSetMap.remove(callback);
    }

    public int getAdvertisementRequestCount() {
        return this.advertisements.size();
    }

    public int getAdvertisingSetRequestCount() {
        return this.advertisingSetMap.size();
    }

    private int getTotalBytes(AdvertiseData data, boolean isConnectable) {
        int size;
        if (data == null) {
            return 0;
        }
        int n = size = isConnectable ? 3 : 0;
        if (data.getServiceUuids() != null) {
            int num16BitUuids = 0;
            int num32BitUuids = 0;
            int num128BitUuids = 0;
            for (ParcelUuid uuid : data.getServiceUuids()) {
                if (BluetoothUuid.is16BitUuid((ParcelUuid)uuid)) {
                    ++num16BitUuids;
                    continue;
                }
                if (BluetoothUuid.is32BitUuid((ParcelUuid)uuid)) {
                    ++num32BitUuids;
                    continue;
                }
                ++num128BitUuids;
            }
            if (num16BitUuids != 0) {
                size += 2 + num16BitUuids * 2;
            }
            if (num32BitUuids != 0) {
                size += 2 + num32BitUuids * 4;
            }
            if (num128BitUuids != 0) {
                size += 2 + num128BitUuids * 16;
            }
        }
        for (byte[] value : data.getServiceData().values()) {
            size += 4 + ShadowBluetoothLeAdvertiser.getByteLength(value);
        }
        for (int i = 0; i < data.getManufacturerSpecificData().size(); ++i) {
            size += 4 + ShadowBluetoothLeAdvertiser.getByteLength((byte[])data.getManufacturerSpecificData().valueAt(i));
        }
        if (data.getIncludeTxPowerLevel()) {
            size += 3;
        }
        if (data.getIncludeDeviceName() && this.bluetoothAdapter.getName() != null) {
            size += 2 + this.bluetoothAdapter.getName().length();
        }
        return size;
    }

    private static int getByteLength(byte[] array) {
        return array == null ? 0 : array.length;
    }

    @ForType(value=BluetoothLeAdvertiser.class)
    private static interface BluetoothLeAdvertiserReflector {
        @Direct
        public void __constructor__(IBluetoothManager var1);

        @Direct
        public void __constructor__(BluetoothAdapter var1);
    }
}

