/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.webkit.MimeTypeMap;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;

@Implements(value=MimeTypeMap.class)
public class ShadowMimeTypeMap {
    private final Map<String, String> extensionToMimeTypeMap = new HashMap<String, String>();
    private final Map<String, String> mimeTypeToExtensionMap = new HashMap<String, String>();
    private static volatile MimeTypeMap singleton = null;
    private static final Object singletonLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static MimeTypeMap getSingleton() {
        if (singleton == null) {
            Object object = singletonLock;
            synchronized (object) {
                if (singleton == null) {
                    singleton = (MimeTypeMap)Shadow.newInstanceOf(MimeTypeMap.class);
                }
            }
        }
        return singleton;
    }

    @Resetter
    public static void reset() {
        if (singleton != null) {
            ShadowMimeTypeMap shadowMimeTypeMap = (ShadowMimeTypeMap)Shadow.extract((Object)ShadowMimeTypeMap.getSingleton());
            shadowMimeTypeMap.clearMappings();
        }
    }

    @Implementation
    protected String getMimeTypeFromExtension(String extension) {
        if (this.extensionToMimeTypeMap.containsKey(extension)) {
            return this.extensionToMimeTypeMap.get(extension);
        }
        return null;
    }

    @Implementation
    protected String getExtensionFromMimeType(String mimeType) {
        if (this.mimeTypeToExtensionMap.containsKey(mimeType)) {
            return this.mimeTypeToExtensionMap.get(mimeType);
        }
        return null;
    }

    public void addExtensionMimeTypeMapping(String extension, String mimeType) {
        this.extensionToMimeTypeMap.put(extension, mimeType);
        this.mimeTypeToExtensionMap.put(mimeType, extension);
    }

    public void clearMappings() {
        this.extensionToMimeTypeMap.clear();
        this.mimeTypeToExtensionMap.clear();
    }

    @Implementation
    protected boolean hasExtension(String extension) {
        return this.extensionToMimeTypeMap.containsKey(extension);
    }

    @Implementation
    protected boolean hasMimeType(String mimeType) {
        return this.mimeTypeToExtensionMap.containsKey(mimeType);
    }
}

