/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=StateListDrawable.class)
public class ShadowStateListDrawable
extends ShadowDrawable {
    @RealObject
    StateListDrawable realStateListDrawable;
    private final Map<List<Integer>, Drawable> stateToDrawable = new HashMap<List<Integer>, Drawable>();

    @Implementation
    protected void addState(int[] stateSet, Drawable drawable2) {
        this.stateToDrawable.put(this.createStateList(stateSet), drawable2);
        ((StateListDrawableReflector)Reflector.reflector(StateListDrawableReflector.class, (Object)this.realStateListDrawable)).addState(stateSet, drawable2);
    }

    public Drawable getDrawableForState(int[] stateSet) {
        return this.stateToDrawable.get(this.createStateList(stateSet));
    }

    private List<Integer> createStateList(int[] stateSet) {
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        if (stateSet == StateSet.WILD_CARD) {
            stateList.add(-1);
        } else {
            for (int state : stateSet) {
                stateList.add(state);
            }
        }
        return stateList;
    }

    @ForType(value=StateListDrawable.class)
    static interface StateListDrawableReflector {
        @Direct
        public void addState(int[] var1, Drawable var2);
    }
}

