/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.HardwareRenderer;
import android.graphics.RenderNode;
import android.media.Image;
import android.media.ImageReader;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.View;
import com.android.internal.R;
import java.nio.IntBuffer;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.ReflectionHelpers;

public final class HardwareRenderingScreenshot {
    static final String USE_HARDWARE_RENDERER_NATIVE_ENV = "robolectric.screenshot.hwrdr.native";

    private HardwareRenderingScreenshot() {
    }

    static boolean canTakeScreenshot() {
        return Build.VERSION.SDK_INT >= 31 && Boolean.getBoolean(USE_HARDWARE_RENDERER_NATIVE_ENV) && ShadowView.useRealGraphics();
    }

    static void takeScreenshot(View view, Bitmap destBitmap) {
        int width = view.getWidth();
        int height = view.getHeight();
        try (ImageReader imageReader = ImageReader.newInstance((int)width, (int)height, (int)1, (int)1);){
            HardwareRenderer renderer = new HardwareRenderer();
            Surface surface = imageReader.getSurface();
            renderer.setSurface(surface);
            Image nativeImage = imageReader.acquireNextImage();
            HardwareRenderingScreenshot.setupRendererShadowProperties(renderer, view);
            RenderNode node = HardwareRenderingScreenshot.getRenderNode(view);
            renderer.setContentRoot(node);
            renderer.createRenderRequest().syncAndDraw();
            int[] renderPixels = new int[width * height];
            Image.Plane[] planes = nativeImage.getPlanes();
            IntBuffer srcBuff = planes[0].getBuffer().asIntBuffer();
            srcBuff.get(renderPixels);
            destBitmap.setPixels(renderPixels, 0, width, 0, 0, width, height);
            surface.release();
        }
    }

    private static RenderNode getRenderNode(View view) {
        return (RenderNode)ReflectionHelpers.callInstanceMethod((Object)view, (String)"updateDisplayListIfDirty", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    private static void setupRendererShadowProperties(HardwareRenderer renderer, View view) {
        Context context = view.getContext();
        Resources resources = context.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        float lightX = (float)displayMetrics.widthPixels / 2.0f;
        float lightY = a.getDimension(3, 0.0f);
        float lightZ = a.getDimension(4, 600.0f * displayMetrics.density);
        float lightRadius = a.getDimension(2, 800.0f * displayMetrics.density);
        float ambientShadowAlpha = a.getFloat(0, 0.039f);
        float spotShadowAlpha = a.getFloat(1, 0.19f);
        a.recycle();
        renderer.setLightSourceGeometry(lightX, lightY, lightZ, lightRadius);
        renderer.setLightSourceAlpha(ambientShadowAlpha, spotShadowAlpha);
    }
}

