/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Range;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

public class MediaCodecInfoBuilder {
    private String name;
    private boolean isEncoder;
    private boolean isVendor;
    private boolean isSoftwareOnly;
    private boolean isHardwareAccelerated;
    private MediaCodecInfo.CodecCapabilities[] capabilities = new MediaCodecInfo.CodecCapabilities[0];

    private MediaCodecInfoBuilder() {
    }

    public static MediaCodecInfoBuilder newBuilder() {
        return new MediaCodecInfoBuilder();
    }

    public MediaCodecInfoBuilder setName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        return this;
    }

    public MediaCodecInfoBuilder setIsEncoder(boolean isEncoder) {
        this.isEncoder = isEncoder;
        return this;
    }

    public MediaCodecInfoBuilder setIsVendor(boolean isVendor) {
        this.isVendor = isVendor;
        return this;
    }

    public MediaCodecInfoBuilder setIsSoftwareOnly(boolean isSoftwareOnly) {
        this.isSoftwareOnly = isSoftwareOnly;
        return this;
    }

    public MediaCodecInfoBuilder setIsHardwareAccelerated(boolean isHardwareAccelerated) {
        this.isHardwareAccelerated = isHardwareAccelerated;
        return this;
    }

    public MediaCodecInfoBuilder setCapabilities(MediaCodecInfo.CodecCapabilities ... capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public MediaCodecInfo build() {
        Preconditions.checkNotNull((Object)this.name, (Object)"Codec name is not set.");
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            int flags = this.getCodecFlags();
            return (MediaCodecInfo)ReflectionHelpers.callConstructor(MediaCodecInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.name), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.name), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(MediaCodecInfo.CodecCapabilities[].class, (Object)this.capabilities)});
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return (MediaCodecInfo)ReflectionHelpers.callConstructor(MediaCodecInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.name), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isEncoder), ReflectionHelpers.ClassParameter.from(MediaCodecInfo.CodecCapabilities[].class, (Object)this.capabilities)});
        }
        throw new UnsupportedOperationException("Unable to create MediaCodecInfo");
    }

    private int getCodecFlags() {
        MediaCodecInfoReflector mediaCodecInfoReflector = (MediaCodecInfoReflector)Reflector.reflector(MediaCodecInfoReflector.class);
        int flags = 0;
        if (this.isEncoder) {
            flags |= mediaCodecInfoReflector.getIsEncoderFlagValue();
        }
        if (this.isVendor) {
            flags |= mediaCodecInfoReflector.getIsVendorFlagValue();
        }
        if (this.isSoftwareOnly) {
            flags |= mediaCodecInfoReflector.getIsSoftwareOnlyFlagValue();
        }
        if (this.isHardwareAccelerated) {
            flags |= mediaCodecInfoReflector.getIsHardwareAcceleratedFlagValue();
        }
        return flags;
    }

    @ForType(value=MediaCodecInfo.class)
    static interface MediaCodecInfoReflector {
        @Static
        @Accessor(value="FLAG_IS_ENCODER")
        public int getIsEncoderFlagValue();

        @Static
        @Accessor(value="FLAG_IS_VENDOR")
        public int getIsVendorFlagValue();

        @Static
        @Accessor(value="FLAG_IS_SOFTWARE_ONLY")
        public int getIsSoftwareOnlyFlagValue();

        @Static
        @Accessor(value="FLAG_IS_HARDWARE_ACCELERATED")
        public int getIsHardwareAcceleratedFlagValue();
    }

    public static class CodecCapabilitiesBuilder {
        private MediaFormat mediaFormat;
        private boolean isEncoder;
        private MediaCodecInfo.CodecProfileLevel[] profileLevels = new MediaCodecInfo.CodecProfileLevel[0];
        private int[] colorFormats;
        private String[] requiredFeatures = new String[0];

        private CodecCapabilitiesBuilder() {
        }

        public static CodecCapabilitiesBuilder newBuilder() {
            return new CodecCapabilitiesBuilder();
        }

        public CodecCapabilitiesBuilder setMediaFormat(MediaFormat mediaFormat) {
            Preconditions.checkNotNull((Object)mediaFormat);
            Preconditions.checkArgument((mediaFormat.getString("mime") != null ? 1 : 0) != 0, (Object)"MIME type of the format is not set.");
            this.mediaFormat = mediaFormat;
            return this;
        }

        public CodecCapabilitiesBuilder setRequiredFeatures(String[] requiredFeatures) {
            this.requiredFeatures = requiredFeatures;
            return this;
        }

        public CodecCapabilitiesBuilder setIsEncoder(boolean isEncoder) {
            this.isEncoder = isEncoder;
            return this;
        }

        public CodecCapabilitiesBuilder setProfileLevels(MediaCodecInfo.CodecProfileLevel[] profileLevels) {
            this.profileLevels = (MediaCodecInfo.CodecProfileLevel[])Preconditions.checkNotNull((Object)profileLevels);
            return this;
        }

        public CodecCapabilitiesBuilder setColorFormats(int[] colorFormats) {
            this.colorFormats = colorFormats;
            return this;
        }

        public MediaCodecInfo.CodecCapabilities build() {
            Preconditions.checkNotNull((Object)this.mediaFormat, (Object)"mediaFormat is not set.");
            Preconditions.checkNotNull((Object)this.profileLevels, (Object)"profileLevels is not set.");
            String mime = this.mediaFormat.getString("mime");
            boolean isVideoCodec = mime.startsWith("video/");
            MediaCodecInfo.CodecCapabilities caps = new MediaCodecInfo.CodecCapabilities();
            CodecCapabilitiesReflector capsReflector = (CodecCapabilitiesReflector)Reflector.reflector(CodecCapabilitiesReflector.class, (Object)caps);
            caps.profileLevels = this.profileLevels;
            if (isVideoCodec) {
                Preconditions.checkNotNull((Object)this.colorFormats, (Object)"colorFormats should not be null for video codec");
                caps.colorFormats = this.colorFormats;
            } else {
                Preconditions.checkArgument((this.colorFormats == null || this.colorFormats.length == 0 ? 1 : 0) != 0, (Object)"colorFormats should not be set for audio codec");
                caps.colorFormats = new int[0];
            }
            capsReflector.setMime(mime);
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                capsReflector.setMaxSupportedInstances(32);
            }
            capsReflector.setDefaultFormat(this.mediaFormat);
            capsReflector.setCapabilitiesInfo(this.mediaFormat);
            if (isVideoCodec) {
                MediaCodecInfo.VideoCapabilities videoCaps = CodecCapabilitiesBuilder.createDefaultVideoCapabilities(caps, this.mediaFormat);
                VideoCapabilitiesReflector videoCapsReflector = (VideoCapabilitiesReflector)Reflector.reflector(VideoCapabilitiesReflector.class, (Object)videoCaps);
                if (this.mediaFormat.containsKey("max-width") && this.mediaFormat.containsKey("width")) {
                    videoCapsReflector.setWidthRange((Range<Integer>)new Range((Comparable)Integer.valueOf(this.mediaFormat.getInteger("width")), (Comparable)Integer.valueOf(this.mediaFormat.getInteger("max-width"))));
                } else if (this.mediaFormat.containsKey("width")) {
                    videoCapsReflector.setWidthRange((Range<Integer>)new Range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(this.mediaFormat.getInteger("width"))));
                }
                if (this.mediaFormat.containsKey("max-height") && this.mediaFormat.containsKey("height")) {
                    videoCapsReflector.setHeightRange((Range<Integer>)new Range((Comparable)Integer.valueOf(this.mediaFormat.getInteger("height")), (Comparable)Integer.valueOf(this.mediaFormat.getInteger("max-height"))));
                } else if (this.mediaFormat.containsKey("height")) {
                    videoCapsReflector.setHeightRange((Range<Integer>)new Range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(this.mediaFormat.getInteger("height"))));
                }
                capsReflector.setVideoCaps(videoCaps);
            } else {
                MediaCodecInfo.AudioCapabilities audioCaps = CodecCapabilitiesBuilder.createDefaultAudioCapabilities(caps, this.mediaFormat);
                capsReflector.setAudioCaps(audioCaps);
            }
            if (this.isEncoder) {
                MediaCodecInfo.EncoderCapabilities encoderCaps = CodecCapabilitiesBuilder.createDefaultEncoderCapabilities(caps, this.mediaFormat);
                capsReflector.setEncoderCaps(encoderCaps);
            }
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                int flagsSupported = CodecCapabilitiesBuilder.getSupportedFeatures(caps, this.mediaFormat);
                capsReflector.setFlagsSupported(flagsSupported);
                int flagsRequired = CodecCapabilitiesBuilder.getRequiredFeatures(caps, this.requiredFeatures);
                capsReflector.setFlagsRequired(flagsRequired);
            }
            return caps;
        }

        private static MediaCodecInfo.AudioCapabilities createDefaultAudioCapabilities(MediaCodecInfo.CodecCapabilities parent, MediaFormat mediaFormat) {
            return (MediaCodecInfo.AudioCapabilities)ReflectionHelpers.callStaticMethod(MediaCodecInfo.AudioCapabilities.class, (String)"create", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(MediaFormat.class, (Object)mediaFormat), ReflectionHelpers.ClassParameter.from(MediaCodecInfo.CodecCapabilities.class, (Object)parent)});
        }

        private static MediaCodecInfo.VideoCapabilities createDefaultVideoCapabilities(MediaCodecInfo.CodecCapabilities parent, MediaFormat mediaFormat) {
            return (MediaCodecInfo.VideoCapabilities)ReflectionHelpers.callStaticMethod(MediaCodecInfo.VideoCapabilities.class, (String)"create", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(MediaFormat.class, (Object)mediaFormat), ReflectionHelpers.ClassParameter.from(MediaCodecInfo.CodecCapabilities.class, (Object)parent)});
        }

        private static MediaCodecInfo.EncoderCapabilities createDefaultEncoderCapabilities(MediaCodecInfo.CodecCapabilities parent, MediaFormat mediaFormat) {
            return (MediaCodecInfo.EncoderCapabilities)ReflectionHelpers.callStaticMethod(MediaCodecInfo.EncoderCapabilities.class, (String)"create", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(MediaFormat.class, (Object)mediaFormat), ReflectionHelpers.ClassParameter.from(MediaCodecInfo.CodecCapabilities.class, (Object)parent)});
        }

        private static int getSupportedFeatures(MediaCodecInfo.CodecCapabilities parent, MediaFormat mediaFormat) {
            Object[] validFeatures;
            int flagsSupported = 0;
            for (Object validFeature : validFeatures = (Object[])ReflectionHelpers.callInstanceMethod((Object)parent, (String)"getValidFeatures", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])) {
                String featureName = (String)ReflectionHelpers.getField((Object)validFeature, (String)"mName");
                int featureValue = (Integer)ReflectionHelpers.getField((Object)validFeature, (String)"mValue");
                if (!mediaFormat.containsFeature(featureName) || !mediaFormat.getFeatureEnabled(featureName)) continue;
                flagsSupported |= featureValue;
            }
            return flagsSupported;
        }

        private static int getRequiredFeatures(MediaCodecInfo.CodecCapabilities parent, String[] requiredFeatures) {
            int flagsRequired = 0;
            Object[] validFeatures = (Object[])ReflectionHelpers.callInstanceMethod((Object)parent, (String)"getValidFeatures", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            HashSet<String> requiredFeaturesSet = new HashSet<String>(Arrays.asList(requiredFeatures));
            for (Object validFeature : validFeatures) {
                String featureName = (String)ReflectionHelpers.getField((Object)validFeature, (String)"mName");
                int featureValue = (Integer)ReflectionHelpers.getField((Object)validFeature, (String)"mValue");
                if (!requiredFeaturesSet.contains(featureName)) continue;
                flagsRequired |= featureValue;
            }
            return flagsRequired;
        }

        @ForType(value=MediaCodecInfo.CodecCapabilities.class)
        static interface CodecCapabilitiesReflector {
            @Accessor(value="mMime")
            public void setMime(String var1);

            @Accessor(value="mMaxSupportedInstances")
            public void setMaxSupportedInstances(int var1);

            @Accessor(value="mDefaultFormat")
            public void setDefaultFormat(MediaFormat var1);

            @Accessor(value="mCapabilitiesInfo")
            public void setCapabilitiesInfo(MediaFormat var1);

            @Accessor(value="mVideoCaps")
            public void setVideoCaps(MediaCodecInfo.VideoCapabilities var1);

            @Accessor(value="mAudioCaps")
            public void setAudioCaps(MediaCodecInfo.AudioCapabilities var1);

            @Accessor(value="mEncoderCaps")
            public void setEncoderCaps(MediaCodecInfo.EncoderCapabilities var1);

            @Accessor(value="mFlagsSupported")
            public void setFlagsSupported(int var1);

            @Accessor(value="mFlagsRequired")
            public void setFlagsRequired(int var1);
        }

        @ForType(value=MediaCodecInfo.VideoCapabilities.class)
        static interface VideoCapabilitiesReflector {
            @Accessor(value="mWidthRange")
            public void setWidthRange(Range<Integer> var1);

            @Accessor(value="mHeightRange")
            public void setHeightRange(Range<Integer> var1);
        }
    }
}

