/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.os.ParcelFileDescriptor;
import android.util.SparseArray;
import android.util.TypedValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.Fs;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.AssetDir;
import org.robolectric.res.android.AssetPath;
import org.robolectric.res.android.AttributeResolution;
import org.robolectric.res.android.CppAssetManager;
import org.robolectric.res.android.DataType;
import org.robolectric.res.android.DynamicRefTable;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.Registries;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResTable;
import org.robolectric.res.android.ResTableTheme;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResXMLParser;
import org.robolectric.res.android.ResXMLTree;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.String8;
import org.robolectric.res.android.Util;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowVMRuntime;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AssetManager.class, maxSdk=27, shadowPicker=ShadowAssetManager.Picker.class)
public class ShadowArscAssetManager
extends ShadowAssetManager.ArscBase {
    private static final int STYLE_NUM_ENTRIES = 6;
    private static final int STYLE_TYPE = 0;
    private static final int STYLE_DATA = 1;
    private static final int STYLE_ASSET_COOKIE = 2;
    private static final int STYLE_RESOURCE_ID = 3;
    private static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    private static final int STYLE_DENSITY = 5;
    @RealObject
    protected AssetManager realObject;
    private CppAssetManager cppAssetManager;
    private static CppAssetManager systemCppAssetManager;

    @Resetter
    public static void reset() {
        if (!ShadowArscAssetManager.useLegacy() && RuntimeEnvironment.getApiLevel() < 28) {
            ((ShadowAssetManager._AssetManager_)Reflector.reflector(ShadowAssetManager._AssetManager_.class)).setSystem(null);
        }
    }

    @Implementation
    protected String[] list(String path) throws IOException {
        CppAssetManager am = this.assetManagerForJavaObject();
        String fileName8 = path;
        if (fileName8 == null) {
            return null;
        }
        AssetDir dir = am.openDir(fileName8);
        if (dir == null) {
            throw new FileNotFoundException(fileName8);
        }
        int N = dir.getFileCount();
        String[] array = new String[dir.getFileCount()];
        for (int i = 0; i < N; ++i) {
            String8 name = dir.getFileName(i);
            array[i] = name.string();
        }
        return array;
    }

    @HiddenApi
    @Implementation(maxSdk=25)
    public final void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int sdkVersion) {
        this.setConfiguration(mcc, mnc, locale, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, 0, sdkVersion);
    }

    @HiddenApi
    @Implementation(minSdk=26)
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int sdkVersion) {
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return;
        }
        ResTable_config config = new ResTable_config();
        int kScreenLayoutRoundMask = 768;
        int kScreenLayoutRoundShift = 8;
        config.mcc = mcc;
        config.mnc = mnc;
        config.orientation = orientation;
        config.touchscreen = touchscreen;
        config.density = density;
        config.keyboard = keyboard;
        config.inputFlags = keyboardHidden;
        config.navigation = navigation;
        config.screenWidth = screenWidth;
        config.screenHeight = screenHeight;
        config.smallestScreenWidthDp = smallestScreenWidthDp;
        config.screenWidthDp = screenWidthDp;
        config.screenHeightDp = screenHeightDp;
        config.screenLayout = screenLayout;
        config.uiMode = uiMode;
        config.colorMode = (byte)colorMode;
        config.sdkVersion = sdkVersion;
        config.minorVersion = 0;
        config.screenLayout2 = (byte)((screenLayout & kScreenLayoutRoundMask) >> kScreenLayoutRoundShift);
        am.setConfiguration(config, locale);
    }

    @HiddenApi
    @Implementation
    protected static void dumpTheme(long theme, int priority, String tag, String prefix) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Implementation
    protected String getResourceName(int resid) {
        char div;
        CppAssetManager am = this.assetManagerForJavaObject();
        ResTable.ResourceName name = new ResTable.ResourceName();
        if (!am.getResources().getResourceName(resid, true, name)) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        if (name.packageName != null) {
            str.append(name.packageName.trim());
        }
        if (name.type != null) {
            if (str.length() > 0) {
                div = ':';
                str.append(div);
            }
            str.append(name.type);
        }
        if (name.name != null) {
            if (str.length() > 0) {
                div = '/';
                str.append(div);
            }
            str.append(name.name);
        }
        return str.toString();
    }

    @Implementation
    protected String getResourcePackageName(int resid) {
        CppAssetManager cppAssetManager = this.assetManagerForJavaObject();
        ResTable.ResourceName name = new ResTable.ResourceName();
        if (!cppAssetManager.getResources().getResourceName(resid, true, name)) {
            return null;
        }
        return name.packageName.trim();
    }

    @Implementation
    protected String getResourceTypeName(int resid) {
        CppAssetManager cppAssetManager = this.assetManagerForJavaObject();
        ResTable.ResourceName name = new ResTable.ResourceName();
        if (!cppAssetManager.getResources().getResourceName(resid, true, name)) {
            return null;
        }
        return name.type;
    }

    @Implementation
    protected String getResourceEntryName(int resid) {
        CppAssetManager cppAssetManager = this.assetManagerForJavaObject();
        ResTable.ResourceName name = new ResTable.ResourceName();
        if (!cppAssetManager.getResources().getResourceName(resid, true, name)) {
            return null;
        }
        return name.name;
    }

    @HiddenApi
    @Implementation(maxSdk=17)
    public int addAssetPath(String path) {
        return this.addAssetPathNative(path);
    }

    @HiddenApi
    @Implementation(maxSdk=23)
    protected final int addAssetPathNative(String path) {
        return this.addAssetPathNative(path, false);
    }

    @HiddenApi
    @Implementation(minSdk=24)
    protected int addAssetPathNative(String path, boolean appAsLib) {
        if (Strings.isNullOrEmpty((String)path)) {
            return 0;
        }
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return 0;
        }
        Ref cookie = new Ref(null);
        boolean res = am.addAssetPath(new String8(path), cookie, appAsLib);
        return res ? (Integer)cookie.get() : 0;
    }

    @HiddenApi
    @Implementation
    public int getResourceIdentifier(String name, String defType, String defPackage) {
        if (Strings.isNullOrEmpty((String)name)) {
            return 0;
        }
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return 0;
        }
        int ident = am.getResources().identifierForName(name, defType, defPackage);
        return ident;
    }

    @HiddenApi
    @Implementation
    protected Number openAsset(String fileName, int mode) throws FileNotFoundException {
        CppAssetManager am = this.assetManagerForJavaObject();
        Util.ALOGV((String)"openAsset in %s", (Object[])new Object[]{am});
        String fileName8 = fileName;
        if (fileName8 == null) {
            throw new IllegalArgumentException("Empty file name");
        }
        if (mode != Asset.AccessMode.ACCESS_UNKNOWN.mode() && mode != Asset.AccessMode.ACCESS_RANDOM.mode() && mode != Asset.AccessMode.ACCESS_STREAMING.mode() && mode != Asset.AccessMode.ACCESS_BUFFER.mode()) {
            throw new IllegalArgumentException("Bad access mode");
        }
        Asset a = am.open(fileName8, Asset.AccessMode.fromInt((int)mode));
        if (a == null) {
            throw new FileNotFoundException(fileName8);
        }
        return RuntimeEnvironment.castNativePtr(Registries.NATIVE_ASSET_REGISTRY.register((Object)a));
    }

    @HiddenApi
    @Implementation
    protected ParcelFileDescriptor openAssetFd(String fileName, long[] outOffsets) throws IOException {
        CppAssetManager am = this.assetManagerForJavaObject();
        Util.ALOGV((String)"openAssetFd in %s", (Object[])new Object[]{am});
        String fileName8 = fileName;
        if (fileName8 == null) {
            return null;
        }
        Asset a = am.open(fileName8, Asset.AccessMode.ACCESS_RANDOM);
        if (a == null) {
            throw new FileNotFoundException(fileName8);
        }
        return ShadowArscAssetManager.returnParcelFileDescriptor(a, outOffsets);
    }

    @HiddenApi
    @Implementation
    protected Number openNonAssetNative(int cookie, String fileName, int accessMode) throws FileNotFoundException {
        Asset a;
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return RuntimeEnvironment.castNativePtr(0L);
        }
        Util.ALOGV((String)"openNonAssetNative in %s (Java object %s)\n", (Object[])new Object[]{am, AssetManager.class});
        String fileName8 = fileName;
        if (fileName8 == null) {
            return RuntimeEnvironment.castNativePtr(-1L);
        }
        Asset.AccessMode mode = Asset.AccessMode.fromInt((int)accessMode);
        if (mode != Asset.AccessMode.ACCESS_UNKNOWN && mode != Asset.AccessMode.ACCESS_RANDOM && mode != Asset.AccessMode.ACCESS_STREAMING && mode != Asset.AccessMode.ACCESS_BUFFER) {
            throw new IllegalArgumentException("Bad access mode");
        }
        Asset asset = a = Util.isTruthy((int)cookie) ? am.openNonAsset(cookie, fileName8, mode) : am.openNonAsset(fileName8, mode, null);
        if (a == null) {
            throw new FileNotFoundException(fileName8);
        }
        long assetId = Registries.NATIVE_ASSET_REGISTRY.register((Object)a);
        a.onClose = () -> this.destroyAsset(assetId);
        return RuntimeEnvironment.castNativePtr(assetId);
    }

    @HiddenApi
    @Implementation
    protected ParcelFileDescriptor openNonAssetFdNative(int cookie, String fileName, long[] outOffsets) throws IOException {
        Asset a;
        CppAssetManager am = this.assetManagerForJavaObject();
        Util.ALOGV((String)"openNonAssetFd in %s (Java object %s)", (Object[])new Object[]{am, this});
        if (fileName == null) {
            return null;
        }
        Asset asset = a = Util.isTruthy((int)cookie) ? am.openNonAsset(cookie, fileName, Asset.AccessMode.ACCESS_RANDOM) : am.openNonAsset(fileName, Asset.AccessMode.ACCESS_RANDOM, null);
        if (a == null) {
            throw new FileNotFoundException(fileName);
        }
        return ShadowArscAssetManager.returnParcelFileDescriptor(a, outOffsets);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected void destroyAsset(int asset) {
        this.destroyAsset((long)asset);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected void destroyAsset(long asset) {
        Registries.NATIVE_ASSET_REGISTRY.unregister(asset);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected int readAssetChar(int asset) {
        return this.readAssetChar((long)asset);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected int readAssetChar(long asset) {
        byte[] b;
        Asset a = this.getAsset(asset);
        int res = a.read(b = new byte[1], 1);
        return res == 1 ? b[0] & 0xFF : -1;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected int readAsset(int asset, byte[] b, int off, int len) throws IOException {
        return this.readAsset((long)asset, b, off, len);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected int readAsset(long asset, byte[] bArray, int off, int len) throws IOException {
        Asset a = this.getAsset(asset);
        if (a == null || bArray == null) {
            throw new NullPointerException("asset");
        }
        if (len == 0) {
            return 0;
        }
        int bLen = bArray.length;
        if (off < 0 || off >= bLen || len < 0 || len > bLen || off + len > bLen) {
            throw new IndexOutOfBoundsException();
        }
        byte[] b = bArray;
        int res = a.read(b, off, len);
        if (res > 0) {
            return res;
        }
        if (res < 0) {
            throw new IOException();
        }
        return -1;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected long seekAsset(int asset, long offset, int whence) {
        return this.seekAsset((long)asset, offset, whence);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected long seekAsset(long asset, long offset, int whence) {
        Asset a = this.getAsset(asset);
        return a.seek(offset, whence < 0 ? 0 : 1);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected long getAssetLength(int asset) {
        return this.getAssetLength((long)asset);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected long getAssetLength(long asset) {
        Asset a = this.getAsset(asset);
        return a.getLength();
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected long getAssetRemainingLength(int asset) {
        return this.getAssetRemainingLength((long)asset);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected long getAssetRemainingLength(long assetHandle) {
        Asset a = this.getAsset(assetHandle);
        if (a == null) {
            throw new NullPointerException("asset");
        }
        return a.getRemainingLength();
    }

    private Asset getAsset(long asset) {
        return (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(asset);
    }

    @HiddenApi
    @Implementation
    protected int loadResourceValue(int ident, short density, TypedValue outValue, boolean resolve) {
        if (outValue == null) {
            throw new NullPointerException("outValue");
        }
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return 0;
        }
        ResTable res = am.getResources();
        Ref value = new Ref(null);
        Ref config = new Ref(null);
        Ref typeSpecFlags = new Ref(null);
        int block = res.getResource(ident, value, false, (int)density, typeSpecFlags, config);
        Ref ref = new Ref((Object)ident);
        if (resolve) {
            block = res.resolveReference(value, block, ref, typeSpecFlags, config);
        }
        if (block >= 0) {
            return ShadowArscAssetManager.copyValue(outValue, res, (ResourceTypes.Res_value)value.get(), (Integer)ref.get(), block, (Integer)typeSpecFlags.get(), (ResTable_config)config.get());
        }
        return block;
    }

    private static int copyValue(TypedValue outValue, ResTable table, ResourceTypes.Res_value value, int ref, int block, int typeSpecFlags) {
        return ShadowArscAssetManager.copyValue(outValue, table, value, ref, block, typeSpecFlags, null);
    }

    private static int copyValue(TypedValue outValue, ResTable table, ResourceTypes.Res_value value, int ref, int block, int typeSpecFlags, ResTable_config config) {
        outValue.type = value.dataType;
        outValue.assetCookie = table.getTableCookie(block);
        outValue.data = value.data;
        outValue.string = null;
        outValue.resourceId = ref;
        outValue.changingConfigurations = typeSpecFlags;
        if (config != null) {
            outValue.density = config.density;
        }
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> getResourceBagValues(int ident, ResTable res) {
        HashMap<String, Integer> map;
        res.lock();
        try {
            Ref entryRef = new Ref(null);
            Ref typeSpecFlags = new Ref((Object)0);
            int entryCount = res.getBagLocked(ident, entryRef, typeSpecFlags);
            map = new HashMap<String, Integer>();
            ResTable.bag_entry[] bag_entries = (ResTable.bag_entry[])entryRef.get();
            for (int i = 0; i < entryCount; ++i) {
                ResTable.bag_entry entry = bag_entries[i];
                ResTable.ResourceName resourceName = new ResTable.ResourceName();
                if (!res.getResourceName(entry.map.name.ident, true, resourceName)) continue;
                map.put(resourceName.name, entry.map.value.data);
            }
        }
        finally {
            res.unlock();
        }
        return map;
    }

    @Implementation
    @HiddenApi
    protected int loadResourceBagValue(int ident, int bagEntryId, TypedValue outValue, boolean resolve) {
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return 0;
        }
        ResTable res = am.getResources();
        return ShadowArscAssetManager.loadResourceBagValueInternal(ident, bagEntryId, outValue, resolve, res);
    }

    public static String getResourceBagValue(int ident, int bagEntryId, ResTable resTable) {
        TypedValue outValue = new TypedValue();
        int blockId = ShadowArscAssetManager.loadResourceBagValueInternal(ident, bagEntryId, outValue, true, resTable);
        if (outValue.type == 3) {
            return resTable.getTableStringBlock(blockId).stringAt(outValue.data);
        }
        return outValue.coerceToString().toString();
    }

    private static int loadResourceBagValueInternal(int ident, int bagEntryId, TypedValue outValue, boolean resolve, ResTable res) {
        res.lock();
        int block = -1;
        Ref valueRef = new Ref(null);
        Ref entryRef = new Ref(null);
        Ref typeSpecFlags = new Ref((Object)0);
        int entryCount = res.getBagLocked(ident, entryRef, typeSpecFlags);
        ResTable.bag_entry[] bag_entries = (ResTable.bag_entry[])entryRef.get();
        for (int i = 0; i < entryCount; ++i) {
            ResTable.bag_entry entry = bag_entries[i];
            if (bagEntryId != entry.map.name.ident) continue;
            block = entry.stringBlock;
            valueRef.set((Object)entry.map.value);
        }
        res.unlock();
        if (block < 0) {
            return block;
        }
        Ref ref = new Ref((Object)ident);
        if (resolve) {
            block = res.resolveReference(valueRef, block, ref, typeSpecFlags);
        }
        if (block >= 0) {
            return ShadowArscAssetManager.copyValue(outValue, res, (ResourceTypes.Res_value)valueRef.get(), (Integer)ref.get(), block, (Integer)typeSpecFlags.get());
        }
        return block;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected static void applyStyle(int themeToken, int defStyleAttr, int defStyleRes, int xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        ShadowArscAssetManager.applyStyle((long)themeToken, defStyleAttr, defStyleRes, (long)xmlParserToken, attrs, outValues, outIndices);
    }

    @HiddenApi
    @Implementation(minSdk=26, maxSdk=27)
    protected static void applyStyle(long themeToken, int defStyleAttr, int defStyleRes, long xmlParserToken, int[] inAttrs, int length, long outValuesAddress, long outIndicesAddress) {
        ShadowVMRuntime shadowVMRuntime = (ShadowVMRuntime)Shadow.extract((Object)VMRuntime.getRuntime());
        int[] outValues = (int[])shadowVMRuntime.getObjectForAddress(outValuesAddress);
        int[] outIndices = (int[])shadowVMRuntime.getObjectForAddress(outIndicesAddress);
        ShadowArscAssetManager.applyStyle(themeToken, defStyleAttr, defStyleRes, xmlParserToken, inAttrs, outValues, outIndices);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=25)
    protected static void applyStyle(long themeToken, int defStyleAttr, int defStyleRes, long xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        ResTableTheme theme = (ResTableTheme)Registries.NATIVE_THEME_REGISTRY.getNativeObject(themeToken);
        ResXMLParser xmlParser = xmlParserToken == 0L ? null : (ResXMLParser)Registries.NATIVE_RES_XML_PARSERS.getNativeObject(xmlParserToken);
        AttributeResolution.ApplyStyle((ResTableTheme)theme, (ResXMLParser)xmlParser, (int)defStyleAttr, (int)defStyleRes, (int[])attrs, (int)attrs.length, (int[])outValues, (int[])outIndices);
    }

    @Implementation
    @HiddenApi
    protected static boolean resolveAttrs(long themeToken, int defStyleAttr, int defStyleRes, int[] inValues, int[] attrs, int[] outValues, int[] outIndices) {
        if (themeToken == 0L) {
            throw new NullPointerException("theme token");
        }
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        if (outValues == null) {
            throw new NullPointerException("out values");
        }
        int NV = outValues.length;
        int NI = attrs.length;
        if (NV < NI * 6) {
            throw new IndexOutOfBoundsException("out values too small");
        }
        int[] src = attrs;
        int[] srcValues = inValues;
        int NSV = srcValues == null ? 0 : inValues.length;
        int[] baseDest = outValues;
        boolean destOffset = false;
        if (baseDest == null) {
            return false;
        }
        int[] indices = null;
        if (outIndices != null && outIndices.length > NI) {
            indices = outIndices;
        }
        ResTableTheme theme = (ResTableTheme)Registries.NATIVE_THEME_REGISTRY.getNativeObject(themeToken);
        boolean result = AttributeResolution.ResolveAttrs((ResTableTheme)theme, (int)defStyleAttr, (int)defStyleRes, (int[])srcValues, (int)NSV, (int[])src, (int)NI, (int[])baseDest, (int[])indices);
        if (indices != null) {
            // empty if block
        }
        return result;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected boolean retrieveAttributes(int xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        return this.retrieveAttributes((long)xmlParserToken, attrs, outValues, outIndices);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected boolean retrieveAttributes(long xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        if (xmlParserToken == 0L) {
            throw new NullPointerException("xmlParserToken");
        }
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        if (outValues == null) {
            throw new NullPointerException("out values");
        }
        CppAssetManager am = this.assetManagerForJavaObject();
        ResTable res = am.getResources();
        ResXMLParser xmlParser = (ResXMLParser)Registries.NATIVE_RES_XML_PARSERS.getNativeObject(xmlParserToken);
        int NV = outValues.length;
        int NI = attrs.length;
        if (NV < NI * 6) {
            throw new IndexOutOfBoundsException("out values too small");
        }
        int[] src = attrs;
        int[] baseDest = outValues;
        if (baseDest == null) {
            return false;
        }
        int[] indices = null;
        if (outIndices != null && outIndices.length > NI) {
            indices = outIndices;
        }
        boolean result = AttributeResolution.RetrieveAttributes((ResTable)res, (ResXMLParser)xmlParser, (int[])src, (int)NI, (int[])baseDest, (int[])indices);
        if (indices != null) {
            // empty if block
        }
        return result;
    }

    @HiddenApi
    @Implementation
    protected int getArraySize(int id2) {
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return 0;
        }
        ResTable res = am.getResources();
        res.lock();
        Ref defStyleEnt = new Ref(null);
        int bagOff = res.getBagLocked(id2, defStyleEnt, null);
        res.unlock();
        return bagOff;
    }

    @Implementation
    @HiddenApi
    protected int retrieveArray(int id2, int[] outValues) {
        int[] baseDest;
        if (outValues == null) {
            throw new NullPointerException("out values");
        }
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return 0;
        }
        ResTable res = am.getResources();
        Ref config = new Ref((Object)new ResTable_config());
        int NV = outValues.length;
        int[] dest = baseDest = outValues;
        res.lock();
        Ref arrayEnt = new Ref(null);
        Ref arrayTypeSetFlags = new Ref((Object)0);
        int bagOff = res.getBagLocked(id2, arrayEnt, arrayTypeSetFlags);
        Ref typeSetFlags = new Ref((Object)0);
        for (int destOffset = 0; destOffset < NV && destOffset < bagOff * 6; destOffset += 6) {
            ResTable.bag_entry curArrayEnt = ((ResTable.bag_entry[])arrayEnt.get())[destOffset / 6];
            int block = curArrayEnt.stringBlock;
            typeSetFlags.set((Object)((Integer)arrayTypeSetFlags.get()));
            ((ResTable_config)config.get()).density = 0;
            ResourceTypes.Res_value value = curArrayEnt.map.value;
            Ref resid = new Ref((Object)0);
            if (value.dataType != DataType.NULL.code()) {
                Ref resValueRef = new Ref((Object)value);
                int newBlock = res.resolveReference(resValueRef, block, resid, typeSetFlags, config);
                value = (ResourceTypes.Res_value)resValueRef.get();
                if (newBlock >= 0) {
                    block = newBlock;
                }
            }
            if (value.dataType == DataType.REFERENCE.code() && value.data == 0) {
                value = ResourceTypes.Res_value.NULL_VALUE;
            }
            dest[destOffset + 0] = value.dataType;
            dest[destOffset + 1] = value.data;
            dest[destOffset + 2] = res.getTableCookie(block);
            dest[destOffset + 3] = (Integer)resid.get();
            dest[destOffset + 4] = (Integer)typeSetFlags.get();
            dest[destOffset + 5] = ((ResTable_config)config.get()).density;
        }
        res.unlock();
        return destOffset /= 6;
    }

    @HiddenApi
    @Implementation
    protected Number getNativeStringBlock(int block) {
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return RuntimeEnvironment.castNativePtr(0L);
        }
        return RuntimeEnvironment.castNativePtr(am.getResources().getTableStringBlock(block).getNativePtr());
    }

    @Implementation
    protected SparseArray<String> getAssignedPackageIdentifiers() {
        CppAssetManager am = this.assetManagerForJavaObject();
        ResTable res = am.getResources();
        SparseArray sparseArray = new SparseArray();
        int N = res.getBasePackageCount();
        for (int i = 0; i < N; ++i) {
            String name = res.getBasePackageName(i);
            sparseArray.put(res.getBasePackageId(i), (Object)name);
        }
        return sparseArray;
    }

    @HiddenApi
    @Implementation
    protected Number newTheme() {
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return RuntimeEnvironment.castNativePtr(0L);
        }
        ResTableTheme theme = new ResTableTheme(am.getResources());
        return RuntimeEnvironment.castNativePtr(Registries.NATIVE_THEME_REGISTRY.register((Object)theme));
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected void deleteTheme(int theme) {
        this.deleteTheme((long)theme);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected void deleteTheme(long theme) {
        Registries.NATIVE_THEME_REGISTRY.unregister(theme);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void applyThemeStyle(int themePtr, int styleRes, boolean force) {
        ShadowArscAssetManager.applyThemeStyle((long)themePtr, styleRes, force);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    public static void applyThemeStyle(long themePtr, int styleRes, boolean force) {
        ((ResTableTheme)Registries.NATIVE_THEME_REGISTRY.getNativeObject(themePtr)).applyStyle(styleRes, force);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void copyTheme(int destPtr, int sourcePtr) {
        ShadowArscAssetManager.copyTheme((long)destPtr, (long)sourcePtr);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    public static void copyTheme(long destPtr, long sourcePtr) {
        ResTableTheme dest = (ResTableTheme)Registries.NATIVE_THEME_REGISTRY.getNativeObject(destPtr);
        ResTableTheme src = (ResTableTheme)Registries.NATIVE_THEME_REGISTRY.getNativeObject(sourcePtr);
        dest.setTo(src);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected static int loadThemeAttributeValue(int themeHandle, int ident, TypedValue outValue, boolean resolve) {
        return ShadowArscAssetManager.loadThemeAttributeValue((long)themeHandle, ident, outValue, resolve);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected static int loadThemeAttributeValue(long themeHandle, int ident, TypedValue outValue, boolean resolve) {
        ResTableTheme theme = (ResTableTheme)Preconditions.checkNotNull((Object)((ResTableTheme)Registries.NATIVE_THEME_REGISTRY.getNativeObject(themeHandle)));
        ResTable res = theme.getResTable();
        Ref value = new Ref(null);
        Ref typeSpecFlags = new Ref((Object)0);
        int block = theme.GetAttribute(ident, value, typeSpecFlags);
        Ref ref = new Ref((Object)0);
        if (resolve) {
            block = res.resolveReference(value, block, ref, typeSpecFlags);
        }
        return block >= 0 ? ShadowArscAssetManager.copyValue(outValue, res, (ResourceTypes.Res_value)value.get(), (Integer)ref.get(), block, (Integer)typeSpecFlags.get(), null) : block;
    }

    @HiddenApi
    @Implementation
    protected Number openXmlAssetNative(int cookie, String fileName) throws FileNotFoundException {
        Asset a;
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return RuntimeEnvironment.castNativePtr(0L);
        }
        Util.ALOGV((String)"openXmlAsset in %s (Java object %s)\n", (Object[])new Object[]{am, ShadowArscAssetManager.class});
        String fileName8 = fileName;
        if (fileName8 == null) {
            return RuntimeEnvironment.castNativePtr(0L);
        }
        int assetCookie = cookie;
        if (Util.isTruthy((int)assetCookie)) {
            a = am.openNonAsset(assetCookie, fileName8, Asset.AccessMode.ACCESS_BUFFER);
        } else {
            Ref assetCookieRef = new Ref((Object)assetCookie);
            a = am.openNonAsset(fileName8, Asset.AccessMode.ACCESS_BUFFER, assetCookieRef);
            assetCookie = (Integer)assetCookieRef.get();
        }
        if (a == null) {
            throw new FileNotFoundException(fileName8);
        }
        DynamicRefTable dynamicRefTable = am.getResources().getDynamicRefTableForCookie(assetCookie);
        ResXMLTree block = new ResXMLTree(dynamicRefTable);
        int err = block.setTo(a.getBuffer(true), (int)a.getLength(), true);
        a.close();
        if (err != 0) {
            throw new FileNotFoundException("Corrupt XML binary file");
        }
        return RuntimeEnvironment.castNativePtr(Registries.NATIVE_RES_XML_TREES.register((Object)block));
    }

    @HiddenApi
    @Implementation
    protected String[] getArrayStringResource(int arrayResId) {
        Ref startOfBag;
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return null;
        }
        ResTable res = am.getResources();
        int N = res.lockBag(arrayResId, startOfBag = new Ref(null));
        if (N < 0) {
            return null;
        }
        String[] array = new String[N];
        Ref valueRef = new Ref(null);
        ResTable.bag_entry[] bag = (ResTable.bag_entry[])startOfBag.get();
        boolean strLen = false;
        for (int i = 0; i < N; ++i) {
            valueRef.set((Object)bag[i].map.value);
            String str = null;
            int block = res.resolveReference(valueRef, bag[i].stringBlock, null);
            if (((ResourceTypes.Res_value)valueRef.get()).dataType != DataType.STRING.code()) continue;
            ResStringPool pool = res.getTableStringBlock(block);
            str = pool.stringAt(((ResourceTypes.Res_value)valueRef.get()).data);
            if (str == null) {
                res.unlockBag(startOfBag);
                return null;
            }
            array[i] = str;
        }
        res.unlockBag(startOfBag);
        return array;
    }

    @HiddenApi
    @Implementation
    protected int[] getArrayStringInfo(int arrayResId) {
        Ref startOfBag;
        CppAssetManager am = this.assetManagerForJavaObject();
        ResTable res = am.getResources();
        int N = res.lockBag(arrayResId, startOfBag = new Ref(null));
        if (N < 0) {
            return null;
        }
        int[] array = new int[N * 2];
        Ref value = new Ref(null);
        ResTable.bag_entry[] bag = (ResTable.bag_entry[])startOfBag.get();
        int j = 0;
        for (int i = 0; i < N; ++i) {
            int stringIndex = -1;
            int stringBlock = 0;
            value.set((Object)bag[i].map.value);
            stringBlock = res.resolveReference(value, bag[i].stringBlock, null);
            if (((ResourceTypes.Res_value)value.get()).dataType == DataType.STRING.code()) {
                stringIndex = ((ResourceTypes.Res_value)value.get()).data;
            }
            array[j] = stringBlock;
            array[j + 1] = stringIndex;
            j += 2;
        }
        res.unlockBag(startOfBag);
        return array;
    }

    @HiddenApi
    @Implementation
    public int[] getArrayIntResource(int arrayResId) {
        Ref startOfBag;
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return null;
        }
        ResTable res = am.getResources();
        int N = res.lockBag(arrayResId, startOfBag = new Ref(null));
        if (N < 0) {
            return null;
        }
        int[] array = new int[N];
        if (array == null) {
            res.unlockBag(startOfBag);
            return null;
        }
        Ref valueRef = new Ref(null);
        ResTable.bag_entry[] bag = (ResTable.bag_entry[])startOfBag.get();
        for (int i = 0; i < N; ++i) {
            int intVal;
            valueRef.set((Object)bag[i].map.value);
            int block = res.resolveReference(valueRef, bag[i].stringBlock, null, null, null);
            ResourceTypes.Res_value value = (ResourceTypes.Res_value)valueRef.get();
            if (value.dataType < DataType.TYPE_FIRST_INT || value.dataType > DataType.TYPE_LAST_INT) continue;
            array[i] = intVal = value.data;
        }
        res.unlockBag(startOfBag);
        return array;
    }

    @HiddenApi
    @Implementation(maxSdk=19)
    protected void init() {
        this.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation(minSdk=20)
    protected void init(boolean isSystem) {
        Path androidFrameworkJarPath = RuntimeEnvironment.getAndroidFrameworkJarPath();
        Preconditions.checkNotNull((Object)androidFrameworkJarPath);
        if (isSystem) {
            Class<ShadowArscAssetManager> clazz = ShadowArscAssetManager.class;
            synchronized (ShadowArscAssetManager.class) {
                if (systemCppAssetManager == null) {
                    systemCppAssetManager = new CppAssetManager();
                    systemCppAssetManager.addDefaultAssets(androidFrameworkJarPath);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.cppAssetManager = systemCppAssetManager;
            }
        } else {
            this.cppAssetManager = new CppAssetManager();
            this.cppAssetManager.addDefaultAssets(androidFrameworkJarPath);
        }
        {
            Util.ALOGV((String)"Created AssetManager %s for Java object %s\n", (Object[])new Object[]{this.cppAssetManager, ShadowArscAssetManager.class});
            return;
        }
    }

    @VisibleForTesting
    ResTable_config getConfiguration() {
        Ref config = new Ref((Object)new ResTable_config());
        this.assetManagerForJavaObject().getConfiguration(config);
        return (ResTable_config)config.get();
    }

    @HiddenApi
    @Implementation
    protected int getStringBlockCount() {
        CppAssetManager am = this.assetManagerForJavaObject();
        if (am == null) {
            return 0;
        }
        return am.getResources().getTableCount();
    }

    private synchronized CppAssetManager assetManagerForJavaObject() {
        if (this.cppAssetManager == null) {
            throw new NullPointerException();
        }
        return this.cppAssetManager;
    }

    static ParcelFileDescriptor returnParcelFileDescriptor(Asset a, long[] outOffsets) throws FileNotFoundException {
        Ref length;
        Ref startOffset = new Ref((Object)-1L);
        FileDescriptor fd = a.openFileDescriptor(startOffset, length = new Ref((Object)-1L));
        if (fd == null) {
            throw new FileNotFoundException("This file can not be opened as a file descriptor; it is probably compressed");
        }
        long[] offsets = outOffsets;
        if (offsets == null) {
            return null;
        }
        offsets[0] = (Long)startOffset.get();
        offsets[1] = (Long)length.get();
        return ParcelFileDescriptor.open((File)a.getFile(), (int)0x10000000);
    }

    @Override
    Collection<Path> getAllAssetDirs() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (AssetPath assetPath : this.cppAssetManager.getAssetPaths()) {
            if (Files.isRegularFile(assetPath.file, new LinkOption[0])) {
                paths.add(Fs.forJar((Path)assetPath.file).getPath("assets", new String[0]));
                continue;
            }
            paths.add(assetPath.file);
        }
        return paths;
    }

    @Override
    @VisibleForTesting
    long getNativePtr() {
        return ((ShadowAssetManager._AssetManager_)Reflector.reflector(ShadowAssetManager._AssetManager_.class, (Object)this.realObject)).getNativePtr();
    }

    @Override
    List<AssetPath> getAssetPaths() {
        return this.assetManagerForJavaObject().getAssetPaths();
    }
}

