/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.LongSparseArray;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.Bootstrap;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.robolectric.res.Plural;
import org.robolectric.res.PluralRules;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ResourceModeShadowPicker;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.shadows.ShadowLegacyAssetManager;
import org.robolectric.shadows.ShadowLegacyResourcesImpl;
import org.robolectric.shadows.ShadowXmlBlock;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Resources.class)
public class ShadowResources {
    private static Resources system = null;
    private static List<LongSparseArray<?>> resettableArrays;
    @RealObject
    Resources realResources;
    private final Set<OnConfigurationChangeListener> configurationChangeListeners = new HashSet<OnConfigurationChangeListener>();

    @Resetter
    public static void reset() {
        if (resettableArrays == null) {
            resettableArrays = ShadowResources.obtainResettableArrays();
        }
        for (LongSparseArray<?> sparseArray : resettableArrays) {
            sparseArray.clear();
        }
        system = null;
        ReflectionHelpers.setStaticField(Resources.class, (String)"mSystem", null);
    }

    @Implementation
    protected static Resources getSystem() {
        if (system == null) {
            AssetManager assetManager = AssetManager.getSystem();
            system = new Resources(assetManager, Bootstrap.getDisplayMetrics(), Bootstrap.getConfiguration());
        }
        return system;
    }

    @Implementation
    protected TypedArray obtainAttributes(AttributeSet set, int[] attrs) {
        if (this.isLegacyAssetManager()) {
            return ShadowAssetManager.legacyShadowOf(this.realResources.getAssets()).attrsToTypedArray(this.realResources, set, attrs, 0, 0L, 0);
        }
        return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).obtainAttributes(set, attrs);
    }

    @Implementation
    protected String getQuantityString(int id2, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        if (this.isLegacyAssetManager()) {
            String raw = this.getQuantityString(id2, quantity);
            return String.format(Locale.ENGLISH, raw, formatArgs);
        }
        return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).getQuantityString(id2, quantity, formatArgs);
    }

    @Implementation
    protected String getQuantityString(int resId, int quantity) throws Resources.NotFoundException {
        if (this.isLegacyAssetManager()) {
            ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResources.getAssets());
            TypedResource typedResource = shadowAssetManager.getResourceTable().getValue(resId, shadowAssetManager.config);
            if (typedResource != null && typedResource instanceof PluralRules) {
                PluralRules pluralRules = (PluralRules)typedResource;
                Plural plural = pluralRules.find(quantity);
                if (plural == null) {
                    return null;
                }
                TypedResource resolvedTypedResource = shadowAssetManager.resolve(new TypedResource((Object)plural.getString(), ResType.CHAR_SEQUENCE, pluralRules.getXmlContext()), shadowAssetManager.config, resId);
                return resolvedTypedResource == null ? null : resolvedTypedResource.asString();
            }
            return null;
        }
        return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).getQuantityString(resId, quantity);
    }

    @Implementation
    protected InputStream openRawResource(int id2) throws Resources.NotFoundException {
        if (this.isLegacyAssetManager()) {
            ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResources.getAssets());
            ResourceTable resourceTable = shadowAssetManager.getResourceTable();
            InputStream inputStream = resourceTable.getRawValue(id2, shadowAssetManager.config);
            if (inputStream == null) {
                throw this.newNotFoundException(id2);
            }
            return inputStream;
        }
        return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).openRawResource(id2);
    }

    @Implementation
    protected AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        if (this.isLegacyAssetManager()) {
            InputStream inputStream = this.openRawResource(id2);
            if (!(inputStream instanceof FileInputStream)) {
                return null;
            }
            FileInputStream fis = (FileInputStream)inputStream;
            try {
                return new AssetFileDescriptor(ParcelFileDescriptor.dup((FileDescriptor)fis.getFD()), 0L, fis.getChannel().size());
            }
            catch (IOException e) {
                throw this.newNotFoundException(id2);
            }
        }
        return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).openRawResourceFd(id2);
    }

    private Resources.NotFoundException newNotFoundException(int id2) {
        ResourceTable resourceTable = ShadowAssetManager.legacyShadowOf(this.realResources.getAssets()).getResourceTable();
        ResName resName = resourceTable.getResName(id2);
        if (resName == null) {
            return new Resources.NotFoundException("resource ID #0x" + Integer.toHexString(id2));
        }
        return new Resources.NotFoundException(resName.getFullyQualifiedName());
    }

    @Implementation
    protected TypedArray obtainTypedArray(int id2) throws Resources.NotFoundException {
        if (this.isLegacyAssetManager()) {
            ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResources.getAssets());
            TypedArray typedArray = shadowAssetManager.getTypedArrayResource(this.realResources, id2);
            if (typedArray != null) {
                return typedArray;
            }
            throw this.newNotFoundException(id2);
        }
        return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).obtainTypedArray(id2);
    }

    @HiddenApi
    @Implementation
    protected XmlResourceParser loadXmlResourceParser(int resId, String type) throws Resources.NotFoundException {
        if (this.isLegacyAssetManager()) {
            ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResources.getAssets());
            return ShadowResources.setSourceResourceId(shadowAssetManager.loadXmlResourceParser(resId, type), resId);
        }
        ResourcesReflector relectedResources = (ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources);
        return ShadowResources.setSourceResourceId(relectedResources.loadXmlResourceParser(resId, type), resId);
    }

    @HiddenApi
    @Implementation
    protected XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        if (this.isLegacyAssetManager()) {
            return this.loadXmlResourceParser(id2, type);
        }
        ResourcesReflector relectedResources = (ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources);
        return ShadowResources.setSourceResourceId(relectedResources.loadXmlResourceParser(file, id2, assetCookie, type), id2);
    }

    private static XmlResourceParser setSourceResourceId(XmlResourceParser parser, int resourceId) {
        Object shadow;
        Object object = shadow = parser instanceof ShadowedObject ? Shadow.extract((Object)parser) : null;
        if (shadow instanceof ShadowXmlBlock.ShadowParser) {
            ((ShadowXmlBlock.ShadowParser)shadow).setSourceResourceId(resourceId);
        }
        return parser;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected Drawable loadDrawable(TypedValue value, int id2) {
        Drawable drawable = ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).loadDrawable(value, id2);
        ShadowResources.setCreatedFromResId(this.realResources, id2, drawable);
        return drawable;
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected Drawable loadDrawable(TypedValue value, int id2, Resources.Theme theme) throws Resources.NotFoundException {
        Drawable drawable = ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).loadDrawable(value, id2, theme);
        ShadowResources.setCreatedFromResId(this.realResources, id2, drawable);
        return drawable;
    }

    private static List<LongSparseArray<?>> obtainResettableArrays() {
        Field[] allFields;
        ArrayList resettableArrays = new ArrayList();
        for (Field field : allFields = Resources.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(LongSparseArray.class)) continue;
            field.setAccessible(true);
            try {
                LongSparseArray longSparseArray = (LongSparseArray)field.get(null);
                if (longSparseArray == null) continue;
                resettableArrays.add(longSparseArray);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return resettableArrays;
    }

    @Implementation(minSdk=29)
    public static int getAttributeSetSourceResId(AttributeSet attrs) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class)).getAttributeSetSourceResId(attrs);
        }
        Object shadow = attrs instanceof ShadowedObject ? Shadow.extract((Object)attrs) : null;
        return shadow instanceof ShadowXmlBlock.ShadowParser ? ((ShadowXmlBlock.ShadowParser)shadow).getSourceResourceId() : 0;
    }

    public void addConfigurationChangeListener(OnConfigurationChangeListener listener) {
        this.configurationChangeListeners.add(listener);
    }

    public void removeConfigurationChangeListener(OnConfigurationChangeListener listener) {
        this.configurationChangeListeners.remove(listener);
    }

    @Implementation
    protected void updateConfiguration(Configuration config, DisplayMetrics metrics, CompatibilityInfo compat) {
        Configuration oldConfig;
        try {
            oldConfig = new Configuration(this.realResources.getConfiguration());
        }
        catch (NullPointerException e) {
            oldConfig = null;
        }
        ((ResourcesReflector)Reflector.reflector(ResourcesReflector.class, (Object)this.realResources)).updateConfiguration(config, metrics, compat);
        if (oldConfig != null && config != null) {
            for (OnConfigurationChangeListener listener : this.configurationChangeListeners) {
                listener.onConfigurationChange(oldConfig, config, metrics);
            }
        }
    }

    static void setCreatedFromResId(Resources resources, int id2, Drawable drawable) {
        if (drawable != null && Shadow.extract((Object)drawable) instanceof ShadowDrawable) {
            String resourceName;
            ShadowDrawable shadowDrawable = (ShadowDrawable)Shadow.extract((Object)drawable);
            try {
                resourceName = resources.getResourceName(id2);
            }
            catch (Resources.NotFoundException e) {
                resourceName = "Unknown resource #0x" + Integer.toHexString(id2);
            }
            shadowDrawable.setCreatedFromResId(id2, resourceName);
        }
    }

    private boolean isLegacyAssetManager() {
        return ShadowAssetManager.useLegacy();
    }

    @ForType(value=Resources.class)
    static interface ResourcesReflector {
        @Direct
        public XmlResourceParser loadXmlResourceParser(int var1, String var2);

        @Direct
        public XmlResourceParser loadXmlResourceParser(String var1, int var2, int var3, String var4);

        @Direct
        public Drawable loadDrawable(TypedValue var1, int var2);

        @Direct
        public Drawable loadDrawable(TypedValue var1, int var2, Resources.Theme var3);

        @Direct
        public TypedArray obtainAttributes(AttributeSet var1, int[] var2);

        @Direct
        public String getQuantityString(int var1, int var2, Object ... var3);

        @Direct
        public String getQuantityString(int var1, int var2);

        @Direct
        public InputStream openRawResource(int var1);

        @Direct
        public AssetFileDescriptor openRawResourceFd(int var1);

        @Direct
        public TypedArray obtainTypedArray(int var1);

        @Direct
        public int getAttributeSetSourceResId(AttributeSet var1);

        @Direct
        public void updateConfiguration(Configuration var1, DisplayMetrics var2, CompatibilityInfo var3);
    }

    public static interface OnConfigurationChangeListener {
        public void onConfigurationChange(Configuration var1, Configuration var2, DisplayMetrics var3);
    }

    @Implements(value=Resources.NotFoundException.class)
    public static class ShadowNotFoundException {
        @RealObject
        Resources.NotFoundException realObject;
        private String message;

        @Implementation
        protected void __constructor__() {
        }

        @Implementation
        protected void __constructor__(String name) {
            this.message = name;
        }

        @Implementation
        public String toString() {
            return this.realObject.getClass().getName() + ": " + this.message;
        }
    }

    @Implements(value=Resources.Theme.class, shadowPicker=ShadowTheme.Picker.class)
    public static class ShadowLegacyTheme
    extends ShadowTheme {
        @RealObject
        Resources.Theme realTheme;

        long getNativePtr() {
            if (RuntimeEnvironment.getApiLevel() >= 24) {
                ResourcesImpl.ThemeImpl themeImpl = (ResourcesImpl.ThemeImpl)ReflectionHelpers.getField((Object)this.realTheme, (String)"mThemeImpl");
                return ((ShadowLegacyResourcesImpl.ShadowLegacyThemeImpl)Shadow.extract((Object)themeImpl)).getNativePtr();
            }
            return ((Number)ReflectionHelpers.getField((Object)this.realTheme, (String)"mTheme")).longValue();
        }

        @Implementation(maxSdk=23)
        protected TypedArray obtainStyledAttributes(int[] attrs) {
            return this.obtainStyledAttributes(0, attrs);
        }

        @Implementation(maxSdk=23)
        protected TypedArray obtainStyledAttributes(int resid, int[] attrs) throws Resources.NotFoundException {
            return this.obtainStyledAttributes(null, attrs, 0, resid);
        }

        @Implementation(maxSdk=23)
        protected TypedArray obtainStyledAttributes(AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            return this.getShadowAssetManager().attrsToTypedArray(this.innerGetResources(), set, attrs, defStyleAttr, this.getNativePtr(), defStyleRes);
        }

        private ShadowLegacyAssetManager getShadowAssetManager() {
            return ShadowAssetManager.legacyShadowOf(this.innerGetResources().getAssets());
        }

        private Resources innerGetResources() {
            if (RuntimeEnvironment.getApiLevel() >= 21) {
                return this.realTheme.getResources();
            }
            return (Resources)ReflectionHelpers.getField((Object)this.realTheme, (String)"this$0");
        }
    }

    public static abstract class ShadowTheme {

        public static class Picker
        extends ResourceModeShadowPicker<ShadowTheme> {
            public Picker() {
                super(ShadowLegacyTheme.class, null, null);
            }
        }
    }
}

