/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDatatypeMismatchException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteOutOfMemoryException;
import android.database.sqlite.SQLiteReadOnlyDatabaseException;
import android.database.sqlite.SQLiteTableLockedException;
import android.os.OperationCanceledException;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowLegacyCursorWindow;
import org.robolectric.shadows.ShadowSQLiteConnection;
import org.robolectric.shadows.util.SQLiteLibraryLoader;
import org.robolectric.util.PerfStatsCollector;

@Implements(value=SQLiteConnection.class, isInAndroidSdk=false)
public class ShadowLegacySQLiteConnection
extends ShadowSQLiteConnection {
    private static final String IN_MEMORY_PATH = ":memory:";
    private static final Connections CONNECTIONS = new Connections();
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
    private static final int IGNORED_REINDEX_STMT = -2;

    @Implementation(maxSdk=26)
    protected static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile) {
        SQLiteLibraryLoader.load();
        return CONNECTIONS.open(path);
    }

    @Implementation(minSdk=27)
    protected static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile, int lookasideSlotSize, int lookasideSlotCount) {
        return ShadowLegacySQLiteConnection.nativeOpen(path, openFlags, label, enableTrace, enableProfile);
    }

    @Implementation
    protected static long nativePrepareStatement(long connectionPtr, String sql) {
        String newSql = ShadowLegacySQLiteConnection.convertSQLWithLocalizedUnicodeCollator(sql);
        return CONNECTIONS.prepareStatement(connectionPtr, newSql);
    }

    static String convertSQLWithLocalizedUnicodeCollator(String sql) {
        Matcher matcher = COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql);
        return matcher.replaceAll(" COLLATE NOCASE");
    }

    @Resetter
    public static void reset() {
        CONNECTIONS.reset();
    }

    @Implementation
    protected static void nativeClose(long connectionPtr) {
        CONNECTIONS.close(connectionPtr);
    }

    @Implementation
    protected static void nativeFinalizeStatement(long connectionPtr, long statementPtr) {
        CONNECTIONS.finalizeStmt(connectionPtr, statementPtr);
    }

    @Implementation
    protected static int nativeGetParameterCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.getParameterCount(connectionPtr, statementPtr);
    }

    @Implementation
    protected static boolean nativeIsReadOnly(long connectionPtr, long statementPtr) {
        return CONNECTIONS.isReadOnly(connectionPtr, statementPtr);
    }

    @Implementation
    protected static long nativeExecuteForLong(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForLong(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=32)
    protected static void nativeExecute(long connectionPtr, long statementPtr) {
        CONNECTIONS.executeStatement(connectionPtr, statementPtr);
    }

    @Implementation(minSdk=33)
    protected static void nativeExecute(long connectionPtr, long statementPtr, boolean isPragmaStmt) {
        CONNECTIONS.executeStatement(connectionPtr, statementPtr);
    }

    @Implementation
    protected static String nativeExecuteForString(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForString(connectionPtr, statementPtr);
    }

    @Implementation
    protected static int nativeGetColumnCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.getColumnCount(connectionPtr, statementPtr);
    }

    @Implementation
    protected static String nativeGetColumnName(long connectionPtr, long statementPtr, int index) {
        return CONNECTIONS.getColumnName(connectionPtr, statementPtr, index);
    }

    @Implementation
    protected static void nativeBindNull(long connectionPtr, long statementPtr, int index) {
        CONNECTIONS.bindNull(connectionPtr, statementPtr, index);
    }

    @Implementation
    protected static void nativeBindLong(long connectionPtr, long statementPtr, int index, long value) {
        CONNECTIONS.bindLong(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeBindDouble(long connectionPtr, long statementPtr, int index, double value) {
        CONNECTIONS.bindDouble(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeBindString(long connectionPtr, long statementPtr, int index, String value) {
        CONNECTIONS.bindString(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeBindBlob(long connectionPtr, long statementPtr, int index, byte[] value) {
        CONNECTIONS.bindBlob(connectionPtr, statementPtr, index, value);
    }

    @Implementation
    protected static void nativeRegisterLocalizedCollators(long connectionPtr, String locale) {
    }

    @Implementation
    protected static int nativeExecuteForChangedRowCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForChangedRowCount(connectionPtr, statementPtr);
    }

    @Implementation
    protected static long nativeExecuteForLastInsertedRowId(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForLastInsertedRowId(connectionPtr, statementPtr);
    }

    @Implementation
    protected static long nativeExecuteForCursorWindow(long connectionPtr, long statementPtr, long windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return CONNECTIONS.executeForCursorWindow(connectionPtr, statementPtr, windowPtr);
    }

    @Implementation
    protected static void nativeResetStatementAndClearBindings(long connectionPtr, long statementPtr) {
        CONNECTIONS.resetStatementAndClearBindings(connectionPtr, statementPtr);
    }

    @Implementation
    protected static void nativeCancel(long connectionPtr) {
        CONNECTIONS.cancel(connectionPtr);
    }

    @Implementation
    protected static void nativeResetCancel(long connectionPtr, boolean cancelable) {
    }

    @Implementation(maxSdk=29)
    protected static void nativeRegisterCustomFunction(long connectionPtr, SQLiteCustomFunction function) {
    }

    @Implementation
    protected static int nativeExecuteForBlobFileDescriptor(long connectionPtr, long statementPtr) {
        return -1;
    }

    @Implementation
    protected static int nativeGetDbLookaside(long connectionPtr) {
        return 0;
    }

    static class Connections {
        private final Object lock = new Object();
        private final AtomicLong pointerCounter = new AtomicLong(0L);
        private final Map<Long, SQLiteStatement> statementsMap = new HashMap<Long, SQLiteStatement>();
        private final Map<Long, com.almworks.sqlite4java.SQLiteConnection> connectionsMap = new HashMap<Long, com.almworks.sqlite4java.SQLiteConnection>();
        private final Map<Long, List<Long>> statementPtrsForConnection = new HashMap<Long, List<Long>>();
        private ExecutorService dbExecutor = Executors.newSingleThreadExecutor(Connections.threadFactory());
        private static final ImmutableMap<Integer, String> ERROR_CODE_MAP = new ImmutableMap.Builder().put((Object)4, (Object)"SQLITE_ABORT").put((Object)23, (Object)"SQLITE_AUTH").put((Object)5, (Object)"SQLITE_BUSY").put((Object)14, (Object)"SQLITE_CANTOPEN").put((Object)19, (Object)"SQLITE_CONSTRAINT").put((Object)11, (Object)"SQLITE_CORRUPT").put((Object)101, (Object)"SQLITE_DONE").put((Object)16, (Object)"SQLITE_EMPTY").put((Object)1, (Object)"SQLITE_ERROR").put((Object)24, (Object)"SQLITE_FORMAT").put((Object)13, (Object)"SQLITE_FULL").put((Object)2, (Object)"SQLITE_INTERNAL").put((Object)9, (Object)"SQLITE_INTERRUPT").put((Object)10, (Object)"SQLITE_IOERR").put((Object)6, (Object)"SQLITE_LOCKED").put((Object)20, (Object)"SQLITE_MISMATCH").put((Object)21, (Object)"SQLITE_MISUSE").put((Object)22, (Object)"SQLITE_NOLFS").put((Object)7, (Object)"SQLITE_NOMEM").put((Object)26, (Object)"SQLITE_NOTADB").put((Object)12, (Object)"SQLITE_NOTFOUND").put((Object)27, (Object)"SQLITE_NOTICE").put((Object)0, (Object)"SQLITE_OK").put((Object)3, (Object)"SQLITE_PERM").put((Object)15, (Object)"SQLITE_PROTOCOL").put((Object)25, (Object)"SQLITE_RANGE").put((Object)8, (Object)"SQLITE_READONLY").put((Object)100, (Object)"SQLITE_ROW").put((Object)17, (Object)"SQLITE_SCHEMA").put((Object)18, (Object)"SQLITE_TOOBIG").put((Object)28, (Object)"SQLITE_WARNING").put((Object)516, (Object)"SQLITE_ABORT_ROLLBACK").put((Object)261, (Object)"SQLITE_BUSY_RECOVERY").put((Object)517, (Object)"SQLITE_BUSY_SNAPSHOT").put((Object)1038, (Object)"SQLITE_CANTOPEN_CONVPATH").put((Object)782, (Object)"SQLITE_CANTOPEN_FULLPATH").put((Object)526, (Object)"SQLITE_CANTOPEN_ISDIR").put((Object)270, (Object)"SQLITE_CANTOPEN_NOTEMPDIR").put((Object)275, (Object)"SQLITE_CONSTRAINT_CHECK").put((Object)531, (Object)"SQLITE_CONSTRAINT_COMMITHOOK").put((Object)787, (Object)"SQLITE_CONSTRAINT_FOREIGNKEY").put((Object)1043, (Object)"SQLITE_CONSTRAINT_FUNCTION").put((Object)1299, (Object)"SQLITE_CONSTRAINT_NOTNULL").put((Object)1555, (Object)"SQLITE_CONSTRAINT_PRIMARYKEY").put((Object)2579, (Object)"SQLITE_CONSTRAINT_ROWID").put((Object)1811, (Object)"SQLITE_CONSTRAINT_TRIGGER").put((Object)2067, (Object)"SQLITE_CONSTRAINT_UNIQUE").put((Object)2323, (Object)"SQLITE_CONSTRAINT_VTAB").put((Object)267, (Object)"SQLITE_CORRUPT_VTAB").put((Object)3338, (Object)"SQLITE_IOERR_ACCESS").put((Object)2826, (Object)"SQLITE_IOERR_BLOCKED").put((Object)3594, (Object)"SQLITE_IOERR_CHECKRESERVEDLOCK").put((Object)4106, (Object)"SQLITE_IOERR_CLOSE").put((Object)6666, (Object)"SQLITE_IOERR_CONVPATH").put((Object)2570, (Object)"SQLITE_IOERR_DELETE").put((Object)5898, (Object)"SQLITE_IOERR_DELETE_NOENT").put((Object)4362, (Object)"SQLITE_IOERR_DIR_CLOSE").put((Object)1290, (Object)"SQLITE_IOERR_DIR_FSYNC").put((Object)1802, (Object)"SQLITE_IOERR_FSTAT").put((Object)1034, (Object)"SQLITE_IOERR_FSYNC").put((Object)6410, (Object)"SQLITE_IOERR_GETTEMPPATH").put((Object)3850, (Object)"SQLITE_IOERR_LOCK").put((Object)6154, (Object)"SQLITE_IOERR_MMAP").put((Object)3082, (Object)"SQLITE_IOERR_NOMEM").put((Object)2314, (Object)"SQLITE_IOERR_RDLOCK").put((Object)266, (Object)"SQLITE_IOERR_READ").put((Object)5642, (Object)"SQLITE_IOERR_SEEK").put((Object)5130, (Object)"SQLITE_IOERR_SHMLOCK").put((Object)5386, (Object)"SQLITE_IOERR_SHMMAP").put((Object)4618, (Object)"SQLITE_IOERR_SHMOPEN").put((Object)4874, (Object)"SQLITE_IOERR_SHMSIZE").put((Object)522, (Object)"SQLITE_IOERR_SHORT_READ").put((Object)1546, (Object)"SQLITE_IOERR_TRUNCATE").put((Object)2058, (Object)"SQLITE_IOERR_UNLOCK").put((Object)778, (Object)"SQLITE_IOERR_WRITE").put((Object)262, (Object)"SQLITE_LOCKED_SHAREDCACHE").put((Object)539, (Object)"SQLITE_NOTICE_RECOVER_ROLLBACK").put((Object)283, (Object)"SQLITE_NOTICE_RECOVER_WAL").put((Object)256, (Object)"SQLITE_OK_LOAD_PERMANENTLY").put((Object)520, (Object)"SQLITE_READONLY_CANTLOCK").put((Object)1032, (Object)"SQLITE_READONLY_DBMOVED").put((Object)264, (Object)"SQLITE_READONLY_RECOVERY").put((Object)776, (Object)"SQLITE_READONLY_ROLLBACK").put((Object)284, (Object)"SQLITE_WARNING_AUTOINDEX").build();

        Connections() {
        }

        static ThreadFactory threadFactory() {
            ThreadFactory delegate = Executors.defaultThreadFactory();
            return r -> {
                Thread worker = delegate.newThread(r);
                worker.setName(ShadowLegacySQLiteConnection.class.getSimpleName() + " worker");
                return worker;
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        com.almworks.sqlite4java.SQLiteConnection getConnection(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.connectionsMap.get(connectionPtr);
                if (connection == null) {
                    throw new IllegalStateException("Illegal connection pointer " + connectionPtr + ". Current pointers for thread " + Thread.currentThread() + " " + this.connectionsMap.keySet());
                }
                return connection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SQLiteStatement getStatement(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                this.getConnection(connectionPtr);
                SQLiteStatement statement = this.statementsMap.get(statementPtr);
                if (statement == null) {
                    throw new IllegalArgumentException("Invalid prepared statement pointer: " + statementPtr + ". Current pointers: " + this.statementsMap.keySet());
                }
                if (statement.isDisposed()) {
                    throw new IllegalStateException("Statement " + statementPtr + " " + statement + " is disposed");
                }
                return statement;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long open(final String path) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection dbConnection = this.execute(new Callable<com.almworks.sqlite4java.SQLiteConnection>(){

                    @Override
                    public com.almworks.sqlite4java.SQLiteConnection call() throws Exception {
                        com.almworks.sqlite4java.SQLiteConnection connection = ShadowSQLiteConnection.useInMemoryDatabase.get() || ShadowLegacySQLiteConnection.IN_MEMORY_PATH.equals(path) ? new com.almworks.sqlite4java.SQLiteConnection() : new com.almworks.sqlite4java.SQLiteConnection(new File(path));
                        connection.open();
                        return connection;
                    }
                });
                long connectionPtr = this.pointerCounter.incrementAndGet();
                this.connectionsMap.put(connectionPtr, dbConnection);
                this.statementPtrsForConnection.put(connectionPtr, new ArrayList());
                return connectionPtr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long prepareStatement(long connectionPtr, final String sql) {
            if ("REINDEX LOCALIZED".equals(sql)) {
                return -2L;
            }
            Object object = this.lock;
            synchronized (object) {
                final com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                SQLiteStatement statement = this.execute(new Callable<SQLiteStatement>(){

                    @Override
                    public SQLiteStatement call() throws Exception {
                        return connection.prepare(sql);
                    }
                });
                long statementPtr = this.pointerCounter.incrementAndGet();
                this.statementsMap.put(statementPtr, statement);
                this.statementPtrsForConnection.get(connectionPtr).add(statementPtr);
                return statementPtr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                this.execute(() -> {
                    connection.dispose();
                    return null;
                });
                this.connectionsMap.remove(connectionPtr);
                this.statementPtrsForConnection.remove(connectionPtr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            ArrayList<com.almworks.sqlite4java.SQLiteConnection> openConnections;
            ExecutorService oldDbExecutor;
            Object object = this.lock;
            synchronized (object) {
                oldDbExecutor = this.dbExecutor;
                openConnections = new ArrayList<com.almworks.sqlite4java.SQLiteConnection>(this.connectionsMap.values());
                this.dbExecutor = Executors.newSingleThreadExecutor(Connections.threadFactory());
                this.connectionsMap.clear();
                this.statementsMap.clear();
                this.statementPtrsForConnection.clear();
            }
            Connections.shutdownDbExecutor(oldDbExecutor, openConnections);
        }

        private static void shutdownDbExecutor(ExecutorService executorService, Collection<com.almworks.sqlite4java.SQLiteConnection> connections) {
            for (com.almworks.sqlite4java.SQLiteConnection connection : connections) {
                Connections.getFuture(executorService.submit(() -> {
                    connection.dispose();
                    return null;
                }));
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finalizeStmt(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                this.statementsMap.remove(statementPtr);
                this.execute(() -> {
                    statement.dispose();
                    return null;
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                this.getConnection(connectionPtr);
                for (Long statementPtr : this.statementPtrsForConnection.get(connectionPtr)) {
                    final SQLiteStatement statement = this.statementsMap.get(statementPtr);
                    if (statement == null) continue;
                    this.execute(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            statement.cancel();
                            return null;
                        }
                    });
                }
            }
        }

        int getParameterCount(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return 0;
            }
            return this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Integer>(){

                @Override
                public Integer call(SQLiteStatement statement) throws Exception {
                    return statement.getBindParameterCount();
                }
            });
        }

        boolean isReadOnly(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return true;
            }
            return this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Boolean>(){

                @Override
                public Boolean call(SQLiteStatement statement) throws Exception {
                    return statement.isReadOnly();
                }
            });
        }

        long executeForLong(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Long>(){

                @Override
                public Long call(SQLiteStatement statement) throws Exception {
                    if (!statement.step()) {
                        throw new SQLiteException(101, "No rows returned from query");
                    }
                    return statement.columnLong(0);
                }
            });
        }

        void executeStatement(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.stepThrough();
                    return null;
                }
            });
        }

        String executeForString(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<String>(){

                @Override
                public String call(SQLiteStatement statement) throws Exception {
                    if (!statement.step()) {
                        throw new SQLiteException(101, "No rows returned from query");
                    }
                    return statement.columnString(0);
                }
            });
        }

        int getColumnCount(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Integer>(){

                @Override
                public Integer call(SQLiteStatement statement) throws Exception {
                    return statement.columnCount();
                }
            });
        }

        String getColumnName(long connectionPtr, long statementPtr, final int index) {
            return this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<String>(){

                @Override
                public String call(SQLiteStatement statement) throws Exception {
                    return statement.getColumnName(index);
                }
            });
        }

        void bindNull(long connectionPtr, long statementPtr, final int index) {
            this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bindNull(index);
                    return null;
                }
            });
        }

        void bindLong(long connectionPtr, long statementPtr, final int index, final long value) {
            this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        void bindDouble(long connectionPtr, long statementPtr, final int index, final double value) {
            this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        void bindString(long connectionPtr, long statementPtr, final int index, final String value) {
            this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        void bindBlob(long connectionPtr, long statementPtr, final int index, final byte[] value) {
            this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int executeForChangedRowCount(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                final com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                final SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return this.execute(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        if (statement.step()) {
                            throw new android.database.sqlite.SQLiteException("Queries can be performed using SQLiteDatabase query or rawQuery methods only.");
                        }
                        return connection.getChanges();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long executeForLastInsertedRowId(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                final com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                final SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return this.execute(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        statement.stepThrough();
                        return connection.getChanges() > 0 ? connection.getLastInsertId() : -1L;
                    }
                });
            }
        }

        long executeForCursorWindow(long connectionPtr, long statementPtr, final long windowPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Integer>(){

                @Override
                public Integer call(SQLiteStatement statement) throws Exception {
                    return ShadowLegacyCursorWindow.setData(windowPtr, statement);
                }
            }).intValue();
        }

        void resetStatementAndClearBindings(long connectionPtr, long statementPtr) {
            this.executeStatementOperation(connectionPtr, statementPtr, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.reset(true);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T executeStatementOperation(long connectionPtr, long statementPtr, StatementOperation<T> statementOperation) {
            Object object = this.lock;
            synchronized (object) {
                SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return (T)this.execute(() -> statementOperation.call(statement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T execute(Callable<T> work) {
            Object object = this.lock;
            synchronized (object) {
                return (T)PerfStatsCollector.getInstance().measure("sqlite", () -> Connections.getFuture(this.dbExecutor.submit(work)));
            }
        }

        private static <T> T getFuture(Future<T> future) {
            try {
                return (T)Uninterruptibles.getUninterruptibly(future);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof SQLiteException) {
                    SQLiteException sqliteException = (SQLiteException)t;
                    RuntimeException sqlException = Connections.getSqliteException(sqliteException.getMessage(), sqliteException.getErrorCode());
                    sqlException.initCause(e);
                    throw sqlException;
                }
                if (t instanceof android.database.sqlite.SQLiteException) {
                    throw (android.database.sqlite.SQLiteException)t;
                }
                throw new RuntimeException(e);
            }
        }

        private static RuntimeException getSqliteException(String sqliteErrorMessage, int errorCode) {
            int baseErrorCode = errorCode & 0xFF;
            String errorMessageWithoutCode = sqliteErrorMessage.replaceAll("^\\[\\d+\\] ?", "");
            StringBuilder fullMessage = new StringBuilder(errorMessageWithoutCode);
            fullMessage.append(" (code ");
            fullMessage.append(errorCode);
            String errorCodeMessage = (String)ERROR_CODE_MAP.getOrDefault((Object)errorCode, (Object)"");
            if (((String)MoreObjects.firstNonNull((Object)errorCodeMessage, (Object)"")).length() > 0) {
                fullMessage.append(" ").append(errorCodeMessage);
            }
            fullMessage.append(")");
            String message = fullMessage.toString();
            switch (baseErrorCode) {
                case 4: {
                    return new SQLiteAbortException(message);
                }
                case 3: {
                    return new SQLiteAccessPermException(message);
                }
                case 25: {
                    return new SQLiteBindOrColumnIndexOutOfRangeException(message);
                }
                case 18: {
                    return new SQLiteBlobTooBigException(message);
                }
                case 14: {
                    return new SQLiteCantOpenDatabaseException(message);
                }
                case 19: {
                    return new SQLiteConstraintException(message);
                }
                case 11: 
                case 26: {
                    return new SQLiteDatabaseCorruptException(message);
                }
                case 5: {
                    return new SQLiteDatabaseLockedException(message);
                }
                case 20: {
                    return new SQLiteDatatypeMismatchException(message);
                }
                case 10: {
                    return new SQLiteDiskIOException(message);
                }
                case 101: {
                    return new SQLiteDoneException(message);
                }
                case 13: {
                    return new SQLiteFullException(message);
                }
                case 21: {
                    return new SQLiteMisuseException(message);
                }
                case 7: {
                    return new SQLiteOutOfMemoryException(message);
                }
                case 8: {
                    return new SQLiteReadOnlyDatabaseException(message);
                }
                case 6: {
                    return new SQLiteTableLockedException(message);
                }
                case 9: {
                    return new OperationCanceledException(message);
                }
            }
            return new android.database.sqlite.SQLiteException(message + ", base error code: " + baseErrorCode);
        }

        static interface StatementOperation<T> {
            public T call(SQLiteStatement var1) throws Exception;
        }
    }
}

