/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.CharArrayBuffer;
import android.database.CursorWindow;
import com.google.common.base.Preconditions;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.CursorWindowNatives;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.shadows.ShadowCursorWindow;

@Implements(value=CursorWindow.class, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeCursorWindow
extends ShadowCursorWindow {
    @Implementation(maxSdk=34)
    protected static long nativeCreate(String name, int cursorWindowSize) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return CursorWindowNatives.nativeCreate((String)name, (int)cursorWindowSize);
    }

    @Implementation(maxSdk=34)
    protected static void nativeDispose(long windowPtr) {
        CursorWindowNatives.nativeDispose((long)windowPtr);
    }

    @Implementation(maxSdk=34)
    protected static String nativeGetName(long windowPtr) {
        return CursorWindowNatives.nativeGetName((long)windowPtr);
    }

    @Implementation(maxSdk=34)
    protected static byte[] nativeGetBlob(long windowPtr, int row, int column) {
        return CursorWindowNatives.nativeGetBlob((long)windowPtr, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static String nativeGetString(long windowPtr, int row, int column) {
        return CursorWindowNatives.nativeGetString((long)windowPtr, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static void nativeCopyStringToBuffer(long windowPtr, int row, int column, CharArrayBuffer buffer) {
        CursorWindowNatives.nativeCopyStringToBuffer((long)windowPtr, (int)row, (int)column, (CharArrayBuffer)buffer);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativePutBlob(long windowPtr, byte[] value, int row, int column) {
        Preconditions.checkNotNull((Object)value);
        return CursorWindowNatives.nativePutBlob((long)windowPtr, (byte[])value, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativePutString(long windowPtr, String value, int row, int column) {
        Preconditions.checkNotNull((Object)value);
        return CursorWindowNatives.nativePutString((long)windowPtr, (String)value, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static void nativeClear(long windowPtr) {
        CursorWindowNatives.nativeClear((long)windowPtr);
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetNumRows(long windowPtr) {
        return CursorWindowNatives.nativeGetNumRows((long)windowPtr);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeSetNumColumns(long windowPtr, int columnNum) {
        return CursorWindowNatives.nativeSetNumColumns((long)windowPtr, (int)columnNum);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeAllocRow(long windowPtr) {
        return CursorWindowNatives.nativeAllocRow((long)windowPtr);
    }

    @Implementation(maxSdk=34)
    protected static void nativeFreeLastRow(long windowPtr) {
        CursorWindowNatives.nativeFreeLastRow((long)windowPtr);
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetType(long windowPtr, int row, int column) {
        return CursorWindowNatives.nativeGetType((long)windowPtr, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static long nativeGetLong(long windowPtr, int row, int column) {
        return CursorWindowNatives.nativeGetLong((long)windowPtr, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static double nativeGetDouble(long windowPtr, int row, int column) {
        return CursorWindowNatives.nativeGetDouble((long)windowPtr, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativePutLong(long windowPtr, long value, int row, int column) {
        return CursorWindowNatives.nativePutLong((long)windowPtr, (long)value, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativePutDouble(long windowPtr, double value, int row, int column) {
        return CursorWindowNatives.nativePutDouble((long)windowPtr, (double)value, (int)row, (int)column);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativePutNull(long windowPtr, int row, int column) {
        return CursorWindowNatives.nativePutNull((long)windowPtr, (int)row, (int)column);
    }
}

