/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraCaptureSessionImpl;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.SessionConfiguration;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.Executor;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

@Implements(value=CameraDeviceImpl.class, isInAndroidSdk=false)
public class ShadowCameraDeviceImpl {
    @RealObject
    private CameraDeviceImpl realObject;
    private boolean closed = false;

    @Implementation(minSdk=35)
    protected void __constructor__(String cameraId, CameraDevice.StateCallback callback, Executor executor, CameraCharacteristics characteristics, CameraManager cameraManager, int appTargetSdkVersion, Context ctx, @ClassName(value="android.hardware.camera2.CameraDevice$CameraDeviceSetup") @ClassName(value="android.hardware.camera2.CameraDevice$CameraDeviceSetup") Object cameraDeviceSetup) {
        try {
            ((CameraDeviceImplReflector)Reflector.reflector(CameraDeviceImplReflector.class, (Object)this.realObject)).__constructor__(cameraId, callback, executor, characteristics, cameraManager, appTargetSdkVersion, ctx, Class.forName("android.hardware.camera2.CameraDevice$CameraDeviceSetup").cast(cameraDeviceSetup));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ((CameraDeviceImplReflector)Reflector.reflector(CameraDeviceImplReflector.class, (Object)this.realObject)).setDeviceExecutor(MoreExecutors.directExecutor());
    }

    @Implementation
    protected CaptureRequest.Builder createCaptureRequest(int templateType) {
        this.checkIfCameraClosedOrInError();
        CameraMetadataNative templatedRequest = new CameraMetadataNative();
        String cameraId = (String)ReflectionHelpers.getField((Object)this.realObject, (String)"mCameraId");
        CaptureRequest.Builder builder = Build.VERSION.SDK_INT >= 28 ? new CaptureRequest.Builder(templatedRequest, false, -1, cameraId, null) : (Build.VERSION.SDK_INT >= 23 ? (CaptureRequest.Builder)ReflectionHelpers.callConstructor(CaptureRequest.Builder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CameraMetadataNative.class, (Object)templatedRequest), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)-1)}) : (CaptureRequest.Builder)ReflectionHelpers.callConstructor(CaptureRequest.Builder.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(CameraMetadataNative.class, (Object)templatedRequest)}));
        return builder;
    }

    @Implementation(minSdk=28)
    protected void createCaptureSession(List<Surface> outputs, CameraCaptureSession.StateCallback callback, Handler handler) throws CameraAccessException {
        this.checkIfCameraClosedOrInError();
        CameraCaptureSession session = this.createCameraCaptureSession(callback);
        handler.post(() -> callback.onConfigured(session));
    }

    @Implementation(minSdk=28)
    protected void createCaptureSession(SessionConfiguration config) throws CameraAccessException {
        this.checkIfCameraClosedOrInError();
        CameraCaptureSession session = this.createCameraCaptureSession(config.getStateCallback());
        config.getExecutor().execute(() -> config.getStateCallback().onConfigured(session));
    }

    @Implementation
    protected void close() {
        if (!this.closed) {
            Runnable callOnClosed = (Runnable)ReflectionHelpers.getField((Object)this.realObject, (String)"mCallOnClosed");
            if (Build.VERSION.SDK_INT >= 28) {
                Executor deviceExecutor = (Executor)ReflectionHelpers.getField((Object)this.realObject, (String)"mDeviceExecutor");
                deviceExecutor.execute(callOnClosed);
            } else {
                Handler deviceHandler = (Handler)ReflectionHelpers.getField((Object)this.realObject, (String)"mDeviceHandler");
                deviceHandler.post(callOnClosed);
            }
        }
        this.closed = true;
    }

    @Implementation
    protected void checkIfCameraClosedOrInError() {
        if (this.closed) {
            throw new IllegalStateException("CameraDevice was already closed");
        }
    }

    private CameraCaptureSession createCameraCaptureSession(CameraCaptureSession.StateCallback callback) {
        CameraCaptureSession sess = (CameraCaptureSession)Shadow.newInstanceOf(CameraCaptureSessionImpl.class);
        ReflectionHelpers.setField(CameraCaptureSessionImpl.class, (Object)sess, (String)"mStateCallback", (Object)callback);
        ReflectionHelpers.setField(CameraCaptureSessionImpl.class, (Object)sess, (String)"mDeviceImpl", (Object)this.realObject);
        return sess;
    }

    @ForType(value=CameraDeviceImpl.class)
    static interface CameraDeviceImplReflector {
        @Direct
        public void __constructor__(String var1, CameraDevice.StateCallback var2, Executor var3, CameraCharacteristics var4, CameraManager var5, int var6, Context var7, @WithType(value="android.hardware.camera2.CameraDevice$CameraDeviceSetup") Object var8);

        @Accessor(value="mDeviceExecutor")
        public void setDeviceExecutor(Executor var1);
    }
}

