/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.Nullable;
import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.nfc.INfcCardEmulation;
import android.nfc.cardemulation.CardEmulation;
import android.provider.Settings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=CardEmulation.class)
public class ShadowCardEmulation {
    private static final Set<ComponentName> defaultObserveModeEnabledServices = new HashSet<ComponentName>();
    private static Map<String, ComponentName> defaultServiceForCategoryMap = new HashMap<String, ComponentName>();
    private static ComponentName preferredService = null;
    @RealObject
    CardEmulation cardEmulation;

    @Implementation
    public boolean isDefaultServiceForCategory(ComponentName service, String category) {
        return service.equals((Object)defaultServiceForCategoryMap.get(category));
    }

    @Implementation
    public boolean setPreferredService(Activity activity, ComponentName service) {
        preferredService = service;
        return true;
    }

    @Implementation
    public boolean unsetPreferredService(Activity activity) {
        preferredService = null;
        return true;
    }

    @Implementation(minSdk=35)
    protected boolean setShouldDefaultToObserveModeForService(ComponentName service, boolean shouldDefaultToObserveMode) {
        if (shouldDefaultToObserveMode) {
            defaultObserveModeEnabledServices.add(service);
        } else {
            defaultObserveModeEnabledServices.remove(service);
        }
        return true;
    }

    public static void setDefaultServiceForCategory(ComponentName service, String category) {
        defaultServiceForCategoryMap.put(category, service);
    }

    @Nullable
    public static ComponentName getPreferredService() {
        return preferredService;
    }

    public static void setCategoryPaymentAllowsForegroundPreference(boolean value) {
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"nfc_payment_foreground", (int)(value ? 1 : 0));
    }

    public static boolean getShouldDefaultToObserveModeForService(ComponentName service) {
        return defaultObserveModeEnabledServices.contains(service);
    }

    @Resetter
    public static void reset() {
        defaultServiceForCategoryMap = new HashMap<String, ComponentName>();
        preferredService = null;
        CardEmulationReflector reflector = (CardEmulationReflector)Reflector.reflector(CardEmulationReflector.class);
        reflector.setIsInitialized(false);
        reflector.setService(null);
        Map<Context, CardEmulation> cardEmus = reflector.getCardEmus();
        if (cardEmus != null) {
            cardEmus.clear();
        }
    }

    @ForType(value=CardEmulation.class)
    static interface CardEmulationReflector {
        @Static
        @Accessor(value="sIsInitialized")
        public void setIsInitialized(boolean var1);

        @Static
        @Accessor(value="sService")
        public void setService(INfcCardEmulation var1);

        @Static
        @Accessor(value="sCardEmus")
        public Map<Context, CardEmulation> getCardEmus();
    }
}

