/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=CarrierConfigManager.class, minSdk=23)
public class ShadowCarrierConfigManager {
    private static final HashMap<Integer, PersistableBundle> bundles = new HashMap();
    private static final HashMap<Integer, PersistableBundle> overrideBundles = new HashMap();
    private static boolean readPhoneStatePermission = true;
    @VisibleForTesting
    static final PersistableBundle BASE = new PersistableBundle();

    @Resetter
    public static void reset() {
        bundles.clear();
        overrideBundles.clear();
        readPhoneStatePermission = true;
    }

    @Implementation
    public PersistableBundle getConfigForSubId(int subId) {
        this.checkReadPhoneStatePermission();
        if (overrideBundles.containsKey(subId) && overrideBundles.get(subId) != null) {
            return overrideBundles.get(subId) != null ? new PersistableBundle(overrideBundles.get(subId)) : null;
        }
        if (bundles.containsKey(subId)) {
            return bundles.get(subId) != null ? new PersistableBundle(bundles.get(subId)) : null;
        }
        return new PersistableBundle();
    }

    @Implementation(minSdk=34)
    @NonNull
    public PersistableBundle getConfigForSubId(int subId, String ... keys) {
        this.checkReadPhoneStatePermission();
        PersistableBundle bundle = this.getConfigForSubId(subId);
        PersistableBundle result = new PersistableBundle(BASE);
        if (bundle == null) {
            return result;
        }
        result.putAll(bundle);
        if (keys.length == 0) {
            return result;
        }
        ImmutableSet requiredKeys = ImmutableSet.builder().addAll((Iterable)BASE.keySet()).addAll((Iterable)ImmutableSet.copyOf((Object[])keys)).build();
        for (String key : bundle.keySet()) {
            if (requiredKeys.contains((Object)key)) continue;
            result.remove(key);
        }
        return result;
    }

    public void setReadPhoneStatePermission(boolean readPhoneStatePermission) {
        ShadowCarrierConfigManager.readPhoneStatePermission = readPhoneStatePermission;
    }

    public void setConfigForSubId(int subId, PersistableBundle config) {
        bundles.put(subId, config);
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected void overrideConfig(int subId, @Nullable PersistableBundle config) {
        overrideBundles.put(subId, config);
    }

    private void checkReadPhoneStatePermission() {
        if (!readPhoneStatePermission) {
            throw new SecurityException();
        }
    }

    static {
        BASE.putString("carrier_config_version_string", "version");
        BASE.putBoolean("carrier_config_applied_bool", false);
    }
}

