/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ApplicationPackageManager;
import android.app.KeyguardManager;
import android.app.admin.DevicePolicyManager;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.SystemUpdateInfo;
import android.app.admin.SystemUpdatePolicy;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowKeyguardManager;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.shadows.ShadowUserManager;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=DevicePolicyManager.class)
@SuppressLint(value={"NewApi"})
public class ShadowDevicePolicyManager {
    private final Map<PackageAndPermission, Boolean> appPermissionGrantedMap = new HashMap<PackageAndPermission, Boolean>();
    private final Map<PackageAndPermission, Integer> appPermissionGrantStateMap = new HashMap<PackageAndPermission, Integer>();
    private final Map<ComponentName, byte[]> passwordResetTokens = new HashMap<ComponentName, byte[]>();
    private final List<ComponentName> deviceAdmins = new ArrayList<ComponentName>();
    private final Map<Integer, String> profileOwnerNamesMap = new HashMap<Integer, String>();
    private final Map<String, Bundle> applicationRestrictionsMap = new HashMap<String, Bundle>();
    private List<String> permittedAccessibilityServices = new ArrayList<String>();
    private List<String> permittedInputMethods = new ArrayList<String>();
    private Collection<String> packagesToFailForSetApplicationHidden = Collections.emptySet();
    private Context context;
    private List<UserHandle> bindDeviceAdminTargetUsers = ImmutableList.of();
    @RealObject
    private DevicePolicyManager realObject;
    private static final int DEFAULT_ORGANIZATION_COLOR = -16744320;
    private static final Set<String> wasHiddenPackages = new HashSet<String>();
    private static final Set<String> accountTypesWithManagementDisabled = new HashSet<String>();
    private static final Set<String> systemAppsEnabled = new HashSet<String>();
    private static final Set<String> uninstallBlockedPackages = new HashSet<String>();
    private static final Set<String> suspendedPackages = new HashSet<String>();
    private static final Set<String> affiliationIds = new HashSet<String>();
    private static final Map<String, Set<String>> delegatedScopePackagesMap = new HashMap<String, Set<String>>();
    private static final Map<ComponentName, Set<Integer>> adminPolicyGrantedMap = new HashMap<ComponentName, Set<Integer>>();
    private static final Map<ComponentName, CharSequence> shortSupportMessageMap = new HashMap<ComponentName, CharSequence>();
    private static final Map<ComponentName, CharSequence> longSupportMessageMap = new HashMap<ComponentName, CharSequence>();
    private static final Set<ComponentName> componentsWithActivatedTokens = new HashSet<ComponentName>();
    private static final List<String> lockTaskPackages = new ArrayList<String>();
    private static final Map<UserHandle, Account> finalizedWorkProfileProvisioningMap = new HashMap<UserHandle, Account>();
    private static final Map<Integer, Integer> userProvisioningStatesMap = new HashMap<Integer, Integer>();
    private static ComponentName deviceOwner;
    private static ComponentName profileOwner;
    private static CharSequence organizationName;
    private static int organizationColor;
    private static boolean isAutoTimeEnabled;
    private static boolean isAutoTimeRequired;
    private static boolean isAutoTimeZoneEnabled;
    private static String timeZone;
    private static int keyguardDisabledFeatures;
    private static String lastSetPassword;
    private static int requiredPasswordQuality;
    private static int passwordMinimumLength;
    private static int passwordMinimumLetters;
    private static int passwordMinimumLowerCase;
    private static int passwordMinimumUpperCase;
    private static int passwordMinimumNonLetter;
    private static int passwordMinimumNumeric;
    private static int passwordMinimumSymbols;
    private static int passwordHistoryLength;
    private static long passwordExpiration;
    private static long passwordExpirationTimeout;
    private static int maximumFailedPasswordsForWipe;
    private static long maximumTimeToLock;
    private static boolean cameraDisabled;
    private static boolean isActivePasswordSufficient;
    private static boolean isUniqueDeviceAttestationSupported;
    private static int passwordComplexity;
    private static int wipeCalled;
    private static int storageEncryptionStatus;
    private static int permissionPolicy;
    private static boolean storageEncryptionRequested;
    private static int lockTaskFeatures;
    private static ApplicationPackageManager applicationPackageManager;
    private static SystemUpdatePolicy policy;
    private static boolean isDeviceProvisioned;
    private static boolean isDeviceProvisioningConfigApplied;
    private static volatile boolean organizationOwnedDeviceWithManagedProfile;
    private static int nearbyNotificationStreamingPolicy;
    private static int nearbyAppStreamingPolicy;
    private static boolean isUsbDataSignalingEnabled;
    @Nullable
    private static String devicePolicyManagementRoleHolderPackage;
    private static List<UserHandle> policyManagedProfiles;
    @Nullable
    private static PersistableBundle lastTransferOwnershipBundle;
    private static Object devicePolicyState;
    @Nullable
    private static SystemUpdateInfo systemUpdateInfo;

    @Resetter
    public static void reset() {
        deviceOwner = null;
        profileOwner = null;
        organizationName = null;
        organizationColor = -16744320;
        isAutoTimeEnabled = false;
        isAutoTimeRequired = false;
        isAutoTimeZoneEnabled = false;
        timeZone = null;
        keyguardDisabledFeatures = 0;
        lastSetPassword = null;
        requiredPasswordQuality = 0;
        passwordMinimumLength = 0;
        passwordMinimumLetters = 1;
        passwordMinimumLowerCase = 0;
        passwordMinimumUpperCase = 0;
        passwordMinimumNonLetter = 0;
        passwordMinimumNumeric = 1;
        passwordMinimumSymbols = 1;
        passwordHistoryLength = 0;
        passwordExpiration = 0L;
        passwordExpirationTimeout = 0L;
        maximumFailedPasswordsForWipe = 0;
        maximumTimeToLock = 0L;
        cameraDisabled = false;
        isActivePasswordSufficient = false;
        isUniqueDeviceAttestationSupported = false;
        passwordComplexity = 0;
        wipeCalled = 0;
        storageEncryptionStatus = 0;
        permissionPolicy = 0;
        storageEncryptionRequested = false;
        wasHiddenPackages.clear();
        accountTypesWithManagementDisabled.clear();
        systemAppsEnabled.clear();
        uninstallBlockedPackages.clear();
        suspendedPackages.clear();
        affiliationIds.clear();
        delegatedScopePackagesMap.clear();
        adminPolicyGrantedMap.clear();
        shortSupportMessageMap.clear();
        longSupportMessageMap.clear();
        componentsWithActivatedTokens.clear();
        lockTaskFeatures = 0;
        lockTaskPackages.clear();
        policy = null;
        isDeviceProvisioned = false;
        isDeviceProvisioningConfigApplied = false;
        organizationOwnedDeviceWithManagedProfile = false;
        nearbyNotificationStreamingPolicy = 0;
        nearbyAppStreamingPolicy = 0;
        isUsbDataSignalingEnabled = true;
        devicePolicyManagementRoleHolderPackage = null;
        finalizedWorkProfileProvisioningMap.clear();
        policyManagedProfiles = new ArrayList<UserHandle>();
        userProvisioningStatesMap.clear();
        lastTransferOwnershipBundle = null;
    }

    @Implementation(maxSdk=23)
    protected void __constructor__(Context context, Handler handler) {
        this.init(context);
        Shadow.invokeConstructor(DevicePolicyManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler)});
    }

    @Implementation(minSdk=24, maxSdk=25)
    protected void __constructor__(Context context, boolean parentInstance) {
        this.init(context);
    }

    @Implementation(minSdk=26)
    protected void __constructor__(Context context, IDevicePolicyManager service) {
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        applicationPackageManager = (ApplicationPackageManager)context.getApplicationContext().getPackageManager();
        organizationColor = -16744320;
        storageEncryptionStatus = 0;
    }

    @Implementation
    protected boolean isDeviceOwnerApp(String packageName) {
        return deviceOwner != null && deviceOwner.getPackageName().equals(packageName);
    }

    @Implementation
    protected boolean isProfileOwnerApp(String packageName) {
        return profileOwner != null && profileOwner.getPackageName().equals(packageName);
    }

    @Implementation
    protected boolean isAdminActive(ComponentName who) {
        return who != null && this.deviceAdmins.contains(who);
    }

    @Implementation
    protected List<ComponentName> getActiveAdmins() {
        return this.deviceAdmins;
    }

    @Implementation
    protected void addUserRestriction(ComponentName admin, String key) {
        this.enforceActiveAdmin(admin);
        this.getShadowUserManager().setUserRestriction(Process.myUserHandle(), key, true);
    }

    @Implementation
    protected void clearUserRestriction(ComponentName admin, String key) {
        this.enforceActiveAdmin(admin);
        this.getShadowUserManager().setUserRestriction(Process.myUserHandle(), key, false);
    }

    @Implementation
    protected boolean setApplicationHidden(ComponentName admin, String packageName, boolean hidden) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        } else {
            this.enforceCallerDelegated("delegation-package-access");
        }
        if (this.packagesToFailForSetApplicationHidden.contains(packageName)) {
            return false;
        }
        if (hidden) {
            wasHiddenPackages.add(packageName);
        }
        return applicationPackageManager.setApplicationHiddenSettingAsUser(packageName, hidden, Process.myUserHandle());
    }

    public void failSetApplicationHiddenFor(Collection<String> packagesToFail) {
        if (packagesToFail == null) {
            packagesToFail = Collections.emptySet();
        }
        this.packagesToFailForSetApplicationHidden = packagesToFail;
    }

    @Implementation
    protected boolean isApplicationHidden(ComponentName admin, String packageName) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        } else {
            this.enforceCallerDelegated("delegation-package-access");
        }
        return applicationPackageManager.getApplicationHiddenSettingAsUser(packageName, Process.myUserHandle());
    }

    public boolean wasPackageEverHidden(String packageName) {
        return wasHiddenPackages.contains(packageName);
    }

    @Implementation
    protected void enableSystemApp(ComponentName admin, String packageName) {
        this.enforceActiveAdmin(admin);
        systemAppsEnabled.add(packageName);
    }

    public boolean wasSystemAppEnabled(String packageName) {
        return systemAppsEnabled.contains(packageName);
    }

    @Implementation
    protected void setUninstallBlocked(ComponentName admin, String packageName, boolean uninstallBlocked) {
        this.enforceActiveAdmin(admin);
        if (uninstallBlocked) {
            uninstallBlockedPackages.add(packageName);
        } else {
            uninstallBlockedPackages.remove(packageName);
        }
    }

    @Implementation
    protected boolean isUninstallBlocked(@Nullable ComponentName admin, String packageName) {
        if (admin == null) {
            if (Build.VERSION.SDK_INT < 22) {
                throw new NullPointerException("ComponentName is null");
            }
        } else {
            this.enforceActiveAdmin(admin);
        }
        return uninstallBlockedPackages.contains(packageName);
    }

    public void setIsUniqueDeviceAttestationSupported(boolean supported) {
        isUniqueDeviceAttestationSupported = supported;
    }

    @Implementation(minSdk=30)
    protected boolean isUniqueDeviceAttestationSupported() {
        return isUniqueDeviceAttestationSupported;
    }

    public void setIsUsbDataSignalingEnabled(boolean isEnabled) {
        isUsbDataSignalingEnabled = isEnabled;
    }

    @Implementation(minSdk=31)
    protected boolean isUsbDataSignalingEnabled() {
        return isUsbDataSignalingEnabled;
    }

    @Implementation
    protected String getDeviceOwner() {
        return deviceOwner != null ? deviceOwner.getPackageName() : null;
    }

    @Implementation(minSdk=24)
    public boolean isDeviceManaged() {
        return this.getDeviceOwner() != null;
    }

    @Implementation
    protected ComponentName getProfileOwner() {
        return profileOwner;
    }

    @Implementation
    protected String getProfileOwnerNameAsUser(int userId) {
        return this.profileOwnerNamesMap.get(userId);
    }

    @Implementation(minSdk=28)
    protected void transferOwnership(ComponentName admin, ComponentName target, @Nullable PersistableBundle bundle) {
        Objects.requireNonNull(admin, "ComponentName is null");
        Objects.requireNonNull(target, "Target cannot be null.");
        Preconditions.checkArgument((!admin.equals((Object)target) ? 1 : 0) != 0, (Object)"Provided administrator and target are the same object.");
        Preconditions.checkArgument((!admin.getPackageName().equals(target.getPackageName()) ? 1 : 0) != 0, (Object)"Provided administrator and target have the same package name.");
        try {
            this.context.getPackageManager().getReceiverInfo(target, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Unknown admin: " + target);
        }
        if (admin.equals((Object)deviceOwner)) {
            deviceOwner = target;
        } else if (admin.equals((Object)profileOwner)) {
            profileOwner = target;
        } else {
            throw new SecurityException("Calling identity is not authorized");
        }
        lastTransferOwnershipBundle = bundle;
    }

    @Implementation(minSdk=28)
    @Nullable
    protected PersistableBundle getTransferOwnershipBundle() {
        return lastTransferOwnershipBundle;
    }

    private ShadowUserManager getShadowUserManager() {
        return (ShadowUserManager)Shadow.extract((Object)this.context.getSystemService("user"));
    }

    @Implementation(minSdk=24, maxSdk=32)
    public boolean setDeviceOwner(ComponentName admin) {
        this.setActiveAdmin(admin);
        deviceOwner = admin;
        return true;
    }

    public void setProfileOwner(ComponentName admin) {
        this.setActiveAdmin(admin);
        profileOwner = admin;
    }

    public void setProfileOwnerName(int userId, String name) {
        this.profileOwnerNamesMap.put(userId, name);
    }

    public void setActiveAdmin(ComponentName componentName) {
        this.deviceAdmins.add(componentName);
    }

    @Implementation
    protected void removeActiveAdmin(ComponentName admin) {
        this.deviceAdmins.remove(admin);
    }

    @Implementation
    protected void clearProfileOwner(ComponentName admin) {
        profileOwner = null;
        lastTransferOwnershipBundle = null;
        if (Build.VERSION.SDK_INT >= 24) {
            this.removeActiveAdmin(admin);
        }
    }

    @Implementation
    protected Bundle getApplicationRestrictions(ComponentName admin, String packageName) {
        if (admin != null) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceCallerDelegated("delegation-app-restrictions");
        }
        return this.getApplicationRestrictions(packageName);
    }

    public Bundle getApplicationRestrictions(String packageName) {
        Bundle bundle = this.applicationRestrictionsMap.get(packageName);
        return bundle != null ? new Bundle(bundle) : new Bundle();
    }

    @Implementation
    protected void setApplicationRestrictions(ComponentName admin, String packageName, Bundle applicationRestrictions) {
        if (admin != null) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceCallerDelegated("delegation-app-restrictions");
        }
        this.setApplicationRestrictions(packageName, applicationRestrictions);
    }

    public void setApplicationRestrictions(String packageName, Bundle applicationRestrictions) {
        this.applicationRestrictionsMap.put(packageName, new Bundle(applicationRestrictions));
    }

    private void enforceProfileOwner(ComponentName admin) {
        if (!admin.equals((Object)profileOwner)) {
            throw new SecurityException("[" + admin + "] is not a profile owner");
        }
    }

    private void enforceDeviceOwnerOrProfileOwner(ComponentName admin) {
        if (!admin.equals((Object)deviceOwner) && !admin.equals((Object)profileOwner)) {
            throw new SecurityException("[" + admin + "] is neither a device owner nor a profile owner.");
        }
    }

    private void enforceActiveAdmin(ComponentName admin) {
        if (!this.deviceAdmins.contains(admin)) {
            throw new SecurityException("[" + admin + "] is not an active device admin");
        }
    }

    private void enforceCallerDelegated(String targetScope) {
        String caller = this.context.getPackageName();
        if (!delegatedScopePackagesMap.containsKey(caller) || !delegatedScopePackagesMap.get(caller).contains(targetScope)) {
            throw new SecurityException("[" + caller + "] is not delegated with" + targetScope);
        }
    }

    @Implementation(minSdk=26)
    protected void setDelegatedScopes(ComponentName admin, String delegatePackage, List<String> scopes) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        delegatedScopePackagesMap.put(delegatePackage, (Set<String>)ImmutableSet.copyOf(scopes));
    }

    @Implementation(minSdk=26)
    protected List<String> getDelegatedScopes(ComponentName admin, String delegatePackage) {
        Objects.requireNonNull(delegatePackage, "Delegate package is null");
        if (admin == null) {
            String caller = this.context.getPackageName();
            if (!Objects.equals(caller, delegatePackage)) {
                throw new SecurityException(String.format("Caller is not %s.", delegatePackage));
            }
        } else {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        }
        if (delegatedScopePackagesMap.containsKey(delegatePackage)) {
            return ImmutableList.copyOf((Collection)delegatedScopePackagesMap.get(delegatePackage));
        }
        return ImmutableList.of();
    }

    @Implementation
    protected void setAccountManagementDisabled(ComponentName admin, String accountType, boolean disabled) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        if (disabled) {
            accountTypesWithManagementDisabled.add(accountType);
        } else {
            accountTypesWithManagementDisabled.remove(accountType);
        }
    }

    @Implementation
    protected String[] getAccountTypesWithManagementDisabled() {
        return accountTypesWithManagementDisabled.toArray(new String[0]);
    }

    @Implementation(minSdk=24)
    protected void setOrganizationName(ComponentName admin, @Nullable CharSequence name) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceProfileOwner(admin);
        }
        organizationName = TextUtils.isEmpty((CharSequence)name) ? null : name;
    }

    @Implementation(minSdk=24)
    protected String[] setPackagesSuspended(ComponentName admin, String[] packageNames, boolean suspended) {
        if (admin != null) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceCallerDelegated("delegation-package-access");
        }
        if (packageNames == null) {
            throw new NullPointerException("package names cannot be null");
        }
        PackageManager pm = this.context.getPackageManager();
        ArrayList<String> packagesFailedToSuspend = new ArrayList<String>();
        for (String packageName : packageNames) {
            try {
                pm.getPackageInfo(packageName, 0);
                if (suspended) {
                    suspendedPackages.add(packageName);
                    continue;
                }
                suspendedPackages.remove(packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                packagesFailedToSuspend.add(packageName);
            }
        }
        return packagesFailedToSuspend.toArray(new String[0]);
    }

    @Implementation(minSdk=24)
    protected boolean isPackageSuspended(ComponentName admin, String packageName) throws PackageManager.NameNotFoundException {
        if (admin != null) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceCallerDelegated("delegation-package-access");
        }
        this.context.getPackageManager().getPackageInfo(packageName, 0);
        return suspendedPackages.contains(packageName);
    }

    @Implementation(minSdk=24)
    protected void setOrganizationColor(ComponentName admin, int color) {
        this.enforceProfileOwner(admin);
        organizationColor = color;
    }

    @Implementation(minSdk=24)
    @Nullable
    protected CharSequence getOrganizationName(ComponentName admin) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceProfileOwner(admin);
        }
        return organizationName;
    }

    @Implementation(minSdk=24)
    protected int getOrganizationColor(ComponentName admin) {
        this.enforceProfileOwner(admin);
        return organizationColor;
    }

    @Implementation(minSdk=30)
    protected void setAutoTimeEnabled(ComponentName admin, boolean enabled) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        isAutoTimeEnabled = enabled;
    }

    @Implementation(minSdk=30)
    protected boolean getAutoTimeEnabled(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return isAutoTimeEnabled;
    }

    @Implementation
    protected void setAutoTimeRequired(ComponentName admin, boolean required) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        isAutoTimeRequired = required;
    }

    @Implementation
    protected boolean getAutoTimeRequired() {
        return isAutoTimeRequired;
    }

    @Implementation(minSdk=30)
    protected void setAutoTimeZoneEnabled(ComponentName admin, boolean enabled) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        isAutoTimeZoneEnabled = enabled;
    }

    @Implementation(minSdk=30)
    protected boolean getAutoTimeZoneEnabled(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return isAutoTimeZoneEnabled;
    }

    @Implementation(minSdk=28)
    protected boolean setTimeZone(ComponentName admin, String timeZone) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        if (isAutoTimeZoneEnabled) {
            return false;
        }
        ShadowDevicePolicyManager.timeZone = timeZone;
        return true;
    }

    public String getTimeZone() {
        return timeZone;
    }

    @Implementation
    protected boolean setPermittedAccessibilityServices(ComponentName admin, List<String> packageNames) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.permittedAccessibilityServices = packageNames;
        return true;
    }

    @Implementation
    @Nullable
    protected List<String> getPermittedAccessibilityServices(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.permittedAccessibilityServices;
    }

    @Implementation
    protected boolean setPermittedInputMethods(ComponentName admin, List<String> packageNames) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.permittedInputMethods = packageNames;
        return true;
    }

    @Implementation
    @Nullable
    protected List<String> getPermittedInputMethods(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.permittedInputMethods;
    }

    @Implementation
    protected int getStorageEncryptionStatus() {
        return storageEncryptionStatus;
    }

    public void setStorageEncryptionStatus(int status) {
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                if (RuntimeEnvironment.getApiLevel() >= 23) break;
                throw new IllegalArgumentException("status " + status + " requires API " + 23);
            }
            case 5: {
                if (RuntimeEnvironment.getApiLevel() >= 24) break;
                throw new IllegalArgumentException("status " + status + " requires API " + 24);
            }
            default: {
                throw new IllegalArgumentException("Unknown status: " + status);
            }
        }
        storageEncryptionStatus = status;
    }

    @Implementation
    protected int setStorageEncryption(ComponentName admin, boolean encrypt) {
        this.enforceActiveAdmin(admin);
        storageEncryptionRequested = encrypt;
        return storageEncryptionStatus;
    }

    @Implementation
    protected boolean getStorageEncryption(ComponentName admin) {
        return storageEncryptionRequested;
    }

    @Implementation(minSdk=23)
    protected int getPermissionGrantState(ComponentName admin, String packageName, String permission2) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        Integer state = this.appPermissionGrantStateMap.get(new PackageAndPermission(packageName, permission2));
        return state == null ? 0 : state;
    }

    public boolean isPermissionGranted(String packageName, String permission2) {
        Boolean isGranted = this.appPermissionGrantedMap.get(new PackageAndPermission(packageName, permission2));
        return isGranted == null ? false : isGranted;
    }

    @Implementation(minSdk=23)
    protected boolean setPermissionGrantState(ComponentName admin, String packageName, String permission2, int grantState) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        String selfPackageName = this.context.getPackageName();
        if (packageName.equals(selfPackageName)) {
            PackageInfo packageInfo;
            try {
                packageInfo = this.context.getPackageManager().getPackageInfo(selfPackageName, 4096);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (Arrays.asList(packageInfo.requestedPermissions).contains(permission2)) {
                if (grantState == 1) {
                    ShadowApplication.getInstance().grantPermissions(permission2);
                }
                if (grantState == 2) {
                    ShadowApplication.getInstance().denyPermissions(permission2);
                }
            } else {
                return false;
            }
        }
        PackageAndPermission key = new PackageAndPermission(packageName, permission2);
        switch (grantState) {
            case 1: {
                this.appPermissionGrantedMap.put(key, true);
                break;
            }
            case 2: {
                this.appPermissionGrantedMap.put(key, false);
                break;
            }
        }
        this.appPermissionGrantStateMap.put(key, grantState);
        return true;
    }

    @Implementation
    protected void lockNow() {
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        ShadowKeyguardManager shadowKeyguardManager = (ShadowKeyguardManager)Shadow.extract((Object)keyguardManager);
        shadowKeyguardManager.setKeyguardLocked(true);
        shadowKeyguardManager.setIsDeviceLocked(true);
    }

    @Implementation
    protected void wipeData(int flags) {
        ++wipeCalled;
    }

    public long getWipeCalledTimes() {
        return wipeCalled;
    }

    @Implementation
    protected void setPasswordQuality(ComponentName admin, int quality) {
        this.enforceActiveAdmin(admin);
        requiredPasswordQuality = quality;
    }

    @Implementation
    protected int getPasswordQuality(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return requiredPasswordQuality;
    }

    @Implementation
    protected boolean resetPassword(String password, int flags) {
        if (!this.passwordMeetsRequirements(password)) {
            return false;
        }
        lastSetPassword = password;
        boolean secure = !password.isEmpty();
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        Shadows.shadowOf(keyguardManager).setIsDeviceSecure(secure);
        Shadows.shadowOf(keyguardManager).setIsKeyguardSecure(secure);
        return true;
    }

    @Implementation(minSdk=26)
    protected boolean resetPasswordWithToken(ComponentName admin, String password, byte[] token, int flags) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        if (!Arrays.equals(this.passwordResetTokens.get(admin), token) || !componentsWithActivatedTokens.contains(admin)) {
            throw new IllegalStateException("wrong or not activated token");
        }
        this.resetPassword(password, flags);
        return true;
    }

    @Implementation(minSdk=26)
    protected boolean isResetPasswordTokenActive(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return componentsWithActivatedTokens.contains(admin);
    }

    @Implementation(minSdk=26)
    protected boolean setResetPasswordToken(ComponentName admin, byte[] token) {
        if (token.length < 32) {
            throw new IllegalArgumentException("token too short: " + token.length);
        }
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.passwordResetTokens.put(admin, token);
        componentsWithActivatedTokens.remove(admin);
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        if (!keyguardManager.isDeviceSecure()) {
            this.activateResetToken(admin);
        }
        return true;
    }

    @Implementation
    protected void setPasswordMinimumLength(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordMinimumLength = length;
    }

    @Implementation
    protected int getPasswordMinimumLength(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordMinimumLength;
    }

    @Implementation
    protected void setPasswordMinimumLetters(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordMinimumLetters = length;
    }

    @Implementation
    protected int getPasswordMinimumLetters(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordMinimumLetters;
    }

    @Implementation
    protected void setPasswordMinimumLowerCase(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordMinimumLowerCase = length;
    }

    @Implementation
    protected int getPasswordMinimumLowerCase(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordMinimumLowerCase;
    }

    @Implementation
    protected void setPasswordMinimumUpperCase(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordMinimumUpperCase = length;
    }

    @Implementation
    protected int getPasswordMinimumUpperCase(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordMinimumUpperCase;
    }

    @Implementation
    protected void setPasswordMinimumNonLetter(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordMinimumNonLetter = length;
    }

    @Implementation
    protected int getPasswordMinimumNonLetter(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordMinimumNonLetter;
    }

    @Implementation
    protected void setPasswordMinimumNumeric(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordMinimumNumeric = length;
    }

    @Implementation
    protected int getPasswordMinimumNumeric(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordMinimumNumeric;
    }

    @Implementation
    protected void setPasswordMinimumSymbols(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordMinimumSymbols = length;
    }

    @Implementation
    protected int getPasswordMinimumSymbols(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordMinimumSymbols;
    }

    @Implementation
    protected void setMaximumFailedPasswordsForWipe(ComponentName admin, int num) {
        this.enforceActiveAdmin(admin);
        maximumFailedPasswordsForWipe = num;
    }

    @Implementation
    protected int getMaximumFailedPasswordsForWipe(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return maximumFailedPasswordsForWipe;
    }

    @Implementation
    protected void setCameraDisabled(ComponentName admin, boolean disabled) {
        this.enforceActiveAdmin(admin);
        cameraDisabled = disabled;
    }

    @Implementation
    protected boolean getCameraDisabled(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return cameraDisabled;
    }

    @Implementation
    protected void setPasswordExpirationTimeout(ComponentName admin, long timeout) {
        this.enforceActiveAdmin(admin);
        passwordExpirationTimeout = timeout;
    }

    @Implementation
    protected long getPasswordExpirationTimeout(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordExpirationTimeout;
    }

    public void setPasswordExpiration(ComponentName admin, long timeout) {
        this.enforceActiveAdmin(admin);
        passwordExpiration = timeout;
    }

    @Implementation
    protected long getPasswordExpiration(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordExpiration;
    }

    @Implementation
    protected void setMaximumTimeToLock(ComponentName admin, long timeMs) {
        this.enforceActiveAdmin(admin);
        maximumTimeToLock = timeMs;
    }

    @Implementation
    protected long getMaximumTimeToLock(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return maximumTimeToLock;
    }

    @Implementation
    protected void setPasswordHistoryLength(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        passwordHistoryLength = length;
    }

    @Implementation
    protected int getPasswordHistoryLength(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return passwordHistoryLength;
    }

    public void setActivePasswordSufficient(boolean sufficient) {
        isActivePasswordSufficient = sufficient;
    }

    @Implementation
    protected boolean isActivePasswordSufficient() {
        return isActivePasswordSufficient;
    }

    public void setDeviceProvisioned(boolean isProvisioned) {
        isDeviceProvisioned = isProvisioned;
    }

    @Implementation(minSdk=26)
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    protected boolean isDeviceProvisioned() {
        return isDeviceProvisioned;
    }

    @Implementation(minSdk=26)
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    protected void setDeviceProvisioningConfigApplied() {
        isDeviceProvisioningConfigApplied = true;
    }

    @Implementation(minSdk=26)
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    protected boolean isDeviceProvisioningConfigApplied() {
        return isDeviceProvisioningConfigApplied;
    }

    public void setPasswordComplexity(int passwordComplexity) {
        ShadowDevicePolicyManager.passwordComplexity = passwordComplexity;
    }

    @Implementation(minSdk=29)
    protected int getPasswordComplexity() {
        return passwordComplexity;
    }

    private boolean passwordMeetsRequirements(String password) {
        int digit = 0;
        int alpha = 0;
        int upper = 0;
        int lower = 0;
        int symbol = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (Character.isDigit(c)) {
                ++digit;
            }
            if (Character.isLetter(c)) {
                ++alpha;
            }
            if (Character.isUpperCase(c)) {
                ++upper;
            }
            if (Character.isLowerCase(c)) {
                ++lower;
            }
            if (Character.isLetterOrDigit(c)) continue;
            ++symbol;
        }
        switch (requiredPasswordQuality) {
            case 0: 
            case 32768: 
            case 524288: {
                return true;
            }
            case 65536: {
                return password.length() > 0;
            }
            case 131072: 
            case 196608: {
                return digit > 0 && password.length() >= passwordMinimumLength;
            }
            case 327680: {
                return digit > 0 && alpha > 0 && password.length() >= passwordMinimumLength;
            }
            case 393216: {
                return password.length() >= passwordMinimumLength && alpha >= passwordMinimumLetters && lower >= passwordMinimumLowerCase && upper >= passwordMinimumUpperCase && digit + symbol >= passwordMinimumNonLetter && digit >= passwordMinimumNumeric && symbol >= passwordMinimumSymbols;
            }
        }
        return true;
    }

    public String getLastSetPassword() {
        return lastSetPassword;
    }

    public boolean activateResetToken(ComponentName admin) {
        if (!this.passwordResetTokens.containsKey(admin)) {
            throw new IllegalArgumentException("No token set for comopnent: " + admin);
        }
        return componentsWithActivatedTokens.add(admin);
    }

    @Implementation
    protected void addPersistentPreferredActivity(ComponentName admin, IntentFilter filter, ComponentName activity) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        PackageManager packageManager = this.context.getPackageManager();
        ((ShadowPackageManager)Shadow.extract((Object)packageManager)).addPersistentPreferredActivity(filter, activity);
    }

    @Implementation
    protected void clearPackagePersistentPreferredActivities(ComponentName admin, String packageName) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        PackageManager packageManager = this.context.getPackageManager();
        ((ShadowPackageManager)Shadow.extract((Object)packageManager)).clearPackagePersistentPreferredActivities(packageName);
    }

    @Implementation
    protected void setKeyguardDisabledFeatures(ComponentName admin, int which) {
        this.enforceActiveAdmin(admin);
        keyguardDisabledFeatures = which;
    }

    @Implementation
    protected int getKeyguardDisabledFeatures(ComponentName admin) {
        return keyguardDisabledFeatures;
    }

    public void setUserProvisioningState(int state) {
        this.setUserProvisioningState(state, Process.myUserHandle());
    }

    @Implementation(minSdk=33)
    protected void setUserProvisioningState(int state, UserHandle userHandle) {
        userProvisioningStatesMap.put(userHandle.getIdentifier(), state);
    }

    @Implementation(minSdk=24)
    protected int getUserProvisioningState() {
        return this.getUserProvisioningStateForUser(Process.myUserHandle().getIdentifier());
    }

    @Implementation
    protected boolean hasGrantedPolicy(@NonNull ComponentName admin, int usesPolicy) {
        this.enforceActiveAdmin(admin);
        Set<Integer> policyGrantedSet = adminPolicyGrantedMap.get(admin);
        return policyGrantedSet != null && policyGrantedSet.contains(usesPolicy);
    }

    @Implementation(minSdk=28)
    protected int getLockTaskFeatures(ComponentName admin) {
        Objects.requireNonNull(admin, "ComponentName is null");
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return lockTaskFeatures;
    }

    @Implementation(minSdk=28)
    protected void setLockTaskFeatures(ComponentName admin, int flags) {
        Objects.requireNonNull(admin, "ComponentName is null");
        this.enforceDeviceOwnerOrProfileOwner(admin);
        boolean hasHome = (flags & 4) != 0;
        boolean hasOverview = (flags & 8) != 0;
        Preconditions.checkArgument((hasHome || !hasOverview ? 1 : 0) != 0, (Object)"Cannot use LOCK_TASK_FEATURE_OVERVIEW without LOCK_TASK_FEATURE_HOME");
        boolean hasNotification = (flags & 2) != 0;
        Preconditions.checkArgument((hasHome || !hasNotification ? 1 : 0) != 0, (Object)"Cannot use LOCK_TASK_FEATURE_NOTIFICATIONS without LOCK_TASK_FEATURE_HOME");
        lockTaskFeatures = flags;
    }

    @Implementation
    protected void setLockTaskPackages(@NonNull ComponentName admin, String[] packages) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        lockTaskPackages.clear();
        Collections.addAll(lockTaskPackages, packages);
    }

    @Implementation
    protected String[] getLockTaskPackages(@NonNull ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return lockTaskPackages.toArray(new String[0]);
    }

    @Implementation
    protected boolean isLockTaskPermitted(@NonNull String pkg) {
        return lockTaskPackages.contains(pkg);
    }

    @Implementation(minSdk=26)
    protected void setAffiliationIds(@NonNull ComponentName admin, @NonNull Set<String> ids) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        affiliationIds.clear();
        affiliationIds.addAll(ids);
    }

    @Implementation(minSdk=26)
    protected Set<String> getAffiliationIds(@NonNull ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return affiliationIds;
    }

    @Implementation(minSdk=23)
    protected void setPermissionPolicy(@NonNull ComponentName admin, int policy) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        permissionPolicy = policy;
    }

    @Implementation(minSdk=23)
    protected int getPermissionPolicy(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return permissionPolicy;
    }

    public void grantPolicy(@NonNull ComponentName admin, int usesPolicy) {
        this.enforceActiveAdmin(admin);
        Set<Integer> policyGrantedSet = adminPolicyGrantedMap.get(admin);
        if (policyGrantedSet == null) {
            policyGrantedSet = new HashSet<Integer>();
            policyGrantedSet.add(usesPolicy);
            adminPolicyGrantedMap.put(admin, policyGrantedSet);
        } else {
            policyGrantedSet.add(usesPolicy);
        }
    }

    @Implementation(minSdk=23)
    protected SystemUpdatePolicy getSystemUpdatePolicy() {
        return policy;
    }

    @Implementation(minSdk=23)
    protected void setSystemUpdatePolicy(ComponentName admin, SystemUpdatePolicy policy) {
        ShadowDevicePolicyManager.policy = policy;
    }

    public void setSystemUpdatePolicy(SystemUpdatePolicy policy) {
        this.setSystemUpdatePolicy(null, policy);
    }

    public void setBindDeviceAdminTargetUsers(List<UserHandle> bindDeviceAdminTargetUsers) {
        this.bindDeviceAdminTargetUsers = bindDeviceAdminTargetUsers;
    }

    @Implementation(minSdk=26)
    protected List<UserHandle> getBindDeviceAdminTargetUsers(ComponentName admin) {
        return this.bindDeviceAdminTargetUsers;
    }

    @Implementation(minSdk=26)
    protected boolean bindDeviceAdminServiceAsUser(ComponentName admin, Intent serviceIntent, ServiceConnection conn, int flags, UserHandle targetUser) {
        if (!this.getBindDeviceAdminTargetUsers(admin).contains(targetUser)) {
            throw new SecurityException("Not allowed to bind to target user id");
        }
        return this.context.bindServiceAsUser(serviceIntent, conn, flags, targetUser);
    }

    @Implementation(minSdk=24)
    protected void setShortSupportMessage(ComponentName admin, @Nullable CharSequence message) {
        this.enforceActiveAdmin(admin);
        shortSupportMessageMap.put(admin, message);
    }

    @Implementation(minSdk=24)
    @Nullable
    protected CharSequence getShortSupportMessage(ComponentName admin) {
        this.enforceActiveAdmin(admin);
        return shortSupportMessageMap.get(admin);
    }

    @Implementation(minSdk=24)
    protected void setLongSupportMessage(ComponentName admin, @Nullable CharSequence message) {
        this.enforceActiveAdmin(admin);
        longSupportMessageMap.put(admin, message);
    }

    @Implementation(minSdk=24)
    @Nullable
    protected CharSequence getLongSupportMessage(ComponentName admin) {
        this.enforceActiveAdmin(admin);
        return longSupportMessageMap.get(admin);
    }

    public void setOrganizationOwnedDeviceWithManagedProfile(boolean value) {
        organizationOwnedDeviceWithManagedProfile = value;
    }

    @Implementation(minSdk=30)
    protected boolean isOrganizationOwnedDeviceWithManagedProfile() {
        return organizationOwnedDeviceWithManagedProfile;
    }

    @Implementation(minSdk=31)
    protected int getNearbyNotificationStreamingPolicy() {
        return nearbyNotificationStreamingPolicy;
    }

    @Implementation(minSdk=31)
    protected void setNearbyNotificationStreamingPolicy(int policy) {
        nearbyNotificationStreamingPolicy = policy;
    }

    @Implementation(minSdk=31)
    protected int getNearbyAppStreamingPolicy() {
        return nearbyAppStreamingPolicy;
    }

    @Implementation(minSdk=31)
    protected void setNearbyAppStreamingPolicy(int policy) {
        nearbyAppStreamingPolicy = policy;
    }

    @Implementation(minSdk=33)
    @Nullable
    protected String getDevicePolicyManagementRoleHolderPackage() {
        return devicePolicyManagementRoleHolderPackage;
    }

    public void setDevicePolicyManagementRoleHolderPackage(@Nullable String packageName) {
        devicePolicyManagementRoleHolderPackage = packageName;
    }

    @Implementation(minSdk=33)
    protected void finalizeWorkProfileProvisioning(UserHandle managedProfileUser, @Nullable Account migratedAccount) {
        finalizedWorkProfileProvisioningMap.put(managedProfileUser, migratedAccount);
    }

    public boolean isWorkProfileProvisioningFinalized(UserHandle userHandle, @Nullable Account migratedAccount) {
        return finalizedWorkProfileProvisioningMap.containsKey(userHandle) && Objects.equals(finalizedWorkProfileProvisioningMap.get(userHandle), migratedAccount);
    }

    @Implementation(minSdk=33)
    protected List<UserHandle> getPolicyManagedProfiles(UserHandle userHandle) {
        return policyManagedProfiles;
    }

    public void setPolicyManagedProfiles(List<UserHandle> policyManagedProfiles) {
        ShadowDevicePolicyManager.policyManagedProfiles = policyManagedProfiles;
    }

    public int getUserProvisioningStateForUser(int userId) {
        return userProvisioningStatesMap.getOrDefault(userId, 0);
    }

    @Implementation(minSdk=34)
    protected @ClassName(value="android.app.admin.DevicePolicyState") Object getDevicePolicyState() {
        return devicePolicyState;
    }

    public void setDevicePolicyState(Object policyState) {
        devicePolicyState = policyState;
    }

    public void setPendingSystemUpdate(@Nullable SystemUpdateInfo info) {
        systemUpdateInfo = info;
    }

    @Implementation(minSdk=26)
    protected void notifyPendingSystemUpdate(long updateReceivedTime) {
        systemUpdateInfo = ((SystemUpdateInfoReflector)Reflector.reflector(SystemUpdateInfoReflector.class)).of(updateReceivedTime);
    }

    @Implementation(minSdk=26)
    protected void notifyPendingSystemUpdate(long updateReceivedTime, boolean isSecurityPatch) {
        systemUpdateInfo = ((SystemUpdateInfoReflector)Reflector.reflector(SystemUpdateInfoReflector.class)).of(updateReceivedTime, isSecurityPatch);
    }

    @Implementation(minSdk=26)
    @Nullable
    protected SystemUpdateInfo getPendingSystemUpdate(@Nullable ComponentName admin) {
        return systemUpdateInfo;
    }

    static {
        requiredPasswordQuality = 0;
        passwordMinimumLetters = 1;
        passwordMinimumNumeric = 1;
        passwordMinimumSymbols = 1;
        passwordHistoryLength = 0;
        passwordExpiration = 0L;
        passwordExpirationTimeout = 0L;
        maximumFailedPasswordsForWipe = 0;
        maximumTimeToLock = 0L;
        organizationOwnedDeviceWithManagedProfile = false;
        nearbyNotificationStreamingPolicy = 0;
        nearbyAppStreamingPolicy = 0;
        isUsbDataSignalingEnabled = true;
        policyManagedProfiles = new ArrayList<UserHandle>();
    }

    private static class PackageAndPermission {
        private String packageName;
        private String permission;

        public PackageAndPermission(String packageName, String permission2) {
            this.packageName = packageName;
            this.permission = permission2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PackageAndPermission)) {
                return false;
            }
            PackageAndPermission other = (PackageAndPermission)o;
            return this.packageName.equals(other.packageName) && this.permission.equals(other.permission);
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = 31 * result + this.permission.hashCode();
            return result;
        }
    }

    @ForType(value=SystemUpdateInfo.class)
    static interface SystemUpdateInfoReflector {
        @Static
        public SystemUpdateInfo of(long var1);

        @Static
        public SystemUpdateInfo of(long var1, boolean var3);
    }
}

