/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.IBinder;
import android.view.Surface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaCodec.class)
public class ShadowMediaCodec {
    private static final int DEFAULT_BUFFER_SIZE = 512;
    @VisibleForTesting
    static final int BUFFER_COUNT = 10;
    private static final int EVENT_CALLBACK = 1;
    private static final int CB_INPUT_AVAILABLE = 1;
    private static final int CB_OUTPUT_AVAILABLE = 2;
    private static final int CB_OUTPUT_FORMAT_CHANGE = 4;
    private static final Map<String, CodecConfig> encoders = new HashMap<String, CodecConfig>();
    private static final Map<String, CodecConfig> decoders = new HashMap<String, CodecConfig>();
    private static final CodecConfig DEFAULT_CODEC = new CodecConfig(512, 512, (in, out) -> out.put(in));
    @RealObject
    private MediaCodec realCodec;
    @Nullable
    private CodecConfig.Codec fakeCodec;
    @Nullable
    private MediaCodec.Callback callback;
    @Nullable
    private MediaFormat pendingOutputFormat;
    @Nullable
    private MediaFormat outputFormat;
    @Nullable
    private MediaFormat inputFormat;
    @Nullable
    private String[] initialPendingOutputFormatKeys;
    @Nullable
    private Object[] initialPendingOutputFormatValues;
    private final BlockingQueue<Integer> inputBuffersPendingDequeue = new LinkedBlockingDeque<Integer>();
    private final BlockingQueue<Integer> outputBuffersPendingDequeue = new LinkedBlockingDeque<Integer>();
    private final List<Integer> inputBuffersPendingQueuing = Collections.synchronizedList(new ArrayList());
    private final ByteBuffer[] inputBuffers = new ByteBuffer[10];
    private final ByteBuffer[] outputBuffers = new ByteBuffer[10];
    private final MediaCodec.BufferInfo[] outputBufferInfos = new MediaCodec.BufferInfo[10];
    private boolean isAsync = false;

    public static void addEncoder(String type, CodecConfig config) {
        encoders.put(type, config);
    }

    public static void addDecoder(String type, CodecConfig config) {
        decoders.put(type, config);
    }

    @Resetter
    public static void clearCodecs() {
        encoders.clear();
        decoders.clear();
    }

    @Implementation
    protected void __constructor__(String name, boolean nameIsType, boolean encoder) {
        Shadow.invokeConstructor(MediaCodec.class, (Object)this.realCodec, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)name), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)nameIsType), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)encoder)});
        if (!nameIsType) {
            for (MediaCodecInfo codecInfo : new MediaCodecList(1).getCodecInfos()) {
                if (!codecInfo.getName().equals(name)) continue;
                encoder = codecInfo.isEncoder();
                break;
            }
        }
        CodecConfig codecConfig = encoder ? encoders.getOrDefault(name, DEFAULT_CODEC) : decoders.getOrDefault(name, DEFAULT_CODEC);
        this.fakeCodec = codecConfig.codec;
        for (int i = 0; i < 10; ++i) {
            this.inputBuffers[i] = ByteBuffer.allocateDirect(codecConfig.inputBufferSize).order(ByteOrder.LITTLE_ENDIAN);
            this.outputBuffers[i] = ByteBuffer.allocateDirect(codecConfig.outputBufferSize).order(ByteOrder.LITTLE_ENDIAN);
            this.outputBufferInfos[i] = new MediaCodec.BufferInfo();
        }
    }

    @Implementation
    protected void native_setCallback(MediaCodec.Callback callback) {
        this.callback = callback;
    }

    @Implementation(maxSdk=25)
    protected void native_configure(String[] keys, Object[] values, Surface surface, MediaCrypto crypto, int flags) {
        this.innerConfigure(keys, values, surface, crypto, flags);
    }

    @Implementation(minSdk=26, maxSdk=26)
    protected void native_configure(String[] keys, Object[] values, Surface surface, MediaCrypto crypto, IBinder descramblerBinder, int flags) {
        this.innerConfigure(keys, values, surface, crypto, flags);
    }

    @Implementation(minSdk=27)
    protected void native_configure(String[] keys, Object[] values, Surface surface, MediaCrypto crypto, @ClassName(value="android.os.IHwBinder") @ClassName(value="android.os.IHwBinder") Object descramblerBinder, int flags) {
        this.innerConfigure(keys, values, surface, crypto, flags);
    }

    private void innerConfigure(@Nullable String[] keys, @Nullable Object[] values, @Nullable Surface surface, @Nullable MediaCrypto mediaCrypto, int flags) {
        this.isAsync = this.callback != null;
        this.pendingOutputFormat = ShadowMediaCodec.recreateMediaFormatFromKeysValues(keys, values);
        this.inputFormat = ShadowMediaCodec.recreateMediaFormatFromKeysValues(keys, values);
        this.initialPendingOutputFormatKeys = keys;
        this.initialPendingOutputFormatValues = values;
        this.fakeCodec.onConfigured(this.pendingOutputFormat, surface, mediaCrypto, flags);
    }

    @Implementation
    protected void native_start() {
        this.inputBuffersPendingDequeue.clear();
        this.outputBuffersPendingDequeue.clear();
        for (int i = 0; i < 10; ++i) {
            this.inputBuffersPendingDequeue.add(i);
        }
        if (this.isAsync) {
            HashMap<String, Object> format = new HashMap<String, Object>();
            if (this.pendingOutputFormat != null) {
                this.pendingOutputFormat.setByteBuffer("csd-0", ByteBuffer.wrap(new byte[]{19, 16}));
                this.pendingOutputFormat.setByteBuffer("csd-1", ByteBuffer.wrap(new byte[0]));
                if (this.initialPendingOutputFormatKeys != null && this.initialPendingOutputFormatValues != null && this.initialPendingOutputFormatKeys.length == this.initialPendingOutputFormatValues.length) {
                    for (int i = 0; i < this.initialPendingOutputFormatKeys.length; ++i) {
                        format.put(this.initialPendingOutputFormatKeys[i], this.initialPendingOutputFormatValues[i]);
                    }
                }
            }
            format.put("csd-0", ByteBuffer.wrap(new byte[]{19, 16}));
            format.put("csd-1", ByteBuffer.wrap(new byte[0]));
            this.postFakeNativeEvent(1, 4, 0, format);
            try {
                this.makeInputBufferAvailable(this.inputBuffersPendingDequeue.take());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Implementation
    protected void native_flush() {
        if (!this.isAsync) {
            this.inputBuffersPendingDequeue.clear();
            this.outputBuffersPendingDequeue.clear();
            this.inputBuffersPendingQueuing.clear();
            for (int i = 0; i < 10; ++i) {
                this.inputBuffersPendingDequeue.add(i);
                ((Buffer)this.inputBuffers[i]).clear();
            }
        }
    }

    @Implementation
    protected ByteBuffer[] getBuffers(boolean input) {
        return input ? this.inputBuffers : this.outputBuffers;
    }

    @Implementation
    protected ByteBuffer getBuffer(boolean input, int index) {
        ByteBuffer[] buffers = input ? this.inputBuffers : this.outputBuffers;
        return index >= 0 && index < buffers.length && (!input || !this.codecOwnsInputBuffer(index)) ? buffers[index] : null;
    }

    @Implementation
    protected int native_dequeueInputBuffer(long timeoutUs) {
        Preconditions.checkState((!this.isAsync ? 1 : 0) != 0, (Object)"Attempting to deque buffer in Async mode.");
        try {
            Integer index = timeoutUs < 0L ? this.inputBuffersPendingDequeue.take() : this.inputBuffersPendingDequeue.poll(timeoutUs, TimeUnit.MICROSECONDS);
            if (index == null) {
                return -1;
            }
            this.inputBuffersPendingQueuing.add(index);
            return index;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    @Implementation
    protected void native_queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        if (index < 0 || index >= this.inputBuffers.length || this.codecOwnsInputBuffer(index) || !this.canQueueInputBuffer(index)) {
            ShadowMediaCodec.throwCodecException(0, 0, "Input buffer not owned by client: " + index);
        }
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        info.set(offset, size, presentationTimeUs, flags);
        this.makeOutputBufferAvailable(index, info);
        this.inputBuffersPendingQueuing.remove((Object)index);
    }

    @Implementation
    protected int native_dequeueOutputBuffer(MediaCodec.BufferInfo info, long timeoutUs) {
        Preconditions.checkState((!this.isAsync ? 1 : 0) != 0, (Object)"Attempting to deque buffer in Async mode.");
        try {
            if (this.pendingOutputFormat != null) {
                this.outputFormat = this.pendingOutputFormat;
                this.pendingOutputFormat = null;
                return -2;
            }
            Integer index = timeoutUs < 0L ? this.outputBuffersPendingDequeue.take() : this.outputBuffersPendingDequeue.poll(timeoutUs, TimeUnit.MICROSECONDS);
            if (index == null) {
                return -1;
            }
            ShadowMediaCodec.copyBufferInfo(this.outputBufferInfos[index], info);
            return index;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -1;
        }
    }

    @Implementation
    protected void releaseOutputBuffer(int index, boolean renderer) {
        this.releaseOutputBuffer(index);
    }

    @Implementation
    protected void releaseOutputBuffer(int index, long renderTimestampNs) {
        this.releaseOutputBuffer(index);
    }

    private void releaseOutputBuffer(int index) {
        if (this.outputBuffersPendingDequeue.contains(index)) {
            throw new IllegalStateException("Cannot release a buffer when it's still owned by the codec");
        }
        this.makeInputBufferAvailable(index);
    }

    private void makeInputBufferAvailable(int index) {
        if (index < 0 || index >= this.inputBuffers.length) {
            throw new IndexOutOfBoundsException("Cannot make non-existent input available.");
        }
        ((Buffer)this.inputBuffers[index]).clear();
        if (this.isAsync) {
            this.inputBuffersPendingQueuing.add(index);
            this.postFakeNativeEvent(1, 1, index, null);
        } else {
            this.inputBuffersPendingDequeue.add(index);
        }
    }

    private void makeOutputBufferAvailable(int index, MediaCodec.BufferInfo info) {
        if (index < 0 || index >= this.outputBuffers.length) {
            throw new IndexOutOfBoundsException("Cannot make non-existent output buffer available.");
        }
        ByteBuffer inputBuffer = this.inputBuffers[index];
        ByteBuffer outputBuffer = this.outputBuffers[index];
        MediaCodec.BufferInfo outputBufferInfo = this.outputBufferInfos[index];
        ((Buffer)outputBuffer).clear();
        ((Buffer)inputBuffer).position(info.offset).limit(info.offset + info.size);
        this.fakeCodec.process(this.inputBuffers[index], this.outputBuffers[index]);
        outputBufferInfo.flags = info.flags;
        outputBufferInfo.size = outputBuffer.position();
        outputBufferInfo.offset = info.offset;
        outputBufferInfo.presentationTimeUs = info.presentationTimeUs;
        ((Buffer)outputBuffer).flip();
        this.outputBuffersPendingDequeue.add(index);
        if (this.isAsync) {
            this.outputBuffersPendingDequeue.remove(index);
            this.postFakeNativeEvent(1, 2, index, this.outputBufferInfos[index]);
        }
    }

    private void postFakeNativeEvent(int what, int arg1, int arg2, @Nullable Object obj) {
        ReflectionHelpers.callInstanceMethod(MediaCodec.class, (Object)this.realCodec, (String)"postEventFromNative", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)what), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)arg1), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)arg2), ReflectionHelpers.ClassParameter.from(Object.class, (Object)obj)});
    }

    private boolean codecOwnsInputBuffer(int index) {
        return this.inputBuffersPendingDequeue.contains(index);
    }

    private boolean canQueueInputBuffer(int index) {
        return this.inputBuffersPendingQueuing.contains(index);
    }

    @Implementation(maxSdk=33)
    protected void invalidateByteBuffer(@Nullable ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=34)
    protected void invalidateByteBufferLocked(@Nullable ByteBuffer[] buffers, int index, boolean input) {
    }

    @Implementation(maxSdk=33)
    protected void validateInputByteBuffer(@Nullable ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=34)
    protected void validateInputByteBufferLocked(@Nullable ByteBuffer[] buffers, int index) {
    }

    @Implementation(maxSdk=33)
    protected void revalidateByteBuffer(@Nullable ByteBuffer[] buffers, int index) {
    }

    @Implementation(minSdk=34)
    protected void revalidateByteBuffer(@Nullable ByteBuffer[] buffers, int index, boolean input) {
    }

    @Implementation(maxSdk=33)
    protected void validateOutputByteBuffer(@Nullable ByteBuffer[] buffers, int index, @NonNull MediaCodec.BufferInfo info) {
        ByteBuffer buffer;
        if (buffers != null && index >= 0 && index < buffers.length && (buffer = buffers[index]) != null) {
            ((Buffer)buffer).limit(info.offset + info.size).position(info.offset);
        }
    }

    @Implementation(minSdk=34)
    protected void validateOutputByteBufferLocked(@Nullable ByteBuffer[] buffers, int index, @NonNull MediaCodec.BufferInfo info) {
        this.validateOutputByteBuffer(buffers, index, info);
    }

    @Implementation(maxSdk=33)
    protected void invalidateByteBuffers(@Nullable ByteBuffer[] buffers) {
    }

    @Implementation(minSdk=34)
    protected void invalidateByteBuffersLocked(@Nullable ByteBuffer[] buffers) {
    }

    @Implementation(maxSdk=33)
    protected void freeByteBuffer(@Nullable ByteBuffer buffer) {
    }

    @Implementation(minSdk=34)
    protected void freeByteBufferLocked(@Nullable ByteBuffer buffer) {
    }

    @Implementation
    protected MediaFormat getOutputFormat() {
        Preconditions.checkState((this.pendingOutputFormat != null || this.outputFormat != null ? 1 : 0) != 0, (Object)"Codec is not configured.");
        return this.pendingOutputFormat != null ? this.pendingOutputFormat : this.outputFormat;
    }

    @Implementation
    protected MediaFormat getInputFormat() {
        Preconditions.checkState((this.inputFormat != null ? 1 : 0) != 0, (Object)"Codec is not configured.");
        return this.inputFormat;
    }

    private static void copyBufferInfo(MediaCodec.BufferInfo from, MediaCodec.BufferInfo to) {
        to.set(from.offset, from.size, from.presentationTimeUs, from.flags);
    }

    private static MediaFormat recreateMediaFormatFromKeysValues(String[] keys, Object[] values) {
        MediaFormat mediaFormat = new MediaFormat();
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] == null || values[i] instanceof ByteBuffer) {
                mediaFormat.setByteBuffer(keys[i], (ByteBuffer)values[i]);
                continue;
            }
            if (values[i] instanceof Integer) {
                mediaFormat.setInteger(keys[i], ((Integer)values[i]).intValue());
                continue;
            }
            if (values[i] instanceof Long) {
                mediaFormat.setLong(keys[i], ((Long)values[i]).longValue());
                continue;
            }
            if (values[i] instanceof Float) {
                mediaFormat.setFloat(keys[i], ((Float)values[i]).floatValue());
                continue;
            }
            if (values[i] instanceof String) {
                mediaFormat.setString(keys[i], (String)values[i]);
                continue;
            }
            throw new IllegalArgumentException("Invalid value for key.");
        }
        return mediaFormat;
    }

    private static void throwCodecException(int errorCode, int actionCode, String message) {
        throw (MediaCodec.CodecException)ReflectionHelpers.callConstructor(MediaCodec.CodecException.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)errorCode), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)actionCode), ReflectionHelpers.ClassParameter.from(String.class, (Object)message)});
    }

    public static final class CodecConfig {
        private final int inputBufferSize;
        private final int outputBufferSize;
        private final Codec codec;

        public CodecConfig(int inputBufferSize, int outputBufferSize, Codec codec) {
            this.inputBufferSize = inputBufferSize;
            this.outputBufferSize = outputBufferSize;
            this.codec = codec;
        }

        public static interface Codec {
            public void process(ByteBuffer var1, ByteBuffer var2);

            default public void onConfigured(MediaFormat format, @Nullable Surface surface, @Nullable MediaCrypto crypto, int flags) {
            }
        }
    }

    @Implements(className="android.media.MediaCodec$BufferMap$CodecBuffer")
    protected static class ShadowCodecBuffer {
        @Implementation
        protected void __constructor__() {
        }

        @Implementation
        protected void free() {
        }
    }
}

