/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowMediaStore_CloudMediaChangedEvent;
import org.robolectric.shadows.ShadowBitmapFactory;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MediaStore.class)
public class ShadowMediaStore {
    private static Bitmap stubBitmap = null;
    private static final List<CloudMediaChangedEvent> cloudMediaChangedEventList = new ArrayList<CloudMediaChangedEvent>();
    private static final List<String> supportedCloudMediaProviderAuthorities = new ArrayList<String>();
    @Nullable
    private static String currentCloudMediaProviderAuthority = null;

    @Resetter
    public static void reset() {
        stubBitmap = null;
        cloudMediaChangedEventList.clear();
        supportedCloudMediaProviderAuthorities.clear();
        currentCloudMediaProviderAuthority = null;
    }

    public static void setStubBitmapForThumbnails(Bitmap bitmap) {
        stubBitmap = bitmap;
    }

    @Implementation(minSdk=33)
    protected static void notifyCloudMediaChangedEvent(ContentResolver resolver, String authority, String currentMediaCollectionId) {
        cloudMediaChangedEventList.add(CloudMediaChangedEvent.create(authority, currentMediaCollectionId));
    }

    public static ImmutableList<CloudMediaChangedEvent> getCloudMediaChangedEvents() {
        return ImmutableList.copyOf(cloudMediaChangedEventList);
    }

    public static void clearCloudMediaChangedEventList() {
        cloudMediaChangedEventList.clear();
    }

    @Implementation(minSdk=33)
    protected static boolean isSupportedCloudMediaProviderAuthority(@NonNull ContentResolver resolver, @NonNull String authority) {
        return supportedCloudMediaProviderAuthorities.contains(authority);
    }

    public static void addSupportedCloudMediaProviderAuthorities(@NonNull List<String> authorities) {
        supportedCloudMediaProviderAuthorities.addAll(authorities);
    }

    public static void clearSupportedCloudMediaProviderAuthorities() {
        supportedCloudMediaProviderAuthorities.clear();
    }

    @Implementation(minSdk=33)
    protected static boolean isCurrentCloudMediaProviderAuthority(@NonNull ContentResolver resolver, @NonNull String authority) {
        return currentCloudMediaProviderAuthority.equals(authority);
    }

    public static void setCurrentCloudMediaProviderAuthority(@Nullable String authority) {
        currentCloudMediaProviderAuthority = authority;
    }

    @AutoValue
    public static abstract class CloudMediaChangedEvent {
        public static CloudMediaChangedEvent create(String authority, String currentMediaCollectionId) {
            return new AutoValue_ShadowMediaStore_CloudMediaChangedEvent(authority, currentMediaCollectionId);
        }

        public abstract String authority();

        public abstract String currentMediaCollectionId();
    }

    @ForType(value=MediaStore.Video.Thumbnails.class)
    static interface VideoThumbnailsReflector {
        @Direct
        public Bitmap getThumbnail(ContentResolver var1, long var2, int var4, BitmapFactory.Options var5);
    }

    @ForType(value=MediaStore.Images.Thumbnails.class)
    static interface ImagesThumbnailsReflector {
        @Direct
        public Bitmap getThumbnail(ContentResolver var1, long var2, int var4, BitmapFactory.Options var5);
    }

    @Implements(value=MediaStore.Video.class)
    public static class ShadowVideo {

        @Implements(value=MediaStore.Video.Thumbnails.class)
        public static class ShadowThumbnails {
            @Implementation
            protected static Bitmap getThumbnail(ContentResolver cr, long imageId, int kind, BitmapFactory.Options options) {
                if (stubBitmap != null) {
                    return stubBitmap;
                }
                return ((VideoThumbnailsReflector)Reflector.reflector(VideoThumbnailsReflector.class)).getThumbnail(cr, imageId, kind, options);
            }
        }
    }

    @Implements(value=MediaStore.Images.class)
    public static class ShadowImages {

        @Implements(value=MediaStore.Images.Thumbnails.class)
        public static class ShadowThumbnails {
            @Implementation
            protected static Bitmap getThumbnail(ContentResolver cr, long imageId, int kind, BitmapFactory.Options options) {
                if (stubBitmap != null) {
                    return stubBitmap;
                }
                return ((ImagesThumbnailsReflector)Reflector.reflector(ImagesThumbnailsReflector.class)).getThumbnail(cr, imageId, kind, options);
            }
        }

        @Implements(value=MediaStore.Images.Media.class)
        public static class ShadowMedia {
            @Implementation
            protected static Bitmap getBitmap(ContentResolver cr, Uri url) {
                if (ShadowView.useRealGraphics()) {
                    return Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                return ShadowBitmapFactory.create(url.toString(), null, null);
            }
        }
    }
}

