/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontCustomizationParser;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.SystemFonts;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Log;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowSystemFonts;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=SystemFonts.class, minSdk=29, isInAndroidSdk=false, shadowPicker=Picker.class)
public class ShadowNativeSystemFonts {
    @Implementation(minSdk=31)
    protected static FontConfig getSystemFontConfigInternal(String fontsXml, String systemFontDir, String oemXml, String productFontDir, Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        String fontDir = System.getProperty("robolectric.nativeruntime.fontdir");
        Preconditions.checkNotNull((Object)fontDir);
        Preconditions.checkState((boolean)new File(fontDir).isDirectory(), (Object)"Missing fonts directory");
        Preconditions.checkState((boolean)fontDir.endsWith(File.separator), (Object)"Fonts directory must end with a slash");
        return ((SystemFontsReflector)Reflector.reflector(SystemFontsReflector.class)).getSystemFontConfigInternal(fontDir + "fonts.xml", fontDir, null, null, updatableFontMap, lastModifiedDate, configVersion);
    }

    @Implementation(maxSdk=30)
    public static FontConfig.Alias[] buildSystemFallback(String xmlPath, String systemFontDir, FontCustomizationParser.Result oemCustomization, ArrayMap<String, FontFamily[]> fallbackMap, ArrayList<Font> availableFonts) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        String fontDir = System.getProperty("robolectric.nativeruntime.fontdir");
        Preconditions.checkNotNull((Object)fontDir);
        Preconditions.checkState((boolean)new File(fontDir).isDirectory(), (Object)"Missing fonts directory");
        Preconditions.checkState((boolean)fontDir.endsWith(File.separator), (Object)"Fonts directory must end with a slash");
        return ((SystemFontsReflector)Reflector.reflector(SystemFontsReflector.class)).buildSystemFallback(fontDir + "fonts.xml", fontDir, oemCustomization, fallbackMap, availableFonts);
    }

    @Implementation(minSdk=29, maxSdk=29)
    @Nullable
    protected static ByteBuffer mmap(@NonNull String fullPath) {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream file = new FileInputStream(fullPath);
        try {
            FileChannel fileChannel = file.getChannel();
            long fontSize = fileChannel.size();
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Log.w((String)"SystemFonts", (String)e.getMessage());
                return null;
            }
        }
        file.close();
        return mappedByteBuffer;
    }

    @ForType(value=SystemFonts.class)
    static interface SystemFontsReflector {
        @Static
        @Direct
        public FontConfig getSystemFontConfigInternal(String var1, String var2, String var3, String var4, Map<String, File> var5, long var6, int var8);

        @Static
        @Direct
        public FontConfig.Alias[] buildSystemFallback(String var1, String var2, FontCustomizationParser.Result var3, ArrayMap<String, FontFamily[]> var4, ArrayList<Font> var5);
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowSystemFonts.class, ShadowNativeSystemFonts.class);
        }
    }
}

