/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPausedChoreographer;
import org.robolectric.shadows.ShadowPausedMessage;
import org.robolectric.shadows.ShadowPausedMessageQueue;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Looper.class, isInAndroidSdk=false)
public final class ShadowPausedLooper
extends ShadowLooper {
    private static Set<Looper> loopingLoopers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private static boolean ignoreUncaughtExceptions = false;
    @RealObject
    private Looper realLooper;
    private boolean isPaused = false;
    private Executor looperExecutor;
    private static final Object instrumentationTestMainThreadLock = new Object();
    @GuardedBy(value="instrumentationTestMainThreadLock")
    private static boolean instrumentationTestMainThreadShouldRestart = false;

    @Implementation
    protected void __constructor__(boolean quitAllowed) {
        Shadow.invokeConstructor(Looper.class, (Object)this.realLooper, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)quitAllowed)});
        loopingLoopers.add(this.realLooper);
        this.looperExecutor = new HandlerExecutor(this.realLooper);
    }

    protected static Collection<Looper> getLoopers() {
        ArrayList<Looper> loopers = new ArrayList<Looper>(loopingLoopers);
        return Collections.unmodifiableCollection(loopers);
    }

    @Override
    public void quitUnchecked() {
        throw new UnsupportedOperationException("this action is not supported in " + ShadowPausedLooper.looperMode() + " mode.");
    }

    @Override
    public boolean hasQuit() {
        throw new UnsupportedOperationException("this action is not supported in " + ShadowPausedLooper.looperMode() + " mode.");
    }

    @Override
    public void idle() {
        this.executeOnLooper(new IdlingRunnable());
    }

    @Override
    public void idleFor(long time, TimeUnit timeUnit) {
        long endingTimeMs = SystemClock.uptimeMillis() + timeUnit.toMillis(time);
        long nextScheduledTimeMs = this.getNextScheduledTaskTime().toMillis();
        while (nextScheduledTimeMs != 0L && nextScheduledTimeMs <= endingTimeMs) {
            SystemClock.setCurrentTimeMillis((long)nextScheduledTimeMs);
            this.idle();
            nextScheduledTimeMs = this.getNextScheduledTaskTime().toMillis();
        }
        SystemClock.setCurrentTimeMillis((long)endingTimeMs);
        this.idle();
    }

    @Override
    public boolean isIdle() {
        if (Thread.currentThread() == this.realLooper.getThread() || this.isPaused) {
            return this.shadowQueue().isIdle();
        }
        return this.shadowQueue().isIdle() && this.shadowQueue().isPolling();
    }

    @Override
    public void unPause() {
        if (this.realLooper == Looper.getMainLooper() && ShadowPausedLooper.looperMode() != LooperMode.Mode.INSTRUMENTATION_TEST) {
            throw new UnsupportedOperationException("main looper cannot be unpaused");
        }
        this.executeOnLooper(new UnPauseRunnable());
    }

    @Override
    public void pause() {
        if (!this.isPaused()) {
            this.executeOnLooper(new PausedLooperExecutor());
        }
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public boolean setPaused(boolean shouldPause) {
        if (shouldPause) {
            this.pause();
        } else {
            this.unPause();
        }
        return true;
    }

    @Override
    public void resetScheduler() {
        throw new UnsupportedOperationException("this action is not supported in " + ShadowPausedLooper.looperMode() + " mode.");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("this action is not supported in " + ShadowPausedLooper.looperMode() + " mode.");
    }

    @Override
    public void idleIfPaused() {
        if (this.isPaused()) {
            this.idle();
        }
    }

    @Override
    public void idleConstantly(boolean shouldIdleConstantly) {
        throw new UnsupportedOperationException("this action is not supported in " + ShadowPausedLooper.looperMode() + " mode.");
    }

    @Override
    public void runToEndOfTasks() {
        this.idleFor(Duration.ofMillis(this.getLastScheduledTaskTime().toMillis() - SystemClock.uptimeMillis()));
    }

    @Override
    public void runToNextTask() {
        this.idleFor(Duration.ofMillis(this.getNextScheduledTaskTime().toMillis() - SystemClock.uptimeMillis()));
    }

    @Override
    public void runOneTask() {
        this.executeOnLooper(new RunOneRunnable());
    }

    @Override
    public boolean post(Runnable runnable, long delayMillis) {
        return new Handler(this.realLooper).postDelayed(runnable, delayMillis);
    }

    @Override
    public boolean postAtFrontOfQueue(Runnable runnable) {
        return new Handler(this.realLooper).postAtFrontOfQueue(runnable);
    }

    public void postSync(Runnable runnable) {
        this.executeOnLooper(new PostAndIdleToRunnable(runnable));
    }

    void postSyncQuiet(Runnable runnable) {
        try {
            this.executeOnLooper(new PostAsyncAndIdleToRunnable(runnable));
        }
        catch (RuntimeException e) {
            Log.w((String)"ShadowPausedLooper", (String)"ignoring exception on postSyncQuiet", (Throwable)e);
        }
    }

    @Override
    public void runPaused(Runnable runnable) {
        if (Thread.currentThread() != this.realLooper.getThread()) {
            throw new UnsupportedOperationException("this method can only be called on " + this.realLooper.getThread().getName());
        }
        runnable.run();
    }

    public void poll(long timeout) {
        Preconditions.checkState((Looper.myLooper() == Looper.getMainLooper() && Looper.myLooper() == this.realLooper ? 1 : 0) != 0);
        this.shadowQueue().poll(timeout);
    }

    @Override
    public Duration getNextScheduledTaskTime() {
        return this.shadowQueue().getNextScheduledTaskTime();
    }

    @Override
    public Duration getLastScheduledTaskTime() {
        return this.shadowQueue().getLastScheduledTaskTime();
    }

    @Resetter
    public static synchronized void resetLoopers() {
        LooperMode.Mode looperMode = (LooperMode.Mode)ConfigurationRegistry.get(LooperMode.Mode.class);
        if (looperMode == LooperMode.Mode.LEGACY) {
            return;
        }
        ShadowPausedLooper.createMainThreadAndLooperIfNotAlive();
        ShadowPausedChoreographer.resetChoreographers();
        for (Looper looper : ShadowPausedLooper.getLoopers()) {
            ShadowPausedLooper shadowPausedLooper = (ShadowPausedLooper)Shadow.extract((Object)looper);
            shadowPausedLooper.resetLooperToInitialState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void createMainThreadAndLooperIfNotAlive() {
        Looper mainLooper = Looper.getMainLooper();
        switch ((LooperMode.Mode)ConfigurationRegistry.get(LooperMode.Mode.class)) {
            case INSTRUMENTATION_TEST: {
                if (mainLooper == null) {
                    final ConditionVariable mainThreadPrepared = new ConditionVariable();
                    Thread mainThread = new Thread(String.format("SDK %d Main Thread", RuntimeEnvironment.getApiLevel())){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Looper.prepareMainLooper();
                            mainThreadPrepared.open();
                            while (true) {
                                try {
                                    Looper.loop();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                Object object = instrumentationTestMainThreadLock;
                                synchronized (object) {
                                    while (!instrumentationTestMainThreadShouldRestart) {
                                        try {
                                            instrumentationTestMainThreadLock.wait();
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    instrumentationTestMainThreadShouldRestart = false;
                                }
                            }
                        }
                    };
                    mainThread.start();
                    mainThreadPrepared.block();
                    Thread.currentThread().setName(String.format("SDK %d Test Thread", RuntimeEnvironment.getApiLevel()));
                    break;
                }
                ShadowPausedMessageQueue shadowQueue = (ShadowPausedMessageQueue)Shadow.extract((Object)mainLooper.getQueue());
                if (!shadowQueue.hasUncaughtException()) break;
                shadowQueue.reset();
                Object object = instrumentationTestMainThreadLock;
                synchronized (object) {
                    instrumentationTestMainThreadShouldRestart = true;
                    instrumentationTestMainThreadLock.notify();
                    break;
                }
            }
            case PAUSED: {
                if (Looper.myLooper() != null) break;
                Looper.prepareMainLooper();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Only supports INSTRUMENTATION_TEST and PAUSED LooperMode.");
            }
        }
    }

    @VisibleForTesting
    synchronized void resetLooperToInitialState() {
        LooperMode.Mode looperMode = (LooperMode.Mode)ConfigurationRegistry.get(LooperMode.Mode.class);
        ShadowPausedMessageQueue shadowQueue = (ShadowPausedMessageQueue)Shadow.extract((Object)this.realLooper.getQueue());
        shadowQueue.reset();
        if (this.realLooper.getThread().isAlive() && !shadowQueue.isQuitting() && this.isPaused() && (this.realLooper != Looper.getMainLooper() || looperMode == LooperMode.Mode.INSTRUMENTATION_TEST)) {
            this.unPause();
        }
    }

    @Implementation
    protected static void prepareMainLooper() {
        ((LooperReflector)Reflector.reflector(LooperReflector.class)).prepareMainLooper();
        ShadowPausedLooper pausedLooper = (ShadowPausedLooper)Shadow.extract((Object)Looper.getMainLooper());
        pausedLooper.isPaused = ShadowPausedLooper.looperMode() == LooperMode.Mode.PAUSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void quit() {
        if (this.isPaused()) {
            this.executeOnLooper(new UnPauseRunnable());
        }
        MessageQueue messageQueue = this.realLooper.getQueue();
        synchronized (messageQueue) {
            ShadowPausedLooper.drainQueueSafely(this.shadowQueue());
            ((LooperReflector)Reflector.reflector(LooperReflector.class, (Object)this.realLooper)).quit();
        }
    }

    @Implementation
    protected void quitSafely() {
        if (this.isPaused()) {
            this.executeOnLooper(new UnPauseRunnable());
        }
        ((LooperReflector)Reflector.reflector(LooperReflector.class, (Object)this.realLooper)).quitSafely();
    }

    @Override
    public Scheduler getScheduler() {
        throw new UnsupportedOperationException(String.format("this action is not supported in %s mode.", ShadowPausedLooper.looperMode()));
    }

    private static ShadowPausedMessage shadowMsg(Message msg) {
        return (ShadowPausedMessage)Shadow.extract((Object)msg);
    }

    private ShadowPausedMessageQueue shadowQueue() {
        return (ShadowPausedMessageQueue)Shadow.extract((Object)this.realLooper.getQueue());
    }

    private void setLooperExecutor(Executor executor) {
        this.looperExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getNextExecutableMessage() {
        MessageQueue messageQueue = this.realLooper.getQueue();
        synchronized (messageQueue) {
            return this.shadowQueue().isIdle() ? null : this.shadowQueue().getNext();
        }
    }

    @Deprecated
    public static void setIgnoreUncaughtExceptions(boolean shouldIgnore) {
        ignoreUncaughtExceptions = shouldIgnore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static void loop() {
        try {
            ((LooperReflector)Reflector.reflector(LooperReflector.class)).loop();
        }
        catch (Exception e) {
            Looper realLooper = (Looper)Preconditions.checkNotNull((Object)Looper.myLooper());
            ShadowPausedMessageQueue shadowQueue = (ShadowPausedMessageQueue)Shadow.extract((Object)realLooper.getQueue());
            if (!ignoreUncaughtExceptions) {
                MessageQueue messageQueue = realLooper.getQueue();
                synchronized (messageQueue) {
                    shadowQueue.setUncaughtException(e);
                    ShadowPausedLooper.drainQueueSafely(shadowQueue);
                }
            }
            if (e instanceof ControlException) {
                ((ControlException)e).rethrowCause();
            }
            throw e;
        }
    }

    private static void drainQueueSafely(ShadowPausedMessageQueue shadowQueue) {
        shadowQueue.drainQueue((Predicate<Runnable>)((Predicate)input -> {
            if (input instanceof ControlRunnable) {
                ((ControlRunnable)input).runLatch.countDown();
                return true;
            }
            return false;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerIdleHandlersIfNeeded(Message lastMessageRead) {
        ArrayList<MessageQueue.IdleHandler> idleHandlers;
        MessageQueue messageQueue = this.realLooper.getQueue();
        synchronized (messageQueue) {
            if (lastMessageRead == null || !this.shadowQueue().isIdle()) {
                return;
            }
            idleHandlers = this.shadowQueue().getIdleHandlersCopy();
        }
        for (MessageQueue.IdleHandler idleHandler : idleHandlers) {
            if (idleHandler.queueIdle()) continue;
            this.realLooper.getQueue().removeIdleHandler(idleHandler);
        }
    }

    private void executeOnLooper(ControlRunnable runnable) throws IllegalStateException {
        Preconditions.checkState((!this.shadowQueue().isQuitting() ? 1 : 0) != 0, (Object)"Looper is quitting");
        if (Thread.currentThread() == this.realLooper.getThread()) {
            if (runnable instanceof UnPauseRunnable) {
                this.looperExecutor.execute(runnable);
            } else {
                try {
                    runnable.run();
                }
                catch (ControlException e) {
                    e.rethrowCause();
                }
            }
        } else {
            if (ShadowPausedLooper.looperMode() == LooperMode.Mode.PAUSED && this.realLooper.equals(Looper.getMainLooper())) {
                throw new UnsupportedOperationException("main looper can only be controlled from main thread");
            }
            this.looperExecutor.execute(runnable);
            runnable.waitTillComplete();
            this.shadowQueue().checkQueueState();
        }
    }

    static Handler createAsyncHandler(Looper looper) {
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            return Handler.createAsync((Looper)looper);
        }
        return new Handler(looper, null, true);
    }

    private static class HandlerExecutor
    implements Executor {
        private final Handler handler;

        private HandlerExecutor(Looper looper) {
            this.handler = ShadowPausedLooper.createAsyncHandler(looper);
        }

        @Override
        public void execute(Runnable runnable) {
            if (!this.handler.post(runnable)) {
                throw new IllegalStateException(String.format("post to %s failed. Is handler thread dead?", this.handler));
            }
        }
    }

    private class IdlingRunnable
    extends ControlRunnable {
        private IdlingRunnable() {
        }

        @Override
        public void doRun() {
            Message msg;
            while ((msg = ShadowPausedLooper.this.getNextExecutableMessage()) != null) {
                msg.getTarget().dispatchMessage(msg);
                ShadowPausedLooper.shadowMsg(msg).recycleUnchecked();
                ShadowPausedLooper.this.triggerIdleHandlersIfNeeded(msg);
            }
        }
    }

    private static abstract class ControlRunnable
    implements Runnable {
        protected final CountDownLatch runLatch = new CountDownLatch(1);
        private volatile RuntimeException exception;

        private ControlRunnable() {
        }

        @Override
        public void run() {
            boolean controlExceptionThrown = false;
            try {
                this.doRun();
            }
            catch (RuntimeException e) {
                if (!ignoreUncaughtExceptions) {
                    this.exception = e;
                }
                controlExceptionThrown = true;
                throw new ControlException(this, e);
            }
            finally {
                if (!controlExceptionThrown) {
                    this.runLatch.countDown();
                }
            }
        }

        protected abstract void doRun() throws RuntimeException;

        public void waitTillComplete() throws RuntimeException {
            try {
                this.runLatch.await();
            }
            catch (InterruptedException e) {
                Log.w((String)"ShadowPausedLooper", (String)"wait till idle interrupted");
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    private class UnPauseRunnable
    extends ControlRunnable {
        private UnPauseRunnable() {
        }

        @Override
        public void doRun() {
            ShadowPausedLooper.this.setLooperExecutor(new HandlerExecutor(ShadowPausedLooper.this.realLooper));
            ShadowPausedLooper.this.isPaused = false;
        }
    }

    private class PausedLooperExecutor
    extends ControlRunnable
    implements Executor {
        private final LinkedBlockingQueue<Runnable> executionQueue = new LinkedBlockingQueue();

        private PausedLooperExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            ShadowPausedLooper.this.shadowQueue().checkQueueState();
            this.executionQueue.add(runnable);
        }

        @Override
        public void run() {
            ShadowPausedLooper.this.setLooperExecutor(this);
            ShadowPausedLooper.this.isPaused = true;
            this.runLatch.countDown();
            while (ShadowPausedLooper.this.isPaused) {
                try {
                    Runnable runnable = this.executionQueue.take();
                    runnable.run();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        protected void doRun() throws RuntimeException {
            throw new UnsupportedOperationException();
        }
    }

    private class RunOneRunnable
    extends ControlRunnable {
        private RunOneRunnable() {
        }

        @Override
        public void doRun() {
            Message msg = ShadowPausedLooper.this.shadowQueue().getNextIgnoringWhen();
            if (msg != null) {
                SystemClock.setCurrentTimeMillis((long)ShadowPausedLooper.shadowMsg(msg).getWhen());
                msg.getTarget().dispatchMessage(msg);
                ShadowPausedLooper.this.triggerIdleHandlersIfNeeded(msg);
            }
        }
    }

    private class PostAndIdleToRunnable
    extends ControlRunnable {
        private final Runnable runnable;

        PostAndIdleToRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void doRun() {
            Message msg;
            new Handler(ShadowPausedLooper.this.realLooper).post(this.runnable);
            do {
                if ((msg = ShadowPausedLooper.this.getNextExecutableMessage()) == null) {
                    throw new IllegalStateException("Runnable is not in the queue");
                }
                msg.getTarget().dispatchMessage(msg);
                ShadowPausedLooper.this.triggerIdleHandlersIfNeeded(msg);
            } while (msg.getCallback() != this.runnable);
        }
    }

    private class PostAsyncAndIdleToRunnable
    extends ControlRunnable {
        private final Runnable runnable;
        private final Handler handler;

        PostAsyncAndIdleToRunnable(Runnable runnable) {
            this.runnable = runnable;
            this.handler = ShadowPausedLooper.createAsyncHandler(ShadowPausedLooper.this.realLooper);
        }

        @Override
        public void doRun() {
            Message msg;
            this.handler.postAtFrontOfQueue(this.runnable);
            do {
                if ((msg = ShadowPausedLooper.this.getNextExecutableMessage()) == null) {
                    throw new IllegalStateException("Runnable is not in the queue");
                }
                msg.getTarget().dispatchMessage(msg);
            } while (msg.getCallback() != this.runnable);
        }
    }

    @ForType(value=Looper.class)
    static interface LooperReflector {
        @Static
        @Direct
        public void prepareMainLooper();

        @Direct
        public void quit();

        @Direct
        public void quitSafely();

        @Direct
        public void loop();

        @Accessor(value="mThread")
        public void setThread(Thread var1);

        @Accessor(value="sThreadLocal")
        public ThreadLocal<Looper> getThreadLocal();
    }

    private static final class ControlException
    extends RuntimeException {
        private final ControlRunnable controlRunnable;

        ControlException(ControlRunnable controlRunnable, RuntimeException cause) {
            super(cause);
            this.controlRunnable = controlRunnable;
        }

        void rethrowCause() {
            this.controlRunnable.runLatch.countDown();
            throw (RuntimeException)this.getCause();
        }
    }
}

