/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.uwb.AdapterState;
import android.uwb.RangingSession;
import android.uwb.StateChangeReason;
import android.uwb.UwbManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowRangingSession;

@Implements(value=UwbManager.class, minSdk=31, isInAndroidSdk=false)
public class ShadowUwbManager {
    private static UwbManager.AdapterStateCallback callback;
    private static int adapterState;
    private static int stateChangedReason;
    private static PersistableBundle specificationInfo;
    private static List<PersistableBundle> chipInfos;
    private static ShadowRangingSession.Adapter adapter;

    @Implementation
    protected void registerAdapterStateCallback(Executor executor, UwbManager.AdapterStateCallback callback) {
        ShadowUwbManager.callback = callback;
        callback.onStateChanged(adapterState, stateChangedReason);
    }

    public void simulateAdapterStateChange(@AdapterState int state, @StateChangeReason int reason) {
        if (callback == null) {
            throw new IllegalArgumentException("AdapterStateCallback should not be null");
        }
        adapterState = state;
        stateChangedReason = reason;
        callback.onStateChanged(state, reason);
    }

    @Implementation
    protected PersistableBundle getSpecificationInfo() {
        return specificationInfo;
    }

    @Implementation
    @AdapterState
    protected int getAdapterState() {
        return adapterState;
    }

    @Implementation
    protected CancellationSignal openRangingSession(PersistableBundle params, Executor executor, RangingSession.Callback callback) {
        if (!this.isUwbEnabled()) {
            throw new IllegalStateException("Uwb is not enabled");
        }
        RangingSession session = ShadowRangingSession.newInstance(executor, callback, adapter);
        CancellationSignal cancellationSignal = new CancellationSignal();
        cancellationSignal.setOnCancelListener(() -> ((RangingSession)session).close());
        ((ShadowRangingSession)Shadow.extract((Object)session)).open(params);
        return cancellationSignal;
    }

    public void setUwbAdapter(ShadowRangingSession.Adapter adapter) {
        ShadowUwbManager.adapter = adapter;
    }

    public void setSpecificationInfo(PersistableBundle specificationInfo) {
        ShadowUwbManager.specificationInfo = new PersistableBundle(specificationInfo);
    }

    @Implementation(minSdk=33)
    protected CancellationSignal openRangingSession(PersistableBundle params, Executor executor, RangingSession.Callback callback, String chipId) {
        return this.openRangingSession(params, executor, callback);
    }

    @Implementation(minSdk=33)
    protected boolean isUwbEnabled() {
        return adapterState != 0;
    }

    @Implementation
    protected void setUwbEnabled(boolean enabled) {
        boolean stateChanged = false;
        if (enabled && adapterState == 0) {
            adapterState = 1;
            stateChanged = true;
        } else if (!enabled && adapterState != 0) {
            adapterState = 0;
            stateChanged = true;
        }
        if (callback != null && stateChanged) {
            callback.onStateChanged(adapterState, 2);
        }
    }

    @Implementation(minSdk=33)
    protected List<PersistableBundle> getChipInfos() {
        return ImmutableList.copyOf(chipInfos);
    }

    public void setChipInfos(List<PersistableBundle> chipInfos) {
        ShadowUwbManager.chipInfos = new ArrayList<PersistableBundle>(chipInfos);
    }

    @Resetter
    public static void reset() {
        callback = null;
        adapterState = 1;
        stateChangedReason = 2;
        specificationInfo = new PersistableBundle();
        if (chipInfos != null) {
            chipInfos.clear();
        }
        adapter = ShadowUwbManager.createDefaultAdapter();
    }

    private static ShadowRangingSession.Adapter createDefaultAdapter() {
        return new ShadowRangingSession.Adapter(){

            @Override
            public void onOpen(RangingSession session, RangingSession.Callback callback, PersistableBundle params) {
            }

            @Override
            public void onStart(RangingSession session, RangingSession.Callback callback, PersistableBundle params) {
            }

            @Override
            public void onReconfigure(RangingSession session, RangingSession.Callback callback, PersistableBundle params) {
            }

            @Override
            public void onStop(RangingSession session, RangingSession.Callback callback) {
            }

            @Override
            public void onClose(RangingSession session, RangingSession.Callback callback) {
            }
        };
    }

    static {
        adapterState = 1;
        stateChangedReason = 2;
        specificationInfo = new PersistableBundle();
        chipInfos = new ArrayList<PersistableBundle>();
        adapter = ShadowUwbManager.createDefaultAdapter();
    }
}

