/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.wearable.WearableSensingManager;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.SharedMemory;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=WearableSensingManager.class, minSdk=34, isInAndroidSdk=false)
public class ShadowWearableSensingManager {
    private static Integer provideDataStreamResult = 1;
    private static Integer provideDataResult = 1;
    private static final ArrayList<PersistableBundle> dataBundleList = new ArrayList();
    private static final ArrayList<SharedMemory> sharedMemoryList = new ArrayList();
    private static ParcelFileDescriptor lastParcelFileDescriptor;

    @Implementation
    protected void provideDataStream(ParcelFileDescriptor parcelFileDescriptor, Executor executor, Consumer<Integer> statusConsumer) {
        lastParcelFileDescriptor = parcelFileDescriptor;
        executor.execute(() -> statusConsumer.accept(provideDataStreamResult));
    }

    @Implementation
    protected void provideData(PersistableBundle data, SharedMemory sharedMemory, Executor executor, Consumer<Integer> statusConsumer) {
        dataBundleList.add(data);
        sharedMemoryList.add(sharedMemory);
        executor.execute(() -> statusConsumer.accept(provideDataResult));
    }

    public void setProvideDataStreamResult(Integer provideDataStreamResult) {
        ShadowWearableSensingManager.provideDataStreamResult = provideDataStreamResult;
    }

    public void setProvideDataResult(Integer provideDataResult) {
        ShadowWearableSensingManager.provideDataResult = provideDataResult;
    }

    public ParcelFileDescriptor getLastParcelFileDescriptor() {
        return lastParcelFileDescriptor;
    }

    public PersistableBundle getLastDataBundle() {
        return dataBundleList.isEmpty() ? null : (PersistableBundle)Iterables.getLast(dataBundleList);
    }

    public List<PersistableBundle> getAllDataBundles() {
        return new ArrayList<PersistableBundle>(dataBundleList);
    }

    public SharedMemory getLastSharedMemory() {
        return sharedMemoryList.isEmpty() ? null : (SharedMemory)Iterables.getLast(sharedMemoryList);
    }

    public List<SharedMemory> getAllSharedMemories() {
        return new ArrayList<SharedMemory>(sharedMemoryList);
    }

    @Resetter
    public static void reset() {
        provideDataStreamResult = 1;
        provideDataResult = 1;
        dataBundleList.clear();
        sharedMemoryList.clear();
        lastParcelFileDescriptor = null;
    }
}

