/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothProfileServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.google.common.base.Preconditions;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.BluetoothGattProxyDelegate;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

class IBluetoothManagerDelegates {
    private IBluetoothManagerDelegates() {
    }

    static Object createDelegate() {
        if (RuntimeEnvironment.getApiLevel() < 33) {
            return new IBluetoothManagerDelegateS();
        }
        return new IBluetoothManagerDelegate();
    }

    private static class IBluetoothManagerDelegateS
    extends IBluetoothManagerDelegateBase {
        private IBluetoothManagerDelegateS() {
        }

        public IBluetooth registerAdapter(IBluetoothManagerCallback callback) {
            IBinder btBinder = (IBinder)Preconditions.checkNotNull((Object)ServiceManager.getService((String)"bluetooth"));
            IBluetooth btService = (IBluetooth)Preconditions.checkNotNull((Object)IBluetooth.Stub.asInterface((IBinder)btBinder));
            ((IBluetoothManagerCallbackReflectorS)Reflector.reflector(IBluetoothManagerCallbackReflectorS.class, (Object)callback)).onBluetoothServiceUp(btService);
            return btService;
        }
    }

    private static class IBluetoothManagerDelegate
    extends IBluetoothManagerDelegateBase {
        private IBluetoothManagerDelegate() {
        }

        public boolean bindBluetoothProfileService(int bluetoothProfile, String serviceName, IBluetoothProfileServiceConnection proxy) {
            if (!BluetoothAdapter.getDefaultAdapter().isEnabled()) {
                return false;
            }
            try {
                proxy.onServiceConnected(null, null);
            }
            catch (RemoteException e) {
                return false;
            }
            return true;
        }

        public void unbindBluetoothProfileService(int bluetoothProfile, IBluetoothProfileServiceConnection proxy) {
            try {
                proxy.onServiceDisconnected(null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @ForType(value=IBluetoothManagerCallback.class)
    private static interface IBluetoothManagerCallbackReflectorS {
        public void onBluetoothServiceUp(IBluetooth var1);
    }

    private static class IBluetoothManagerDelegateBase {
        private IBluetoothGatt iBluetoothGatt;

        private IBluetoothManagerDelegateBase() {
        }

        public IBluetoothGatt getBluetoothGatt() {
            if (this.iBluetoothGatt == null) {
                this.iBluetoothGatt = BluetoothGattProxyDelegate.createBluetoothGattProxy();
            }
            return this.iBluetoothGatt;
        }
    }
}

