/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.app.SyncNotedAppOp;
import android.content.AttributionSource;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.util.ArrayMap;
import android.util.LongSparseArray;
import android.util.LongSparseLongArray;
import com.android.internal.app.IAppOpsService;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AutoValue_ShadowAppOpsManager_Key;
import org.robolectric.shadows.ShadowApplicationPackageManager;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AppOpsManager.class)
public class ShadowAppOpsManager {
    protected static final long OP_TIME = 1400000000L;
    protected static final long REJECT_TIME = 0L;
    protected static final int DURATION = 10;
    protected static final int PROXY_UID = 0;
    protected static final String PROXY_PACKAGE = "";
    @RealObject
    private AppOpsManager realObject;
    private static boolean staticallyInitialized;
    private static final Multimap<Key, Integer> storedOps;
    private static final Map<Key, Integer> appModeMap;
    private static final Set<Key> longRunningOp;
    private static final Map<AppOpsManager.OnOpChangedListener, Set<Key>> appOpListeners;
    private static final Map<Integer, ModeAndException> audioRestrictions;
    private Context context;

    @Implementation
    protected void __constructor__(Context context, IAppOpsService service) {
        this.context = context;
        Shadow.invokeConstructor(AppOpsManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(IAppOpsService.class, (Object)service)});
    }

    @Implementation
    protected static void __staticInitializer__() {
        staticallyInitialized = true;
        Shadow.directInitialize(AppOpsManager.class);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    public void setMode(String op, int uid, String packageName, int mode) {
        this.setMode(AppOpsManager.strOpToOp((String)op), uid, packageName, mode);
    }

    @Implementation
    @HiddenApi
    public void setMode(int op, int uid, String packageName, int mode) {
        Integer oldMode = appModeMap.put(Key.create(uid, packageName, op), mode);
        if (Objects.equals(oldMode, mode)) {
            return;
        }
        for (Map.Entry<AppOpsManager.OnOpChangedListener, Set<Key>> entry : appOpListeners.entrySet()) {
            for (Key key : entry.getValue()) {
                if (op != key.getOpCode() || key.getPackageName() != null && !key.getPackageName().equals(packageName)) continue;
                entry.getKey().onOpChanged(this.getOpString(op), packageName);
            }
        }
    }

    @Implementation(minSdk=28)
    @HiddenApi
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_OPS_MODES")
    protected void setUidMode(String op, int uid, int mode) {
        this.setUidMode(AppOpsManager.strOpToOp((String)op), uid, mode);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected void setUidMode(int op, int uid, int mode) {
        Integer oldMode = appModeMap.put(Key.create(uid, null, op), mode);
        if (Objects.equals(oldMode, mode)) {
            return;
        }
        for (Map.Entry<AppOpsManager.OnOpChangedListener, Set<Key>> entry : appOpListeners.entrySet()) {
            for (Key key : entry.getValue()) {
                if (op != key.getOpCode()) continue;
                entry.getKey().onOpChanged(this.getOpString(op), null);
            }
        }
    }

    protected String getOpString(int opCode) {
        if (RuntimeEnvironment.getApiLevel() <= 33) {
            String[] sOpToString = (String[])ReflectionHelpers.getStaticField(AppOpsManager.class, (String)"sOpToString");
            return sOpToString[opCode];
        }
        Object[] sAppOpInfos = (Object[])ReflectionHelpers.getStaticField(AppOpsManager.class, (String)"sAppOpInfos");
        return ((AppOpInfoReflector)Reflector.reflector(AppOpInfoReflector.class, (Object)sAppOpInfos[opCode])).getName();
    }

    @Implementation(minSdk=29)
    @HiddenApi
    @SystemApi
    @NonNull
    protected List<AppOpsManager.PackageOps> getPackagesForOps(@Nullable String[] ops) {
        List<Object> result = null;
        if (ops == null) {
            int[] intOps = null;
            result = this.getPackagesForOps(intOps);
        } else {
            ArrayList<Integer> intOpsList = new ArrayList<Integer>();
            for (String op : ops) {
                intOpsList.add(AppOpsManager.strOpToOp((String)op));
            }
            result = this.getPackagesForOps(intOpsList.stream().mapToInt(i -> i).toArray());
        }
        return result != null ? result : new ArrayList();
    }

    @Implementation
    @HiddenApi
    protected List<AppOpsManager.PackageOps> getPackagesForOps(int[] ops) {
        Set<Object> relevantOps = ops != null ? IntStream.of(ops).boxed().collect(Collectors.toSet()) : new HashSet();
        SetMultimap perPackageMap = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Map.Entry<Key, Integer> appOpInfo : appModeMap.entrySet()) {
            Key key = appOpInfo.getKey();
            if (ops != null && !relevantOps.contains(key.getOpCode())) continue;
            Key packageKey = Key.create(key.getUid(), key.getPackageName(), null);
            AppOpsManager.OpEntry opEntry = this.toOpEntry(key.getOpCode(), appOpInfo.getValue());
            perPackageMap.put((Object)packageKey, (Object)opEntry);
        }
        ArrayList<AppOpsManager.PackageOps> result = new ArrayList<AppOpsManager.PackageOps>();
        for (Map.Entry packageInfo : perPackageMap.asMap().entrySet()) {
            Key key = (Key)packageInfo.getKey();
            result.add(new AppOpsManager.PackageOps(key.getPackageName(), key.getUid().intValue(), new ArrayList((Collection)packageInfo.getValue())));
        }
        return result.isEmpty() ? null : result;
    }

    @Implementation(minSdk=29)
    public int unsafeCheckOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp((String)op), uid, packageName);
    }

    @Implementation(minSdk=30)
    protected int unsafeCheckOpRawNoThrow(int op, int uid, String packageName) {
        Integer mode = appModeMap.get(Key.create(uid, packageName, op));
        if (mode != null) {
            return mode;
        }
        mode = appModeMap.get(Key.create(uid, null, op));
        if (mode != null) {
            return mode;
        }
        return 0;
    }

    @Implementation(minSdk=29)
    public int unsafeCheckOpRawNoThrow(String op, int uid, String packageName) {
        return this.unsafeCheckOpRawNoThrow(AppOpsManager.strOpToOp((String)op), uid, packageName);
    }

    @Implementation(minSdk=30)
    protected int startOp(String op, int uid, String packageName, String attributionTag, String message) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        if (mode == 0) {
            longRunningOp.add(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
        }
        return mode;
    }

    @Implementation(maxSdk=29)
    protected int startOpNoThrow(int op, int uid, String packageName) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        if (mode == 0) {
            longRunningOp.add(Key.create(uid, packageName, op));
        }
        return mode;
    }

    @Implementation(minSdk=30)
    protected int startOpNoThrow(String op, int uid, String packageName, String attributionTag, String message) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        if (mode == 0) {
            longRunningOp.add(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
        }
        return mode;
    }

    @Implementation(maxSdk=29)
    protected void finishOp(int op, int uid, String packageName) {
        longRunningOp.remove(Key.create(uid, packageName, op));
    }

    @Implementation(minSdk=30)
    protected void finishOp(String op, int uid, String packageName, String attributionTag) {
        longRunningOp.remove(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
    }

    @Implementation(minSdk=30)
    protected int checkOp(String op, int uid, String packageName) {
        return this.checkOpNoThrow(op, uid, packageName);
    }

    @Implementation(minSdk=30)
    public boolean isOpActive(String op, int uid, String packageName) {
        return longRunningOp.contains(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
    }

    @Implementation(minSdk=28)
    @Deprecated
    protected int checkOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp((String)op), uid, packageName);
    }

    @Implementation
    @HiddenApi
    public int checkOpNoThrow(int op, int uid, String packageName) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        return mode == 4 ? 0 : mode;
    }

    @Implementation
    public int noteOp(int op, int uid, String packageName) {
        return this.noteOpInternal(op, uid, packageName, PROXY_PACKAGE, PROXY_PACKAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int noteOpInternal(int op, int uid, String packageName, String attributionTag, String message) {
        storedOps.put((Object)Key.create(uid, packageName, null), (Object)op);
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            Object lock;
            Object object = lock = ReflectionHelpers.getStaticField(AppOpsManager.class, (String)"sLock");
            synchronized (object) {
                AppOpsManager.OnOpNotedCallback callback = (AppOpsManager.OnOpNotedCallback)ReflectionHelpers.getStaticField(AppOpsManager.class, (String)"sOnOpNotedCallback");
                if (callback != null) {
                    callback.onSelfNoted(new SyncNotedAppOp(op, attributionTag));
                }
            }
        }
        return 0;
    }

    @Implementation(minSdk=30)
    protected int noteOp(int op, int uid, String packageName, String attributionTag, String message) {
        return this.noteOpInternal(op, uid, packageName, attributionTag, message);
    }

    @Implementation
    protected int noteOpNoThrow(int op, int uid, String packageName) {
        storedOps.put((Object)Key.create(uid, packageName, null), (Object)op);
        return this.checkOpNoThrow(op, uid, packageName);
    }

    @Implementation(minSdk=30)
    protected int noteOpNoThrow(int op, int uid, @Nullable String packageName, @Nullable String attributionTag, @Nullable String message) {
        return this.noteOpNoThrow(op, uid, packageName);
    }

    @Implementation(minSdk=23, maxSdk=29)
    @HiddenApi
    protected int noteProxyOpNoThrow(int op, String proxiedPackageName) {
        storedOps.put((Object)Key.create(Binder.getCallingUid(), proxiedPackageName, null), (Object)op);
        return this.checkOpNoThrow(op, Binder.getCallingUid(), proxiedPackageName);
    }

    @Implementation(minSdk=29, maxSdk=29)
    @HiddenApi
    protected int noteProxyOpNoThrow(int op, String proxiedPackageName, int proxiedUid) {
        storedOps.put((Object)Key.create(proxiedUid, proxiedPackageName, null), (Object)op);
        return this.checkOpNoThrow(op, proxiedUid, proxiedPackageName);
    }

    @Implementation(minSdk=30, maxSdk=30)
    @HiddenApi
    protected int noteProxyOpNoThrow(int op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        storedOps.put((Object)Key.create(proxiedUid, proxiedPackageName, null), (Object)op);
        return this.checkOpNoThrow(op, proxiedUid, proxiedPackageName);
    }

    @Implementation(minSdk=31)
    @RequiresApi(api=31)
    protected int noteProxyOpNoThrow(int op, @ClassName(value="android.content.AttributionSource") @ClassName(value="android.content.AttributionSource") Object attributionSource, String message, boolean skipProxyOperation) {
        Preconditions.checkArgument((boolean)(attributionSource instanceof AttributionSource));
        AttributionSource castedAttributionSource = (AttributionSource)attributionSource;
        return this.noteProxyOpNoThrow(op, castedAttributionSource.getNextPackageName(), castedAttributionSource.getNextUid(), castedAttributionSource.getNextAttributionTag(), message);
    }

    @Implementation
    @HiddenApi
    public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        HashSet<Integer> opFilter = new HashSet<Integer>();
        if (ops != null) {
            for (int op : ops) {
                opFilter.add(op);
            }
        }
        ArrayList<AppOpsManager.OpEntry> opEntries = new ArrayList<AppOpsManager.OpEntry>();
        for (Integer op : storedOps.get((Object)Key.create(uid, packageName, null))) {
            if (!opFilter.isEmpty() && !opFilter.contains(op)) continue;
            opEntries.add(this.toOpEntry(op, 0));
        }
        return ImmutableList.of((Object)new AppOpsManager.PackageOps(packageName, uid, opEntries));
    }

    @Implementation(minSdk=29)
    @HiddenApi
    @SystemApi
    @RequiresPermission(value="android.permission.GET_APP_OPS_STATS")
    protected List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, String[] ops) {
        if (ops == null) {
            int[] intOps = null;
            return this.getOpsForPackage(uid, packageName, intOps);
        }
        Map strOpToIntOp = (Map)ReflectionHelpers.getStaticField(AppOpsManager.class, (String)"sOpStrToOp");
        ArrayList<Integer> intOpsList = new ArrayList<Integer>();
        for (String op : ops) {
            Integer intOp = (Integer)strOpToIntOp.get(op);
            if (intOp == null) continue;
            intOpsList.add(intOp);
        }
        return this.getOpsForPackage(uid, packageName, intOpsList.stream().mapToInt(i -> i).toArray());
    }

    @Implementation
    protected void checkPackage(int uid, String packageName) {
        try {
            ShadowApplicationPackageManager shadowApplicationPackageManager = (ShadowApplicationPackageManager)Shadow.extract((Object)this.context.getPackageManager());
            int packageUid = shadowApplicationPackageManager.getPackageUid(packageName, 0);
            if (packageUid == uid) {
                return;
            }
            throw new SecurityException("Package " + packageName + " belongs to " + packageUid);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException("Package " + packageName + " doesn't belong to " + uid, e);
        }
    }

    @Implementation
    @HiddenApi
    public void setRestriction(int code, int usage, int mode, String[] exceptionPackages) {
        audioRestrictions.put(ShadowAppOpsManager.getAudioRestrictionKey(code, usage), new ModeAndException(mode, exceptionPackages));
    }

    @Nullable
    public ModeAndException getRestriction(int code, int usage) {
        return audioRestrictions.get(ShadowAppOpsManager.getAudioRestrictionKey(code, usage));
    }

    @Implementation
    protected void startWatchingMode(int op, String packageName, AppOpsManager.OnOpChangedListener callback) {
        this.startWatchingModeImpl(op, packageName, 0, callback);
    }

    @Implementation(minSdk=29)
    protected void startWatchingMode(int op, String packageName, int flags, AppOpsManager.OnOpChangedListener callback) {
        this.startWatchingModeImpl(op, packageName, flags, callback);
    }

    private void startWatchingModeImpl(int op, String packageName, int flags, AppOpsManager.OnOpChangedListener callback) {
        Set<Key> keys = appOpListeners.get(callback);
        if (keys == null) {
            keys = new HashSet<Key>();
            appOpListeners.put(callback, keys);
        }
        keys.add(Key.create(null, packageName, op));
    }

    @Implementation
    protected void stopWatchingMode(AppOpsManager.OnOpChangedListener callback) {
        appOpListeners.remove(callback);
    }

    protected AppOpsManager.OpEntry toOpEntry(Integer op, int mode) {
        if (RuntimeEnvironment.getApiLevel() < 23) {
            return (AppOpsManager.OpEntry)ReflectionHelpers.callConstructor(AppOpsManager.OpEntry.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)op), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)1400000000L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)10)});
        }
        if (RuntimeEnvironment.getApiLevel() < 29) {
            return (AppOpsManager.OpEntry)ReflectionHelpers.callConstructor(AppOpsManager.OpEntry.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)op), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)1400000000L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)10), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(String.class, (Object)PROXY_PACKAGE)});
        }
        if (RuntimeEnvironment.getApiLevel() < 30) {
            long key = AppOpsManager.makeKey((int)200, (int)1);
            LongSparseLongArray accessTimes = new LongSparseLongArray();
            accessTimes.put(key, 1400000000L);
            LongSparseLongArray rejectTimes = new LongSparseLongArray();
            rejectTimes.put(key, 0L);
            LongSparseLongArray durations = new LongSparseLongArray();
            durations.put(key, 10L);
            LongSparseLongArray proxyUids = new LongSparseLongArray();
            proxyUids.put(key, 0L);
            LongSparseArray proxyPackages = new LongSparseArray();
            proxyPackages.put(key, (Object)PROXY_PACKAGE);
            return (AppOpsManager.OpEntry)ReflectionHelpers.callConstructor(AppOpsManager.OpEntry.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)op), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)accessTimes), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)rejectTimes), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)durations), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)proxyUids), ReflectionHelpers.ClassParameter.from(LongSparseArray.class, (Object)proxyPackages)});
        }
        long key = AppOpsManager.makeKey((int)200, (int)1);
        LongSparseArray accessEvents = new LongSparseArray();
        LongSparseArray rejectEvents = new LongSparseArray();
        accessEvents.put(key, (Object)new AppOpsManager.NoteOpEvent(1400000000L, 10L, new AppOpsManager.OpEventProxyInfo(0, PROXY_PACKAGE, null)));
        rejectEvents.put(key, (Object)new AppOpsManager.NoteOpEvent(0L, -1L, null));
        return new AppOpsManager.OpEntry(op.intValue(), mode, Collections.singletonMap(null, new AppOpsManager.AttributedOpEntry(op.intValue(), false, accessEvents, rejectEvents)));
    }

    private static int getAudioRestrictionKey(int code, int usage) {
        return code | usage << 8;
    }

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() >= 30 && staticallyInitialized) {
            ReflectionHelpers.setStaticField(AppOpsManager.class, (String)"sOnOpNotedCallback", null);
        }
        storedOps.clear();
        appModeMap.clear();
        longRunningOp.clear();
        appOpListeners.clear();
        audioRestrictions.clear();
    }

    static {
        storedOps = HashMultimap.create();
        appModeMap = new HashMap<Key, Integer>();
        longRunningOp = new HashSet<Key>();
        appOpListeners = new ArrayMap();
        audioRestrictions = new HashMap<Integer, ModeAndException>();
    }

    @AutoValue
    static abstract class Key {
        Key() {
        }

        @Nullable
        abstract Integer getUid();

        @Nullable
        abstract String getPackageName();

        @Nullable
        abstract Integer getOpCode();

        static Key create(Integer uid, String packageName, Integer opCode) {
            return new AutoValue_ShadowAppOpsManager_Key(uid, packageName, opCode);
        }
    }

    @ForType(className="android.app.AppOpInfo")
    static interface AppOpInfoReflector {
        @Accessor(value="name")
        public String getName();
    }

    public static class ModeAndException {
        public final int mode;
        public final List<String> exceptionPackages;

        public ModeAndException(int mode, String[] exceptionPackages) {
            this.mode = mode;
            this.exceptionPackages = exceptionPackages == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(exceptionPackages));
        }
    }
}

