/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresApi;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioRouting;
import android.media.AudioTrack;
import android.media.PlaybackParams;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AudioTrack.class)
public class ShadowAudioTrack {
    protected static final int DEFAULT_MIN_BUFFER_SIZE = 1024;
    private static final int AUDIOTRACK_ERROR_SETUP_NATIVEINITFAILED = -20;
    private static final String TAG = "ShadowAudioTrack";
    private static final Multimap<AudioFormatInfo, AudioAttributesInfo> directSupportedFormats = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private static final Set<Integer> allowedNonPcmEncodings = Collections.synchronizedSet(new HashSet());
    private static AudioDeviceInfo routedDevice;
    private static final Set<OnRoutingChangedListenerInfo> onRoutingChangedListeners;
    private static final List<OnAudioDataWrittenListener> audioDataWrittenListeners;
    private static int minBufferSize;
    private static boolean illegalStateOnPlayEnabled;
    private int numBytesReceived;
    private PlaybackParams playbackParams;
    @RealObject
    AudioTrack audioTrack;

    public static void setMinBufferSize(int bufferSize) {
        minBufferSize = bufferSize;
    }

    public static void addDirectPlaybackSupport(@NonNull AudioFormat format, @NonNull AudioAttributes attr) {
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkNotNull((Object)attr);
        Preconditions.checkArgument((!ShadowAudioTrack.isPcm(format.getEncoding()) ? 1 : 0) != 0);
        directSupportedFormats.put((Object)new AudioFormatInfo(format.getEncoding(), format.getSampleRate(), format.getChannelMask(), format.getChannelIndexMask()), (Object)new AudioAttributesInfo(attr.getContentType(), attr.getUsage(), attr.getFlags()));
    }

    public static void clearDirectPlaybackSupportedFormats() {
        directSupportedFormats.clear();
    }

    public static void addAllowedNonPcmEncoding(int encoding) {
        Preconditions.checkArgument((!ShadowAudioTrack.isPcm(encoding) ? 1 : 0) != 0);
        allowedNonPcmEncodings.add(encoding);
    }

    public static void clearAllowedNonPcmEncodings() {
        allowedNonPcmEncodings.clear();
    }

    @RequiresApi(value=24)
    public static void setRoutedDevice(@Nullable AudioDeviceInfo routedDevice) {
        if (Objects.equals(routedDevice, ShadowAudioTrack.routedDevice)) {
            return;
        }
        ShadowAudioTrack.routedDevice = routedDevice;
        for (OnRoutingChangedListenerInfo listenerInfo : onRoutingChangedListeners) {
            listenerInfo.callListener();
        }
    }

    @Implementation(minSdk=24, maxSdk=28)
    protected static int native_get_FCC_8() {
        return 8;
    }

    @Implementation(minSdk=29)
    protected static boolean native_is_direct_output_supported(int encoding, int sampleRate, int channelMask, int channelIndexMask, int contentType, int usage, int flags) {
        return directSupportedFormats.containsEntry((Object)new AudioFormatInfo(encoding, sampleRate, channelMask, channelIndexMask), (Object)new AudioAttributesInfo(contentType, usage, flags));
    }

    @Implementation
    protected static int native_get_min_buff_size(int sampleRateInHz, int channelConfig, int audioFormat) {
        return minBufferSize;
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, long nativeAudioTrack, boolean offload) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=30, maxSdk=30)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, long nativeAudioTrack, boolean offload, int encapsulationMode, Object tunerConfiguration) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=31, maxSdk=33)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, long nativeAudioTrack, boolean offload, int encapsulationMode, Object tunerConfiguration, String opPackageName) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=34)
    protected int native_setup(Object audioTrack, Object attributes, int[] sampleRate, int channelMask, int channelIndexMask, int audioFormat, int buffSizeInBytes, int mode, int[] sessionId, @NonNull Parcel attributionSource, long nativeAudioTrack, boolean offload, int encapsulationMode, Object tunerConfiguration, @NonNull String opPackageName) {
        if (!(offload || ShadowAudioTrack.isPcm(audioFormat) || allowedNonPcmEncodings.contains(audioFormat))) {
            return -20;
        }
        return 0;
    }

    @Implementation(minSdk=23)
    protected int native_write_byte(byte[] audioData, int offsetInBytes, int sizeInBytes, int format, boolean isBlocking) {
        byte[] dataToWrite = new byte[sizeInBytes];
        System.arraycopy(audioData, offsetInBytes, dataToWrite, 0, sizeInBytes);
        return this.maybeWriteBytes(dataToWrite);
    }

    @Implementation(minSdk=23, maxSdk=28)
    protected int native_write_native_bytes(Object audioData, int positionInBytes, int sizeInBytes, int format, boolean blocking) {
        return this.maybeWriteBytes((ByteBuffer)audioData, sizeInBytes);
    }

    @Implementation(minSdk=29)
    protected int native_write_native_bytes(ByteBuffer audioData, int positionInBytes, int sizeInBytes, int format, boolean blocking) {
        return this.maybeWriteBytes(audioData, sizeInBytes);
    }

    private int maybeWriteBytes(ByteBuffer audioData, int sizeInBytes) {
        int previousPosition = audioData.position();
        byte[] dataToWrite = new byte[sizeInBytes];
        audioData.get(dataToWrite);
        audioData.position(previousPosition);
        return this.maybeWriteBytes(dataToWrite);
    }

    private int maybeWriteBytes(byte[] audioData) {
        int encoding = this.audioTrack.getAudioFormat();
        if (!(Build.VERSION.SDK_INT >= 29 && this.audioTrack.isOffloadedPlayback() || ShadowAudioTrack.isPcm(encoding) || allowedNonPcmEncodings.contains(encoding))) {
            return -6;
        }
        this.numBytesReceived += audioData.length;
        for (OnAudioDataWrittenListener listener : audioDataWrittenListeners) {
            listener.onAudioDataWritten(this, audioData, this.audioTrack.getFormat());
        }
        return audioData.length;
    }

    @Implementation(minSdk=24)
    protected AudioDeviceInfo getRoutedDevice() {
        return routedDevice;
    }

    @Implementation(minSdk=24)
    protected void addOnRoutingChangedListener(@NonNull AudioRouting.OnRoutingChangedListener listener, Handler handler) {
        OnRoutingChangedListenerInfo listenerInfo = new OnRoutingChangedListenerInfo(listener, this.audioTrack, handler);
        onRoutingChangedListeners.add(listenerInfo);
        if (routedDevice != null) {
            listenerInfo.callListener();
        }
    }

    @Implementation(minSdk=24)
    protected void removeOnRoutingChangedListener(@NonNull AudioRouting.OnRoutingChangedListener listener) {
        onRoutingChangedListeners.removeIf(registeredListener -> ((OnRoutingChangedListenerInfo)registeredListener).listener.equals(listener));
    }

    @Implementation(minSdk=23)
    public void setPlaybackParams(@NonNull PlaybackParams params) {
        this.playbackParams = (PlaybackParams)Preconditions.checkNotNull((Object)params, (Object)"Illegal null params");
    }

    @Implementation(minSdk=23)
    @NonNull
    protected PlaybackParams getPlaybackParams() {
        return this.playbackParams;
    }

    @Implementation
    protected int getPlaybackHeadPosition() {
        return this.numBytesReceived / this.audioTrack.getFormat().getFrameSizeInBytes();
    }

    @Implementation
    protected void play() {
        if (illegalStateOnPlayEnabled) {
            throw new IllegalStateException("illegalStateOnPlayEnabled == true");
        }
        Shadow.directlyOn((Object)this.audioTrack, AudioTrack.class, (String)"play", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    protected void flush() {
        this.numBytesReceived = 0;
    }

    public static void addAudioDataListener(OnAudioDataWrittenListener listener) {
        audioDataWrittenListeners.add(listener);
    }

    public static void removeAudioDataListener(OnAudioDataWrittenListener listener) {
        audioDataWrittenListeners.remove(listener);
    }

    public static void enableIllegalStateOnPlay(boolean enabled) {
        illegalStateOnPlayEnabled = enabled;
    }

    @Resetter
    public static void resetTest() {
        audioDataWrittenListeners.clear();
        ShadowAudioTrack.clearDirectPlaybackSupportedFormats();
        ShadowAudioTrack.clearAllowedNonPcmEncodings();
        routedDevice = null;
        illegalStateOnPlayEnabled = false;
    }

    private static boolean isPcm(int encoding) {
        switch (encoding) {
            case 2: 
            case 3: 
            case 4: 
            case 21: 
            case 22: {
                return true;
            }
        }
        return false;
    }

    static {
        onRoutingChangedListeners = new CopyOnWriteArraySet<OnRoutingChangedListenerInfo>();
        audioDataWrittenListeners = new CopyOnWriteArrayList<OnAudioDataWrittenListener>();
        minBufferSize = 1024;
        illegalStateOnPlayEnabled = false;
    }

    private static class AudioFormatInfo {
        private final int encoding;
        private final int sampleRate;
        private final int channelMask;
        private final int channelIndexMask;

        public AudioFormatInfo(int encoding, int sampleRate, int channelMask, int channelIndexMask) {
            this.encoding = encoding;
            this.sampleRate = sampleRate;
            this.channelMask = channelMask;
            this.channelIndexMask = channelIndexMask;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AudioFormatInfo)) {
                return false;
            }
            AudioFormatInfo other = (AudioFormatInfo)o;
            return this.encoding == other.encoding && this.sampleRate == other.sampleRate && this.channelMask == other.channelMask && this.channelIndexMask == other.channelIndexMask;
        }

        public int hashCode() {
            int result = this.encoding;
            result = 31 * result + this.sampleRate;
            result = 31 * result + this.channelMask;
            result = 31 * result + this.channelIndexMask;
            return result;
        }
    }

    private static class AudioAttributesInfo {
        private final int contentType;
        private final int usage;
        private final int flags;

        public AudioAttributesInfo(int contentType, int usage, int flags) {
            this.contentType = contentType;
            this.usage = usage;
            this.flags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AudioAttributesInfo)) {
                return false;
            }
            AudioAttributesInfo other = (AudioAttributesInfo)o;
            return this.contentType == other.contentType && this.usage == other.usage && this.flags == other.flags;
        }

        public int hashCode() {
            int result = this.contentType;
            result = 31 * result + this.usage;
            result = 31 * result + this.flags;
            return result;
        }
    }

    private static final class OnRoutingChangedListenerInfo {
        private final AudioRouting.OnRoutingChangedListener listener;
        private final AudioTrack audioTrack;
        private final Handler handler;

        public OnRoutingChangedListenerInfo(AudioRouting.OnRoutingChangedListener listener, AudioTrack audioTrack, Handler handler) {
            this.listener = listener;
            this.audioTrack = audioTrack;
            this.handler = handler;
        }

        public void callListener() {
            this.handler.post(() -> this.listener.onRoutingChanged((AudioRouting)this.audioTrack));
        }
    }

    public static interface OnAudioDataWrittenListener {
        public void onAudioDataWritten(ShadowAudioTrack var1, byte[] var2, AudioFormat var3);
    }
}

