/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.Nullable;
import android.app.ActivityThread;
import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.CompanionDeviceManager;
import android.companion.DeviceNotAssociatedException;
import android.content.ComponentName;
import android.net.MacAddress;
import android.os.Handler;
import android.os.Process;
import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AssociationInfoBuilder;
import org.robolectric.shadows.AutoValue_ShadowCompanionDeviceManager_RoboAssociationInfo;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=CompanionDeviceManager.class, minSdk=26)
public class ShadowCompanionDeviceManager {
    private final Set<RoboAssociationInfo> associations = new HashSet<RoboAssociationInfo>();
    private final Set<ComponentName> hasNotificationAccess = new HashSet<ComponentName>();
    private ComponentName lastRequestedNotificationAccess;
    private AssociationRequest lastAssociationRequest;
    private MacAddress lastSystemApiAssociationMacAddress;
    private CompanionDeviceManager.Callback lastAssociationCallback;
    private String lastObservingDevicePresenceDeviceAddress;
    private static final int DEFAULT_SYSTEMDATASYNCFLAGS = -1;

    @Implementation
    protected List<String> getAssociations() {
        return ImmutableList.copyOf((Collection)this.associations.stream().map(RoboAssociationInfo::deviceMacAddress).collect(Collectors.toList()));
    }

    public void addAssociation(String newAssociation) {
        this.associations.add(RoboAssociationInfo.builder().setDeviceMacAddress(newAssociation).build());
    }

    public void addAssociation(AssociationInfo info) {
        this.associations.add(this.createShadowAssociationInfo(info));
    }

    @Implementation
    protected void disassociate(String deviceMacAddress) {
        RoboAssociationInfo associationInfo = this.associations.stream().filter(association -> Ascii.equalsIgnoreCase((CharSequence)deviceMacAddress, (CharSequence)association.deviceMacAddress())).findFirst().orElseThrow(() -> new IllegalArgumentException("Association does not exist"));
        this.associations.remove(associationInfo);
    }

    @Implementation(minSdk=33)
    protected void disassociate(int associationId) {
        RoboAssociationInfo associationInfo = this.associations.stream().filter(association -> associationId == association.id()).findFirst().orElseThrow(() -> new IllegalArgumentException("Association does not exist"));
        this.associations.remove(associationInfo);
    }

    @Implementation
    protected boolean hasNotificationAccess(ComponentName component) {
        this.checkHasAssociation();
        return this.hasNotificationAccess.contains(component);
    }

    public void setNotificationAccess(ComponentName component, boolean hasAccess) {
        if (hasAccess) {
            this.hasNotificationAccess.add(component);
        } else {
            this.hasNotificationAccess.remove(component);
        }
    }

    @Implementation
    protected void requestNotificationAccess(ComponentName component) {
        this.checkHasAssociation();
        this.lastRequestedNotificationAccess = component;
    }

    @Implementation
    protected void associate(AssociationRequest request, CompanionDeviceManager.Callback callback, Handler handler) {
        this.lastAssociationRequest = request;
        this.lastAssociationCallback = callback;
    }

    @Implementation(minSdk=33)
    protected void associate(AssociationRequest request, Executor executor, CompanionDeviceManager.Callback callback) {
        this.associate(request, callback, null);
    }

    @Implementation(minSdk=33)
    protected void associate(String packageName, MacAddress macAddress, byte[] certificate) {
        this.lastSystemApiAssociationMacAddress = macAddress;
        if (!ShadowCompanionDeviceManager.checkPermission("android.permission.ASSOCIATE_COMPANION_DEVICES")) {
            throw new SecurityException("Permission ASSOCIATE_COMPANION_DEVICES not granted");
        }
        if (!RuntimeEnvironment.getApplication().getPackageName().equals(packageName)) {
            throw new SecurityException("Calling application package does not equal packageName");
        }
        if (certificate == null) {
            throw new SecurityException("Certificate is null");
        }
        this.associations.add(RoboAssociationInfo.builder().setDeviceMacAddress(macAddress.toString()).build());
    }

    @Implementation(minSdk=33)
    protected void startObservingDevicePresence(String deviceAddress) {
        this.lastObservingDevicePresenceDeviceAddress = deviceAddress;
        for (RoboAssociationInfo association : this.associations) {
            if (association.deviceMacAddress() == null || !Ascii.equalsIgnoreCase((CharSequence)deviceAddress, (CharSequence)association.deviceMacAddress())) continue;
            return;
        }
        throw new DeviceNotAssociatedException("Association does not exist");
    }

    public AssociationRequest getLastAssociationRequest() {
        return this.lastAssociationRequest;
    }

    public CompanionDeviceManager.Callback getLastAssociationCallback() {
        return this.lastAssociationCallback;
    }

    public ComponentName getLastRequestedNotificationAccess() {
        return this.lastRequestedNotificationAccess;
    }

    public MacAddress getLastSystemApiAssociationMacAddress() {
        return this.lastSystemApiAssociationMacAddress;
    }

    public String getLastObservingDevicePresenceDeviceAddress() {
        return this.lastObservingDevicePresenceDeviceAddress;
    }

    private void checkHasAssociation() {
        if (this.associations.isEmpty()) {
            throw new IllegalStateException("App must have an association before calling this API");
        }
    }

    @Implementation(minSdk=33)
    protected List<AssociationInfo> getMyAssociations() {
        return this.associations.stream().map(this::createAssociationInfo).collect(Collectors.toCollection(ArrayList::new));
    }

    private AssociationInfo createAssociationInfo(RoboAssociationInfo info) {
        AssociationInfoBuilder aiBuilder = AssociationInfoBuilder.newBuilder().setId(info.id()).setUserId(info.userId()).setPackageName(info.packageName()).setDeviceMacAddress(info.deviceMacAddress()).setDisplayName(info.displayName()).setDeviceProfile(info.deviceProfile()).setAssociatedDevice(info.associatedDevice()).setSelfManaged(info.selfManaged()).setNotifyOnDeviceNearby(info.notifyOnDeviceNearby()).setApprovedMs(info.timeApprovedMs()).setLastTimeConnectedMs(info.lastTimeConnectedMs());
        if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mTag")) {
            ReflectionHelpers.callInstanceMethod((Object)aiBuilder, (String)"setTag", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)info.tag())});
        }
        if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mAssociatedDevice")) {
            ReflectionHelpers.callInstanceMethod((Object)aiBuilder, (String)"setAssociatedDevice", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Object.class, (Object)info.associatedDevice())});
            ReflectionHelpers.callInstanceMethod((Object)aiBuilder, (String)"setSystemDataSyncFlags", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)info.systemDataSyncFlags())});
        }
        if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mRevoked")) {
            ReflectionHelpers.callInstanceMethod((Object)aiBuilder, (String)"setRevoked", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)info.revoked())});
        }
        return aiBuilder.build();
    }

    private RoboAssociationInfo createShadowAssociationInfo(AssociationInfo info) {
        Object associatedDevice = null;
        int systemDataSyncFlags = -1;
        if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mAssociatedDevice")) {
            associatedDevice = ReflectionHelpers.callInstanceMethod((Object)info, (String)"getAssociatedDevice", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            systemDataSyncFlags = (Integer)ReflectionHelpers.callInstanceMethod((Object)info, (String)"getSystemDataSyncFlags", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        boolean revoked = false;
        if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mRevoked")) {
            revoked = (Boolean)ReflectionHelpers.callInstanceMethod((Object)info, (String)"isRevoked", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        String tag = "";
        if (ReflectionHelpers.hasField(AssociationInfo.class, (String)"mTag")) {
            tag = (String)ReflectionHelpers.callInstanceMethod((Object)info, (String)"getTag", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        return RoboAssociationInfo.create(info.getId(), info.getUserId(), info.getPackageName(), tag, info.getDeviceMacAddress() == null ? null : info.getDeviceMacAddress().toString(), info.getDisplayName(), info.getDeviceProfile(), associatedDevice, info.isSelfManaged(), info.isNotifyOnDeviceNearby(), revoked, info.getTimeApprovedMs(), (Long)ReflectionHelpers.callInstanceMethod((Object)info, (String)"getLastTimeConnectedMs", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), systemDataSyncFlags);
    }

    private static boolean checkPermission(String permission2) {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        ShadowInstrumentation shadowInstrumentation = (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
        return shadowInstrumentation.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @AutoValue
    static abstract class RoboAssociationInfo {
        RoboAssociationInfo() {
        }

        public abstract int id();

        public abstract int userId();

        @Nullable
        public abstract String packageName();

        @Nullable
        public abstract String tag();

        @Nullable
        public abstract String deviceMacAddress();

        @Nullable
        public abstract CharSequence displayName();

        @Nullable
        public abstract String deviceProfile();

        @Nullable
        public abstract Object associatedDevice();

        public abstract boolean selfManaged();

        public abstract boolean notifyOnDeviceNearby();

        public abstract boolean revoked();

        public abstract long timeApprovedMs();

        public abstract long lastTimeConnectedMs();

        public abstract int systemDataSyncFlags();

        public static Builder builder() {
            return new AutoValue_ShadowCompanionDeviceManager_RoboAssociationInfo.Builder().setId(1).setUserId(1).setSelfManaged(false).setNotifyOnDeviceNearby(false).setRevoked(false).setAssociatedDevice(null).setTimeApprovedMs(0L).setLastTimeConnectedMs(0L).setSystemDataSyncFlags(-1);
        }

        public static RoboAssociationInfo create(int id2, int userId, String packageName, String tag, String deviceMacAddress, CharSequence displayName, String deviceProfile, Object associatedDevice, boolean selfManaged, boolean notifyOnDeviceNearby, boolean revoked, long timeApprovedMs, long lastTimeConnectedMs, int systemDataSyncFlags) {
            return RoboAssociationInfo.builder().setId(id2).setUserId(userId).setPackageName(packageName).setTag(tag).setDeviceMacAddress(deviceMacAddress).setDisplayName(displayName).setDeviceProfile(deviceProfile).setAssociatedDevice(associatedDevice).setSelfManaged(selfManaged).setNotifyOnDeviceNearby(notifyOnDeviceNearby).setTimeApprovedMs(timeApprovedMs).setRevoked(revoked).setLastTimeConnectedMs(lastTimeConnectedMs).setSystemDataSyncFlags(systemDataSyncFlags).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setId(int var1);

            public abstract Builder setUserId(int var1);

            public abstract Builder setPackageName(String var1);

            public abstract Builder setTag(String var1);

            public abstract Builder setDeviceMacAddress(String var1);

            public abstract Builder setDisplayName(CharSequence var1);

            public abstract Builder setDeviceProfile(String var1);

            public abstract Builder setSelfManaged(boolean var1);

            public abstract Builder setAssociatedDevice(Object var1);

            public abstract Builder setNotifyOnDeviceNearby(boolean var1);

            public abstract Builder setRevoked(boolean var1);

            public abstract Builder setTimeApprovedMs(long var1);

            public abstract Builder setLastTimeConnectedMs(long var1);

            public abstract Builder setSystemDataSyncFlags(int var1);

            public abstract RoboAssociationInfo build();
        }
    }
}

