/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.location.ContextHubClient;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.NanoAppMessage;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ContextHubClient.class, minSdk=28, isInAndroidSdk=false)
public class ShadowContextHubClient {
    @RealObject
    private ContextHubClient realContextHubClient;
    private final List<NanoAppMessage> messages = new ArrayList<NanoAppMessage>();

    @Implementation(minSdk=28)
    @HiddenApi
    protected int sendMessageToNanoApp(NanoAppMessage message) {
        if (!ShadowInstrumentation.hasRequiredPermission((Context)RuntimeEnvironment.getApplication(), "android.permission.ACCESS_CONTEXT_HUB")) {
            throw new SecurityException("ShadowContextHubClient does not have permission");
        }
        if (this.isClosed()) {
            return 1;
        }
        this.messages.add(message);
        return 0;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void close() {
        ((ContextHubClientReflector)Reflector.reflector(ContextHubClientReflector.class, (Object)this.realContextHubClient)).getIsClosed().set(true);
    }

    public List<NanoAppMessage> getMessages() {
        return ImmutableList.copyOf(this.messages);
    }

    @RequiresApi(value=29)
    public boolean isClosed() {
        return ((ContextHubClientReflector)Reflector.reflector(ContextHubClientReflector.class, (Object)this.realContextHubClient)).getIsClosed().get();
    }

    @ForType(value=ContextHubClient.class)
    static interface ContextHubClientReflector {
        @Constructor
        @TargetApi(value=28)
        public ContextHubClient newContextHubClient();

        @Constructor
        @RequiresApi(value=29)
        public ContextHubClient newContextHubClient(ContextHubInfo var1, boolean var2);

        @Accessor(value="mIsClosed")
        public AtomicBoolean getIsClosed();
    }
}

