/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.RequiresApi;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.telephony.SubscriptionManager;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsMmTelManager;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.ImsRegistrationAttributes;
import android.telephony.ims.RegistrationManager;
import android.telephony.ims.feature.MmTelFeature;
import android.util.ArrayMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=ImsMmTelManager.class, minSdk=29, isInAndroidSdk=false)
@SystemApi
public class ShadowImsMmTelManager {
    private static final Map<Integer, ImsMmTelManager> existingInstances = new ArrayMap();
    private static final Map<Integer, Integer> subIdToRegistrationTransportTypeMap = new ArrayMap();
    private static final Map<Integer, Integer> subIdToRegistrationStateMap = new ArrayMap();
    private final Map<ImsMmTelManager.RegistrationCallback, Executor> registrationCallbackExecutorMap = new ArrayMap();
    private final Map<RegistrationManager.RegistrationCallback, Executor> registrationManagerCallbackExecutorMap = new ArrayMap();
    private final Map<ImsMmTelManager.CapabilityCallback, Executor> capabilityCallbackExecutorMap = new ArrayMap();
    private boolean imsAvailableOnDevice = true;
    private MmTelFeature.MmTelCapabilities mmTelCapabilitiesAvailable = new MmTelFeature.MmTelCapabilities();
    private int imsRegistrationTech = -1;
    private Consumer<Integer> stateCallback;
    private Consumer<Integer> transportTypeCallback;
    @RealObject
    private ImsMmTelManager realImsMmTelManager;

    public void setImsAvailableOnDevice(boolean imsAvailableOnDevice) {
        this.imsAvailableOnDevice = imsAvailableOnDevice;
    }

    @Implementation
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    protected void registerImsRegistrationCallback(@NonNull Executor executor, @NonNull ImsMmTelManager.RegistrationCallback c) throws ImsException {
        if (!this.imsAvailableOnDevice) {
            throw new ImsException("IMS not available on device.", 2);
        }
        this.registrationCallbackExecutorMap.put(c, executor);
    }

    @Implementation(minSdk=30)
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    protected void registerImsRegistrationCallback(@NonNull Executor executor, @NonNull RegistrationManager.RegistrationCallback c) throws ImsException {
        if (!this.imsAvailableOnDevice) {
            throw new ImsException("IMS not available on device.", 2);
        }
        this.registrationManagerCallbackExecutorMap.put(c, executor);
    }

    @Implementation
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    protected void unregisterImsRegistrationCallback(@NonNull ImsMmTelManager.RegistrationCallback c) {
        this.registrationCallbackExecutorMap.remove(c);
    }

    @Implementation(minSdk=30)
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    protected void unregisterImsRegistrationCallback(@NonNull RegistrationManager.RegistrationCallback c) {
        this.registrationManagerCallbackExecutorMap.remove(c);
    }

    public void setImsRegistering(int imsRegistrationTech) {
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((ImsMmTelManager.RegistrationCallback)entry.getKey()).onRegistering(imsRegistrationTech));
        }
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationManagerCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((RegistrationManager.RegistrationCallback)entry.getKey()).onRegistering(imsRegistrationTech));
        }
    }

    @RequiresApi(api=31)
    public void setImsRegistering(@NonNull ImsRegistrationAttributes attrs) {
        for (Map.Entry<RegistrationManager.RegistrationCallback, Executor> entry : this.registrationManagerCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((RegistrationManager.RegistrationCallback)entry.getKey()).onRegistering(attrs));
        }
    }

    public void setImsRegistered(int imsRegistrationTech) {
        this.imsRegistrationTech = imsRegistrationTech;
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((ImsMmTelManager.RegistrationCallback)entry.getKey()).onRegistered(imsRegistrationTech));
        }
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationManagerCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((RegistrationManager.RegistrationCallback)entry.getKey()).onRegistered(imsRegistrationTech));
        }
    }

    @RequiresApi(api=31)
    public void setImsRegistered(@NonNull ImsRegistrationAttributes attrs) {
        for (Map.Entry<RegistrationManager.RegistrationCallback, Executor> entry : this.registrationManagerCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((RegistrationManager.RegistrationCallback)entry.getKey()).onRegistered(attrs));
        }
    }

    public void setImsUnregistered(@NonNull ImsReasonInfo imsReasonInfo) {
        this.imsRegistrationTech = -1;
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((ImsMmTelManager.RegistrationCallback)entry.getKey()).onUnregistered(imsReasonInfo));
        }
        for (Map.Entry<ImsMmTelManager.RegistrationCallback, Executor> entry : this.registrationManagerCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((RegistrationManager.RegistrationCallback)entry.getKey()).onUnregistered(imsReasonInfo));
        }
    }

    public void setOnTechnologyChangeFailed(int imsRadioTech, @NonNull ImsReasonInfo imsReasonInfo) {
        for (Map.Entry<RegistrationManager.RegistrationCallback, Executor> entry : this.registrationManagerCallbackExecutorMap.entrySet()) {
            entry.getValue().execute(() -> ((RegistrationManager.RegistrationCallback)entry.getKey()).onTechnologyChangeFailed(imsRadioTech, imsReasonInfo));
        }
    }

    public static void setRegistrationState(int subId, int registrationState) {
        subIdToRegistrationStateMap.put(subId, registrationState);
    }

    public Consumer<Integer> getRegistrationStateCallback() {
        return this.stateCallback;
    }

    @HiddenApi
    @Implementation(minSdk=30)
    public void getRegistrationState(Executor executor, Consumer<Integer> stateCallback) {
        this.stateCallback = stateCallback;
        int subId = this.getSubscriptionId();
        if (subIdToRegistrationStateMap.containsKey(this.getSubscriptionId())) {
            stateCallback.accept(subIdToRegistrationStateMap.get(subId));
        }
    }

    public static void setRegistrationTransportType(int subId, int registrationTransportType) {
        subIdToRegistrationTransportTypeMap.put(subId, registrationTransportType);
    }

    public Consumer<Integer> getRegistrationTransportTypeCallback() {
        return this.transportTypeCallback;
    }

    @Implementation(minSdk=30)
    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.READ_PRECISE_PHONE_STATE"})
    public void getRegistrationTransportType(Executor executor, Consumer<Integer> transportTypeCallback) {
        this.transportTypeCallback = transportTypeCallback;
        int subId = this.getSubscriptionId();
        if (subIdToRegistrationTransportTypeMap.containsKey(this.getSubscriptionId())) {
            transportTypeCallback.accept(subIdToRegistrationTransportTypeMap.get(subId));
        }
    }

    @Implementation
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    protected void registerMmTelCapabilityCallback(@NonNull Executor executor, @NonNull ImsMmTelManager.CapabilityCallback c) throws ImsException {
        if (!this.imsAvailableOnDevice) {
            throw new ImsException("IMS not available on device.", 2);
        }
        this.capabilityCallbackExecutorMap.put(c, executor);
    }

    @Implementation
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    protected void unregisterMmTelCapabilityCallback(@NonNull ImsMmTelManager.CapabilityCallback c) {
        this.capabilityCallbackExecutorMap.remove(c);
    }

    @Implementation
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    protected boolean isAvailable(int capability, int imsRegTech) {
        return this.mmTelCapabilitiesAvailable.isCapable(capability) && imsRegTech == this.imsRegistrationTech;
    }

    public void setMmTelCapabilitiesAvailable(@NonNull MmTelFeature.MmTelCapabilities capabilities) {
        this.mmTelCapabilitiesAvailable = capabilities;
        if (this.imsRegistrationTech != -1) {
            for (Map.Entry<ImsMmTelManager.CapabilityCallback, Executor> entry : this.capabilityCallbackExecutorMap.entrySet()) {
                entry.getValue().execute(() -> ((ImsMmTelManager.CapabilityCallback)entry.getKey()).onCapabilitiesStatusChanged(capabilities));
            }
        }
    }

    public int getSubscriptionId() {
        return ((ImsMmTelManagerReflector)Reflector.reflector(ImsMmTelManagerReflector.class, (Object)this.realImsMmTelManager)).getSubId();
    }

    @Implementation
    protected static ImsMmTelManager createForSubscriptionId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId((int)subId)) {
            throw new IllegalArgumentException("Invalid subscription ID");
        }
        if (existingInstances.containsKey(subId)) {
            return existingInstances.get(subId);
        }
        ImsMmTelManager imsMmTelManager = ((ImsMmTelManagerReflector)Reflector.reflector(ImsMmTelManagerReflector.class)).createForSubscriptionId(subId);
        existingInstances.put(subId, imsMmTelManager);
        return imsMmTelManager;
    }

    @Resetter
    public static void clearExistingInstancesAndStates() {
        existingInstances.clear();
        subIdToRegistrationTransportTypeMap.clear();
        subIdToRegistrationStateMap.clear();
    }

    @ForType(value=ImsMmTelManager.class)
    static interface ImsMmTelManagerReflector {
        @Accessor(value="mSubId")
        public int getSubId();

        @Static
        @Direct
        public ImsMmTelManager createForSubscriptionId(int var1);
    }
}

