/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.view.InsetsController;
import android.view.WindowInsets;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.shadows.ShadowViewRootImpl;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=InsetsController.class, minSdk=30, isInAndroidSdk=false)
@RequiresApi(value=30)
public class ShadowInsetsController {
    @ReflectorObject
    private InsetsControllerReflector insetsControllerReflector;

    @Implementation
    protected void show(int types) {
        if (this.hasStatusBarType(types)) {
            ShadowViewRootImpl.setIsStatusBarVisible(true);
        }
        if (this.hasNavigationBarType(types)) {
            ShadowViewRootImpl.setIsNavigationBarVisible(true);
        }
        this.insetsControllerReflector.show(types);
    }

    @Implementation
    public void hide(int types) {
        if (this.hasStatusBarType(types)) {
            ShadowViewRootImpl.setIsStatusBarVisible(false);
        }
        if (this.hasNavigationBarType(types)) {
            ShadowViewRootImpl.setIsNavigationBarVisible(false);
        }
        this.insetsControllerReflector.hide(types);
    }

    private boolean hasStatusBarType(int types) {
        return this.hasTypeMask(types, WindowInsets.Type.statusBars());
    }

    private boolean hasNavigationBarType(int types) {
        return this.hasTypeMask(types, WindowInsets.Type.navigationBars());
    }

    private boolean hasTypeMask(int types, int typeMask) {
        return (types & typeMask) == typeMask;
    }

    @ForType(value=InsetsController.class)
    static interface InsetsControllerReflector {
        @Direct
        public void show(int var1);

        @Direct
        public void hide(int var1);
    }
}

