/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.PendingIntent;
import android.media.MediaMetadata;
import android.media.session.MediaController;
import android.media.session.PlaybackState;
import android.os.Bundle;
import android.os.Handler;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MediaController.class)
public class ShadowMediaController {
    @RealObject
    private MediaController realMediaController;
    private PlaybackState playbackState;
    private MediaController.PlaybackInfo playbackInfo;
    private MediaMetadata mediaMetadata;
    private PendingIntent sessionActivity;
    private Bundle extras;
    private int ratingType = 0;
    private final List<MediaController.Callback> callbacks = new ArrayList<MediaController.Callback>();

    public void setPackageName(String packageName) {
        ReflectionHelpers.setField((Object)this.realMediaController, (String)"mPackageName", (Object)packageName);
    }

    public void setPlaybackState(PlaybackState playbackState) {
        this.playbackState = playbackState;
    }

    @Implementation
    protected PlaybackState getPlaybackState() {
        return this.playbackState;
    }

    public void setPlaybackInfo(MediaController.PlaybackInfo playbackInfo) {
        this.playbackInfo = playbackInfo;
    }

    @Implementation
    protected MediaController.PlaybackInfo getPlaybackInfo() {
        return this.playbackInfo;
    }

    public void setMetadata(MediaMetadata mediaMetadata) {
        this.mediaMetadata = mediaMetadata;
    }

    @Implementation
    protected MediaMetadata getMetadata() {
        return this.mediaMetadata;
    }

    public void setRatingType(int ratingType) {
        if (ratingType < 0 || ratingType > 6) {
            throw new IllegalArgumentException("Invalid RatingType value " + ratingType + ". The valid range is from 0 to " + 6);
        }
        this.ratingType = ratingType;
    }

    @Implementation
    protected int getRatingType() {
        return this.ratingType;
    }

    public void setSessionActivity(PendingIntent sessionActivity) {
        this.sessionActivity = sessionActivity;
    }

    @Implementation
    protected PendingIntent getSessionActivity() {
        return this.sessionActivity;
    }

    public void setExtras(Bundle extras) {
        this.extras = extras;
    }

    @Implementation
    protected Bundle getExtras() {
        return this.extras;
    }

    @Implementation
    protected void registerCallback(@NonNull MediaController.Callback callback, @Nullable Handler handler) {
        this.callbacks.add(callback);
        ((MediaControllerReflector)Reflector.reflector(MediaControllerReflector.class, (Object)this.realMediaController)).registerCallback(callback, handler);
    }

    @Implementation
    protected void unregisterCallback(@NonNull MediaController.Callback callback) {
        this.callbacks.remove(callback);
        ((MediaControllerReflector)Reflector.reflector(MediaControllerReflector.class, (Object)this.realMediaController)).unregisterCallback(callback);
    }

    public List<MediaController.Callback> getCallbacks() {
        return this.callbacks;
    }

    public void executeOnPlaybackStateChanged(PlaybackState playbackState) {
        this.setPlaybackState(playbackState);
        int messageId = (Integer)ReflectionHelpers.getStaticField(MediaController.class, (String)"MSG_UPDATE_PLAYBACK_STATE");
        ReflectionHelpers.callInstanceMethod(MediaController.class, (Object)this.realMediaController, (String)"postMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)messageId), ReflectionHelpers.ClassParameter.from(Object.class, (Object)playbackState), ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)new Bundle())});
    }

    public void executeOnSessionDestroyed() {
        int messageId = (Integer)ReflectionHelpers.getStaticField(MediaController.class, (String)"MSG_DESTROYED");
        ReflectionHelpers.callInstanceMethod(MediaController.class, (Object)this.realMediaController, (String)"postMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)messageId), ReflectionHelpers.ClassParameter.from(Object.class, null), ReflectionHelpers.ClassParameter.from(Bundle.class, null)});
    }

    public void executeOnMetadataChanged(MediaMetadata metadata) {
        this.setMetadata(metadata);
        int messageId = (Integer)ReflectionHelpers.getStaticField(MediaController.class, (String)"MSG_UPDATE_METADATA");
        ReflectionHelpers.callInstanceMethod(MediaController.class, (Object)this.realMediaController, (String)"postMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)messageId), ReflectionHelpers.ClassParameter.from(Object.class, (Object)metadata), ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)new Bundle())});
    }

    @ForType(value=MediaController.class)
    static interface MediaControllerReflector {
        @Direct
        public void registerCallback(@NonNull MediaController.Callback var1, @Nullable Handler var2);

        @Direct
        public void unregisterCallback(@NonNull MediaController.Callback var1);
    }
}

