/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.Matrix;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.nativeruntime.BitmapNatives;
import org.robolectric.nativeruntime.ColorSpaceRgbNatives;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.NativeAllocationRegistryNatives;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Bitmap.class, minSdk=26, isInAndroidSdk=false, callNativeMethodsByDefault=true)
public class ShadowNativeBitmap
extends ShadowBitmap {
    private int createdFromResId;
    private static final List<Long> colorSpaceAllocationsP = Collections.synchronizedList(new ArrayList());

    void setCreatedFromResId(int createdFromResId) {
        this.createdFromResId = createdFromResId;
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static Bitmap nativeCreate(int[] colors, int offset, int stride, int width, int height, int nativeConfig, boolean mutable, long nativeColorSpace) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return BitmapNatives.nativeCreate((int[])colors, (int)offset, (int)stride, (int)width, (int)height, (int)nativeConfig, (boolean)mutable, (long)nativeColorSpace);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static Bitmap nativeCreate(int[] colors, int offset, int stride, int width, int height, int nativeConfig, boolean mutable, float[] xyzD50, ColorSpace.Rgb.TransferParameters p) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        long colorSpacePtr = 0L;
        if (xyzD50 != null && p != null) {
            colorSpacePtr = ColorSpaceRgbNatives.nativeCreate((float)((float)p.a), (float)((float)p.b), (float)((float)p.c), (float)((float)p.d), (float)((float)p.e), (float)((float)p.f), (float)((float)p.g), (float[])xyzD50);
            colorSpaceAllocationsP.add(colorSpacePtr);
        }
        return ShadowNativeBitmap.nativeCreate(colors, offset, stride, width, height, nativeConfig, mutable, colorSpacePtr);
    }

    @Implementation(maxSdk=34)
    protected static Bitmap nativeCopy(long nativeSrcBitmap, int nativeConfig, boolean isMutable) {
        return BitmapNatives.nativeCopy((long)nativeSrcBitmap, (int)nativeConfig, (boolean)isMutable);
    }

    @Implementation(minSdk=23, maxSdk=34)
    protected static Bitmap nativeCopyAshmem(long nativeSrcBitmap) {
        return BitmapNatives.nativeCopyAshmem((long)nativeSrcBitmap);
    }

    @Implementation(minSdk=24, maxSdk=34)
    protected static Bitmap nativeCopyAshmemConfig(long nativeSrcBitmap, int nativeConfig) {
        return BitmapNatives.nativeCopyAshmemConfig((long)nativeSrcBitmap, (int)nativeConfig);
    }

    @Implementation(minSdk=24, maxSdk=34)
    protected static long nativeGetNativeFinalizer() {
        return BitmapNatives.nativeGetNativeFinalizer();
    }

    @Implementation(maxSdk=28, methodName="nativeRecycle")
    protected static boolean nativeRecyclePreQ(long nativeBitmap) {
        BitmapNatives.nativeRecycle((long)nativeBitmap);
        return true;
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nativeRecycle(long nativeBitmap) {
        BitmapNatives.nativeRecycle((long)nativeBitmap);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static void nativeReconfigure(long nativeBitmap, int width, int height, int config, boolean isPremultiplied) {
        BitmapNatives.nativeReconfigure((long)nativeBitmap, (int)width, (int)height, (int)config, (boolean)isPremultiplied);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeCompress(long nativeBitmap, int format, int quality, OutputStream stream, byte[] tempStorage) {
        return BitmapNatives.nativeCompress((long)nativeBitmap, (int)format, (int)quality, (OutputStream)stream, (byte[])tempStorage);
    }

    @Implementation(maxSdk=34)
    protected static void nativeErase(long nativeBitmap, int color) {
        BitmapNatives.nativeErase((long)nativeBitmap, (int)color);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nativeErase(long nativeBitmap, long colorSpacePtr, long color) {
        BitmapNatives.nativeErase((long)nativeBitmap, (long)colorSpacePtr, (long)color);
    }

    @Implementation(maxSdk=34)
    protected static int nativeRowBytes(long nativeBitmap) {
        return BitmapNatives.nativeRowBytes((long)nativeBitmap);
    }

    @Implementation(maxSdk=34)
    protected static int nativeConfig(long nativeBitmap) {
        return BitmapNatives.nativeConfig((long)nativeBitmap);
    }

    @Implementation(maxSdk=34)
    protected static int nativeGetPixel(long nativeBitmap, int x, int y) {
        return BitmapNatives.nativeGetPixel((long)nativeBitmap, (int)x, (int)y);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static long nativeGetColor(long nativeBitmap, int x, int y) {
        return BitmapNatives.nativeGetColor((long)nativeBitmap, (int)x, (int)y);
    }

    @Implementation(maxSdk=34)
    protected static void nativeGetPixels(long nativeBitmap, int[] pixels, int offset, int stride, int x, int y, int width, int height) {
        BitmapNatives.nativeGetPixels((long)nativeBitmap, (int[])pixels, (int)offset, (int)stride, (int)x, (int)y, (int)width, (int)height);
    }

    @Implementation(maxSdk=34)
    protected static void nativeSetPixel(long nativeBitmap, int x, int y, int color) {
        BitmapNatives.nativeSetPixel((long)nativeBitmap, (int)x, (int)y, (int)color);
    }

    @Implementation(maxSdk=34)
    protected static void nativeSetPixels(long nativeBitmap, int[] colors, int offset, int stride, int x, int y, int width, int height) {
        BitmapNatives.nativeSetPixels((long)nativeBitmap, (int[])colors, (int)offset, (int)stride, (int)x, (int)y, (int)width, (int)height);
    }

    @Implementation(maxSdk=34)
    protected static void nativeCopyPixelsToBuffer(long nativeBitmap, Buffer dst) {
        BitmapNatives.nativeCopyPixelsToBuffer((long)nativeBitmap, (Buffer)dst);
    }

    @Implementation(maxSdk=34)
    protected static void nativeCopyPixelsFromBuffer(long nativeBitmap, Buffer src) {
        BitmapNatives.nativeCopyPixelsFromBuffer((long)nativeBitmap, (Buffer)src);
    }

    @Implementation(maxSdk=34)
    protected static int nativeGenerationId(long nativeBitmap) {
        return BitmapNatives.nativeGenerationId((long)nativeBitmap);
    }

    @Implementation(maxSdk=34)
    protected static Bitmap nativeExtractAlpha(long nativeBitmap, long nativePaint, int[] offsetXY) {
        return BitmapNatives.nativeExtractAlpha((long)nativeBitmap, (long)nativePaint, (int[])offsetXY);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeHasAlpha(long nativeBitmap) {
        return BitmapNatives.nativeHasAlpha((long)nativeBitmap);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeIsPremultiplied(long nativeBitmap) {
        return BitmapNatives.nativeIsPremultiplied((long)nativeBitmap);
    }

    @Implementation(maxSdk=34)
    protected static void nativeSetPremultiplied(long nativeBitmap, boolean isPremul) {
        BitmapNatives.nativeSetPremultiplied((long)nativeBitmap, (boolean)isPremul);
    }

    @Implementation(maxSdk=34)
    protected static void nativeSetHasAlpha(long nativeBitmap, boolean hasAlpha, boolean requestPremul) {
        BitmapNatives.nativeSetHasAlpha((long)nativeBitmap, (boolean)hasAlpha, (boolean)requestPremul);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeHasMipMap(long nativeBitmap) {
        return BitmapNatives.nativeHasMipMap((long)nativeBitmap);
    }

    @Implementation(maxSdk=34)
    protected static void nativeSetHasMipMap(long nativeBitmap, boolean hasMipMap) {
        BitmapNatives.nativeSetHasMipMap((long)nativeBitmap, (boolean)hasMipMap);
    }

    @Implementation(maxSdk=34)
    protected static boolean nativeSameAs(long nativeBitmap0, long nativeBitmap1) {
        return BitmapNatives.nativeSameAs((long)nativeBitmap0, (long)nativeBitmap1);
    }

    @Implementation(minSdk=25, maxSdk=34)
    protected static void nativePrepareToDraw(long nativeBitmap) {
        BitmapNatives.nativePrepareToDraw((long)nativeBitmap);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static int nativeGetAllocationByteCount(long nativeBitmap) {
        return BitmapNatives.nativeGetAllocationByteCount((long)nativeBitmap);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static Bitmap nativeCopyPreserveInternalConfig(long nativeBitmap) {
        return BitmapNatives.nativeCopyPreserveInternalConfig((long)nativeBitmap);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static Bitmap nativeWrapHardwareBufferBitmap(HardwareBuffer buffer, long nativeColorSpace) {
        return BitmapNatives.nativeWrapHardwareBufferBitmap((HardwareBuffer)buffer, (long)nativeColorSpace);
    }

    @Implementation(minSdk=30, maxSdk=34)
    protected static HardwareBuffer nativeGetHardwareBuffer(long nativeBitmap) {
        return BitmapNatives.nativeGetHardwareBuffer((long)nativeBitmap);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static boolean nativeGetColorSpace(long nativePtr, float[] xyz, float[] params) {
        ColorSpace colorSpace = ShadowNativeBitmap.nativeComputeColorSpace(nativePtr);
        if (colorSpace == null) {
            return false;
        }
        if (colorSpace instanceof ColorSpace.Rgb) {
            ColorSpace.Rgb.TransferParameters transferParameters = ((ColorSpace.Rgb)colorSpace).getTransferParameters();
            params[0] = (float)transferParameters.a;
            params[1] = (float)transferParameters.b;
            params[2] = (float)transferParameters.c;
            params[3] = (float)transferParameters.d;
            params[4] = (float)transferParameters.e;
            params[5] = (float)transferParameters.f;
            params[6] = (float)transferParameters.g;
            ColorSpace.Rgb rgb = (ColorSpace.Rgb)ColorSpace.adapt((ColorSpace)colorSpace, (float[])((ColorSpaceReflector)Reflector.reflector(ColorSpaceReflector.class)).getIlluminantD50XYZ());
            rgb.getTransform(xyz);
        }
        return true;
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static ColorSpace nativeComputeColorSpace(long nativePtr) {
        return BitmapNatives.nativeComputeColorSpace((long)nativePtr);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nativeSetColorSpace(long nativePtr, long nativeColorSpace) {
        BitmapNatives.nativeSetColorSpace((long)nativePtr, (long)nativeColorSpace);
    }

    @Implementation(minSdk=26, maxSdk=34)
    protected static boolean nativeIsSRGB(long nativePtr) {
        return BitmapNatives.nativeIsSRGB((long)nativePtr);
    }

    @Implementation(minSdk=28, maxSdk=34)
    protected static boolean nativeIsSRGBLinear(long nativePtr) {
        return BitmapNatives.nativeIsSRGBLinear((long)nativePtr);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static void nativeSetImmutable(long nativePtr) {
        BitmapNatives.nativeSetImmutable((long)nativePtr);
    }

    @Implementation(minSdk=29, maxSdk=34)
    protected static boolean nativeIsImmutable(long nativePtr) {
        return BitmapNatives.nativeIsImmutable((long)nativePtr);
    }

    @Implementation(minSdk=31, maxSdk=34)
    protected static boolean nativeIsBackedByAshmem(long nativePtr) {
        return BitmapNatives.nativeIsBackedByAshmem((long)nativePtr);
    }

    @Implementation(minSdk=34)
    protected static @ClassName(value="android.graphics.Gainmap") Object nativeExtractGainmap(long nativePtr) {
        return null;
    }

    @Implementation
    protected void writeToParcel(Parcel p, int flags) {
        ((ShadowBitmap.BitmapReflector)Reflector.reflector(ShadowBitmap.BitmapReflector.class, (Object)this.realBitmap)).checkRecycled("Can't parcel a recycled bitmap");
        int width = this.realBitmap.getWidth();
        int height = this.realBitmap.getHeight();
        p.writeInt(width);
        p.writeInt(height);
        p.writeInt(this.realBitmap.getDensity());
        p.writeBoolean(this.realBitmap.isMutable());
        p.writeSerializable((Serializable)this.realBitmap.getConfig());
        ColorSpace colorSpace = this.realBitmap.getColorSpace();
        boolean hasColorSpace = colorSpace != null;
        p.writeBoolean(hasColorSpace);
        if (hasColorSpace) {
            p.writeString(colorSpace.getName());
        }
        p.writeBoolean(this.realBitmap.hasAlpha());
        int[] pixels = new int[width * height];
        this.realBitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        p.writeIntArray(pixels);
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            Object gainmap = ((ShadowBitmap.BitmapReflector)Reflector.reflector(ShadowBitmap.BitmapReflector.class, (Object)this.realBitmap)).getGainmap();
            if (gainmap != null) {
                p.writeBoolean(true);
                p.writeTypedObject((Parcelable)gainmap, flags);
            } else {
                p.writeBoolean(false);
            }
        }
    }

    @Implementation
    protected static Bitmap nativeCreateFromParcel(Parcel p) {
        int parceledWidth = p.readInt();
        int parceledHeight = p.readInt();
        int density = p.readInt();
        boolean mutable = p.readBoolean();
        Bitmap.Config parceledConfig = (Bitmap.Config)p.readSerializable();
        ColorSpace colorSpace = null;
        boolean hasColorSpace = p.readBoolean();
        if (hasColorSpace) {
            ColorSpace[] namedColorSpaces;
            String colorSpaceName = p.readString();
            if (RuntimeEnvironment.getApiLevel() >= 35) {
                ColorSpace[] namedColorSpaceMap = ((ColorSpaceReflector)Reflector.reflector(ColorSpaceReflector.class)).getNamedColorSpaceMap();
                namedColorSpaces = namedColorSpaceMap.values().toArray(new ColorSpace[namedColorSpaceMap.size()]);
            } else {
                namedColorSpaces = ((ColorSpaceReflector)Reflector.reflector(ColorSpaceReflector.class)).getNamedColorSpaces();
            }
            for (ColorSpace named : namedColorSpaces) {
                if (!named.getName().equals(colorSpaceName)) continue;
                colorSpace = named;
                break;
            }
        }
        boolean hasAlpha = p.readBoolean();
        int[] parceledColors = new int[parceledHeight * parceledWidth];
        p.readIntArray(parceledColors);
        Bitmap bitmap = colorSpace != null ? Bitmap.createBitmap((int)parceledWidth, (int)parceledHeight, (Bitmap.Config)parceledConfig, (boolean)hasAlpha, colorSpace) : Bitmap.createBitmap((int)parceledWidth, (int)parceledHeight, (Bitmap.Config)parceledConfig, (boolean)hasAlpha);
        bitmap.setPixels(parceledColors, 0, parceledWidth, 0, 0, parceledWidth, parceledHeight);
        bitmap.setDensity(density);
        if (!mutable) {
            bitmap = bitmap.copy(parceledConfig, false);
        }
        return bitmap;
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static void nativeCopyColorSpace(long srcBitmap, long dstBitmap) {
        BitmapNatives.nativeCopyColorSpaceP((long)srcBitmap, (long)dstBitmap);
    }

    @Override
    public Bitmap getCreatedFromBitmap() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public int getCreatedFromResId() {
        return this.createdFromResId;
    }

    @Override
    public String getCreatedFromPath() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public InputStream getCreatedFromStream() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public byte[] getCreatedFromBytes() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public int getCreatedFromX() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public int getCreatedFromY() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public int getCreatedFromWidth() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public int getCreatedFromHeight() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public int[] getCreatedFromColors() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public Matrix getCreatedFromMatrix() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public boolean getCreatedFromFilter() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public void setMutable(boolean mutable) {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public void appendDescription(String s) {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public String getDescription() {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    @Override
    public void setDescription(String s) {
        throw new UnsupportedOperationException("Legacy ShadowBitmap APIs are not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        List<Long> list = colorSpaceAllocationsP;
        synchronized (list) {
            for (Long ptr : colorSpaceAllocationsP) {
                NativeAllocationRegistryNatives.applyFreeFunction((long)ColorSpaceRgbNatives.nativeGetNativeFinalizer(), (long)ptr);
            }
            colorSpaceAllocationsP.clear();
        }
    }

    @ForType(value=ColorSpace.class)
    static interface ColorSpaceReflector {
        @Accessor(value="ILLUMINANT_D50_XYZ")
        @Static
        public float[] getIlluminantD50XYZ();

        @Accessor(value="sNamedColorSpaces")
        public ColorSpace[] getNamedColorSpaces();

        @Accessor(value="sNamedColorSpaceMap")
        public Map<Integer, ColorSpace> getNamedColorSpaceMap();
    }
}

