/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.app.time.ExternalTimeSuggestion;
import android.app.time.TimeManager;
import android.app.time.TimeZoneCapabilities;
import android.app.time.TimeZoneCapabilitiesAndConfig;
import android.app.time.TimeZoneConfiguration;
import android.os.UserHandle;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TimeManager.class, minSdk=31, isInAndroidSdk=false)
public class ShadowTimeManager {
    public static final String CONFIGURE_GEO_DETECTION_CAPABILITY = "configure_geo_detection_capability";
    private static TimeZoneCapabilities timeZoneCapabilities = ShadowTimeManager.getTimeZoneCapabilities();
    private static TimeZoneConfiguration timeZoneConfiguration;

    public void setCapabilityState(String capability, int value) {
        TimeZoneCapabilities.Builder builder = new TimeZoneCapabilities.Builder(timeZoneCapabilities);
        switch (capability) {
            case "configure_geo_detection_capability": {
                builder.setConfigureGeoDetectionEnabledCapability(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized capability=" + capability);
            }
        }
        timeZoneCapabilities = builder.build();
    }

    @Implementation
    @SystemApi
    protected TimeZoneCapabilitiesAndConfig getTimeZoneCapabilitiesAndConfig() throws ClassNotFoundException {
        Objects.requireNonNull(timeZoneConfiguration, "timeZoneConfiguration was not set");
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            Object telephonyAlgoStatus = ReflectionHelpers.callConstructor(Class.forName("android.app.time.TelephonyTimeZoneAlgorithmStatus"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)3)});
            Object locationAlgoStatus = ReflectionHelpers.callConstructor(Class.forName("android.app.time.LocationTimeZoneAlgorithmStatus"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)3), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)3), ReflectionHelpers.ClassParameter.from(Class.forName("android.service.timezone.TimeZoneProviderStatus"), null), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)3), ReflectionHelpers.ClassParameter.from(Class.forName("android.service.timezone.TimeZoneProviderStatus"), null)});
            Object timeZoneDetectorStatus = ReflectionHelpers.callConstructor(Class.forName("android.app.time.TimeZoneDetectorStatus"), (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Class.forName("android.app.time.TelephonyTimeZoneAlgorithmStatus"), (Object)telephonyAlgoStatus), ReflectionHelpers.ClassParameter.from(Class.forName("android.app.time.LocationTimeZoneAlgorithmStatus"), (Object)locationAlgoStatus)});
            return (TimeZoneCapabilitiesAndConfig)ReflectionHelpers.callConstructor(TimeZoneCapabilitiesAndConfig.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Class.forName("android.app.time.TimeZoneDetectorStatus"), (Object)timeZoneDetectorStatus), ReflectionHelpers.ClassParameter.from(Class.forName("android.app.time.TimeZoneCapabilities"), (Object)timeZoneCapabilities), ReflectionHelpers.ClassParameter.from(Class.forName("android.app.time.TimeZoneConfiguration"), (Object)timeZoneConfiguration)});
        }
        return (TimeZoneCapabilitiesAndConfig)ReflectionHelpers.callConstructor(TimeZoneCapabilitiesAndConfig.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Class.forName("android.app.time.TimeZoneCapabilities"), (Object)timeZoneCapabilities), ReflectionHelpers.ClassParameter.from(Class.forName("android.app.time.TimeZoneConfiguration"), (Object)timeZoneConfiguration)});
    }

    @Implementation
    @SystemApi
    protected boolean updateTimeZoneConfiguration(TimeZoneConfiguration configuration) {
        timeZoneConfiguration = configuration;
        return true;
    }

    @Implementation
    protected void addTimeZoneDetectorListener(Executor executor, TimeManager.TimeZoneDetectorListener listener) {
    }

    @Implementation
    protected void removeTimeZoneDetectorListener(TimeManager.TimeZoneDetectorListener listener) {
    }

    @Implementation
    protected void suggestExternalTime(ExternalTimeSuggestion timeSuggestion) {
    }

    private static TimeZoneCapabilities getTimeZoneCapabilities() {
        TimeZoneCapabilities.Builder timeZoneCapabilitiesBuilder = new TimeZoneCapabilities.Builder(UserHandle.CURRENT).setConfigureAutoDetectionEnabledCapability(40).setConfigureGeoDetectionEnabledCapability(40);
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            ReflectionHelpers.callInstanceMethod((Object)timeZoneCapabilitiesBuilder, (String)"setUseLocationEnabled", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true)});
            ReflectionHelpers.callInstanceMethod((Object)timeZoneCapabilitiesBuilder, (String)"setSetManualTimeZoneCapability", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)40)});
            return timeZoneCapabilitiesBuilder.build();
        }
        ReflectionHelpers.callInstanceMethod((Object)timeZoneCapabilitiesBuilder, (String)"setSuggestManualTimeZoneCapability", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)40)});
        return timeZoneCapabilitiesBuilder.build();
    }

    @Resetter
    public static void reset() {
        timeZoneCapabilities = ShadowTimeManager.getTimeZoneCapabilities();
        timeZoneConfiguration = null;
    }
}

