/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Typeface;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowLegacyTypeface;
import org.robolectric.shadows.ShadowNativeTypeface;

@Implements(value=Typeface.class, shadowPicker=Picker.class)
public abstract class ShadowTypeface {
    public abstract FontDesc getFontDescription();

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowLegacyTypeface.class, ShadowNativeTypeface.class);
        }
    }

    public static class FontDesc {
        public final String familyName;
        public final int style;

        public FontDesc(String familyName, int style) {
            this.familyName = familyName;
            this.style = style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FontDesc)) {
                return false;
            }
            FontDesc fontDesc = (FontDesc)o;
            if (this.style != fontDesc.style) {
                return false;
            }
            return !(this.familyName != null ? !this.familyName.equals(fontDesc.familyName) : fontDesc.familyName != null);
        }

        public int hashCode() {
            int result = this.familyName != null ? this.familyName.hashCode() : 0;
            result = 31 * result + this.style;
            return result;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public int getStyle() {
            return this.style;
        }
    }
}

