/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresApi;
import android.telephony.emergency.EmergencyNumber;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.util.ReflectionHelpers;

@RequiresApi(value=29)
public class EmergencyNumberBuilder {
    private final String number;
    private final String countryIso;
    private final String mnc;
    private final List<String> emergencyUrns = new ArrayList<String>();
    private int emergencyServiceCategories = 0;
    private int emergencyNumberSources = 8;
    private int emergencyCallRouting = 0;

    private EmergencyNumberBuilder(String number, String countryIso, String mnc) {
        this.number = number;
        this.countryIso = countryIso;
        this.mnc = mnc;
    }

    public static EmergencyNumberBuilder newBuilder(String number, String countryIso, String mnc) {
        return new EmergencyNumberBuilder(number, countryIso, mnc);
    }

    public EmergencyNumberBuilder setEmergencyServiceCategories(int emergencyServiceCategories) {
        this.emergencyServiceCategories = emergencyServiceCategories;
        return this;
    }

    public EmergencyNumberBuilder addEmergencyUrn(String emergencyUrn) {
        this.emergencyUrns.add(emergencyUrn);
        return this;
    }

    public EmergencyNumberBuilder setEmergencyNumberSources(int emergencyNumberSources) {
        this.emergencyNumberSources = emergencyNumberSources;
        return this;
    }

    public EmergencyNumberBuilder setEmergencyCallRouting(int emergencyCallRouting) {
        this.emergencyCallRouting = emergencyCallRouting;
        return this;
    }

    public EmergencyNumber build() {
        return (EmergencyNumber)ReflectionHelpers.callConstructor(EmergencyNumber.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.number), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.countryIso), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.mnc), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.emergencyServiceCategories), ReflectionHelpers.ClassParameter.from(List.class, this.emergencyUrns), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.emergencyNumberSources), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.emergencyCallRouting)});
    }
}

