/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowView;
import org.robolectric.shadows.ShadowViewGroup;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AdapterView.class)
public class ShadowAdapterView<T extends Adapter>
extends ShadowViewGroup {
    private static final int ignoreRowsAtEndOfList = 0;
    @RealObject
    private AdapterView<T> realAdapterView;
    private AdapterView.OnItemSelectedListener itemSelectedListener;

    @Implementation
    protected void setOnItemSelectedListener(AdapterView.OnItemSelectedListener itemSelectedListener) {
        this.itemSelectedListener = itemSelectedListener;
        ((AdapterViewReflector)Reflector.reflector(AdapterViewReflector.class, this.realAdapterView)).setOnItemSelectedListener(itemSelectedListener);
    }

    public AdapterView.OnItemSelectedListener getItemSelectedListener() {
        return this.itemSelectedListener;
    }

    public boolean performItemClick(int position) {
        return this.realAdapterView.performItemClick(this.realAdapterView.getChildAt(position), position, this.realAdapterView.getItemIdAtPosition(position));
    }

    public int findIndexOfItemContainingText(String targetText) {
        for (int i = 0; i < this.realAdapterView.getCount(); ++i) {
            View childView = this.realAdapterView.getAdapter().getView(i, null, (ViewGroup)new FrameLayout(this.realAdapterView.getContext()));
            ShadowView shadowView = (ShadowView)Shadow.extract((Object)childView);
            String innerText = shadowView.innerText();
            if (!innerText.contains(targetText)) continue;
            return i;
        }
        return -1;
    }

    public View findItemContainingText(String targetText) {
        int itemIndex = this.findIndexOfItemContainingText(targetText);
        if (itemIndex == -1) {
            return null;
        }
        return this.realAdapterView.getChildAt(itemIndex);
    }

    public void clickFirstItemContainingText(String targetText) {
        int itemIndex = this.findIndexOfItemContainingText(targetText);
        if (itemIndex == -1) {
            throw new IllegalArgumentException("No item found containing text \"" + targetText + "\"");
        }
        this.performItemClick(itemIndex);
    }

    public void populateItems() {
        this.realView.measure(0, 0);
        this.realView.layout(0, 0, 100, 10000);
    }

    public void selectItemWithText(String s) {
        int itemIndex = this.findIndexOfItemContainingText(s);
        this.realAdapterView.setSelection(itemIndex);
    }

    @ForType(value=AdapterView.class)
    static interface AdapterViewReflector {
        @Direct
        public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener var1);
    }
}

