/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.hardware.location.ContextHubClient;
import android.hardware.location.ContextHubClientCallback;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubManager;
import android.hardware.location.ContextHubTransaction;
import android.hardware.location.NanoAppInstanceInfo;
import android.hardware.location.NanoAppMessage;
import android.hardware.location.NanoAppState;
import android.os.Build;
import com.google.auto.value.AutoValue;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AutoValue_ShadowContextHubManager_ContextHubClientCallbackDetails;
import org.robolectric.shadows.ShadowContextHubClient;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ContextHubManager.class, minSdk=24, isInAndroidSdk=false)
public class ShadowContextHubManager {
    private static final List<ContextHubInfo> contextHubInfoList = new ArrayList<ContextHubInfo>();
    private static final List<ContextHubClient> contextHubClientWithPendingIntentList = new ArrayList<ContextHubClient>();
    private static final Map<Integer, NanoAppInstanceInfo> nanoAppUidToInfo = new ConcurrentHashMap<Integer, NanoAppInstanceInfo>();
    private static final Multimap<ContextHubInfo, Integer> contextHubToNanoappUid = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private static final Map<Long, ContextHubInfo> nanoAppIdToInfo = new ConcurrentHashMap<Long, ContextHubInfo>();
    private static final HashMultimap<String, ContextHubClient> attributionTagToClientMap = HashMultimap.create();
    private static final Map<ContextHubClient, ContextHubClientCallbackDetails> contextHubClientCallbacks = new HashMap<ContextHubClient, ContextHubClientCallbackDetails>();

    public void addNanoApp(ContextHubInfo info, int nanoAppUid, long nanoAppId, int nanoAppVersion) {
        contextHubToNanoappUid.put((Object)info, (Object)nanoAppUid);
        NanoAppInstanceInfo instanceInfo = this.createInstanceInfo(info, nanoAppUid, nanoAppId, nanoAppVersion);
        nanoAppUidToInfo.put(nanoAppUid, instanceInfo);
        nanoAppIdToInfo.put(nanoAppId, info);
    }

    public NanoAppInstanceInfo createInstanceInfo(ContextHubInfo info, int nanoAppUid, long nanoAppId, int nanoAppVersion) {
        if (Build.VERSION.SDK_INT >= 28) {
            return new NanoAppInstanceInfo(nanoAppUid, nanoAppId, nanoAppVersion, info.getId());
        }
        NanoAppInstanceInfo instanceInfo = new NanoAppInstanceInfo();
        ReflectorNanoAppInstanceInfo reflectedInfo = (ReflectorNanoAppInstanceInfo)Reflector.reflector(ReflectorNanoAppInstanceInfo.class, (Object)instanceInfo);
        reflectedInfo.setAppId(nanoAppId);
        reflectedInfo.setAppVersion(nanoAppVersion);
        return instanceInfo;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected List<ContextHubInfo> getContextHubs() {
        return contextHubInfoList;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected @ClassName(value="android.hardware.location.ContextHubClient") Object createClient(@ClassName(value="android.hardware.location.ContextHubInfo") @ClassName(value="android.hardware.location.ContextHubInfo") Object contextHubInfo, @ClassName(value="android.hardware.location.ContextHubClientCallback") @ClassName(value="android.hardware.location.ContextHubClientCallback") Object callback) {
        ContextHubClient client = Build.VERSION.SDK_INT >= 29 ? ((ShadowContextHubClient.ContextHubClientReflector)Reflector.reflector(ShadowContextHubClient.ContextHubClientReflector.class)).newContextHubClient((ContextHubInfo)contextHubInfo, false) : ((ShadowContextHubClient.ContextHubClientReflector)Reflector.reflector(ShadowContextHubClient.ContextHubClientReflector.class)).newContextHubClient();
        if (callback != null) {
            contextHubClientCallbacks.put(client, ContextHubClientCallbackDetails.create((ContextHubClientCallback)callback, MoreExecutors.directExecutor()));
        }
        return client;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected @ClassName(value="android.hardware.location.ContextHubClient") Object createClient(@ClassName(value="android.hardware.location.ContextHubInfo") @ClassName(value="android.hardware.location.ContextHubInfo") Object contextHubInfo, @ClassName(value="android.hardware.location.ContextHubClientCallback") @ClassName(value="android.hardware.location.ContextHubClientCallback") Object callback, Executor executor) {
        ContextHubClient client = Build.VERSION.SDK_INT >= 29 ? ((ShadowContextHubClient.ContextHubClientReflector)Reflector.reflector(ShadowContextHubClient.ContextHubClientReflector.class)).newContextHubClient((ContextHubInfo)contextHubInfo, false) : ((ShadowContextHubClient.ContextHubClientReflector)Reflector.reflector(ShadowContextHubClient.ContextHubClientReflector.class)).newContextHubClient();
        if (callback != null) {
            contextHubClientCallbacks.put(client, ContextHubClientCallbackDetails.create((ContextHubClientCallback)callback, executor));
        }
        return client;
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected @ClassName(value="android.hardware.location.ContextHubClient") Object createClient(@ClassName(value="android.hardware.location.ContextHubInfo") @ClassName(value="android.hardware.location.ContextHubInfo") Object contextHubInfo, PendingIntent pendingIntent, long nanoAppId) {
        ContextHubClient client = Build.VERSION.SDK_INT >= 29 ? ((ShadowContextHubClient.ContextHubClientReflector)Reflector.reflector(ShadowContextHubClient.ContextHubClientReflector.class)).newContextHubClient((ContextHubInfo)contextHubInfo, false) : ((ShadowContextHubClient.ContextHubClientReflector)Reflector.reflector(ShadowContextHubClient.ContextHubClientReflector.class)).newContextHubClient();
        contextHubClientWithPendingIntentList.add(client);
        return client;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected @ClassName(value="android.hardware.location.ContextHubClient") Object createClient(Context context, @ClassName(value="android.hardware.location.ContextHubInfo") @ClassName(value="android.hardware.location.ContextHubInfo") Object contextHubInfo, Executor executor, @ClassName(value="android.hardware.location.ContextHubClientCallback") @ClassName(value="android.hardware.location.ContextHubClientCallback") Object callback) {
        ContextHubClient client = ((ShadowContextHubClient.ContextHubClientReflector)Reflector.reflector(ShadowContextHubClient.ContextHubClientReflector.class)).newContextHubClient((ContextHubInfo)contextHubInfo, false);
        if (context != null && context.getAttributionTag() != null) {
            attributionTagToClientMap.put((Object)context.getAttributionTag(), (Object)client);
        }
        if (callback != null) {
            contextHubClientCallbacks.put(client, ContextHubClientCallbackDetails.create((ContextHubClientCallback)callback, executor));
        }
        return client;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected @ClassName(value="android.hardware.location.ContextHubClient") Object createClient(Context context, ContextHubInfo contextHubInfo, PendingIntent pendingIntent, long nanoAppId) {
        ContextHubClient client = (ContextHubClient)Shadow.newInstance(ContextHubClient.class, (Class[])new Class[]{ContextHubInfo.class, Boolean.TYPE}, (Object[])new Object[]{contextHubInfo, false});
        contextHubClientWithPendingIntentList.add(client);
        return client;
    }

    @Implementation(minSdk=31)
    @HiddenApi
    protected @ClassName(value="android.hardware.location.ContextHubTransaction<java.lang.Void>") Object unloadNanoApp(ContextHubInfo contextHubInfo, long nanoAppId) {
        nanoAppIdToInfo.remove(nanoAppId);
        ContextHubTransaction transaction = (ContextHubTransaction)ReflectionHelpers.callConstructor(ContextHubTransaction.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1)});
        ContextHubTransaction.Response<List<NanoAppState>> response = ((ReflectorContextHubTransactionResponse)Reflector.reflector(ReflectorContextHubTransactionResponse.class)).create(0, null);
        ((ReflectorContextHubTransaction)Reflector.reflector(ReflectorContextHubTransaction.class, (Object)transaction)).setResponse(response);
        return transaction;
    }

    @Nullable
    public List<ContextHubClient> getClientsWithAttributionTag(String attributionTag) {
        return ImmutableList.copyOf((Collection)attributionTagToClientMap.get((Object)attributionTag));
    }

    @Nullable
    public List<ContextHubClient> getContextHubClientWithPendingIntentList() {
        return ImmutableList.copyOf(contextHubClientWithPendingIntentList);
    }

    public void resetContextHub() {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onHubReset((ContextHubClient)entry.getKey()));
        }
    }

    public void broadcastMessageFromNanoApp(Object message) {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onMessageFromNanoApp((ContextHubClient)entry.getKey(), (NanoAppMessage)message));
        }
    }

    public void broadcastNanoAppAborted(long nanoAppId, int abortCode) {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onNanoAppAborted((ContextHubClient)entry.getKey(), nanoAppId, abortCode));
        }
    }

    public void broadcastNanoAppLoaded(long nanoAppId) {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onNanoAppLoaded((ContextHubClient)entry.getKey(), nanoAppId));
        }
    }

    public void broadcastNanoAppUnloaded(long nanoAppId) {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onNanoAppUnloaded((ContextHubClient)entry.getKey(), nanoAppId));
        }
    }

    public void broadcastNanoAppEnabled(long nanoAppId) {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onNanoAppEnabled((ContextHubClient)entry.getKey(), nanoAppId));
        }
    }

    public void broadcastNanoAppDisabled(long nanoAppId) {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onNanoAppDisabled((ContextHubClient)entry.getKey(), nanoAppId));
        }
    }

    public void broadcastClientAuthorizationChanged(long nanoAppId, int authorization) {
        for (Map.Entry<ContextHubClient, ContextHubClientCallbackDetails> entry : contextHubClientCallbacks.entrySet()) {
            entry.getValue().getExecutor().execute(() -> ((ContextHubClientCallbackDetails)entry.getValue()).getCallback().onClientAuthorizationChanged((ContextHubClient)entry.getKey(), nanoAppId, authorization));
        }
    }

    public boolean nanoAppIsLoaded(long nanoAppId) {
        return nanoAppIdToInfo.containsKey(nanoAppId);
    }

    @Resetter
    public static void clearContextHubClientWithPendingIntentList() {
        contextHubClientWithPendingIntentList.clear();
        nanoAppUidToInfo.clear();
        contextHubToNanoappUid.clear();
        attributionTagToClientMap.clear();
        contextHubClientCallbacks.clear();
        nanoAppIdToInfo.clear();
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected @ClassName(value="android.hardware.location.ContextHubTransaction<java.util.List<android.hardware.location.NanoAppState>>") Object queryNanoApps(ContextHubInfo contextHubInfo) {
        ContextHubTransaction transaction = (ContextHubTransaction)ReflectionHelpers.callConstructor(ContextHubTransaction.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)4)});
        Collection uids = contextHubToNanoappUid.get((Object)contextHubInfo);
        ArrayList<NanoAppState> nanoAppStates = new ArrayList<NanoAppState>();
        for (Integer uid : uids) {
            NanoAppInstanceInfo info = nanoAppUidToInfo.get(uid);
            if (info == null) continue;
            nanoAppStates.add(new NanoAppState(info.getAppId(), info.getAppVersion(), true));
        }
        ContextHubTransaction.Response<List<NanoAppState>> response = ((ReflectorContextHubTransactionResponse)Reflector.reflector(ReflectorContextHubTransactionResponse.class)).create(0, nanoAppStates);
        ((ReflectorContextHubTransaction)Reflector.reflector(ReflectorContextHubTransaction.class, (Object)transaction)).setResponse(response);
        return transaction;
    }

    @Implementation
    @HiddenApi
    protected int[] getContextHubHandles() {
        int[] handles = new int[contextHubInfoList.size()];
        for (int i = 0; i < handles.length; ++i) {
            handles[i] = i;
        }
        return handles;
    }

    @Implementation
    @HiddenApi
    protected ContextHubInfo getContextHubInfo(int hubHandle) {
        if (hubHandle < 0 || hubHandle >= contextHubInfoList.size()) {
            return null;
        }
        return contextHubInfoList.get(hubHandle);
    }

    @Implementation
    @HiddenApi
    protected NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) {
        return nanoAppUidToInfo.get(nanoAppHandle);
    }

    static {
        contextHubInfoList.add(new ContextHubInfo());
    }

    @ForType(value=NanoAppInstanceInfo.class)
    private static interface ReflectorNanoAppInstanceInfo {
        public void setAppId(long var1);

        public void setAppVersion(int var1);
    }

    @AutoValue
    static abstract class ContextHubClientCallbackDetails {
        ContextHubClientCallbackDetails() {
        }

        @Nonnull
        abstract ContextHubClientCallback getCallback();

        @Nonnull
        abstract Executor getExecutor();

        static ContextHubClientCallbackDetails create(ContextHubClientCallback callback, Executor executor) {
            return new AutoValue_ShadowContextHubManager_ContextHubClientCallbackDetails(callback, executor);
        }
    }

    @ForType(value=ContextHubTransaction.Response.class)
    private static interface ReflectorContextHubTransactionResponse {
        @Constructor
        public ContextHubTransaction.Response<List<NanoAppState>> create(int var1, Object var2);
    }

    @ForType(value=ContextHubTransaction.class)
    private static interface ReflectorContextHubTransaction {
        public void setResponse(ContextHubTransaction.Response<List<NanoAppState>> var1);
    }
}

