/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.LoadedApk;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.UserHandle;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(className="android.app.ContextImpl")
public class ShadowContextImpl {
    public static final String CLASS_NAME = "android.app.ContextImpl";
    @RealObject
    private Context realContextImpl;
    private final Map<String, Object> systemServices = new HashMap<String, Object>();
    private final Set<String> removedSystemServices = new HashSet<String>();
    private final Object contentResolverLock = new Object();
    @GuardedBy(value="contentResolverLock")
    private ContentResolver contentResolver;
    private Integer userId;

    @Implementation
    @Nullable
    protected Object getSystemService(String name) {
        if (this.removedSystemServices.contains(name)) {
            return null;
        }
        if (!this.systemServices.containsKey(name)) {
            return ((ContextImplReflector)Reflector.reflector(ContextImplReflector.class, (Object)this.realContextImpl)).getSystemService(name);
        }
        return this.systemServices.get(name);
    }

    public void setSystemService(String key, Object service) {
        this.systemServices.put(key, service);
    }

    public void removeSystemService(String name) {
        this.removedSystemServices.add(name);
    }

    @Implementation
    protected void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        intent.sendIntent(this.realContextImpl, 0, fillInIntent, null, null, null);
    }

    @Implementation
    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Implementation
    protected int checkCallingPermission(String permission2) {
        return this.checkPermission(permission2, Process.myPid(), Process.myUid());
    }

    @Implementation
    protected int checkCallingOrSelfPermission(String permission2) {
        return this.checkCallingPermission(permission2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected ContentResolver getContentResolver() {
        Object object = this.contentResolverLock;
        synchronized (object) {
            if (this.contentResolver == null) {
                this.contentResolver = new ContentResolver(this.realContextImpl){

                    protected IContentProvider acquireProvider(Context c, String name) {
                        return null;
                    }

                    public boolean releaseProvider(IContentProvider icp) {
                        return false;
                    }

                    protected IContentProvider acquireUnstableProvider(Context c, String name) {
                        return null;
                    }

                    public boolean releaseUnstableProvider(IContentProvider icp) {
                        return false;
                    }

                    public void unstableProviderDied(IContentProvider icp) {
                    }
                };
            }
            return this.contentResolver;
        }
    }

    @Implementation
    protected void sendBroadcast(Intent intent) {
        this.getShadowInstrumentation().sendBroadcastWithPermission(intent, null, null, this.realContextImpl);
    }

    @Implementation
    protected void sendBroadcast(Intent intent, String receiverPermission) {
        this.getShadowInstrumentation().sendBroadcastWithPermission(intent, null, receiverPermission, this.realContextImpl);
    }

    @Implementation(minSdk=33)
    protected void sendBroadcast(Intent intent, String receiverPermission, Bundle options) {
        this.getShadowInstrumentation().sendBroadcastWithPermission(intent, receiverPermission, this.realContextImpl, options, 0);
    }

    @Implementation
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    protected void sendBroadcastAsUser(@RequiresPermission Intent intent, UserHandle user) {
        this.getShadowInstrumentation().sendBroadcastWithPermission(intent, user, null, this.realContextImpl);
    }

    @Implementation
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    protected void sendBroadcastAsUser(@RequiresPermission Intent intent, UserHandle user, @Nullable String receiverPermission) {
        this.getShadowInstrumentation().sendBroadcastWithPermission(intent, user, receiverPermission, this.realContextImpl);
    }

    @Implementation
    protected void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        this.getShadowInstrumentation().sendOrderedBroadcastWithPermission(intent, receiverPermission, this.realContextImpl);
    }

    @Implementation
    protected void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.getShadowInstrumentation().sendOrderedBroadcastAsUser(intent, null, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras, this.realContextImpl);
    }

    @Implementation
    protected void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.getShadowInstrumentation().sendOrderedBroadcastAsUser(intent, userHandle, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras, this.realContextImpl);
    }

    @Implementation(minSdk=23)
    protected void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String receiverPermission, int appOp, Bundle options, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.sendOrderedBroadcastAsUser(intent, userHandle, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Implementation
    protected void sendStickyBroadcast(Intent intent) {
        this.getShadowInstrumentation().sendStickyBroadcast(intent, this.realContextImpl);
    }

    @Implementation
    protected int checkPermission(String permission2, int pid, int uid) {
        return this.getShadowInstrumentation().checkPermission(permission2, pid, uid);
    }

    @Implementation
    protected Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.getShadowInstrumentation().registerReceiver(receiver, filter, 0, this.realContextImpl);
    }

    @Implementation(minSdk=26)
    protected Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, int flags) {
        return this.getShadowInstrumentation().registerReceiver(receiver, filter, flags, this.realContextImpl);
    }

    @Implementation
    protected Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.getShadowInstrumentation().registerReceiver(receiver, filter, broadcastPermission, scheduler, 0, this.realContextImpl);
    }

    @Implementation(minSdk=26)
    protected Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler, int flags) {
        return this.getShadowInstrumentation().registerReceiver(receiver, filter, broadcastPermission, scheduler, flags, this.realContextImpl);
    }

    @Implementation
    protected Intent registerReceiverAsUser(BroadcastReceiver receiver, UserHandle user, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.getShadowInstrumentation().registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, 0, this.realContextImpl);
    }

    @Implementation
    protected void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        this.getShadowInstrumentation().unregisterReceiver(broadcastReceiver);
    }

    @Implementation
    protected ComponentName startService(Intent service) {
        this.validateServiceIntent(service);
        return this.getShadowInstrumentation().startService(service);
    }

    @Implementation(minSdk=26)
    protected ComponentName startForegroundService(Intent service) {
        return this.startService(service);
    }

    @Implementation
    protected boolean stopService(Intent name) {
        this.validateServiceIntent(name);
        return this.getShadowInstrumentation().stopService(name);
    }

    @Implementation(minSdk=29)
    protected boolean bindService(Intent service, int flags, Executor executor, ServiceConnection conn) {
        return this.getShadowInstrumentation().bindService(service, flags, executor, conn);
    }

    @Implementation
    protected boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        this.validateServiceIntent(intent);
        return this.getShadowInstrumentation().bindService(intent, serviceConnection, i);
    }

    @Implementation
    protected boolean bindServiceAsUser(Intent intent, ServiceConnection serviceConnection, int i, UserHandle userHandle) {
        return this.bindService(intent, serviceConnection, i);
    }

    @Implementation
    protected void unbindService(ServiceConnection serviceConnection) {
        this.getShadowInstrumentation().unbindService(serviceConnection);
    }

    @Implementation
    protected void validateServiceIntent(Intent service) {
        if (service.getComponent() == null && service.getPackage() == null) {
            throw new IllegalArgumentException("Service Intent must be explicit: " + service);
        }
    }

    @Implementation
    protected void startActivityAsUser(Intent intent, Bundle options, UserHandle user) {
        ((ContextImplReflector)Reflector.reflector(ContextImplReflector.class, (Object)this.realContextImpl)).startActivity(intent, options);
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    @Implementation
    protected int getUserId() {
        if (this.userId != null) {
            return this.userId;
        }
        return (Integer)Shadow.directlyOn((Object)this.realContextImpl, (String)CLASS_NAME, (String)"getUserId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Implementation
    protected File getExternalFilesDir(String type) {
        File externalDir = Environment.getExternalStoragePublicDirectory(null);
        if (externalDir == null) {
            return null;
        }
        File externalFilesDir = new File(externalDir, "Android/data/" + this.realContextImpl.getPackageName());
        if (type != null) {
            externalFilesDir = new File(externalFilesDir, type);
        }
        externalFilesDir.mkdirs();
        return externalFilesDir;
    }

    @Implementation
    protected File[] getExternalFilesDirs(String type) {
        return new File[]{this.getExternalFilesDir(type)};
    }

    @Resetter
    public static void reset() {
        String prefsCacheFieldName = RuntimeEnvironment.getApiLevel() >= 24 ? "sSharedPrefsCache" : "sSharedPrefs";
        Class contextImplClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)CLASS_NAME);
        ReflectionHelpers.setStaticField((Class)contextImplClass, (String)prefsCacheFieldName, null);
        if (RuntimeEnvironment.getApiLevel() <= 22) {
            HashMap fetchers = (HashMap)ReflectionHelpers.getStaticField((Class)contextImplClass, (String)"SYSTEM_SERVICE_MAP");
            Class staticServiceFetcherClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)"android.app.ContextImpl$StaticServiceFetcher");
            for (Object o : fetchers.values()) {
                if (!staticServiceFetcherClass.isInstance(o)) continue;
                ReflectionHelpers.setField((Class)staticServiceFetcherClass, o, (String)"mCachedInstance", null);
            }
            Object windowServiceFetcher = fetchers.get("window");
            ReflectionHelpers.setField(windowServiceFetcher.getClass(), windowServiceFetcher, (String)"mDefaultDisplay", null);
        }
    }

    private ShadowInstrumentation getShadowInstrumentation() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        return (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
    }

    @Implementation
    public File getDatabasePath(String name) {
        if (File.separatorChar == '\\' && Paths.get(name, new String[0]).isAbsolute()) {
            String dirPath = name.substring(0, name.lastIndexOf(File.separatorChar));
            File dir = new File(dirPath);
            name = name.substring(name.lastIndexOf(File.separatorChar));
            File f = new File(dir, name);
            if (!dir.isDirectory() && dir.mkdir()) {
                FileUtils.setPermissions((String)dir.getPath(), (int)505, (int)-1, (int)-1);
            }
            return f;
        }
        return ((ContextImplReflector)Reflector.reflector(ContextImplReflector.class, (Object)this.realContextImpl)).getDatabasePath(name);
    }

    @Implementation
    protected SharedPreferences getSharedPreferences(String name, int mode) {
        if (!Strings.isNullOrEmpty((String)name) && File.separatorChar == '\\') {
            name = name.replace(":", "%3A");
        }
        return ((ContextImplReflector)Reflector.reflector(ContextImplReflector.class, (Object)this.realContextImpl)).getSharedPreferences(name, mode);
    }

    @ForType(className="android.app.ContextImpl")
    public static interface ContextImplReflector {
        @Static
        public Context createSystemContext(ActivityThread var1);

        @Static
        public Context createAppContext(ActivityThread var1, LoadedApk var2);

        @Static
        public Context createActivityContext(ActivityThread var1, LoadedApk var2, ActivityInfo var3, IBinder var4, int var5, Configuration var6);

        public void setOuterContext(Context var1);

        @Direct
        public Object getSystemService(String var1);

        public void startActivity(Intent var1, Bundle var2);

        @Direct
        public File getDatabasePath(String var1);

        @Direct
        public SharedPreferences getSharedPreferences(String var1, int var2);

        @Accessor(value="mClassLoader")
        public void setClassLoader(ClassLoader var1);
    }
}

