/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.os.MessageQueue;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowMessageQueue;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;

@Implements(value=Looper.class, isInAndroidSdk=false)
public class ShadowLegacyLooper
extends ShadowLooper {
    private static final Map<Thread, Looper> loopingLoopers = Collections.synchronizedMap(new WeakHashMap());
    private static Looper mainLooper;
    private static Scheduler backgroundScheduler;
    @RealObject
    private Looper realObject;
    boolean quit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static synchronized void resetThreadLoopers() {
        if (ConfigurationRegistry.get(LooperMode.Mode.class) != LooperMode.Mode.LEGACY) {
            return;
        }
        Map<Thread, Looper> map = loopingLoopers;
        synchronized (map) {
            Iterator<Looper> iterator = loopingLoopers.values().iterator();
            while (iterator.hasNext()) {
                Looper looper;
                Looper looper2 = looper = iterator.next();
                synchronized (looper2) {
                    if (!ShadowLegacyLooper.shadowOf((Looper)looper).quit) {
                        looper.quit();
                    } else {
                        ShadowLegacyLooper.shadowOf(looper).getScheduler().reset();
                        ShadowLegacyLooper.shadowOf(looper.getQueue()).reset();
                    }
                }
            }
        }
        if (mainLooper != null) {
            ShadowLegacyLooper.shadowOf(mainLooper).reset();
        }
    }

    static synchronized Scheduler getBackgroundThreadScheduler() {
        return backgroundScheduler;
    }

    public static void internalInitializeBackgroundThreadScheduler() {
        backgroundScheduler = ShadowLegacyLooper.useGlobalScheduler() ? RuntimeEnvironment.getMasterScheduler() : new Scheduler();
    }

    @Implementation
    protected void __constructor__(boolean quitAllowed) {
        Shadow.invokeConstructor(Looper.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)quitAllowed)});
        if (RuntimeEnvironment.isMainThread()) {
            mainLooper = this.realObject;
        } else {
            loopingLoopers.put(Thread.currentThread(), this.realObject);
        }
        this.resetScheduler();
    }

    @Implementation
    protected static Looper getMainLooper() {
        return mainLooper;
    }

    @Implementation
    protected static Looper myLooper() {
        return ShadowLegacyLooper.getLooperForThread(Thread.currentThread());
    }

    @Implementation
    protected static void loop() {
        ShadowLegacyLooper.shadowOf(Looper.myLooper()).doLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoop() {
        if (this.realObject != Looper.getMainLooper()) {
            Looper looper = this.realObject;
            synchronized (looper) {
                while (!this.quit) {
                    try {
                        this.realObject.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Implementation
    protected void quit() {
        if (this.realObject == Looper.getMainLooper()) {
            throw new RuntimeException("Main thread not allowed to quit");
        }
        this.quitUnchecked();
    }

    @Implementation
    protected void quitSafely() {
        this.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quitUnchecked() {
        Looper looper = this.realObject;
        synchronized (looper) {
            this.quit = true;
            this.realObject.notifyAll();
            this.getScheduler().reset();
            ShadowLegacyLooper.shadowOf(this.realObject.getQueue()).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasQuit() {
        Looper looper = this.realObject;
        synchronized (looper) {
            return this.quit;
        }
    }

    public static Looper getLooperForThread(Thread thread) {
        return RuntimeEnvironment.isMainThread(thread) ? mainLooper : loopingLoopers.get(thread);
    }

    protected static Collection<Looper> getLoopers() {
        ArrayList<Looper> loopers = new ArrayList<Looper>(loopingLoopers.values());
        loopers.add(mainLooper);
        return Collections.unmodifiableCollection(loopers);
    }

    @Override
    public void idle() {
        this.idle(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void idleFor(long time, TimeUnit timeUnit) {
        this.getScheduler().advanceBy(time, timeUnit);
    }

    @Override
    public boolean isIdle() {
        return !this.getScheduler().areAnyRunnable();
    }

    @Override
    public void idleIfPaused() {
    }

    @Override
    public void idleConstantly(boolean shouldIdleConstantly) {
        this.getScheduler().setIdleState(shouldIdleConstantly ? Scheduler.IdleState.CONSTANT_IDLE : Scheduler.IdleState.UNPAUSED);
    }

    @Override
    public void runToEndOfTasks() {
        this.getScheduler().advanceToLastPostedRunnable();
    }

    @Override
    public void runToNextTask() {
        this.getScheduler().advanceToNextPostedRunnable();
    }

    @Override
    public void runOneTask() {
        this.getScheduler().runOneTask();
    }

    @Override
    @Deprecated
    public boolean post(Runnable runnable, long delayMillis) {
        if (!this.quit) {
            this.getScheduler().postDelayed(runnable, delayMillis, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean postAtFrontOfQueue(Runnable runnable) {
        if (!this.quit) {
            this.getScheduler().postAtFrontOfQueue(runnable);
            return true;
        }
        return false;
    }

    @Override
    public void pause() {
        this.getScheduler().pause();
    }

    @Override
    public Duration getNextScheduledTaskTime() {
        return this.getScheduler().getNextScheduledTaskTime();
    }

    @Override
    public Duration getLastScheduledTaskTime() {
        return this.getScheduler().getLastScheduledTaskTime();
    }

    @Override
    public void unPause() {
        this.getScheduler().unPause();
    }

    @Override
    public boolean isPaused() {
        return this.getScheduler().isPaused();
    }

    @Override
    public boolean setPaused(boolean shouldPause) {
        boolean wasPaused = this.isPaused();
        if (shouldPause) {
            this.pause();
        } else {
            this.unPause();
        }
        return wasPaused;
    }

    @Override
    public void resetScheduler() {
        ShadowMessageQueue shadowMessageQueue = ShadowLegacyLooper.shadowOf(this.realObject.getQueue());
        if (this.realObject == Looper.getMainLooper() || ShadowLegacyLooper.useGlobalScheduler()) {
            shadowMessageQueue.setScheduler(RuntimeEnvironment.getMasterScheduler());
        } else {
            shadowMessageQueue.setScheduler(new Scheduler());
        }
    }

    @Override
    public void reset() {
        ShadowLegacyLooper.shadowOf(this.realObject.getQueue()).reset();
        this.resetScheduler();
        this.quit = false;
    }

    @Override
    public Scheduler getScheduler() {
        return ShadowLegacyLooper.shadowOf(this.realObject.getQueue()).getScheduler();
    }

    @Override
    public void runPaused(Runnable r) {
        boolean wasPaused = this.setPaused(true);
        try {
            r.run();
        }
        finally {
            if (!wasPaused) {
                this.unPause();
            }
        }
    }

    private static ShadowLegacyLooper shadowOf(Looper looper) {
        return (ShadowLegacyLooper)Shadow.extract((Object)looper);
    }

    private static ShadowMessageQueue shadowOf(MessageQueue mq) {
        return (ShadowMessageQueue)Shadow.extract((Object)mq);
    }

    private static boolean useGlobalScheduler() {
        return Boolean.getBoolean("robolectric.scheduling.global");
    }
}

